/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.WorkflowSerializationUtils;
import com.nuix.automate.scheduler.workflow.WorkflowBuilderSubmission;
import com.nuix.automate.utils.api.automatelicense.FileContents;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.CountingZipInputStream;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.audit.DownloadableAuditEvent;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.ParameterSubmission;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.workflowlibrary.AddWorkflowLibrariesResponse;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrarySubmission;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowSubmission;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.formbuilder.DateEpochMillisAdapter;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesProducer;
import com.nuix.automate.utils.models.internal.formbuilder.DynamicValuesType;
import com.nuix.automate.utils.models.internal.formbuilder.FormConfiguration;
import com.nuix.automate.utils.models.internal.formbuilder.FormFieldProcessor;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.workflow.DisplayCondition;
import com.nuix.automate.utils.workflow.ExecutionMode;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import com.nuix.automate.utils.workflow.StaticParameter;
import com.nuix.automate.workflow.core.execution.operations.ConfigureNativeOcrOperation;
import com.nuix.automate.workflow.core.execution.operations.ConfigureParametersOperation;
import com.nuix.automate.workflow.core.execution.operations.DummyOperation;
import com.nuix.automate.workflow.core.execution.operations.GenAiChainOperation;
import com.nuix.automate.workflow.core.execution.operations.OcrOperation;
import com.nuix.automate.workflow.core.execution.operations.PowerShellOperation;
import com.nuix.automate.workflow.core.execution.operations.RunExternalApplicationOperation;
import com.nuix.automate.workflow.core.execution.operations.ScriptOperation;
import com.nuix.automate.workflow.core.execution.serialization.OperationListAdapter;
import com.nuix.automate.workflow.core.execution.workflow.ImmutableWorkflow;
import com.nuix.automate.workflow.core.execution.workflow.OperationList;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowExecution;
import com.nuix.automate.workflow.core.execution.workflow.WorkflowRenderer;
import com.nuix.automate.workflow.core.nuix.ExecutionContext;
import com.nuix.automate.workflow.core.utils.general.DisplayConditionUtils;
import com.nuix.automate.workflow.core.utils.general.OperationUtils;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@javax.ws.rs.Path(value="/v1/scheduler/library")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LibraryResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LibraryResource.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private Map<String, Workflow> workflows;
    private Map<String, WorkflowLibrary> libraries;
    private Map<String, Map<String, Workflow>> libraryWorkflows;
    private final Gson operationGson = new GsonBuilder().serializeNulls().serializeSpecialFloatingPointValues().registerTypeAdapter(Date.class, (Object)new DateEpochMillisAdapter()).registerTypeAdapter(OperationList.class, (Object)new OperationListAdapter()).create();
    private Object operationFormConfigurations;
    private String formConfigurationsHash;

    public LibraryResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.initializeLibraryWorkflowsFromStore();
        this.buildAllowedOperationsForLicense();
    }

    private com.nuix.automate.workflow.core.execution.workflow.Workflow parseWorkflowXml(String workflowXml) {
        try {
            WorkflowExecution workflowExecution = new WorkflowExecution();
            workflowExecution.openWorkflow(workflowXml);
            return workflowExecution.getWorkflow();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void initializeLibraryWorkflowsFromStore() {
        LOGGER.info("Initializing Libraries from store");
        this.libraries = new HashMap<String, WorkflowLibrary>();
        this.libraryWorkflows = new HashMap<String, Map<String, Workflow>>();
        List<WorkflowLibrary> workflowLibraries = this.schedulerApplication.getWorkflowLibraryDao().getLibraries();
        for (WorkflowLibrary workflowLibrary : workflowLibraries) {
            this.libraries.put(workflowLibrary.getId(), workflowLibrary);
            this.libraryWorkflows.put(workflowLibrary.getId(), new HashMap());
        }
        LOGGER.info("Initializing Workflows from store");
        this.workflows = new HashMap<String, Workflow>();
        List<Workflow> workflows = this.schedulerApplication.getWorkflowLibraryDao().getWorkflows();
        for (Workflow workflow : workflows) {
            this.workflows.put(workflow.getId(), workflow);
            Map libraryMap = this.libraryWorkflows.computeIfAbsent(workflow.getLibraryId(), k -> new HashMap());
            libraryMap.put(workflow.getId(), workflow);
        }
    }

    public void migrateWorkflows() {
        LOGGER.info("Running workflow migration check");
        WorkflowExecution workflowExecution = new WorkflowExecution();
        Pattern xmlSizePattern = Pattern.compile("Xml: ([\\d,.\\s]+) ");
        for (Workflow workflow : this.workflows.values()) {
            boolean updateWorkflow = false;
            if (workflow.getLastModified() == 0L) {
                workflow.setLastModified(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
                LOGGER.info("Setting current timestamp on workflow " + workflow.getId());
                updateWorkflow = true;
            }
            if (workflow.getUsage() == null) {
                workflow.setUsage("");
                LOGGER.info("Setting default value for using on workflow " + workflow.getId());
                updateWorkflow = true;
            }
            boolean parametersMigrationRequired = false;
            if (workflow.getSessionParameters() == null || workflow.getSessionParameters().isEmpty()) {
                parametersMigrationRequired = true;
            } else {
                for (com.nuix.automate.utils.models.api.job.Parameter parameter : workflow.getSessionParameters()) {
                    if (parameter.getParameterType() != null) continue;
                    parametersMigrationRequired = true;
                }
            }
            try {
                com.nuix.automate.utils.models.api.job.Parameter parameter;
                HashMap<String, com.nuix.automate.utils.models.api.job.Parameter> workflowSessionParameters = new HashMap<String, com.nuix.automate.utils.models.api.job.Parameter>();
                parameter = workflow.getSessionParameters().iterator();
                while (parameter.hasNext()) {
                    com.nuix.automate.utils.models.api.job.Parameter parameter2 = (com.nuix.automate.utils.models.api.job.Parameter)parameter.next();
                    workflowSessionParameters.put(parameter2.getName(), parameter2);
                }
                workflowExecution.openWorkflow(workflow.getOperationsXml());
                boolean normalized = workflowExecution.normalizeWorkflow();
                boolean parametersModified = workflowExecution.getWorkflow().cleanupScriptedParameters();
                if (normalized || parametersModified) {
                    parametersMigrationRequired = true;
                }
                boolean userParametersMigrated = false;
                for (com.nuix.automate.workflow.core.execution.operations.Operation operation : workflowExecution.getWorkflow().getOperations()) {
                    if (!(operation instanceof ConfigureParametersOperation)) continue;
                    ConfigureParametersOperation configureParameters = (ConfigureParametersOperation)operation;
                    if (configureParameters.userParameters == null || configureParameters.userParameters.size() <= 0) continue;
                    for (StaticParameter userParameter : configureParameters.userParameters) {
                        com.nuix.automate.utils.models.api.job.Parameter workflowSessionParameter = (com.nuix.automate.utils.models.api.job.Parameter)workflowSessionParameters.get(userParameter.getName());
                        if (workflowSessionParameter == null || workflowSessionParameter.getParameterType() != userParameter.getParameterType()) {
                            userParametersMigrated = true;
                        }
                        if (userParameter.getAllowedValuesMatchBy() == null || workflowSessionParameter == null || workflowSessionParameter.getAllowedValuesMatchBy() == null || !userParameter.getAllowedValuesMatchBy().equals((Object)workflowSessionParameter.getAllowedValuesMatchBy())) {
                            userParameter.setAllowedValuesMatchBy(ParameterValueMatchBy.SYSTEM_OR_USER_PRINTABLE_VALUE);
                            userParametersMigrated = true;
                        }
                        if (userParameter.getParameterType() != ParameterType.MICROSOFT_USER_SERVICE) continue;
                        userParameter.setParameterType(ParameterType.PURVIEW_SERVICE);
                        userParametersMigrated = true;
                    }
                }
                if (userParametersMigrated) {
                    updateWorkflow = true;
                    parametersMigrationRequired = true;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to normalize workflow", (Throwable)e);
            }
            if (parametersMigrationRequired) {
                if (workflow.getSessionParameters() == null) {
                    workflow.setSessionParameters(new ArrayList());
                }
                try {
                    List configurationParameters = workflowExecution.getWorkflow().getUserParameters();
                    workflow.setSessionParameters(configurationParameters);
                }
                catch (Exception e) {
                    LOGGER.info("Failed to migrate workflow parameters for workflow " + workflow.getId(), (Throwable)e);
                }
                updateWorkflow = true;
            }
            if (workflow.getAllowedParameterValues() != null) {
                for (com.nuix.automate.utils.models.api.job.Parameter sessionParameter : workflow.getSessionParameters()) {
                    List allowedValues;
                    if (!workflow.getAllowedParameterValues().containsKey(sessionParameter.getName()) || (allowedValues = (List)workflow.getAllowedParameterValues().get(sessionParameter.getName())) == null) continue;
                    sessionParameter.setAllowedValues(new LinkedHashSet(allowedValues));
                }
                workflow.setAllowedParameterValues(null);
                updateWorkflow = true;
            }
            try {
                List<AuditEvent> auditEvents = this.schedulerApplication.getAuditLogDao().getAuditEvents(workflow.getId());
                if (auditEvents != null) {
                    for (AuditEvent auditEvent : auditEvents) {
                        Matcher matcher = xmlSizePattern.matcher(auditEvent.getDetails());
                        if (!matcher.find()) continue;
                        String fileSize = matcher.group(1);
                        auditEvent.setDetails(iu.getFormattedString("LibraryResource.Details.FileSize", (Object)fileSize));
                        this.schedulerApplication.getAuditLogDao().updateAuditEventDetails(auditEvent);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to migrate workflow auditEvent XML to File Size", (Throwable)e);
            }
            if (!updateWorkflow) continue;
            try {
                com.nuix.automate.workflow.core.execution.workflow.Workflow previousWorkflow = workflowExecution.getWorkflow();
                if (previousWorkflow != null) {
                    workflow.setOperationsXml(previousWorkflow.toXml());
                }
            }
            catch (IOException e) {
                LOGGER.error("Error converting workflow to xml", (Throwable)e);
            }
            this.schedulerApplication.getWorkflowLibraryDao().updateWorkflow(workflow);
        }
    }

    @Operation(tags={"Workflow Libraries", "Job Submission"}, operationId="ListWorkflowLibraries", summary="List Libraries", description="List workflow libraries", responses={@ApiResponse(description="The list of libraries", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @javax.ws.rs.Path(value="/list")
    public Response listWorkflowLibraries(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The max number of items to return") @QueryParam(value="maxCount") Integer maxCount) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LIBRARIES_ENABLED, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<WorkflowLibrary> allowedLibraries = new ArrayList<WorkflowLibrary>();
            for (WorkflowLibrary workflowLibrary : this.libraries.values()) {
                WorkflowLibrary result;
                if (!workflowLibrary.getEnabled().booleanValue() || !(result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary)).getUserPermissions().contains(Permission.VIEW)) continue;
                allowedLibraries.add(result);
            }
            SortingUtils.sortList(allowedLibraries, WorkflowLibrary::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedLibraries, (Integer)maxCount)).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowLibraries", summary="Get Libraries", description="Get full information of all workflow libraries. Only use this method if the information returned by ListWorkflowLibraries is not sufficient", responses={@ApiResponse(description="The list of libraries", content={@Content(array=@ArraySchema(schema=@Schema(implementation=WorkflowLibrary.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getWorkflowLibraries(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="Include disabled clients") @QueryParam(value="includeDisabled") boolean includeDisabled, @Parameter(description="Required parameter types") @QueryParam(value="requiredParameterTypes") Set<ParameterType> requiredParameterTypes, @Parameter(description="Forbidden parameter types") @QueryParam(value="forbiddenParameterTypes") Set<ParameterType> forbiddenParameterTypes) {
        boolean hasParameterTypeFilters;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(includeDisabled ? CacheKey.LIBRARIES : CacheKey.LIBRARIES_ENABLED, "");
        boolean bl = hasParameterTypeFilters = requiredParameterTypes != null && requiredParameterTypes.size() > 0 || forbiddenParameterTypes != null && forbiddenParameterTypes.size() > 0;
        if (!hasParameterTypeFilters) {
            try {
                return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        ArrayList<WorkflowLibrary> allowedLibraries = new ArrayList<WorkflowLibrary>();
        for (WorkflowLibrary workflowLibrary : this.libraries.values()) {
            WorkflowLibrary result;
            if (!includeDisabled && !workflowLibrary.getEnabled().booleanValue()) continue;
            if (hasParameterTypeFilters) {
                boolean librarySatisfiesFilter = false;
                for (Workflow workflow : this.getLibraryWorkflows(workflowLibrary.getId())) {
                    if (!includeDisabled && !workflow.getEnabled().booleanValue()) continue;
                    boolean workflowSatisfiesFilter = true;
                    if (requiredParameterTypes != null) {
                        boolean containsRequiredParameter = false;
                        for (ParameterType requiredParameterType : requiredParameterTypes) {
                            if (containsRequiredParameter) break;
                            if (workflow.getSessionParameters() != null) {
                                for (com.nuix.automate.utils.models.api.job.Parameter param : workflow.getSessionParameters()) {
                                    if (param.getParameterType() != requiredParameterType) continue;
                                    containsRequiredParameter = true;
                                    break;
                                }
                            }
                            if (containsRequiredParameter) continue;
                            workflowSatisfiesFilter = false;
                        }
                    }
                    if (forbiddenParameterTypes != null) {
                        boolean containsForbiddenParameter = false;
                        for (ParameterType forbiddenParameterType : forbiddenParameterTypes) {
                            if (containsForbiddenParameter) break;
                            if (workflow.getSessionParameters() != null) {
                                for (com.nuix.automate.utils.models.api.job.Parameter param : workflow.getSessionParameters()) {
                                    if (param.getParameterType() != forbiddenParameterType) continue;
                                    containsForbiddenParameter = true;
                                    break;
                                }
                            }
                            if (!containsForbiddenParameter) continue;
                            workflowSatisfiesFilter = false;
                        }
                    }
                    if (!workflowSatisfiesFilter) continue;
                    librarySatisfiesFilter = true;
                    break;
                }
                if (!librarySatisfiesFilter) continue;
            }
            if (!(result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary)).getUserPermissions().contains(Permission.VIEW)) continue;
            allowedLibraries.add(result);
        }
        SortingUtils.sortList(allowedLibraries, WorkflowLibrary::getName);
        if (hasParameterTypeFilters) {
            String lastHash = ResponseCache.getInstance().hashObject(allowedLibraries);
            try {
                return ResponseCache.getInstance().getResponse(lastHash, request);
            }
            catch (CacheException cacheException) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedLibraries).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedLibraries).build();
    }

    public List<WorkflowLibrary> getWorkflowLibraries() {
        return new ArrayList<WorkflowLibrary>(this.libraries.values());
    }

    public WorkflowLibrary getWorkflowLibrary(String libraryId) {
        return this.libraries.get(libraryId);
    }

    public Workflow getLibraryWorkflow(String workflowId) {
        Workflow workflow = this.workflows.get(workflowId);
        if (workflow != null && workflow.getExecutionMode() == null && workflow.getOperationsXml() != null) {
            try {
                ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
                workflow.setExecutionMode(immutableWorkflow.getExecutionMode());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return workflow;
    }

    public List<com.nuix.automate.utils.models.api.job.Parameter> getLibraryWorkflowParameters(String workflowId) {
        Workflow workflow = this.workflows.get(workflowId);
        if (workflow != null) {
            return workflow.getSessionParameters();
        }
        return null;
    }

    public Collection<Workflow> getLibraryWorkflows(String libraryId) {
        if (libraryId == null || this.libraryWorkflows.get(libraryId) == null) {
            return new ArrayList<Workflow>();
        }
        return this.libraryWorkflows.get(libraryId).values();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowLibrary", summary="Get Library", description="Get the library with the specified ID", responses={@ApiResponse(description="The library", content={@Content(schema=@Schema(implementation=WorkflowLibrary.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}")
    @GET
    public Response getWorkflowLibrary(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The library ID") @PathParam(value="libraryId") String libraryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LIBRARY, libraryId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            WorkflowLibrary workflowLibrary = this.libraries.get(libraryId);
            if (workflowLibrary == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindLibrary", (Map)new HashMap<String, String>(){
                    {
                        this.put("libraryId", libraryId);
                    }
                })).build();
            }
            WorkflowLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowLibraryWorkflows", summary="Get Workflows", description="Get full information of all workflows in the library with the specified ID. Only use this method if the information returned by ListWorkflowLibraryWorkflows is not sufficient", responses={@ApiResponse(description="The list of workflows", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Workflow.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}/workflows")
    @GET
    public Response getWorkflowLibraryWorkflows(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The library ID") @PathParam(value="libraryId") String libraryId, @Parameter(description="Include disabled workflows") @QueryParam(value="includeDisabled") boolean includeDisabled, @Parameter(description="Required parameter types") @QueryParam(value="requiredParameterTypes") Set<ParameterType> requiredParameterTypes, @Parameter(description="Forbidden parameter types") @QueryParam(value="forbiddenParameterTypes") Set<ParameterType> forbiddenParameterTypes) {
        WorkflowLibrary workflowLibrary;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        boolean hasParameterTypeFilters = requiredParameterTypes != null && requiredParameterTypes.size() > 0 || forbiddenParameterTypes != null && forbiddenParameterTypes.size() > 0;
        long lastModified = ResponseCache.getInstance().getLastModified(includeDisabled ? CacheKey.LIBRARY_WORKFLOWS : CacheKey.LIBRARY_WORKFLOWS_ENABLED, libraryId);
        if (!hasParameterTypeFilters) {
            try {
                return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
        if ((workflowLibrary = this.libraries.get(libraryId)) == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindLibrary", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryId", libraryId);
                }
            })).build();
        }
        ArrayList<Workflow> allowedWorkflows = new ArrayList<Workflow>();
        for (Workflow workflowModel : this.libraryWorkflows.get(libraryId).values()) {
            Workflow result;
            if (!includeDisabled && !workflowModel.getEnabled().booleanValue()) continue;
            if (hasParameterTypeFilters) {
                HashSet<ParameterType> workflowParameterTypes = new HashSet<ParameterType>();
                for (com.nuix.automate.utils.models.api.job.Parameter parameter : workflowModel.getSessionParameters()) {
                    workflowParameterTypes.add(parameter.getParameterType());
                }
                boolean workflowSatisfiesFilter = true;
                if (requiredParameterTypes != null) {
                    workflowSatisfiesFilter = workflowParameterTypes.containsAll(requiredParameterTypes);
                }
                if (forbiddenParameterTypes != null) {
                    for (ParameterType forbiddenParameterType : forbiddenParameterTypes) {
                        if (!workflowParameterTypes.contains(forbiddenParameterType)) continue;
                        workflowSatisfiesFilter = false;
                        break;
                    }
                }
                if (!workflowSatisfiesFilter) continue;
            }
            if (!(result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowModel)).getUserPermissions().contains(Permission.VIEW)) continue;
            allowedWorkflows.add(result);
            result.setOperationsXml(null);
            result.setSessionParameters(null);
            result.setIcon(null);
        }
        SortingUtils.sortList(allowedWorkflows, Workflow::getName);
        if (hasParameterTypeFilters) {
            String lastHash = ResponseCache.getInstance().hashObject(allowedWorkflows);
            try {
                return ResponseCache.getInstance().getResponse(lastHash, request);
            }
            catch (CacheException cacheException) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedWorkflows).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedWorkflows).build();
    }

    @Operation(tags={"Workflow Libraries", "Job Submission"}, operationId="ListWorkflowLibraryWorkflows", summary="List Workflows", description="List the workflows in the library with the specified ID", responses={@ApiResponse(description="The list of workflows", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}/workflows/list")
    @GET
    public Response listWorkflowLibraryWorkflows(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The library ID") @PathParam(value="libraryId") String libraryId, @Parameter(description="The max number of items to return") @QueryParam(value="maxCount") Integer maxCount) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.LIBRARY_WORKFLOWS_ENABLED, libraryId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            WorkflowLibrary workflowLibrary = this.libraries.get(libraryId);
            if (workflowLibrary == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindLibrary", (Map)new HashMap<String, String>(){
                    {
                        this.put("libraryId", libraryId);
                    }
                })).build();
            }
            ArrayList<Workflow> allowedWorkflows = new ArrayList<Workflow>();
            for (Workflow workflowModel : this.libraryWorkflows.get(libraryId).values()) {
                Workflow result;
                if (!workflowModel.getEnabled().booleanValue() || !(result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowModel)).getUserPermissions().contains(Permission.VIEW)) continue;
                allowedWorkflows.add(result);
                result.setOperationsXml(null);
                result.setSessionParameters(null);
                result.setIcon(null);
            }
            SortingUtils.sortList(allowedWorkflows, Workflow::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedWorkflows, (Integer)maxCount)).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="AddWorkflowLibrary", summary="Add Library", description="Add a new library", responses={@ApiResponse(description="The library that was added", content={@Content(schema=@Schema(implementation=WorkflowLibrary.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @POST
    public Response addWorkflowLibrary(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The library to add", schema=@Schema(implementation=WorkflowLibrarySubmission.class)) WorkflowLibrary workflowLibrary) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)workflowLibrary);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (workflowLibrary.getName() == null || workflowLibrary.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"libraryNameMissing", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (final WorkflowLibrary existingWorkflowWorkflowLibrary : this.libraries.values()) {
            if (!existingWorkflowWorkflowLibrary.getName().equalsIgnoreCase(workflowLibrary.getName())) continue;
            return ExceptionUtils.toResponse((String)"libraryExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingLibraryModel", existingWorkflowWorkflowLibrary.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        workflowLibrary.setId(UidUtils.getRandom());
        return this.addWorkflowLibraryInternal(user, workflowLibrary, request);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="LoadWorkflowLibraries", summary="Load Libraries", description="Load libraries from a folder structure", responses={@ApiResponse(description="The load status", content={@Content(schema=@Schema(implementation=AddWorkflowLibrariesResponse.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @javax.ws.rs.Path(value="/load")
    @POST
    public Response loadLibraries(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The folder to load libraries from") String librariesLocation) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)BuiltInScopeIdentifiers.ALL_LIBRARIES);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        AddWorkflowLibrariesResponse response = this.loadLibrariesInternal(librariesLocation);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @javax.ws.rs.Path(value="/{libraryId}/downloadZip")
    @POST
    public Response downloadLibraryZip(@Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="libraryId") String libraryId, @FormParam(value="token") String token) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, request);
        if (user.isPresent()) {
            return this.downloadLibraryZip(user.get(), request, libraryId);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DownloadWorkflowLibraryZip", summary="Download Library Zip", description="Download library as a zip", responses={@ApiResponse(description="Workflow library as a zip", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @javax.ws.rs.Path(value="/{libraryId}/downloadZip")
    @GET
    public Response downloadLibraryZip(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="libraryId") String libraryId) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        WorkflowLibrary library = this.libraries.get(libraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLibrary", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryId", libraryId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        WorkflowLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)request);
        }
        String sanitizedLibraryName = FormattingUtils.sanitizeFilename((String)library.getName());
        StreamingOutput streamingOutput = outputStream -> {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                zipOutputStream.setLevel(1);
                try {
                    this.writeLibraryZipEntry(user, zipOutputStream, library, sanitizedLibraryName);
                }
                catch (Exception e) {
                    LOGGER.error("Error writing library " + library.getName(), (Throwable)e);
                }
            }
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)streamingOutput, (String)(sanitizedLibraryName + ".zip"));
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @javax.ws.rs.Path(value="/downloadZip")
    @POST
    public Response downloadLibrariesZip(@Parameter(hidden=true) @Context HttpServletRequest request, @FormParam(value="token") String token) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, request);
        if (user.isPresent()) {
            return this.downloadLibrariesZip(user.get(), request);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DownloadWorkflowLibrariesZip", summary="Download Libraries Zip", description="Download libraries as a zip", responses={@ApiResponse(description="Workflow libraries as a zip", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @javax.ws.rs.Path(value="/downloadZip")
    @GET
    public Response downloadLibrariesZip(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)BuiltInScopeIdentifiers.ALL_LIBRARIES);
        }
        StreamingOutput streamingOutput = outputStream -> {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                zipOutputStream.setLevel(1);
                for (WorkflowLibrary library : this.libraries.values()) {
                    WorkflowLibrary libraryResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library);
                    if (!libraryResult.getUserPermissions().contains(Permission.VIEW)) continue;
                    try {
                        String sanitizedLibraryName = FormattingUtils.sanitizeFilename((String)library.getName());
                        this.writeLibraryZipEntry(user, zipOutputStream, library, sanitizedLibraryName);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error writing library " + library.getName(), (Throwable)e);
                    }
                }
            }
        };
        String fileName = "Automate Libraries " + FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC));
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)streamingOutput, (String)(fileName + ".zip"));
    }

    @Operation(tags={"Workflow Libraries"}, operationId="UploadWorkflowLibrariesZip", summary="Upload Libraries Zip", description="Upload libraries as a zip", responses={@ApiResponse(description="The load status", content={@Content(schema=@Schema(implementation=AddWorkflowLibrariesResponse.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @javax.ws.rs.Path(value="/uploadZip")
    @POST
    public Response uploadLibrariesZip(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The zip of libraries") FileContents fileContentsModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)BuiltInScopeIdentifiers.ALL_LIBRARIES);
        }
        String fileContents = fileContentsModel.getContents();
        byte[] decodedFileContents = Base64.getDecoder().decode(fileContents);
        LOGGER.info("Loading Workflow libraries from uploaded zip file");
        AddWorkflowLibrariesResponse addResponse = new AddWorkflowLibrariesResponse();
        try (CountingZipInputStream zis = new CountingZipInputStream((InputStream)new ByteArrayInputStream(decodedFileContents), 2048, 0x200000000L);){
            ZipEntry zipEntry;
            HashMap<String, WorkflowLibrary> workflowLibraries = new HashMap<String, WorkflowLibrary>();
            HashSet<String> existingLibraries = new HashSet<String>();
            while ((zipEntry = zis.getNextEntry()) != null) {
                try {
                    if (zipEntry.isDirectory()) {
                        String libraryName = zipEntry.getName();
                        if (libraryName.endsWith("/")) {
                            libraryName = libraryName.substring(0, libraryName.length() - 1);
                        }
                        LOGGER.info("Loading Workflow Library " + libraryName);
                        WorkflowLibrary workflowLibrary = null;
                        for (WorkflowLibrary existing : this.libraries.values()) {
                            if (!existing.getName().equalsIgnoreCase(libraryName)) continue;
                            workflowLibrary = existing;
                        }
                        if (workflowLibrary == null) {
                            workflowLibrary = this.createDefaultWorkflowLibrary(libraryName);
                            try (Response addLibraryResponse = this.addWorkflowLibraryInternal(new SystemBearerUser(), workflowLibrary, null);){
                                if (addLibraryResponse.getStatus() == 200) {
                                    workflowLibrary = (WorkflowLibrary)addLibraryResponse.getEntity();
                                    addResponse.incrementLibrariesAdded();
                                }
                                addResponse.incrementLibrariesWithErrors();
                            }
                        } else {
                            existingLibraries.add(libraryName);
                        }
                        workflowLibraries.put(libraryName, this.libraries.get(workflowLibrary.getId()));
                        continue;
                    }
                    String[] nameSplit = zipEntry.getName().split("/");
                    if (nameSplit.length != 2) {
                        LOGGER.error("Unexpected zip entry " + zipEntry.getName() + ", expected entry to be nested within a library directory");
                        addResponse.incrementInvalidEntries();
                        continue;
                    }
                    String name = nameSplit[nameSplit.length - 1];
                    String libraryName = nameSplit[0];
                    WorkflowLibrary workflowLibrary = (WorkflowLibrary)workflowLibraries.get(libraryName);
                    if (workflowLibrary == null) {
                        LOGGER.error("Could not find library " + libraryName);
                        addResponse.incrementInvalidEntries();
                        continue;
                    }
                    boolean libraryUpdated = false;
                    if (name.equalsIgnoreCase("library.json")) {
                        try {
                            LOGGER.info("Loading library metadata for " + workflowLibrary.getName());
                            String metadataContents = IOUtils.toString((InputStream)zis, (Charset)StandardCharsets.UTF_8);
                            WorkflowLibrary updatedLibrary = (WorkflowLibrary)workflowLibrary.clone();
                            this.updateWorkflowLibraryMetadata(updatedLibrary, metadataContents);
                            try (Response updateResponse = this.updateWorkflowLibrary(new SystemBearerUser(), null, updatedLibrary.getId(), updatedLibrary);){
                                if (updateResponse.getStatus() == 200) {
                                    if (existingLibraries.remove(libraryName)) {
                                        libraryUpdated = true;
                                    }
                                } else {
                                    addResponse.incrementLibrariesWithErrors();
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error parsing metadata JSON for library " + workflowLibrary.getName(), (Throwable)e);
                        }
                    } else if (name.toLowerCase().contains(".rfn") || name.toLowerCase().contains(".zip")) {
                        try {
                            LOGGER.info("Loading workflow " + name);
                            if (this.loadWorkflow(workflowLibrary.getId(), zis.readAllBytes())) {
                                addResponse.incrementWorkflowsUpdated();
                            } else {
                                addResponse.incrementWorkflowsAdded();
                            }
                            if (existingLibraries.remove(libraryName)) {
                                libraryUpdated = true;
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Error adding workflow " + name, (Throwable)e);
                            addResponse.incrementWorkflowsWithErrors();
                        }
                    }
                    if (!libraryUpdated) continue;
                    addResponse.incrementLibrariesUpdated();
                }
                catch (Exception e) {
                    LOGGER.error("Error handling zipEntry " + zipEntry.getName(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading zip file contents", (Throwable)e);
            return ExceptionUtils.toResponse((String)"errorUploadingLibraryZip", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)addResponse).build();
    }

    private void writeLibraryZipEntry(BearerUser user, ZipOutputStream zipOutputStream, WorkflowLibrary library, String parentZipEntryName) throws IOException {
        LOGGER.info("Writing library " + library.getName() + " and workflows");
        WorkflowLibrary clone = (WorkflowLibrary)library.clone();
        clone.setId(null);
        clone.setUserPermissions(null);
        zipOutputStream.putNextEntry(new ZipEntry(parentZipEntryName + "/"));
        zipOutputStream.putNextEntry(new ZipEntry(parentZipEntryName + "/library.json"));
        zipOutputStream.write(SerializationUtils.toJson((Object)library, (boolean)false).getBytes(StandardCharsets.UTF_8));
        for (Workflow workflow : this.libraryWorkflows.get(library.getId()).values()) {
            try {
                Set workflowPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions();
                if (!workflowPermissions.contains(Permission.VIEW) || !workflowPermissions.contains(Permission.VIEW_SENSITIVE)) continue;
                String sanitizedWorkflowName = FormattingUtils.sanitizeFilename((String)workflow.getName());
                this.writeWorkflowZipEntry(zipOutputStream, workflow, parentZipEntryName + "/" + sanitizedWorkflowName, false);
            }
            catch (Exception e) {
                LOGGER.error("Error writing workflow " + workflow.getName(), (Throwable)e);
            }
        }
    }

    private void writeWorkflowZipEntry(ZipOutputStream zipOutputStream, Workflow workflow, String zipEntryName, boolean includeHtml) throws IOException {
        ZipEntry rfnEntry = new ZipEntry(zipEntryName + ".rfn");
        rfnEntry.setCreationTime(FileTime.fromMillis(0L));
        rfnEntry.setLastModifiedTime(FileTime.fromMillis(workflow.getLastModified()));
        zipOutputStream.putNextEntry(rfnEntry);
        FormattingUtils.appendBOM((OutputStream)zipOutputStream);
        zipOutputStream.write(workflow.getOperationsXml().getBytes(StandardCharsets.UTF_8));
        if (includeHtml) {
            ZipEntry htmlEntry = new ZipEntry(zipEntryName + ".html");
            htmlEntry.setCreationTime(FileTime.fromMillis(0L));
            htmlEntry.setLastModifiedTime(FileTime.fromMillis(workflow.getLastModified()));
            ImmutableWorkflow immutableWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
            zipOutputStream.putNextEntry(htmlEntry);
            FormattingUtils.appendBOM((OutputStream)zipOutputStream);
            zipOutputStream.write(WorkflowRenderer.getWorkflowHtmlReport((ImmutableWorkflow)immutableWorkflow, (long)workflow.getLastModified()).getBytes(StandardCharsets.UTF_8));
        }
    }

    private WorkflowLibrary createDefaultWorkflowLibrary(String name) {
        WorkflowLibrary workflowLibrary = new WorkflowLibrary();
        workflowLibrary.setName(name);
        workflowLibrary.setEnabled(Boolean.valueOf(true));
        workflowLibrary.setDescription("");
        return workflowLibrary;
    }

    private void updateWorkflowLibraryMetadata(WorkflowLibrary workflowLibrary, String metadataContents) {
        Map libraryMetadataMap = (Map)SerializationUtils.fromJson((String)metadataContents, Map.class);
        this.updateWorkflowLibraryMetadata(workflowLibrary, libraryMetadataMap);
    }

    private void updateWorkflowLibraryMetadata(WorkflowLibrary workflowLibrary, Map<String, Object> metadataMap) {
        Object libraryEnabled;
        Object libraryDescription;
        if (metadataMap == null) {
            return;
        }
        Object libraryName = metadataMap.get("name");
        if (libraryName != null) {
            workflowLibrary.setName(libraryName.toString());
        }
        if ((libraryDescription = metadataMap.get("description")) != null) {
            workflowLibrary.setDescription(libraryDescription.toString());
        }
        if ((libraryEnabled = metadataMap.get("enabled")) != null) {
            workflowLibrary.setEnabled(Boolean.valueOf(Boolean.parseBoolean(libraryEnabled.toString())));
        }
    }

    private boolean loadWorkflow(String libraryId, byte[] workflowData) throws IOException {
        com.nuix.automate.workflow.core.execution.workflow.Workflow _workflow = com.nuix.automate.workflow.core.execution.workflow.Workflow.fromXml((String)new String(workflowData, StandardCharsets.UTF_8));
        byte[] encodedData = Base64.getEncoder().encode(workflowData);
        String workflowXml = new String(encodedData, StandardCharsets.UTF_8);
        Workflow workflow = new Workflow();
        workflow.setOperationsXml(workflowXml);
        workflow.setName(_workflow.getName());
        workflow.setEnabled(Boolean.valueOf(true));
        try (Response addResponse = this.addWorkflow(new SystemBearerUser(), null, workflow, libraryId, false, false, false);){
            if (addResponse.getStatus() == 200) {
                boolean bl = false;
                return bl;
            }
            try (Response updateResponse = this.addWorkflow(new SystemBearerUser(), null, workflow, libraryId, false, true, false);){
                if (updateResponse.getStatus() == 200) {
                    boolean bl = true;
                    return bl;
                }
                throw new IllegalStateException("Unsuccessful response: " + updateResponse.getStatus() + ", " + SerializationUtils.toJson((Object)updateResponse.getEntity()));
            }
        }
    }

    public AddWorkflowLibrariesResponse loadLibrariesInternal(String librariesLocation) throws IOException {
        LOGGER.info("Loading libraries from " + librariesLocation);
        AtomicInteger librariesWithErrors = new AtomicInteger(0);
        AtomicInteger librariesAddedCount = new AtomicInteger(0);
        AtomicInteger librariesUpdatedCount = new AtomicInteger(0);
        AtomicInteger workflowsWithErrors = new AtomicInteger(0);
        AtomicInteger workflowsAddedCount = new AtomicInteger(0);
        AtomicInteger workflowsUpdatedCount = new AtomicInteger(0);
        Path librariesPath = Paths.get(librariesLocation, new String[0]);
        try (Stream<Path> libraryPaths = Files.walk(librariesPath, 1, new FileVisitOption[0]);){
            libraryPaths.filter(libraryPath -> !libraryPath.equals(librariesPath)).forEach(libraryPath -> {
                WorkflowLibrary workflowLibrary = this.createDefaultWorkflowLibrary(libraryPath.toFile().getName());
                workflowLibrary.setId(UidUtils.getRandom());
                Path libraryMetadata = libraryPath.resolve("library.json");
                boolean libraryError = false;
                if (Files.exists(libraryMetadata, new LinkOption[0])) {
                    try {
                        String fileContents = FileUtils.readFileWithAutodetectEncoding((File)libraryMetadata.toFile());
                        this.updateWorkflowLibraryMetadata(workflowLibrary, fileContents);
                    }
                    catch (Exception e) {
                        libraryError = true;
                        LOGGER.error("Cannot read library " + String.valueOf(libraryPath) + " metadata", (Throwable)e);
                    }
                }
                try {
                    LOGGER.info("Adding library " + workflowLibrary.getName() + " from filesystem");
                    boolean libraryExists = false;
                    for (WorkflowLibrary existingWorkflowWorkflowLibrary : this.libraries.values()) {
                        if (!existingWorkflowWorkflowLibrary.getName().equalsIgnoreCase(workflowLibrary.getName())) continue;
                        libraryExists = true;
                        workflowLibrary = existingWorkflowWorkflowLibrary;
                    }
                    if (!libraryExists) {
                        this.addWorkflowLibraryInternal(new SystemBearerUser(), workflowLibrary, null);
                        librariesAddedCount.incrementAndGet();
                    } else {
                        librariesUpdatedCount.incrementAndGet();
                    }
                    WorkflowLibrary finalWorkflowLibrary = workflowLibrary;
                    try (Stream<Path> workflowPaths = Files.walk(libraryPath, 1, new FileVisitOption[0]);){
                        workflowPaths.filter(workflowPath -> !workflowPath.equals(libraryPath) && (workflowPath.getFileName().toString().toLowerCase().contains(".zip") || workflowPath.getFileName().toString().toLowerCase().contains(".rfn"))).forEach(workflowPath -> {
                            LOGGER.info("Loading workflow from " + String.valueOf(workflowPath));
                            try {
                                byte[] workflowData = Files.readAllBytes(workflowPath);
                                byte[] encodedData = Base64.getEncoder().encode(workflowData);
                                Workflow workflow = new Workflow();
                                workflow.setOperationsXml(new String(encodedData, StandardCharsets.UTF_8));
                                workflow.setName(FileUtils.getFileNameWithoutExtension((String)workflowPath.getFileName().toString()));
                                workflow.setEnabled(Boolean.valueOf(true));
                                Response response = this.addWorkflow(new SystemBearerUser(), null, workflow, finalWorkflowLibrary.getId(), false, false, false);
                                if (response.getStatus() == 200) {
                                    workflowsAddedCount.incrementAndGet();
                                } else {
                                    Response responseUpdate = this.addWorkflow(new SystemBearerUser(), null, workflow, finalWorkflowLibrary.getId(), false, true, false);
                                    if (responseUpdate.getStatus() == 200) {
                                        workflowsUpdatedCount.incrementAndGet();
                                    } else {
                                        workflowsWithErrors.incrementAndGet();
                                    }
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("Cannot add workflow", (Throwable)e);
                                workflowsWithErrors.incrementAndGet();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    libraryError = true;
                    LOGGER.error("Cannot add library " + workflowLibrary.getName(), (Throwable)e);
                }
                if (libraryError) {
                    librariesWithErrors.incrementAndGet();
                }
            });
        }
        AddWorkflowLibrariesResponse response = new AddWorkflowLibrariesResponse();
        response.setLibrariesAdded(Integer.valueOf(librariesAddedCount.get()));
        response.setLibrariesWithErrors(Integer.valueOf(librariesWithErrors.get()));
        response.setLibrariesUpdated(Integer.valueOf(librariesUpdatedCount.get()));
        response.setWorkflowsAdded(Integer.valueOf(workflowsAddedCount.get()));
        response.setWorkflowsWithErrors(Integer.valueOf(workflowsWithErrors.get()));
        response.setWorkflowsUpdated(Integer.valueOf(workflowsUpdatedCount.get()));
        return response;
    }

    public Response addWorkflowLibraryInternal(BearerUser user, WorkflowLibrary workflowLibrary, HttpServletRequest request) {
        if (workflowLibrary.getId() == null) {
            workflowLibrary.setId(UidUtils.getRandom());
        }
        String libraryId = workflowLibrary.getId();
        workflowLibrary.setDefaults();
        FormattingUtils.trimAllStrings((Object)workflowLibrary);
        this.libraries.put(workflowLibrary.getId(), workflowLibrary);
        this.libraryWorkflows.put(workflowLibrary.getId(), new HashMap());
        this.schedulerApplication.getWorkflowLibraryDao().addLibrary(workflowLibrary);
        WorkflowLibrary createdWorkflowWorkflowLibrary = this.libraries.get(workflowLibrary.getId());
        if (createdWorkflowWorkflowLibrary != null) {
            StringBuilder details = new StringBuilder();
            if (createdWorkflowWorkflowLibrary.getName() != null) {
                details.append(iu.getFormattedString("LibraryResource.Details.Name", (Object)createdWorkflowWorkflowLibrary.getName()));
            }
            if (createdWorkflowWorkflowLibrary.getDescription() != null && createdWorkflowWorkflowLibrary.getDescription().trim().length() > 0) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getFormattedString("LibraryResource.Details.Description", (Object)createdWorkflowWorkflowLibrary.getDescription()));
            }
            if (createdWorkflowWorkflowLibrary.getEnabled() != null && createdWorkflowWorkflowLibrary.getEnabled() != Boolean.TRUE) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getString("LibraryResource.Details.Disabled"));
            }
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), libraryId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LIBRARY_ADDED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.updateLibraryUtilization(createdWorkflowWorkflowLibrary);
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
            WorkflowLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdWorkflowWorkflowLibrary);
            WorkflowLibrary eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdWorkflowWorkflowLibrary);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.LIBRARY_ADDED, eventResult, user.getName());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
        return ExceptionUtils.toResponse((String)"libraryIdDoesNotExist", (Map)new HashMap<String, String>(){
            {
                this.put("libraryWorkflowModel", "");
            }
        }, (Response.Status)Response.Status.NOT_FOUND);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="UpdateWorkflowLibrary", summary="Update Library", description="Update the library with the specified ID", responses={@ApiResponse(description="The updated library", content={@Content(schema=@Schema(implementation=WorkflowLibrary.class))}), @ApiResponse(responseCode="400", description="Library name is missing, or a library with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}")
    @PUT
    public Response updateWorkflowLibrary(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the library to update") @PathParam(value="libraryId") String libraryId, @Parameter(description="The information to update the library with", schema=@Schema(implementation=WorkflowLibrarySubmission.class)) WorkflowLibrary workflowLibrary) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        WorkflowLibrary originalWorkflowWorkflowLibrary = this.libraries.get(libraryId);
        if (workflowLibrary.getName() == null) {
            workflowLibrary.setName(originalWorkflowWorkflowLibrary.getName());
        }
        if (workflowLibrary.getDescription() == null) {
            workflowLibrary.setDescription(originalWorkflowWorkflowLibrary.getDescription());
        }
        if (workflowLibrary.getEnabled() == null) {
            workflowLibrary.setEnabled(originalWorkflowWorkflowLibrary.getEnabled());
        }
        if (workflowLibrary.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"libraryNameMissing", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (final WorkflowLibrary existingWorkflowWorkflowLibrary : this.libraries.values()) {
            if (!existingWorkflowWorkflowLibrary.getName().equalsIgnoreCase(workflowLibrary.getName()) || existingWorkflowWorkflowLibrary.getId().equals(libraryId)) continue;
            return ExceptionUtils.toResponse((String)"libraryNamedExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingLibraryModel", existingWorkflowWorkflowLibrary.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        workflowLibrary.setId(libraryId);
        FormattingUtils.trimAllStrings((Object)workflowLibrary);
        this.libraries.put(libraryId, workflowLibrary);
        this.schedulerApplication.getWorkflowLibraryDao().updateLibrary(workflowLibrary);
        WorkflowLibrary updatedWorkflowLibrary = this.libraries.get(libraryId);
        if (updatedWorkflowLibrary == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLibrary", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryId", libraryId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        WorkflowLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedWorkflowLibrary);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        StringBuilder details = new StringBuilder();
        if (workflowLibrary.getName() != null && !workflowLibrary.getName().equals(originalWorkflowWorkflowLibrary.getName())) {
            details.append(iu.getFormattedString("LibraryResource.Details.Name", (Object)updatedWorkflowLibrary.getName()));
        }
        if (workflowLibrary.getDescription() != null && !workflowLibrary.getDescription().equals(originalWorkflowWorkflowLibrary.getDescription())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(iu.getFormattedString("LibraryResource.Details.Description", (Object)updatedWorkflowLibrary.getDescription()));
        }
        if (workflowLibrary.getEnabled() != null && !workflowLibrary.getEnabled().equals(originalWorkflowWorkflowLibrary.getEnabled())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            if (updatedWorkflowLibrary.getEnabled() == Boolean.TRUE) {
                details.append(iu.getString("LibraryResource.Details.Enabled"));
            } else {
                details.append(iu.getString("LibraryResource.Details.Disabled"));
            }
        }
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), libraryId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LIBRARY_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        this.updateLibraryUtilization(updatedWorkflowLibrary);
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, libraryId);
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, libraryId);
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedWorkflowLibrary);
        WorkflowLibrary eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedWorkflowLibrary);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.LIBRARY_MODIFIED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DeleteWorkflowLibrary", summary="Delete Library", description="Delete the library with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find library with the specified ID or library has workflows associated")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}")
    @DELETE
    public Response deleteWorkflowLibrary(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the library to delete") @PathParam(value="libraryId") String libraryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        WorkflowLibrary workflowLibrary = this.libraries.get(libraryId);
        if (workflowLibrary == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindLibrary", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryId", libraryId);
                }
            })).build();
        }
        WorkflowLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (this.libraryWorkflows.get(libraryId).size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotDeleteLibrary")).build();
        }
        this.libraries.remove(libraryId);
        this.libraryWorkflows.remove(libraryId);
        this.schedulerApplication.getWorkflowLibraryDao().deleteLibrary(libraryId);
        WorkflowLibrary eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.LIBRARY_DELETED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), libraryId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.LIBRARY_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, libraryId);
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, libraryId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("libraryDeleted", (Map)new HashMap<String, String>(){
            {
                this.put("libraryId", libraryId);
            }
        })).build();
    }

    public void buildAllowedOperationsForLicense() {
        try {
            DynamicValuesProducer dynamicValuesProducer = new DynamicValuesProducer(){

                public Collection<String> produce(DynamicValuesType type) {
                    switch (type) {
                        case PROCESSING_PROFILES: 
                        case CONFIGURATION_PROFILES: 
                        case METADATA_PROFILES: 
                        case METADATA_IMPORT_PROFILES: 
                        case PLAYBOOKS: 
                        case OCR_PROFILES: 
                        case IMAGING_PROFILES: 
                        case PRODUCTION_PROFILES: {
                            return null;
                        }
                        case CHARSETS: {
                            return Charset.availableCharsets().keySet();
                        }
                        case TIMEZONE_IDS: {
                            return FormattingUtils.getAvailableTimezoneIDs();
                        }
                        case ISO_COUNTRIES: {
                            return Arrays.asList(Locale.getISOCountries());
                        }
                        case ISO_LANGUAGES: {
                            return Arrays.asList(Locale.getISOLanguages());
                        }
                        case ISO3_LANGUAGES: {
                            HashSet<String> iso3Languages = new HashSet<String>();
                            for (Locale locale : Locale.getAvailableLocales()) {
                                String iso3 = locale.getISO3Language();
                                if (iso3 == null || iso3.trim().isEmpty()) continue;
                                iso3Languages.add(iso3);
                            }
                            return iso3Languages.stream().sorted().collect(Collectors.toList());
                        }
                        case OCR_LANGUAGES: {
                            return Arrays.asList(OcrOperation.OCR_LANGUAGES);
                        }
                        case YEAR_MONTH: {
                            return LibraryResource.this.getYearMoths();
                        }
                    }
                    return null;
                }
            };
            FormFieldProcessor formFieldProcessor = new FormFieldProcessor().withProducer(dynamicValuesProducer).withLicensedModules(this.schedulerApplication.getLicenceUtils().getAllModulesLicensed());
            formFieldProcessor.setReplaceScriptPaneWithTextArea(!this.schedulerApplication.getConfiguration().getUsesUnsafeInline());
            this.operationFormConfigurations = this.operationGson.toJson((Object)OperationUtils.getOperationFormConfigurations((FormFieldProcessor)formFieldProcessor));
            this.formConfigurationsHash = ResponseCache.getInstance().hashObject(this.operationFormConfigurations);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Error building operation formConfigurations, ", (Throwable)e);
        }
    }

    private List<String> getYearMoths() {
        ArrayList<String> options = new ArrayList<String>();
        for (int year = 1980; year < 2030; ++year) {
            for (int month = 1; month <= 12; ++month) {
                options.add(year + "-" + String.format("%02d", month));
            }
        }
        return options;
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetAllOperationFormConfigurations", summary="Get All Operation Form Configurations", description="Get full information of all operation form configurations", responses={@ApiResponse(description="The list of operation form configurations", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FormConfiguration.class)))}), @ApiResponse(responseCode="400", description="Cannot find workflow with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflowBuilder/operationFormConfigurations")
    @GET
    public synchronized Response getAllOperationFormConfigurations(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        boolean canUserView = this.schedulerApplication.getSecurityPolicyUtil().doesUserHaveAnyPermissionOnAnyLibrary(user, Permission.MODIFY, Permission.MODIFY_CHILDREN);
        if (!canUserView) {
            return ExceptionUtils.buildForbiddenResponse();
        }
        try {
            return ResponseCache.getInstance().getResponse(this.formConfigurationsHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)this.formConfigurationsHash).type(MediaType.APPLICATION_JSON_TYPE).entity(this.operationFormConfigurations).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowOperations", summary="Get Workflow Operations", description="Get full information of all operations from the workflow with the specified ID", responses={@ApiResponse(description="The list of workflow operations", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.job.Operation.class)))}), @ApiResponse(responseCode="400", description="Cannot find workflow with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/operations")
    @GET
    public Response getWorkflowOperations(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow to get the operations of") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WORKFLOW_OPERATIONS, workflowId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ImmutableWorkflow libraryWorkflow;
            Workflow workflow = this.workflows.get(workflowId);
            if (workflow == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", workflowId);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            try {
                libraryWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse workflow XML", (Throwable)e);
                return ExceptionUtils.toResponse((String)"cannotParseXMLDataWorkflowData", null, (Exception)e);
            }
            boolean canViewSensitive = result.getUserPermissions() != null && result.getUserPermissions().contains(Permission.VIEW_SENSITIVE);
            ArrayList operations = new ArrayList();
            libraryWorkflow.useReadOnlyOperations(_operations -> {
                for (com.nuix.automate.workflow.core.execution.operations.Operation o : _operations) {
                    com.nuix.automate.utils.models.api.job.Operation operation = new com.nuix.automate.utils.models.api.job.Operation();
                    operation.setNotes(o.notes);
                    operation.setOperationAlias(o.getOperationAlias());
                    operation.setName(o.getOperationName());
                    operation.setDisabled(o.disabled);
                    operation.setSoftFail(o.softFail);
                    operation.setSuppressWarnings(o.suppressWarnings);
                    operation.setEnableFieldOverwrite(o.enableFieldOverwrite);
                    operation.setProgressWeight(o.progressWeight);
                    operation.setOptions(null);
                    if (canViewSensitive) {
                        operation.setOptions(WorkflowRenderer.getOperationPrintableOptions((com.nuix.automate.workflow.core.execution.operations.Operation)o, (boolean)false, (boolean)true));
                    }
                    operation.setUsesWorkers(o.getUsesWorkers());
                    operation.setSkippable(o.skippable);
                    operations.add(operation);
                }
            });
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(operations).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowDetailedOperations", summary="Get Workflow Detailed Operations", description="Get full information of all detailed operations from the workflow with the specified ID", responses={@ApiResponse(description="The list of workflow detailed operations", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.job.Operation.class)))}), @ApiResponse(responseCode="400", description="Cannot find workflow with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/detailedOperations")
    @GET
    public Response getWorkflowDetailedOperations(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow to get the operations of") @PathParam(value="workflowId") String workflowId, @QueryParam(value="withFieldOverwrite") boolean withFieldOverwrite) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WORKFLOW_OPERATIONS, workflowId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Workflow workflow = this.workflows.get(workflowId);
            if (workflow == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindWorkflow", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", workflowId);
                    }
                })).build();
            }
            Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            boolean canViewSensitive = result.getUserPermissions().contains(Permission.VIEW_SENSITIVE);
            if (!withFieldOverwrite && !canViewSensitive) {
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            OperationList operationList = new OperationList();
            try {
                ImmutableWorkflow libraryWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml());
                HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
                Set<Permission> scriptParameterPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
                boolean canViewScriptCode = scriptParameterPermissions.contains(Permission.VIEW_SENSITIVE);
                scopeIdentifiers = new HashSet();
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.EXTERNAL_APPLICATIONS));
                Set<Permission> externalApplicationsPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
                boolean canViewExternalApplications = externalApplicationsPermissions.contains(Permission.VIEW_SENSITIVE);
                Response errorResponse = (Response)libraryWorkflow.useReadOnlyOperations(operations -> {
                    for (com.nuix.automate.workflow.core.execution.operations.Operation o : operations) {
                        boolean addOperation = false;
                        if (withFieldOverwrite) {
                            if (o.enableFieldOverwrite) {
                                addOperation = true;
                                if (!canViewScriptCode) {
                                    if (o instanceof ConfigureParametersOperation) {
                                        ConfigureParametersOperation configureParameters = (ConfigureParametersOperation)o;
                                        if (configureParameters.userParameters != null && !configureParameters.userParameters.isEmpty()) {
                                            for (StaticParameter param : configureParameters.userParameters) {
                                                if (param.getParameterType() != ParameterType.SCRIPTED) continue;
                                                param.setScriptCode(null);
                                            }
                                        }
                                    } else if (o instanceof ScriptOperation) {
                                        ScriptOperation scriptOperation = (ScriptOperation)o;
                                        scriptOperation.scriptCode = null;
                                    } else if (o instanceof GenAiChainOperation) {
                                        GenAiChainOperation genAiChainOperation = (GenAiChainOperation)o;
                                        genAiChainOperation.chainJson = null;
                                    } else if (o instanceof PowerShellOperation) {
                                        PowerShellOperation powerShellOperation = (PowerShellOperation)o;
                                        powerShellOperation.powerShellCode = null;
                                    }
                                }
                                if (!canViewExternalApplications && o instanceof RunExternalApplicationOperation) {
                                    RunExternalApplicationOperation runExternalApplicationOperation = (RunExternalApplicationOperation)o;
                                    runExternalApplicationOperation.applicationArguments = null;
                                    runExternalApplicationOperation.applicationLocation = null;
                                    runExternalApplicationOperation.applicationWorkingDirectory = null;
                                }
                            }
                        } else {
                            addOperation = true;
                        }
                        if (addOperation) {
                            operationList.add((Object)o);
                            continue;
                        }
                        operationList.add((Object)new DummyOperation());
                    }
                    return null;
                });
                if (errorResponse != null) {
                    return errorResponse;
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to parse workflow XML", (Throwable)e);
                return ExceptionUtils.toResponse((String)"cannotParseXMLDataWorkflowData", null, (Exception)e);
            }
            String customJSON = this.operationGson.toJson((Object)operationList);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)customJSON).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowDetailedOperationsFromWorkflowFile", summary="Get Workflow Detailed Operations from Workflow File", description="Get full information of all detailed operations from the workflow file xml", responses={@ApiResponse(description="The list of workflow detailed operations", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.job.Operation.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/workflowDetailedOperationsFromXml")
    @POST
    public Response getWorkflowDetailedOperationsFromWorkflowFile(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The workflow to append to the current workflow builder workflow") Workflow workflow) {
        com.nuix.automate.workflow.core.execution.workflow.Workflow libraryWorkflow;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, null);
        WorkflowExecution workflowExecution = new WorkflowExecution(executionContext);
        try {
            workflowExecution.openWorkflow(workflow.getOperationsXml());
            libraryWorkflow = workflowExecution.getWorkflow();
            libraryWorkflow.normalize(new StringBuilder(), new HashSet());
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse workflow XML", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotParseXMLDataWorkflowData", null, (Exception)e);
        }
        OperationList operationList = new OperationList((Collection)libraryWorkflow.getOperations());
        String customJSON = this.operationGson.toJson((Object)operationList);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)customJSON).build();
    }

    private Workflow convertWorkflowBuilderToWorkflow(WorkflowBuilderSubmission workflowBuilderSubmission) {
        Workflow workflow = new Workflow();
        workflow.setLibraryId(workflowBuilderSubmission.getLibraryId());
        workflow.setName(workflowBuilderSubmission.getWorkflowName());
        workflow.setExplicitExecutionMode(workflowBuilderSubmission.getExplicitExecutionMode());
        workflow.setEnabled(workflowBuilderSubmission.getEnabled());
        if (workflowBuilderSubmission.getDescription() != null) {
            workflow.setDescription(workflowBuilderSubmission.getDescription().trim());
        }
        if (workflowBuilderSubmission.getPrerequisites() != null) {
            workflow.setPrerequisites(workflowBuilderSubmission.getPrerequisites().stream().filter(prereq -> prereq != null && !prereq.trim().isEmpty()).collect(Collectors.toList()));
        }
        if (workflowBuilderSubmission.getUsage() != null) {
            workflow.setUsage(workflowBuilderSubmission.getUsage().trim());
        }
        if (workflowBuilderSubmission.getIcon() != null) {
            workflow.setIcon(workflowBuilderSubmission.getIcon());
        }
        return workflow;
    }

    private void normalizeWorkflowBuilderSubmission(WorkflowBuilderSubmission workflowBuilderSubmission) {
        if (workflowBuilderSubmission.getOperations() != null) {
            for (com.nuix.automate.workflow.core.execution.operations.Operation operation : workflowBuilderSubmission.getOperations()) {
                if (!(operation instanceof ConfigureParametersOperation)) continue;
                ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)operation;
                this.normalizeParameters(configureParametersOperation.staticParameters);
                this.normalizeParameters(configureParametersOperation.userParameters);
            }
        }
    }

    private void normalizeParameters(List<StaticParameter> parameters) {
        for (StaticParameter parameter : parameters) {
            if (!parameter.isEffectiveTypeMaskedOrProtected()) continue;
            parameter.setValue(null);
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="AddWorkflowBuilder", summary="Add Workflow from Workflow Builder", description="Add a new workflow", responses={@ApiResponse(description="The workflow that was added", content={@Content(schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="400", description="Workflow is not valid, or a workflow with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}/workflowBuilder")
    @POST
    public Response addWorkflowFromBuilder(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The workflow to add", schema=@Schema(implementation=WorkflowBuilderSubmission.class)) String workflowBuilderSubmissionString, @Parameter(description="The ID of the library of the workflow") @PathParam(value="libraryId") String libraryId, @Parameter(description="Was the workflow added from job queue") @QueryParam(value="fromJobQueue") boolean fromJobQueue, @Parameter(description="Update if a workflow with the same name exists") @QueryParam(value="updateExisting") boolean updateExisting, @Parameter(description="Create a copy if a workflow with the same name exists") @QueryParam(value="createCopy") boolean createCopy) {
        WorkflowBuilderSubmission workflowBuilderSubmission = (WorkflowBuilderSubmission)((Object)this.operationGson.fromJson(workflowBuilderSubmissionString, WorkflowBuilderSubmission.class));
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.normalizeWorkflowBuilderSubmission(workflowBuilderSubmission);
        Workflow workflow = this.convertWorkflowBuilderToWorkflow(workflowBuilderSubmission);
        try {
            com.nuix.automate.workflow.core.execution.workflow.Workflow executionWorkflow = new com.nuix.automate.workflow.core.execution.workflow.Workflow(workflow.getName());
            executionWorkflow.setExplicitExecutionMode(workflowBuilderSubmission.getExplicitExecutionMode());
            executionWorkflow.setDescription(workflowBuilderSubmission.getDescription());
            executionWorkflow.setOperations(new ArrayList(workflowBuilderSubmission.getOperations()));
            executionWorkflow.setUsage(workflowBuilderSubmission.getUsage());
            executionWorkflow.setPrerequisites(workflowBuilderSubmission.getPrerequisites());
            executionWorkflow.setProducerName(SchedulerApplication.getInstance().getName());
            executionWorkflow.setProducerVersion(VersionResources.getVersion());
            workflow.setOperationsXml(executionWorkflow.toXml());
        }
        catch (IOException e) {
            return ExceptionUtils.toResponse((String)"workflowNotValid", new HashMap(), (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return this.addWorkflow(user, request, workflow, libraryId, fromJobQueue, updateExisting, createCopy);
    }

    private String stripTag(String xml, String tag) {
        return xml.replaceAll("<" + tag + ">[^<]*</" + tag + ">", "");
    }

    private String stripEmptyTags(String xml) {
        return xml.replaceAll("<\\w+>\\s*</\\w+>", "").replaceAll("<\\w+/>", "").replaceAll(">\\s*<", "><");
    }

    private boolean workflowXmlIsSameIgnoreVersion(String xml1, String xml2) {
        List<String> ignoreTags = Collections.unmodifiableList(Arrays.asList("lastModifiedEpoch", "producerName", "producerVersion"));
        for (String ignoreTag : ignoreTags) {
            xml1 = this.stripTag(xml1, ignoreTag);
            xml2 = this.stripTag(xml2, ignoreTag);
        }
        xml1 = this.stripEmptyTags(xml1);
        xml2 = this.stripEmptyTags(xml2);
        return xml1.equals(xml2);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="AddWorkflow", summary="Add Workflow", description="Add a new workflow", responses={@ApiResponse(description="The workflow that was added", content={@Content(schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="400", description="Workflow is not valid, or a workflow with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/{libraryId}/workflow")
    @POST
    public Response addWorkflow(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The workflow to add", schema=@Schema(implementation=WorkflowSubmission.class)) Workflow workflow, final @Parameter(description="The ID of the library of the workflow") @PathParam(value="libraryId") String libraryId, @Parameter(description="Was the workflow added from job queue") @QueryParam(value="fromJobQueue") boolean fromJobQueue, @Parameter(description="\n if a workflow with the same name exists") @QueryParam(value="updateExisting") boolean updateExisting, @Parameter(description="Create a copy if a workflow with the same name exists") @QueryParam(value="createCopy") boolean createCopy) {
        com.nuix.automate.workflow.core.execution.workflow.Workflow executionWorkflow;
        WorkflowLibrary workflowLibrary = this.libraries.get(libraryId);
        if (workflowLibrary == null) {
            return ExceptionUtils.toResponse((String)"libraryIdDoesNotExist", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryWorkflowModel", libraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        workflowLibrary = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary);
        if (!(user instanceof SystemBearerUser || workflowLibrary.getUserPermissions().contains(Permission.MODIFY) || workflowLibrary.getUserPermissions().contains(Permission.MODIFY_CHILDREN))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)workflowLibrary);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (workflow.getName() == null || workflow.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"workflowNameMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            WorkflowExecution workflowExecution = new WorkflowExecution();
            workflowExecution.openWorkflow(workflow.getOperationsXml());
            Response errorPreparingWorkflow = this.prepareWorkflowForAddingUpdating(user, workflow, workflowExecution);
            if (errorPreparingWorkflow != null) {
                return errorPreparingWorkflow;
            }
            executionWorkflow = workflowExecution.getWorkflow();
            workflow.setOperationsXml(executionWorkflow.toXml());
            workflow.setIcon(executionWorkflow.getIcon());
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"workflowNotValid", new HashMap(), (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Collection<Workflow> libraryWorkflows = this.libraryWorkflows.get(libraryId).values();
        HashSet<String> workflowNames = new HashSet<String>();
        for (Workflow existingWorkflow : libraryWorkflows) {
            workflowNames.add(existingWorkflow.getName());
        }
        String updateExistingWorkflowId = null;
        Workflow disabledWorkflowWithSameContent = null;
        if (fromJobQueue) {
            for (Workflow existingWorkflow : libraryWorkflows) {
                if (!this.workflowXmlIsSameIgnoreVersion(existingWorkflow.getOperationsXml(), workflow.getOperationsXml())) continue;
                if (existingWorkflow.getEnabled() == Boolean.TRUE) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("libraryName", workflowLibrary.getName());
                    values.put("existingWorkflowTemplateName", existingWorkflow.getName());
                    values.put("existingWorkflowTemplateId", existingWorkflow.getId());
                    return ExceptionUtils.toResponse((String)"workflowXmlExists", values, (Response.Status)Response.Status.BAD_REQUEST);
                }
                disabledWorkflowWithSameContent = existingWorkflow;
            }
            if (disabledWorkflowWithSameContent != null) {
                if (createCopy) {
                    workflow.setName(FormattingUtils.incrementName((String)disabledWorkflowWithSameContent.getName(), workflowNames));
                } else if (updateExisting) {
                    updateExistingWorkflowId = disabledWorkflowWithSameContent.getId();
                    workflow.setName(disabledWorkflowWithSameContent.getName());
                } else {
                    return ExceptionUtils.toResponse((String)"workflowXmlExistsOfferOverwriteOrCopy", (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
        }
        try {
            List configurationParameters = executionWorkflow.getUserParameters();
            workflow.setSessionParameters(configurationParameters);
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse workflow session parameters", (Throwable)e);
        }
        for (final Workflow existingWorkflow : libraryWorkflows) {
            boolean usedInSchedule;
            if (!existingWorkflow.getName().equalsIgnoreCase(workflow.getName())) continue;
            if (createCopy) {
                workflow.setName(FormattingUtils.incrementName((String)workflow.getName(), workflowNames));
                break;
            }
            if (updateExisting) {
                if (workflow.getDescription() == null || workflow.getDescription().trim().isEmpty()) {
                    workflow.setDescription(existingWorkflow.getDescription());
                }
                if (workflow.getSessionParameters().size() > 0) {
                    Map<String, com.nuix.automate.utils.models.api.job.Parameter> existingSessionParametersMap = existingWorkflow.getSessionParameters().stream().collect(Collectors.toMap(com.nuix.automate.utils.models.api.job.Parameter::getName, p -> p, com.nuix.automate.utils.models.api.job.Parameter::new));
                    for (com.nuix.automate.utils.models.api.job.Parameter parameter : workflow.getSessionParameters()) {
                        com.nuix.automate.utils.models.api.job.Parameter existingParameter = existingSessionParametersMap.get(parameter.getName());
                        if (existingParameter != null) {
                            if (parameter.getValue() == null || parameter.getValue().trim().equals("")) {
                                parameter.setValue(existingParameter.getValue());
                            }
                            if (parameter.getAllowedValuesMatchBy() == null) {
                                parameter.setAllowedValuesMatchBy(existingParameter.getAllowedValuesMatchBy());
                            }
                            if (parameter.getAllowedValues() == null) {
                                parameter.setAllowedValues(existingParameter.getAllowedValues());
                            }
                        }
                        if (parameter.getValue() == null || parameter.getAllowedValues() == null || parameter.getAllowedValues().contains(parameter.getValue())) continue;
                        parameter.setValue("");
                    }
                }
                updateExistingWorkflowId = existingWorkflow.getId();
                workflow.setName(existingWorkflow.getName());
                break;
            }
            if (existingWorkflow.getOperationsXml() != null && this.workflowXmlIsSameIgnoreVersion(existingWorkflow.getOperationsXml(), workflow.getOperationsXml())) {
                final WorkflowLibrary finalWorkflowWorkflowLibrary = workflowLibrary;
                return ExceptionUtils.toResponse((String)"workflowExists", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingWorkflowTemplateName", existingWorkflow.getName());
                        this.put("libraryName", finalWorkflowWorkflowLibrary.getName());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            boolean usedInBacklogJob = this.schedulerApplication.getJobResource().getBacklogJobsUsingWorkflow(existingWorkflow.getId()).size() > 0;
            boolean bl = usedInSchedule = this.schedulerApplication.getScheduleResource().getActiveSchedulesUsingWorkflow(existingWorkflow.getId()).size() > 0;
            if (!usedInBacklogJob && !usedInSchedule) {
                return ExceptionUtils.toResponse((String)"workflowExistsOfferOverwriteOrCopy", (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (usedInBacklogJob) {
                return ExceptionUtils.toResponse((String)"workflowExistsInJobOfferCopy", (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!usedInSchedule) continue;
            return ExceptionUtils.toResponse((String)"workflowExistsInScheduleOfferCopy", (Response.Status)Response.Status.BAD_REQUEST);
        }
        workflow.setLibraryId(libraryId);
        if (updateExistingWorkflowId != null) {
            workflow.setId(updateExistingWorkflowId);
            List operations = executionWorkflow.getOperations();
            return this.internalUpdateWorkflow(request, user, workflow, operations);
        }
        workflow.setId(UidUtils.getRandom());
        return this.addWorkflowInternal(user, workflow, request, false);
    }

    public Response prepareWorkflowForAddingUpdating(BearerUser user, Workflow workflow, WorkflowExecution workflowExecution) {
        HashSet<Object> scopeIdentifiers;
        if (workflow.getId() == null) {
            workflow.setId(UidUtils.getRandom());
        }
        workflow.setDefaults();
        workflow.setLastModified(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        try {
            workflowExecution.normalizeWorkflow();
            workflowExecution.getWorkflow().cleanupScriptedParameters();
            workflow.setSessionParameters(workflowExecution.getWorkflow().getUserParameters());
        }
        catch (ParameterException e) {
            LOGGER.error("Error getting user parameters", (Throwable)e);
        }
        if (workflow.getSessionParameters().size() > 0) {
            scopeIdentifiers = new HashSet<Identifier>();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
            Set<Permission> scriptParameterPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
            for (final com.nuix.automate.utils.models.api.job.Parameter sessionParameter : workflow.getSessionParameters()) {
                StaticParameter dummyParameter;
                if (sessionParameter.getAllowedValues() != null && sessionParameter.getAllowedValues().size() > 0 && (dummyParameter = new StaticParameter(sessionParameter)).isEffectiveTypeMaskedOrProtected()) {
                    return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                        {
                            this.put("parameterName", sessionParameter.getName());
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (sessionParameter.getParameterType() != ParameterType.SCRIPTED || scriptParameterPermissions.contains(Permission.MODIFY) || user instanceof SystemBearerUser) continue;
                return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameterName", sessionParameter.getName());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        scopeIdentifiers = new HashSet();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
        Set<Permission> scriptPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
        boolean canModifyScripts = scriptPermissions.contains(Permission.MODIFY);
        scopeIdentifiers = new HashSet();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.EXTERNAL_APPLICATIONS));
        Set<Permission> externalApplicationsPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
        boolean canModifyExternalApplications = externalApplicationsPermissions.contains(Permission.MODIFY);
        com.nuix.automate.workflow.core.execution.workflow.Workflow parsedWorkflow = this.parseWorkflowXml(workflow.getOperationsXml());
        List operations = parsedWorkflow.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            final com.nuix.automate.workflow.core.execution.operations.Operation o = (com.nuix.automate.workflow.core.execution.operations.Operation)operations.get(i);
            if (o.disabled) continue;
            final int finalI = i;
            String missingOperationPermissionName = null;
            if (!canModifyScripts) {
                if (o instanceof ConfigureParametersOperation) {
                    ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)o;
                    if (configureParametersOperation.userParameters != null) {
                        for (final StaticParameter userParameter : configureParametersOperation.userParameters) {
                            if (!userParameter.getName().contains("job_side_script_file") && !userParameter.getName().contains("wfn_execution_script_file")) continue;
                            return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                                {
                                    this.put("parameterName", userParameter.getName());
                                }
                            }, (Response.Status)Response.Status.BAD_REQUEST);
                        }
                    }
                    if (configureParametersOperation.staticParameters != null) {
                        for (final StaticParameter staticParameter : configureParametersOperation.staticParameters) {
                            if (!staticParameter.getName().contains("job_side_script_file") && !staticParameter.getName().contains("wfn_execution_script_file")) continue;
                            return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                                {
                                    this.put("parameterName", staticParameter.getName());
                                }
                            }, (Response.Status)Response.Status.BAD_REQUEST);
                        }
                    }
                }
                if (o instanceof ScriptOperation) {
                    missingOperationPermissionName = "missingScriptsOperationPermission";
                }
                if (o instanceof GenAiChainOperation) {
                    missingOperationPermissionName = "missingScriptsOperationPermission";
                }
                if (o instanceof PowerShellOperation) {
                    missingOperationPermissionName = "missingScriptsOperationPermission";
                }
            }
            if (!canModifyExternalApplications) {
                if (o instanceof RunExternalApplicationOperation) {
                    missingOperationPermissionName = "missingExecutableOperationPermission";
                }
                if (o instanceof ConfigureNativeOcrOperation) {
                    ConfigureNativeOcrOperation configureNativeOcrOperation = (ConfigureNativeOcrOperation)o;
                    if (configureNativeOcrOperation.ocrEngineBinariesFolderEnabled) {
                        missingOperationPermissionName = "missingExecutableOperationPermission";
                    }
                }
            }
            if (missingOperationPermissionName == null) continue;
            return ExceptionUtils.toResponse((String)missingOperationPermissionName, (Map)new HashMap<String, String>(){
                {
                    this.put("operationName", o.getOperationName());
                    this.put("workflowPosition", String.valueOf(finalI + 1));
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Response errorResponse = this.verifyNoBuiltInParameters(workflow);
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            com.nuix.automate.workflow.core.execution.workflow.Workflow executionWorkflow = workflowExecution.getWorkflow();
            if (workflow.getPrerequisites() == null || workflow.getPrerequisites().isEmpty()) {
                workflow.setPrerequisites(new ArrayList(executionWorkflow.getPrerequisites()));
            }
            if (workflow.getDescription() == null || workflow.getDescription().isEmpty()) {
                workflow.setDescription(executionWorkflow.getDescription());
            }
            if (workflow.getUsage() == null || workflow.getUsage().isEmpty()) {
                workflow.setUsage(executionWorkflow.getUsage());
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot parse workflow details", (Throwable)e);
        }
        if (workflow.getPrerequisites() != null) {
            workflow.getPrerequisites().removeIf(prereq -> prereq.trim().isEmpty());
        }
        return null;
    }

    public Response addWorkflowInternal(BearerUser user, Workflow workflow, HttpServletRequest request, boolean updateExisting) {
        FormattingUtils.trimAllStrings((Object)workflow);
        String workflowId = workflow.getId();
        try {
            com.nuix.automate.workflow.core.execution.workflow.Workflow _workflow = com.nuix.automate.workflow.core.execution.workflow.Workflow.fromXml((String)workflow.getOperationsXml());
            _workflow.setName(workflow.getName());
            workflow.setOperationsXml(_workflow.toXml());
            workflow.setExecutionMode(_workflow.getExecutionMode());
        }
        catch (Exception e) {
            LOGGER.error("Cannot change workflow xml name", (Throwable)e);
        }
        this.workflows.put(workflow.getId(), workflow);
        this.libraryWorkflows.get(workflow.getLibraryId()).put(workflow.getId(), workflow);
        this.schedulerApplication.getWorkflowLibraryDao().addLibraryWorkflow(workflow);
        Workflow createdWorkflow = this.workflows.get(workflowId);
        if (createdWorkflow != null) {
            StringBuilder details = new StringBuilder();
            if (createdWorkflow.getName() != null) {
                details.append(iu.getFormattedString("LibraryResource.Details.Name", (Object)createdWorkflow.getName()));
            }
            if (createdWorkflow.getDescription() != null && createdWorkflow.getDescription().trim().length() > 0) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getFormattedString("LibraryResource.Details.Description", (Object)createdWorkflow.getDescription()));
            }
            if (createdWorkflow.getPrerequisites() != null && createdWorkflow.getPrerequisites().size() > 0) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getFormattedString("LibraryResource.Details.Prerequisites", (Object)String.join((CharSequence)";", createdWorkflow.getPrerequisites())));
            }
            if (createdWorkflow.getUsage() != null && createdWorkflow.getUsage().trim().length() > 0) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getFormattedString("LibraryResource.Details.Usage", (Object)createdWorkflow.getUsage()));
            }
            if (createdWorkflow.getEnabled() != null && createdWorkflow.getEnabled() != Boolean.TRUE) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getString("LibraryResource.Details.Disabled"));
            }
            String auditEventId = UidUtils.getRandom();
            if (createdWorkflow.getOperationsXml() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(iu.getFormattedString("LibraryResource.Details.FileSize", (Object)createdWorkflow.getOperationsXml().length()));
                this.schedulerApplication.getWorkflowLibraryDao().addWorkflowHistory(auditEventId, workflow.getId(), createdWorkflow.getOperationsXml());
            }
            EventType.Type eventType = updateExisting ? EventType.Type.WORKFLOW_MODIFIED : EventType.Type.WORKFLOW_ADDED;
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(auditEventId, workflowId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), eventType, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.updateLibraryWorkflowUtilization(createdWorkflow);
            Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdWorkflow);
            result.setOperationsXml(null);
            result.setSessionParameters(null);
            result.setIcon(null);
            Workflow eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdWorkflow);
            this.schedulerApplication.getWebhookWorker().triggerEvent(eventType, eventResult, user.getName());
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, workflow.getLibraryId());
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, workflow.getLibraryId());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
        return ExceptionUtils.toResponse((String)"libraryIdDoesNotExist", (Map)new HashMap<String, String>(){
            {
                this.put("libraryWorkflowModel", "");
            }
        }, (Response.Status)Response.Status.NOT_FOUND);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowIcon", summary="Get Workflow Icon", description="Get the icon the workflow with the specified ID", responses={@ApiResponse(responseCode="404", description="Cannot icon for the workflow with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/icon")
    @GET
    public Response getWorkflowIcon(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow to get the operations of") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WORKFLOW_ICON, workflowId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Workflow workflow = this.workflows.get(workflowId);
            if (workflow == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", workflowId);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
            if (!result.getUserPermissions().contains(Permission.VIEW) && !result.getUserPermissions().contains(Permission.VIEW_LIMITED)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            if (workflow.getIcon() == null) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(null).build();
            }
            byte[] byteImage = Base64.getDecoder().decode(workflow.getIcon());
            ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)streamImage).build();
        }
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DeleteWorkflow", summary="Delete Workflow", description="Delete the workflow with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find workflow with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}")
    @DELETE
    public Response deleteWorkflow(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow to delete") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow workflow = this.workflows.get(workflowId);
        if (workflow == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindWorkflow", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            })).build();
        }
        Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Response errorResponse = this.verifyNotUsedInBacklogJob(user, workflowId);
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.verifyNotUsedInSchedules(user, workflowId);
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.verifyNotUsedInLegalHolds(user, workflowId);
        if (errorResponse != null) {
            return errorResponse;
        }
        this.workflows.remove(workflow.getId());
        this.libraryWorkflows.get(workflow.getLibraryId()).remove(workflow.getId());
        this.schedulerApplication.getWorkflowLibraryDao().deleteWorkflow(workflowId);
        this.schedulerApplication.getWorkflowLibraryDao().deleteWorkflowHistory(workflowId);
        Workflow eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WORKFLOW_DELETED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), workflowId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WORKFLOW_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, workflow.getLibraryId());
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, workflow.getLibraryId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("workflowDeleted", (Map)new HashMap<String, String>(){
            {
                this.put("workflowId", workflowId);
            }
        })).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="UpdateWorkflow", summary="Update Workflow", description="Update the workflow with the specified ID", responses={@ApiResponse(description="The updated workflow", content={@Content(schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="400", description="Workflow name is missing, or workflow is not valid, or a workflow with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}")
    @PUT
    public synchronized Response updateWorkflow(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the workflow to update") @PathParam(value="workflowId") String workflowId, @Parameter(description="The information to update the workflow with", schema=@Schema(implementation=WorkflowSubmission.class)) Workflow workflow) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        workflow.setId(workflowId);
        Response errorResponse = this.validateWorkflowUpdate(user, workflow, null);
        if (errorResponse != null) {
            return errorResponse;
        }
        return this.internalUpdateWorkflow(request, user, workflow, null);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetObjectsUsingWorkflow", summary="Get Objects Using Workflow", description="Get full information of all objects using the workflow with specified ID", responses={@ApiResponse(description="The list of objects")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/dependants")
    @GET
    public Response getObjectsUsingWorkflow(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow workflow = this.workflows.get(workflowId);
        if (workflow == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindWorkflow", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            })).build();
        }
        Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)request);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        HashMap objectsUsingWorkflow = new HashMap();
        ArrayList<JobModel> backlogJobs = new ArrayList<JobModel>();
        objectsUsingWorkflow.put("backlogJobs", backlogJobs);
        for (JobDetailsModel job : this.schedulerApplication.getJobResource().getBacklogJobsUsingWorkflow(workflowId)) {
            Job jobResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, job.getSettings());
            if (!jobResult.getUserPermissions().contains(Permission.VIEW)) continue;
            backlogJobs.add(job.getSettings());
        }
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        objectsUsingWorkflow.put("schedules", schedules);
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getActiveSchedulesUsingWorkflow(workflowId)) {
            Schedule scheduleResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule);
            if (!scheduleResult.getUserPermissions().contains(Permission.VIEW)) continue;
            schedules.add(scheduleResult);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(objectsUsingWorkflow).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="UpdateWorkflowBuilder", summary="Update Workflow with Workflow Builder", description="Update the workflow with the specified ID", responses={@ApiResponse(description="The updated workflow", content={@Content(schema=@Schema(implementation=Workflow.class))}), @ApiResponse(responseCode="400", description="Workflow name is missing, or workflow is not valid, or a workflow with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflowBuilder/{workflowId}")
    @PUT
    public Response updateWorkflowFromBuilder(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the workflow to update") @PathParam(value="workflowId") String workflowId, @Parameter(description="The information to update the workflow with", schema=@Schema(implementation=WorkflowBuilderSubmission.class)) String workflowBuilderSubmissionString) {
        boolean usedInSchedule;
        WorkflowBuilderSubmission workflowBuilderSubmission = (WorkflowBuilderSubmission)((Object)this.operationGson.fromJson(workflowBuilderSubmissionString, WorkflowBuilderSubmission.class));
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.normalizeWorkflowBuilderSubmission(workflowBuilderSubmission);
        Workflow workflow = this.convertWorkflowBuilderToWorkflow(workflowBuilderSubmission);
        workflow.setId(workflowId);
        Response errorResponse = this.validateWorkflowUpdate(user, workflow, workflowBuilderSubmission.getOperations());
        if (errorResponse != null) {
            return errorResponse;
        }
        boolean usedInBacklogJob = this.schedulerApplication.getJobResource().getBacklogJobsUsingWorkflow(workflow.getId()).size() > 0;
        boolean bl = usedInSchedule = this.schedulerApplication.getScheduleResource().getActiveSchedulesUsingWorkflow(workflow.getId()).size() > 0;
        if (usedInBacklogJob) {
            return ExceptionUtils.toResponse((String)"workflowUsedInBacklogJobOfferCopy", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (usedInSchedule) {
            return ExceptionUtils.toResponse((String)"workflowUsedInScheduleOfferCopy", (Response.Status)Response.Status.BAD_REQUEST);
        }
        return this.internalUpdateWorkflow(request, user, workflow, (List<com.nuix.automate.workflow.core.execution.operations.Operation>)workflowBuilderSubmission.getOperations());
    }

    @POST
    @javax.ws.rs.Path(value="/workflow/{workflowId}/auditLog/{downloadId}/download")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response downloadWorkflowAuditLog(@Context HttpServletRequest req, @FormParam(value="token") String token, @PathParam(value="workflowId") String workflowId, @PathParam(value="downloadId") String downloadId) throws ParseException, AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.downloadWorkflowAuditLog(user.get(), workflowId, downloadId);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DownloadWorkflowChangeLog", summary="Download Workflow", description="Download the Workflow, HTML report and diff with previous Workflow", responses={@ApiResponse(description="The Workflow and Workflow report", content={@Content(schema=@Schema(implementation=String.class))})})
    @GET
    @javax.ws.rs.Path(value="/workflow/{workflowId}/auditLog/{downloadId}/download")
    @SecurityRequirement(name="Bearer_Token")
    public Response downloadWorkflowAuditLog(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the workflow") @PathParam(value="workflowId") String workflowId, final @Parameter(description="The download ID of the event") @PathParam(value="downloadId") String downloadId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow libraryWorkflowModel = this.workflows.get(workflowId);
        if (libraryWorkflowModel == null) {
            return ExceptionUtils.toResponse((String)"workflowIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Workflow libraryWorkflow = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, libraryWorkflowModel);
        if (!libraryWorkflow.getUserPermissions().contains(Permission.VIEW) || !libraryWorkflow.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)libraryWorkflow);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        AuditEvent downloadAuditEvent = null;
        for (AuditEvent auditEvent : this.schedulerApplication.getAuditLogDao().getAuditEvents(workflowId)) {
            if (!auditEvent.getId().equals(downloadId)) continue;
            downloadAuditEvent = auditEvent;
            break;
        }
        String historyWorkflowData = this.schedulerApplication.getWorkflowLibraryDao().getWorkflowHistoryData(downloadId, workflowId);
        if (downloadAuditEvent == null || historyWorkflowData == null) {
            LOGGER.error("Cannot download history ID " + downloadId + " for workflow ID " + workflowId + " because data is missing from the workflowHistory table");
            return ExceptionUtils.toResponse((String)"notFound", (Map)new HashMap<String, String>(){
                {
                    this.put("objectId", downloadId);
                }
            });
        }
        Set<String> downloadIds = this.schedulerApplication.getWorkflowLibraryDao().getWorkflowHistoryAuditEventIds(workflowId);
        AuditEvent previousDownloadAuditEvent = null;
        for (AuditEvent auditEvent : this.schedulerApplication.getAuditLogDao().getAuditEvents(workflowId)) {
            if (!downloadIds.contains(auditEvent.getId()) || auditEvent.getDate() >= downloadAuditEvent.getDate() || previousDownloadAuditEvent != null && auditEvent.getDate() <= previousDownloadAuditEvent.getDate()) continue;
            previousDownloadAuditEvent = auditEvent;
        }
        String previousHistoryWorkflowData = null;
        if (previousDownloadAuditEvent != null) {
            previousHistoryWorkflowData = this.schedulerApplication.getWorkflowLibraryDao().getWorkflowHistoryData(previousDownloadAuditEvent.getId(), workflowId);
        }
        String name = libraryWorkflow.getName() + " " + FormattingUtils.dateTimeToInternationalDateTimeString((DateTime)new DateTime((Object)downloadAuditEvent.getDate()));
        String sanitizedZipName = FormattingUtils.sanitizeFilename((String)name);
        String sanitizedWorkflowName = FormattingUtils.sanitizeFilename((String)libraryWorkflow.getName());
        String fileName = sanitizedZipName + ".zip";
        AuditEvent finalDownloadAuditEvent = downloadAuditEvent;
        String finalPreviousHistoryWorkflowData = previousHistoryWorkflowData;
        StreamingOutput stream = outputStream -> {
            ZipOutputStream out = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);
            out.setLevel(1);
            ZipEntry rfnEntry = new ZipEntry(sanitizedWorkflowName + ".rfn");
            out.putNextEntry(rfnEntry);
            FormattingUtils.appendBOM((OutputStream)out);
            rfnEntry.setCreationTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
            rfnEntry.setLastModifiedTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
            out.write(historyWorkflowData.getBytes(StandardCharsets.UTF_8));
            ImmutableWorkflow workflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(historyWorkflowData);
            ZipEntry htmlEntry = new ZipEntry(sanitizedWorkflowName + ".html");
            out.putNextEntry(htmlEntry);
            FormattingUtils.appendBOM((OutputStream)out);
            htmlEntry.setCreationTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
            htmlEntry.setLastModifiedTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
            String html = WorkflowRenderer.getWorkflowHtmlReport((ImmutableWorkflow)workflow, (long)finalDownloadAuditEvent.getDate());
            out.write(html.getBytes(StandardCharsets.UTF_8));
            if (finalPreviousHistoryWorkflowData != null) {
                ImmutableWorkflow previousWorkflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(finalPreviousHistoryWorkflowData);
                ZipEntry htmlDiffEntry = new ZipEntry(sanitizedWorkflowName + ".diff.html");
                out.putNextEntry(htmlDiffEntry);
                FormattingUtils.appendBOM((OutputStream)out);
                htmlDiffEntry.setCreationTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
                htmlDiffEntry.setLastModifiedTime(FileTime.fromMillis(finalDownloadAuditEvent.getDate()));
                String previousHtml = WorkflowRenderer.getWorkflowHtmlReport((ImmutableWorkflow)previousWorkflow, (long)finalDownloadAuditEvent.getDate());
                out.write(WorkflowRenderer.diffHtml((String)previousHtml, (String)html).getBytes(StandardCharsets.UTF_8));
            }
            out.close();
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="GetWorkflowLibraryWorkflowAuditLog", description="Get Workflow Audit Log", summary="Get workflow audit log", responses={@ApiResponse(description="The audit log", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AuditEvent.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/auditLog")
    @GET
    public Response getAuditLogs(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The workflow ID") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow workflow = this.getLibraryWorkflow(workflowId);
        if (workflow == null) {
            return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Workflow workflowResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow);
        ArrayList<DownloadableAuditEvent> auditEvents = new ArrayList<DownloadableAuditEvent>();
        Set permissions = workflowResult.getUserPermissions();
        if (permissions.contains(Permission.VIEW) && permissions.contains(Permission.VIEW_SENSITIVE)) {
            Set<String> auditEventIds = this.schedulerApplication.getWorkflowLibraryDao().getWorkflowHistoryAuditEventIds(workflowId);
            for (AuditEvent auditEvent : this.schedulerApplication.getAuditLogDao().getAuditEvents(workflowId)) {
                DownloadableAuditEvent downloadableAuditEvent = new DownloadableAuditEvent(auditEvent);
                if (auditEventIds.contains(auditEvent.getId())) {
                    downloadableAuditEvent.setDownloadId(auditEvent.getId());
                }
                auditEvents.add(downloadableAuditEvent);
            }
        }
        String lastHash = ResponseCache.getInstance().hashObject(auditEvents);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(auditEvents).build();
        }
    }

    private Response validateWorkflowUpdate(BearerUser user, final Workflow workflow, OperationList updatedOperations) {
        Response errorResponse;
        WorkflowLibrary workflowLibrary;
        final String workflowId = workflow.getId();
        Workflow originalWorkflow = this.workflows.get(workflowId);
        if (originalWorkflow == null) {
            return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Set workflowPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWorkflow).getUserPermissions();
        if (!(user instanceof SystemBearerUser) && !workflowPermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalWorkflow);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (workflow.getLibraryId() == null) {
            workflow.setLibraryId(originalWorkflow.getLibraryId());
        }
        if ((workflowLibrary = this.libraries.get(workflow.getLibraryId())) == null) {
            return ExceptionUtils.toResponse((String)"libraryIdDoesNotExist", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryWorkflowModel", workflow.getLibraryId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (workflow.getName() != null) {
            for (final Workflow existingWorkflow : this.libraryWorkflows.get(workflow.getLibraryId()).values()) {
                if (!existingWorkflow.getName().equalsIgnoreCase(workflow.getName()) || existingWorkflow.getId().equals(workflowId)) continue;
                return ExceptionUtils.toResponse((String)"workflowNamedExistsInLibrary", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingLibraryWorkflowModel", existingWorkflow.getName());
                        this.put("libraryModel", workflowLibrary.getName());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.verifyNoBuiltInParameters(workflow, updatedOperations)) != null) {
            return errorResponse;
        }
        return null;
    }

    public Response internalUpdateWorkflow(HttpServletRequest request, BearerUser user, Workflow workflow, List<com.nuix.automate.workflow.core.execution.operations.Operation> updatedOperations) {
        String workflowIcon;
        ExecutionMode explicitExecutionMode;
        Boolean enabled;
        String usage;
        List prerequisites;
        String description;
        ArrayList<String> detailsList = new ArrayList<String>();
        Workflow originalWorkflow = this.workflows.get(workflow.getId());
        FormattingUtils.trimAllStrings((Object)workflow);
        String name = workflow.getName();
        boolean workflowNameUpdated = false;
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
            workflowNameUpdated = true;
            if (!name.equals(originalWorkflow.getName())) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.Name", (Object)name));
            }
            originalWorkflow.setName(name);
        }
        if ((description = workflow.getDescription()) != null) {
            if (!(description.equals(originalWorkflow.getDescription()) || originalWorkflow.getDescription() == null && description.trim().length() <= 0)) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.Description", (Object)description));
            }
            originalWorkflow.setDescription(description);
        }
        if ((prerequisites = workflow.getPrerequisites()) != null) {
            boolean changed = true;
            if (originalWorkflow.getPrerequisites() != null) {
                boolean bl = changed = prerequisites.size() != originalWorkflow.getPrerequisites().size() || !prerequisites.containsAll(originalWorkflow.getPrerequisites());
            }
            if (changed) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.Prerequisites", (Object)String.join((CharSequence)";", prerequisites)));
            }
            originalWorkflow.setPrerequisites(prerequisites);
        }
        if ((usage = workflow.getUsage()) != null) {
            if (!(usage.equals(originalWorkflow.getUsage()) || originalWorkflow.getUsage() == null && usage.trim().length() <= 0)) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.Usage", (Object)usage));
            }
            originalWorkflow.setUsage(usage);
        }
        String libraryId = workflow.getLibraryId();
        String originalLibraryId = null;
        if (libraryId != null) {
            if (!libraryId.equals(originalWorkflow.getLibraryId())) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.LibraryId", (Object)libraryId));
                originalLibraryId = originalWorkflow.getLibraryId();
            }
            originalWorkflow.setLibraryId(libraryId);
        }
        if ((enabled = workflow.getEnabled()) != null) {
            if (!enabled.equals(originalWorkflow.getEnabled())) {
                if (enabled == Boolean.TRUE) {
                    detailsList.add(iu.getString("LibraryResource.Details.Enabled"));
                } else {
                    detailsList.add(iu.getString("LibraryResource.Details.Disabled"));
                }
            }
            originalWorkflow.setEnabled(enabled);
        }
        if ((explicitExecutionMode = workflow.getExplicitExecutionMode()) != null) {
            if (!explicitExecutionMode.equals((Object)originalWorkflow.getExplicitExecutionMode())) {
                detailsList.add(iu.getFormattedString("LibraryResource.Details.ExecutionMode", (Object)explicitExecutionMode.toLocalizedString()));
            }
            originalWorkflow.setExplicitExecutionMode(explicitExecutionMode);
        }
        if ((workflowIcon = workflow.getIcon()) != null) {
            if (!workflowIcon.equals(originalWorkflow.getIcon())) {
                detailsList.add(iu.getString("LibraryResource.Details.WorkflowIcon"));
            }
            originalWorkflow.setIcon(workflowIcon);
        }
        String operationXml = workflow.getOperationsXml();
        com.nuix.automate.workflow.core.execution.workflow.Workflow _workflow = null;
        try {
            _workflow = com.nuix.automate.workflow.core.execution.workflow.Workflow.fromXml((String)originalWorkflow.getOperationsXml());
            if (workflowNameUpdated) {
                _workflow.setName(originalWorkflow.getName());
            }
            _workflow.setDescription(originalWorkflow.getDescription());
            _workflow.setPrerequisites(originalWorkflow.getPrerequisites());
            _workflow.setUsage(originalWorkflow.getUsage());
            _workflow.setExplicitExecutionMode(originalWorkflow.getExplicitExecutionMode());
            _workflow.setProducerName(SchedulerApplication.getInstance().getName());
            _workflow.setProducerVersion(VersionResources.getVersion());
            if (updatedOperations != null) {
                _workflow.setOperations(new ArrayList<com.nuix.automate.workflow.core.execution.operations.Operation>(updatedOperations));
            }
            _workflow.cleanupScriptedParameters();
            originalWorkflow.setExecutionMode(_workflow.getExecutionMode());
            operationXml = _workflow.toXml();
        }
        catch (Exception e) {
            LOGGER.error("Unable to update workflow properties", (Throwable)e);
        }
        boolean workflowXmlModified = false;
        if (operationXml != null && !operationXml.equals(originalWorkflow.getOperationsXml())) {
            detailsList.add(iu.getFormattedString("LibraryResource.Details.FileSize", (Object)operationXml.length()));
            workflowXmlModified = true;
            com.nuix.automate.workflow.core.execution.workflow.Workflow updatedExecutionWorkflow = this.parseWorkflowXml(operationXml);
            com.nuix.automate.workflow.core.execution.workflow.Workflow originalExecutionWorkflow = this.parseWorkflowXml(originalWorkflow.getOperationsXml());
            if (updatedExecutionWorkflow == null || originalExecutionWorkflow == null || !SerializationUtils.toJson((Object)updatedExecutionWorkflow.getOperations()).equals(SerializationUtils.toJson((Object)originalExecutionWorkflow.getOperations()))) {
                detailsList.add(iu.getString("LibraryResource.Details.OperationsModified"));
                if (updatedExecutionWorkflow != null) {
                    updatedExecutionWorkflow.setLastModifiedEpoch(Long.valueOf(DateTime.now().getMillis()));
                    try {
                        _workflow = updatedExecutionWorkflow;
                        operationXml = updatedExecutionWorkflow.toXml();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to update workflow timestamp", (Throwable)e);
                    }
                }
                HashSet<Object> scopeIdentifiers = new HashSet<Identifier>();
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
                Set<Permission> scriptPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
                boolean canModifyScripts = scriptPermissions.contains(Permission.MODIFY);
                scopeIdentifiers = new HashSet();
                scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.EXTERNAL_APPLICATIONS));
                Set<Permission> externalApplicationsPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
                boolean canModifyExternalApplications = externalApplicationsPermissions.contains(Permission.MODIFY);
                HashSet<Object> existingScriptCodes = new HashSet<Object>();
                HashSet<CallSite> executablesLocations = new HashSet<CallSite>();
                HashSet<String> jssLocations = new HashSet<String>();
                HashSet<String> ocrLocations = new HashSet<String>();
                for (com.nuix.automate.workflow.core.execution.operations.Operation o : originalExecutionWorkflow.getOperations()) {
                    if (o.disabled) continue;
                    if (!canModifyScripts) {
                        if (o instanceof ConfigureParametersOperation) {
                            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)o;
                            if (configureParametersOperation.userParameters != null) {
                                for (StaticParameter userParameter : configureParametersOperation.userParameters) {
                                    if (!userParameter.getName().contains("job_side_script_file") && !userParameter.getName().contains("wfn_execution_script_file")) continue;
                                    jssLocations.add(userParameter.getValue());
                                }
                            }
                            if (configureParametersOperation.staticParameters != null) {
                                for (StaticParameter staticParameter : configureParametersOperation.staticParameters) {
                                    if (!staticParameter.getName().contains("job_side_script_file") && !staticParameter.getName().contains("wfn_execution_script_file")) continue;
                                    jssLocations.add(staticParameter.getValue());
                                }
                            }
                        }
                        if (o instanceof ScriptOperation) {
                            ScriptOperation scriptOperation = (ScriptOperation)o;
                            if (!scriptOperation.useScriptFile) {
                                existingScriptCodes.add(String.valueOf(scriptOperation.scriptType) + scriptOperation.scriptCode);
                            } else {
                                executablesLocations.add((CallSite)((Object)(String.valueOf(scriptOperation.scriptType) + scriptOperation.scriptFileName)));
                            }
                        }
                        if (o instanceof GenAiChainOperation) {
                            GenAiChainOperation genAiChainOperation = (GenAiChainOperation)o;
                            existingScriptCodes.add(genAiChainOperation.chainJson);
                        }
                        if (o instanceof PowerShellOperation) {
                            PowerShellOperation powerShellOperation = (PowerShellOperation)o;
                            if (!powerShellOperation.usePowerShellFile) {
                                existingScriptCodes.add("POWERSHELL" + powerShellOperation.powerShellCode);
                            } else {
                                executablesLocations.add((CallSite)((Object)("POWERSHELL" + powerShellOperation.powerShellFileName)));
                            }
                        }
                    }
                    if (canModifyExternalApplications) continue;
                    if (o instanceof RunExternalApplicationOperation) {
                        RunExternalApplicationOperation runExternalApplicationOperation = (RunExternalApplicationOperation)o;
                        executablesLocations.add((CallSite)((Object)(runExternalApplicationOperation.applicationLocation + " " + runExternalApplicationOperation.applicationArguments)));
                    }
                    if (!(o instanceof ConfigureNativeOcrOperation)) continue;
                    ConfigureNativeOcrOperation configureNativeOcrOperation = (ConfigureNativeOcrOperation)o;
                    if (!configureNativeOcrOperation.ocrEngineBinariesFolderEnabled) continue;
                    ocrLocations.add(configureNativeOcrOperation.ocrEngineBinariesFolder);
                }
                List operations = updatedExecutionWorkflow.getOperations();
                for (int i = 0; i < operations.size(); ++i) {
                    final com.nuix.automate.workflow.core.execution.operations.Operation o = (com.nuix.automate.workflow.core.execution.operations.Operation)operations.get(i);
                    if (o.disabled) continue;
                    final int finalI = i;
                    String missingPermissionName = null;
                    if (!canModifyScripts) {
                        if (o instanceof ConfigureParametersOperation) {
                            ConfigureParametersOperation configureParametersOperation = (ConfigureParametersOperation)o;
                            if (configureParametersOperation.userParameters != null) {
                                for (final StaticParameter userParameter : configureParametersOperation.userParameters) {
                                    if (!userParameter.getName().contains("job_side_script_file") && !userParameter.getName().contains("wfn_execution_script_file") || jssLocations.contains(userParameter.getValue())) continue;
                                    return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                                        {
                                            this.put("parameterName", userParameter.getName());
                                        }
                                    }, (Response.Status)Response.Status.BAD_REQUEST);
                                }
                            }
                            if (configureParametersOperation.staticParameters != null) {
                                for (final StaticParameter staticParameter : configureParametersOperation.staticParameters) {
                                    if (!staticParameter.getName().contains("job_side_script_file") && !staticParameter.getName().contains("wfn_execution_script_file") || jssLocations.contains(staticParameter.getValue())) continue;
                                    return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                                        {
                                            this.put("parameterName", staticParameter.getName());
                                        }
                                    }, (Response.Status)Response.Status.BAD_REQUEST);
                                }
                            }
                        }
                        if (o instanceof ScriptOperation) {
                            ScriptOperation scriptOperation = (ScriptOperation)o;
                            if (!scriptOperation.useScriptFile) {
                                if (!existingScriptCodes.contains(String.valueOf(scriptOperation.scriptType) + scriptOperation.scriptCode)) {
                                    missingPermissionName = "missingScriptsOperationPermission";
                                }
                            } else if (!executablesLocations.contains(String.valueOf(scriptOperation.scriptType) + scriptOperation.scriptFileName)) {
                                missingPermissionName = "missingScriptsOperationPermission";
                            }
                        }
                        if (o instanceof GenAiChainOperation) {
                            GenAiChainOperation genAiChainOperation = (GenAiChainOperation)o;
                            if (!existingScriptCodes.contains(genAiChainOperation.chainJson)) {
                                missingPermissionName = "missingScriptsOperationPermission";
                            }
                        }
                        if (o instanceof PowerShellOperation) {
                            PowerShellOperation powerShellOperation = (PowerShellOperation)o;
                            if (!powerShellOperation.usePowerShellFile) {
                                if (!existingScriptCodes.contains("POWERSHELL" + powerShellOperation.powerShellCode)) {
                                    missingPermissionName = "missingScriptsOperationPermission";
                                }
                            } else if (!executablesLocations.contains("POWERSHELL" + powerShellOperation.powerShellFileName)) {
                                missingPermissionName = "missingScriptsOperationPermission";
                            }
                        }
                    }
                    if (!canModifyExternalApplications) {
                        if (o instanceof RunExternalApplicationOperation) {
                            RunExternalApplicationOperation runExternalApplicationOperation = (RunExternalApplicationOperation)o;
                            if (!executablesLocations.contains(runExternalApplicationOperation.applicationLocation + " " + runExternalApplicationOperation.applicationArguments)) {
                                missingPermissionName = "missingExecutableOperationPermission";
                            }
                        }
                        if (o instanceof ConfigureNativeOcrOperation) {
                            ConfigureNativeOcrOperation configureNativeOcrOperation = (ConfigureNativeOcrOperation)o;
                            if (configureNativeOcrOperation.ocrEngineBinariesFolderEnabled && !ocrLocations.add(configureNativeOcrOperation.ocrEngineBinariesFolder)) {
                                missingPermissionName = "missingExecutableOperationPermission";
                            }
                        }
                    }
                    if (missingPermissionName == null) continue;
                    return ExceptionUtils.toResponse(missingPermissionName, (Map)new HashMap<String, String>(){
                        {
                            this.put("operationName", o.getOperationName());
                            this.put("workflowPosition", String.valueOf(finalI + 1));
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            try {
                if (_workflow == null) {
                    _workflow = WorkflowSerializationUtils.getInstance().fromWorkflowCache(operationXml);
                }
                List configurationParameters = _workflow.getUserParameters();
                workflow.setSessionParameters(configurationParameters);
                if (workflow.getSessionParameters().size() > 0) {
                    Map<String, com.nuix.automate.utils.models.api.job.Parameter> originalSessionParametersMap = originalWorkflow.getSessionParameters().stream().collect(Collectors.toMap(com.nuix.automate.utils.models.api.job.Parameter::getName, p -> p, com.nuix.automate.utils.models.api.job.Parameter::new));
                    HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
                    scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
                    Set<Permission> scriptParameterPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
                    for (final com.nuix.automate.utils.models.api.job.Parameter sessionParameter : workflow.getSessionParameters()) {
                        StaticParameter dummyParameter;
                        if (sessionParameter.getAllowedValues() != null && sessionParameter.getAllowedValues().size() > 0 && (dummyParameter = new StaticParameter(sessionParameter)).isEffectiveTypeMaskedOrProtected()) {
                            return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                                {
                                    this.put("parameterName", sessionParameter.getName());
                                }
                            }, (Response.Status)Response.Status.BAD_REQUEST);
                        }
                        com.nuix.automate.utils.models.api.job.Parameter originalParameter = originalSessionParametersMap.get(sessionParameter.getName());
                        if (sessionParameter.getParameterType() != ParameterType.SCRIPTED || scriptParameterPermissions.contains(Permission.MODIFY) || originalParameter != null && Objects.equals(originalParameter.getScriptCode(), sessionParameter.getScriptCode()) && Objects.equals(originalParameter.getLibraryFileId(), sessionParameter.getLibraryFileId())) continue;
                        return ExceptionUtils.toResponse((String)"missingScriptsParameterPermission", (Map)new HashMap<String, String>(){
                            {
                                this.put("parameterName", sessionParameter.getName());
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                }
                originalWorkflow.setSessionParameters(configurationParameters);
                originalWorkflow.setOperationsXml(operationXml);
            }
            catch (Exception configurationParameters) {
                // empty catch block
            }
        }
        String auditEventId = UidUtils.getRandom();
        originalWorkflow.setLastModified(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.schedulerApplication.getWorkflowLibraryDao().updateWorkflow(originalWorkflow);
        if (workflowXmlModified) {
            this.schedulerApplication.getWorkflowLibraryDao().addWorkflowHistory(auditEventId, originalWorkflow.getId(), originalWorkflow.getOperationsXml());
        }
        String workflowId = originalWorkflow.getId();
        if (detailsList.size() > 0) {
            String details = String.join((CharSequence)"\n", detailsList);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(auditEventId, workflowId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WORKFLOW_MODIFIED, details, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        this.updateLibraryWorkflowUtilization(originalWorkflow);
        Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWorkflow);
        result.setOperationsXml(null);
        result.setSessionParameters(null);
        result.setIcon(null);
        Workflow eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWorkflow);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WORKFLOW_MODIFIED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARIES_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, originalWorkflow.getLibraryId());
        ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, originalWorkflow.getLibraryId());
        if (originalLibraryId != null) {
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS, originalLibraryId);
            ResponseCache.getInstance().resetKeyId(CacheKey.LIBRARY_WORKFLOWS_ENABLED, originalLibraryId);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.WORKFLOW_OPERATIONS, originalWorkflow.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.WORKFLOW_REQUIRED_SESSION_PARAMS, originalWorkflow.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.WORKFLOW_ICON, originalWorkflow.getId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public void updateWorkflowWeights(String workflowId, List<Double> executionWeights, double updateWithWeight) throws IOException {
        WorkflowExecution workflowExecution = new WorkflowExecution();
        Workflow workflow = this.workflows.get(workflowId);
        workflowExecution.openWorkflow(workflow.getOperationsXml());
        if (workflowExecution.getWorkflow().getOperations().size() != executionWeights.size()) {
            LOGGER.info("Skip updating operation weights because operation count does not match, workflow operations: " + workflowExecution.getWorkflow().getOperations().size() + ", weights: " + executionWeights.size());
            return;
        }
        LOGGER.info("Updating workflow operation weights");
        for (int i = 0; i < workflowExecution.getWorkflow().getOperations().size(); ++i) {
            com.nuix.automate.workflow.core.execution.operations.Operation operation = (com.nuix.automate.workflow.core.execution.operations.Operation)workflowExecution.getWorkflow().getOperations().get(i);
            double newWeight = updateWithWeight * executionWeights.get(i) + (1.0 - updateWithWeight) * operation.progressWeight;
            newWeight = Math.min(9999.0, Math.max(0.01, newWeight));
            newWeight = (double)Math.round(newWeight * 100.0) / 100.0;
            LOGGER.info("Updating operation #" + (i + 1) + " " + operation.getOperationName() + " weight from " + operation.progressWeight + " to " + newWeight);
            operation.progressWeight = newWeight;
        }
        try {
            com.nuix.automate.workflow.core.execution.workflow.Workflow updateWorkflow = workflowExecution.getWorkflow();
            if (updateWorkflow != null) {
                workflow.setOperationsXml(updateWorkflow.toXml());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error converting workflow to xml", (Throwable)e);
        }
        this.schedulerApplication.getWorkflowLibraryDao().updateWorkflow(workflow);
        ResponseCache.getInstance().resetKeyId(CacheKey.WORKFLOW_OPERATIONS, workflow.getId());
        LOGGER.info("Finished updating workflow operation weights");
    }

    @Operation(tags={"Workflow Libraries", "Job Submission"}, operationId="GetWorkflowRequiredParameters", summary="Get Workflow Required Parameters", description="Get the parameters which are required by the workflow with the specified ID", responses={@ApiResponse(description="The workflow parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.job.Parameter.class)))}), @ApiResponse(responseCode="404", description="Workflow with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/requiredSessionParameters")
    @GET
    public Response getWorkflowRequiredParameters(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WORKFLOW_REQUIRED_SESSION_PARAMS, workflowId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Workflow libraryWorkflowModel = this.workflows.get(workflowId);
            if (libraryWorkflowModel == null) {
                return ExceptionUtils.toResponse((String)"workflowIdNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("workflowId", workflowId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, libraryWorkflowModel);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            try {
                List configurationParameters = result.getSessionParameters();
                for (com.nuix.automate.utils.models.api.job.Parameter parameterModel : configurationParameters) {
                    if ((parameterModel.isProtected() || parameterModel.isMasked()) && parameterModel.getValue() != null && parameterModel.getValue().length() > 0) {
                        parameterModel.setValue(null);
                    }
                    if (parameterModel.getParameterType() != ParameterType.SCRIPTED) continue;
                    parameterModel.setScriptCode("");
                }
                Map displayConditionUpdates = DisplayConditionUtils.getInstance().updateDisplayableParameters(configurationParameters, this.schedulerApplication.getConfiguration().getRegexTimeout());
                for (com.nuix.automate.utils.models.api.job.Parameter parameter : configurationParameters) {
                    DisplayCondition updatedCondition = (DisplayCondition)displayConditionUpdates.get(parameter.getName());
                    parameter.setDisplayCondition(updatedCondition);
                }
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)configurationParameters).build();
            }
            catch (Exception e) {
                return ExceptionUtils.toResponse((String)"exception", (Map)new HashMap<String, String>(){
                    {
                        this.put("exception", e.getLocalizedMessage());
                    }
                });
            }
        }
    }

    @POST
    @javax.ws.rs.Path(value="/workflow/{workflowId}/download")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response downloadWorkflowStreams(@Context HttpServletRequest req, @FormParam(value="token") String token, @PathParam(value="workflowId") String workflowId) throws ParseException, AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.downloadWorkflow(user.get(), workflowId);
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Operation(tags={"Workflow Libraries"}, operationId="DownloadWorkflow", summary="Download Workflow", description="Download the Workflow and HTML report", responses={@ApiResponse(description="The Workflow and Workflow report", content={@Content(schema=@Schema(implementation=String.class))})})
    @GET
    @javax.ws.rs.Path(value="/workflow/{workflowId}/download")
    @SecurityRequirement(name="Bearer_Token")
    public Response downloadWorkflow(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the workflow") @PathParam(value="workflowId") String workflowId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow libraryWorkflowModel = this.workflows.get(workflowId);
        if (libraryWorkflowModel == null) {
            return ExceptionUtils.toResponse((String)"workflowIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, libraryWorkflowModel);
        if (!result.getUserPermissions().contains(Permission.VIEW) || !result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        String sanitizedWorkflowName = FormattingUtils.sanitizeFilename((String)result.getName());
        String fileName = sanitizedWorkflowName + ".zip";
        StreamingOutput stream = outputStream -> {
            try (ZipOutputStream out = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);){
                out.setLevel(1);
                this.writeWorkflowZipEntry(out, result, sanitizedWorkflowName, true);
            }
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    @Operation(tags={"Workflow Libraries"}, operationId="UpdateWorkflowRequiredParameters", summary="Update Workflow Required Parameters", description="Update the values of the parameters which are required by the workflow with the specified ID. Only the values of required parameters can be updated, new parameters will be ignored", responses={@ApiResponse(description="The updated workflow parameters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.job.Parameter.class)))}), @ApiResponse(responseCode="404", description="Workflow with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @javax.ws.rs.Path(value="/workflow/{workflowId}/requiredSessionParameters")
    @POST
    public synchronized Response updateWorkflowRequiredParameters(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the workflow to update") @PathParam(value="workflowId") String workflowId, @Parameter(description="The parameters to update the workflow with") List<ParameterSubmission> updatedParameters) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Workflow libraryWorkflowModel = this.workflows.get(workflowId);
        if (libraryWorkflowModel == null) {
            return ExceptionUtils.toResponse((String)"workflowIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Workflow result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, libraryWorkflowModel);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        HashMap<String, ParameterSubmission> updateParametersMap = new HashMap<String, ParameterSubmission>();
        for (ParameterSubmission parameterModel : updatedParameters) {
            updateParametersMap.put(parameterModel.getName(), parameterModel);
        }
        try {
            List existingParameters = result.getSessionParameters();
            for (com.nuix.automate.utils.models.api.job.Parameter parameter : existingParameters) {
                String parameterValue;
                ParameterSubmission updateParameter = (ParameterSubmission)updateParametersMap.get(parameter.getName());
                if (updateParameter == null || (parameterValue = updateParameter.getValue()) == null) continue;
                if (parameter.isSensitive()) {
                    try {
                        parameterValue = this.schedulerApplication.getEncryptor().encrypt(updateParameter.getValue());
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot encrypt parameter " + parameter.getName(), (Throwable)e);
                    }
                }
                parameter.setValue(parameterValue);
            }
            libraryWorkflowModel.setSessionParameters(existingParameters);
            libraryWorkflowModel.setId(workflowId);
            this.workflows.put(libraryWorkflowModel.getId(), libraryWorkflowModel);
            this.libraryWorkflows.get(libraryWorkflowModel.getLibraryId()).put(libraryWorkflowModel.getId(), libraryWorkflowModel);
            this.schedulerApplication.getWorkflowLibraryDao().updateWorkflow(libraryWorkflowModel);
            ResponseCache.getInstance().resetKeyId(CacheKey.WORKFLOW_REQUIRED_SESSION_PARAMS, libraryWorkflowModel.getId());
            return this.getWorkflowRequiredParameters(user, request, libraryWorkflowModel.getId());
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"exception", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
    }

    private Set<String> getNamesOfSchedulesUsingWorkflow(BearerUser user, String workflowId) {
        TreeSet<String> scheduleNames = new TreeSet<String>();
        for (Schedule schedule : this.schedulerApplication.getScheduleResource().getActiveSchedulesUsingWorkflow(workflowId)) {
            Set schedulePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule).getUserPermissions();
            if (schedulePermissions.contains(Permission.VIEW)) {
                scheduleNames.add(schedule.getName());
                continue;
            }
            scheduleNames.add(iu.getString("Schedule.Name.Other"));
        }
        return scheduleNames;
    }

    private Response verifyNotUsedInSchedules(BearerUser user, String workflowId) {
        Set<String> scheduleNames = this.getNamesOfSchedulesUsingWorkflow(user, workflowId);
        if (scheduleNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("scheduleNames", String.join((CharSequence)"\n", scheduleNames));
            return ExceptionUtils.toResponse((String)"errorDeletingWorkflowUsedBySchedules", properties);
        }
        return null;
    }

    private Set<String> getNamesOfBacklogJobsUsingWorkflow(BearerUser user, String workflowId) {
        TreeSet<String> jobNames = new TreeSet<String>();
        List<JobDetailsModel> backlogJobsUsingWorkflow = this.schedulerApplication.getJobResource().getBacklogJobsUsingWorkflow(workflowId);
        if (backlogJobsUsingWorkflow.size() == 0) {
            return jobNames;
        }
        if (user == null) {
            jobNames.add(iu.getString("Job.Name.Other"));
        } else {
            for (JobDetailsModel jobDetailsModel : backlogJobsUsingWorkflow) {
                JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobDetailsModel.getSettings());
                if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                    jobNames.add(jobModel.getName());
                    continue;
                }
                jobNames.add(iu.getString("Job.Name.Other"));
            }
        }
        return jobNames;
    }

    private Response verifyNotUsedInBacklogJob(BearerUser user, String workflowId) {
        Set<String> jobNames = this.getNamesOfBacklogJobsUsingWorkflow(user, workflowId);
        if (jobNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("jobNames", String.join((CharSequence)"\n", jobNames));
            return ExceptionUtils.toResponse((String)"errorDeletingWorkflowUsedByJobs", properties);
        }
        return null;
    }

    private Response verifyNotUsedInLegalHolds(BearerUser user, String workflowId) {
        Set<String> legalHoldNames = this.getNamesOfLegalHoldsUsingWorkflow(user, workflowId);
        if (legalHoldNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("legalHoldNames", String.join((CharSequence)"\n", legalHoldNames));
            return ExceptionUtils.toResponse((String)"errorDeletingWorkflowUsedByLegalHolds", properties);
        }
        return null;
    }

    private Set<String> getNamesOfLegalHoldsUsingWorkflow(BearerUser user, String workflowId) {
        TreeSet<String> legalHoldNames = new TreeSet<String>();
        List<LegalHold> legalHoldsUsingWorkflow = this.schedulerApplication.getLegalHoldResource().getLegalHoldsUsingWorkflow(workflowId);
        if (legalHoldsUsingWorkflow.size() == 0) {
            return legalHoldNames;
        }
        if (user == null) {
            legalHoldNames.add(iu.getString("LegalHold.Name.Other"));
        } else {
            for (LegalHold legalHoldModel : legalHoldsUsingWorkflow) {
                LegalHold legalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHoldModel);
                if (legalHold.getUserPermissions().contains(Permission.VIEW)) {
                    legalHoldNames.add(legalHold.getName());
                    continue;
                }
                legalHoldNames.add(iu.getString("LegalHold.Name.Other"));
            }
        }
        return legalHoldNames;
    }

    public Collection<Workflow> getWorkflowsUsingLibraryFileId(String libraryFileId) {
        ArrayList<Workflow> workflowsUsingLibraryFile = new ArrayList<Workflow>();
        for (Workflow workflow : this.workflows.values()) {
            if (workflow.getSessionParameters() != null && workflow.getSessionParameters().size() > 0) {
                for (com.nuix.automate.utils.models.api.job.Parameter parameter : workflow.getSessionParameters()) {
                    if (parameter.getParameterType() == ParameterType.SCRIPTED && parameter.isUseLibraryFile() && parameter.getLibraryFileId() != null && parameter.getLibraryFileId().equalsIgnoreCase(libraryFileId)) {
                        workflowsUsingLibraryFile.add(workflow);
                        break;
                    }
                    if (parameter.getParameterType() != ParameterType.LIBRARY_FILE || !parameter.getValue().equals(libraryFileId)) continue;
                    workflowsUsingLibraryFile.add(workflow);
                    break;
                }
            }
            try {
                WorkflowSerializationUtils.getInstance().fromWorkflowCache(workflow.getOperationsXml()).useReadOnlyOperations(operations -> {
                    block0: for (com.nuix.automate.workflow.core.execution.operations.Operation operation : operations) {
                        if (!(operation instanceof ConfigureParametersOperation)) continue;
                        for (StaticParameter parameter : ((ConfigureParametersOperation)operation).staticParameters) {
                            if (!ParameterType.LIBRARY_FILE.equals((Object)parameter.getParameterType()) || !libraryFileId.equals(parameter.getValue())) continue;
                            workflowsUsingLibraryFile.add(workflow);
                            break block0;
                        }
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error while parsing static parameters", (Throwable)e);
            }
        }
        return workflowsUsingLibraryFile;
    }

    public Response verifyNoBuiltInParameters(Workflow workflow) {
        HashSet<String> parameterNames = new HashSet<String>();
        if (workflow == null) {
            return null;
        }
        List sessionParameters = workflow.getSessionParameters();
        if (sessionParameters != null) {
            for (com.nuix.automate.utils.models.api.job.Parameter parameter : sessionParameters) {
                parameterNames.add(parameter.getName());
            }
        }
        return this.verifyNoBuiltInParameters(parameterNames);
    }

    public Response verifyNoBuiltInParameters(Workflow workflow, OperationList updatedOperations) {
        HashSet<String> parameterNames = new HashSet<String>();
        if (workflow == null) {
            return null;
        }
        Workflow originalWorkflow = this.workflows.get(workflow.getId());
        List sessionParameters = originalWorkflow.getSessionParameters();
        try {
            com.nuix.automate.workflow.core.execution.workflow.Workflow _workflow = com.nuix.automate.workflow.core.execution.workflow.Workflow.fromXml((String)originalWorkflow.getOperationsXml());
            if (updatedOperations != null) {
                _workflow.setOperations(new ArrayList(updatedOperations));
            }
            sessionParameters = _workflow.getUserParameters();
        }
        catch (Exception e) {
            LOGGER.error("Unable to update workflow properties", (Throwable)e);
        }
        if (sessionParameters != null) {
            for (com.nuix.automate.utils.models.api.job.Parameter parameter : sessionParameters) {
                parameterNames.add(parameter.getName());
            }
        }
        return this.verifyNoBuiltInParameters(parameterNames);
    }

    public Response verifyNoBuiltInParameters(Set<String> parameterNames) {
        if (parameterNames == null || parameterNames.size() == 0) {
            return null;
        }
        ArrayList<CallSite> builtInParameterNames = new ArrayList<CallSite>();
        ExecutionContext executionContext = new ExecutionContext(null, null, null, null, null, false, null);
        for (String parameterName : parameterNames) {
            if (!executionContext.checkIfBuiltInParameter(parameterName)) continue;
            builtInParameterNames.add((CallSite)((Object)("  \u2022 " + parameterName)));
        }
        if (builtInParameterNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("builtInParameterNames", String.join((CharSequence)"\n", builtInParameterNames));
            return ExceptionUtils.toResponse((String)"cannotUseExecutionProfileParameter", properties);
        }
        return null;
    }

    private void updateLibraryUtilization(WorkflowLibrary workflowLibrary) {
        Library library = new Library();
        library.setLibraryId(workflowLibrary.getId());
        library.setLibraryName(workflowLibrary.getName());
        try {
            this.schedulerApplication.getUtilizationDaoV2().addLibrary(library);
        }
        catch (StatementException e) {
            this.schedulerApplication.getUtilizationDaoV2().updateLibrary(library);
        }
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<Library> libraries = new HashSet<Library>();
        utilizationRecords.setLibraries(libraries);
        libraries.add(library);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    private void updateLibraryWorkflowUtilization(Workflow workflow) {
        com.nuix.automate.utils.utilization.Workflow libraryWorkflow = new com.nuix.automate.utils.utilization.Workflow();
        libraryWorkflow.setWorkflowId(workflow.getId());
        libraryWorkflow.setLibraryId(workflow.getLibraryId());
        libraryWorkflow.setWorkflowName(workflow.getName());
        try {
            this.schedulerApplication.getUtilizationDaoV2().addWorkflow(libraryWorkflow);
        }
        catch (StatementException e) {
            this.schedulerApplication.getUtilizationDaoV2().updateWorkflow(libraryWorkflow);
        }
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.Workflow> workflows = new HashSet<com.nuix.automate.utils.utilization.Workflow>();
        utilizationRecords.setWorkflows(workflows);
        workflows.add(libraryWorkflow);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }
}

