/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.workers.FileExtensionIconWorker;
import com.nuix.automate.scheduler.workers.UserImageWorker;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.OperationMimeType;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.ui.OperationAlias;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/media")
@Produces(value={"application/json"})
public class MediaResources {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MediaResources.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;
    private Map<String, IconType> operationAliasToIconType;
    private UserImageWorker userImageWorker;
    private FileExtensionIconWorker fileExtensionIconWorker;

    public MediaResources(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
        this.userImageWorker = new UserImageWorker(schedulerApplication);
        this.fileExtensionIconWorker = new FileExtensionIconWorker(schedulerApplication);
        LOGGER.info("Initializing MediaResources");
        this.operationAliasToIconType = Icons.getInstance().getOperationIcons();
    }

    @GET
    @Path(value="/operationIcon/{operationAlias}")
    public Response getOperationIcon(@PathParam(value="operationAlias") String operationAlias) {
        block3: {
            try {
                OperationAlias.valueOf((String)operationAlias);
            }
            catch (IllegalArgumentException e) {
                OperationAlias alias = OperationAlias.fromOperationName((String)operationAlias);
                if (alias == null) break block3;
                operationAlias = alias.name();
            }
        }
        long expirationMs = 86400000L;
        IconType iconType = this.operationAliasToIconType.get(operationAlias);
        if (iconType == null) {
            iconType = IconType.UNKNOWN;
        }
        String base64Image = Icons.getInstance().getImageBase64(iconType);
        return MediaResources.getImageResponse(expirationMs, base64Image);
    }

    static Response getImageResponse(long expirationMs, String base64Image) {
        byte[] byteImage = Base64.getDecoder().decode(base64Image);
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + expirationMs)).type(new MediaType("image", "svg+xml")).cacheControl(CacheControl.valueOf((String)("max-age=" + expirationMs / 1000L))).build();
    }

    @POST
    @Path(value="/mimeTypeIcon")
    public Response getMimeTypeIcon(@Parameter(hidden=true) @Auth BearerUser user, OperationMimeType operationMimeType, @QueryParam(value="getLargeIcon") boolean getLargeIcon) {
        String mimeType = operationMimeType.getMimeType();
        if (mimeType == null) {
            return Response.noContent().build();
        }
        byte[] byteImage = this.fileExtensionIconWorker.getMimeTypeIcon(mimeType, getLargeIcon);
        if (byteImage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
        return Response.ok((Object)streamImage).type(new MediaType("image", "PNG")).build();
    }

    @GET
    @Path(value="/fileIcon/{extension}")
    public Response getFileIconFromExtension(@Parameter(hidden=true) @Auth BearerUser user, @PathParam(value="extension") String extension, @QueryParam(value="getLargeIcon") boolean getLargeIcon) {
        byte[] byteImage = this.fileExtensionIconWorker.getExtensionIcon(extension, getLargeIcon);
        if (byteImage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
        return Response.ok((Object)streamImage).type(new MediaType("image", "PNG")).build();
    }

    @GET
    @Path(value="/userIcon/{username}")
    public Response getUserIcon(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="username") String username) throws IOException {
        byte[] byteImage = null;
        MediaType mediaType = null;
        if (!this.schedulerApplication.getConfiguration().getDisableUserIcons()) {
            InputStream stream;
            Object resourceName2;
            BuiltInPrincipalIdentifiers identifier = BuiltInPrincipalIdentifiers.fromString((String)username);
            if (identifier != null) {
                try {
                    resourceName2 = "/icons/users/" + username + ".svg";
                    stream = this.getClass().getResourceAsStream((String)resourceName2);
                    byteImage = IOUtils.toByteArray((InputStream)stream);
                    if (byteImage.length == 0) {
                        byteImage = null;
                    }
                    mediaType = new MediaType("image", "svg+xml");
                }
                catch (IOException resourceName2) {
                    // empty catch block
                }
            }
            if (byteImage == null) {
                try {
                    Object userDisplayName;
                    resourceName2 = "/icons/users/userInitialsTemplate.svg";
                    stream = this.getClass().getResourceAsStream((String)resourceName2);
                    String svgTemplateString = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                    String displayName = username;
                    UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUserWithEmail(username);
                    if (userAccount != null && (userDisplayName = userAccount.getAttributes().get("displayName")) != null && !userDisplayName.toString().trim().isEmpty()) {
                        displayName = userDisplayName.toString();
                    }
                    svgTemplateString = svgTemplateString.replace(">O<", ">" + FormattingUtils.usernameToInitials((String)displayName) + "<");
                    byteImage = svgTemplateString.getBytes(StandardCharsets.UTF_8);
                    mediaType = new MediaType("image", "svg+xml");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (byteImage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindUserImage", (Map)new HashMap<String, String>(){
                {
                    this.put("username", username);
                }
            })).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getUserImageCacheKeepAlive())).type(mediaType).cacheControl(CacheControl.valueOf((String)("max-age=" + this.schedulerApplication.getConfiguration().getUserImageCacheKeepAlive() / 1000L))).build();
    }

    @GET
    @Path(value="/branding/logoImage")
    public Response getBrandingLogoImage() {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.BRANDING);
        byte[] byteImage = null;
        MediaType mediaType = null;
        try {
            if (this.schedulerConfiguration.getBranding() != null && this.schedulerConfiguration.getBranding().getLogoImagePath() != null) {
                String logoLowerCase = this.schedulerConfiguration.getBranding().getLogoImagePath().toLowerCase();
                mediaType = logoLowerCase.endsWith(".svg") ? new MediaType("image", "svg+xml") : (logoLowerCase.endsWith(".png") ? new MediaType("image", "png") : new MediaType("image", "jpg"));
                byteImage = Files.readAllBytes(Paths.get(this.schedulerConfiguration.getBranding().getLogoImagePath(), new String[0]));
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot read brandingLogoImage", (Throwable)e);
        }
        if (byteImage == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindBrandingLogoImage")).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteImage);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive())).type(mediaType).cacheControl(CacheControl.valueOf((String)("max-age=" + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive() / 1000L))).build();
    }

    @GET
    @Path(value="/branding/logoStyle")
    public Response getBrandingLogoStyle() {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.BRANDING);
        byte[] byteData = null;
        MediaType mediaType = new MediaType("text", "css");
        try {
            if (this.schedulerConfiguration.getBranding() != null && this.schedulerConfiguration.getBranding().getLogoStylePath() != null) {
                byteData = Files.readAllBytes(Paths.get(this.schedulerConfiguration.getBranding().getLogoStylePath(), new String[0]));
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot read brandingLogoStyle", (Throwable)e);
        }
        if (byteData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindBrandingLogoStyle")).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteData);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive())).type(mediaType).cacheControl(CacheControl.valueOf((String)("max-age=" + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive() / 1000L))).build();
    }

    @GET
    @Path(value="/branding/headerStyle")
    public Response getBrandingHeaderStyle() {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.BRANDING);
        byte[] byteData = null;
        MediaType mediaType = new MediaType("text", "css");
        try {
            if (this.schedulerConfiguration.getBranding() != null && this.schedulerConfiguration.getBranding().getHeaderStylePath() != null) {
                byteData = Files.readAllBytes(Paths.get(this.schedulerConfiguration.getBranding().getHeaderStylePath(), new String[0]));
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot read brandingLogoStyle", (Throwable)e);
        }
        if (byteData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindBrandingHeaderStyle")).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteData);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive())).type(mediaType).cacheControl(CacheControl.valueOf((String)("max-age=" + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive() / 1000L))).build();
    }

    @GET
    @Path(value="/branding/title")
    public Response getTitle() {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.BRANDING);
        if (this.schedulerConfiguration.getBranding() != null && this.schedulerConfiguration.getBranding().getTitle() != null) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.schedulerConfiguration.getBranding().getTitle()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindBrandingTitle")).build();
    }

    @GET
    @Path(value="/branding/favicon")
    public Response getBrandingFavicon() {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.BRANDING);
        byte[] byteData = null;
        MediaType mediaType = new MediaType("image", "x-icon");
        try {
            if (this.schedulerConfiguration.getBranding() != null && this.schedulerConfiguration.getBranding().getFaviconPath() != null) {
                byteData = Files.readAllBytes(Paths.get(this.schedulerConfiguration.getBranding().getFaviconPath(), new String[0]));
            }
        }
        catch (IOException e) {
            LOGGER.error("Cannot read cannotFindBrandingFavicon", (Throwable)e);
        }
        if (byteData == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindBrandingFavicon")).build();
        }
        ByteArrayInputStream streamImage = new ByteArrayInputStream(byteData);
        return Response.ok((Object)streamImage).expires(new Date(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive())).type(mediaType).cacheControl(CacheControl.valueOf((String)("max-age=" + this.schedulerApplication.getConfiguration().getBrandingCacheKeepAlive() / 1000L))).build();
    }

    public UserImageWorker getUserImageWorker() {
        return this.userImageWorker;
    }
}

