/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.LegalHoldParticipationCache;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetCommand;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.legalhold.CustodianState;
import com.nuix.automate.utils.models.api.legalhold.JobTriggerType;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.legalhold.SurveyNoticesTrigger;
import com.nuix.automate.utils.models.api.notice.Command;
import com.nuix.automate.utils.models.api.notice.CommentType;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeComment;
import com.nuix.automate.utils.models.api.notice.NoticeCommentSubmission;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import com.nuix.automate.utils.models.api.notice.RecurringNoticeFrequency;
import com.nuix.automate.utils.models.api.notice.UserNotice;
import com.nuix.automate.utils.models.api.notice.UserNoticeCommand;
import com.nuix.automate.utils.models.api.notice.UserNoticeQueryFilter;
import com.nuix.automate.utils.models.api.notice.UserNoticeStateFilter;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/notices")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NoticeResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NoticeResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, Notice> notices;
    private long lastReminderWorkerTime;
    private long lastRecurringWorkerTime;

    public NoticeResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.notices = new ConcurrentHashMap<String, Notice>();
    }

    public void initializeNoticesFromStore() {
        LOGGER.info("Initializing Notices from store");
        List<Notice> notices = this.schedulerApplication.getSchedulerConfigurationDao().getNotices();
        for (Notice notice : notices) {
            this.notices.put(notice.getId(), notice);
            if (notice.getSurveyFormOptions() == null) continue;
            for (FormOption formOption : notice.getSurveyFormOptions()) {
                if (formOption.getType() != FormElementType.DATA_UPLOAD || formOption.getModelNamingPattern() != null) continue;
                formOption.setModelNamingPattern("{custodian_name} - Files");
            }
        }
    }

    public UserNotice buildUserNoticeModel(SchedulerApplication schedulerApplication, BearerUser user, Notice noticeModel, NoticeEvent noticeEvent) {
        UserNotice userNotice = new UserNotice(noticeModel, noticeEvent);
        userNotice = schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userNotice);
        if (noticeModel.getSurveyFormOptions() != null) {
            userNotice.setSurveyFormOptions(noticeModel, noticeEvent);
        }
        if (userNotice.getUserPermissions().contains(Permission.MANAGE)) {
            userNotice.setAdminLastViewedDate(noticeEvent.getAdminLastViewedDate());
        }
        userNotice.evaluateOutstanding(user.getId());
        if (userNotice.canView()) {
            Map<String, com.nuix.automate.utils.models.api.job.Parameter> parameters = schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
            userNotice.evaluateParameters(parameters);
        }
        return userNotice;
    }

    public void addNotice(Notice notice) {
        this.schedulerApplication.getSchedulerConfigurationDao().addNotice(notice);
        this.notices.put(notice.getId(), notice);
    }

    public Notice getNotice(String noticeId) {
        if (noticeId != null) {
            return this.notices.get(noticeId);
        }
        return null;
    }

    public Collection<Notice> getNotices() {
        return this.notices.values();
    }

    public Notice deleteNotice(String noticeId) {
        if (noticeId != null) {
            this.schedulerApplication.getSchedulerConfigurationDao().deleteNotice(noticeId);
            return this.notices.remove(noticeId);
        }
        return null;
    }

    public long getRecurringNoticePeriod(NoticeConfiguration configuration) {
        long period = 0L;
        long currentTimeMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        period = configuration.getRecurringNoticeFrequency() == RecurringNoticeFrequency.MONTHS ? Instant.ofEpochMilli(currentTimeMillis).atZone(ZoneId.of("UTC")).plusMonths(configuration.getSendRecurringNoticeEveryN().intValue()).toEpochSecond() * 1000L : Instant.ofEpochMilli(currentTimeMillis).plus((long)configuration.getSendRecurringNoticeEveryN().intValue(), ChronoUnit.DAYS).toEpochMilli();
        return period - currentTimeMillis;
    }

    private synchronized void handleNoticeRecurring() {
        if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.LEGAL_HOLD)) {
            return;
        }
        this.lastRecurringWorkerTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Starting notice recurring check");
        try {
            long currentTimeMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            boolean noticeEventCreated = false;
            for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
                if (legalHold.getState() != LegalHoldState.ACTIVE || Boolean.TRUE.equals(legalHold.getSilent()) || legalHold.getRecurringNoticeConfiguration() == null || Boolean.FALSE.equals(legalHold.getRecurringNoticeConfiguration().getEnabled())) continue;
                long recurringNoticePeriod = this.getRecurringNoticePeriod(legalHold.getRecurringNoticeConfiguration());
                Notice holdNotice = this.notices.get(legalHold.getHoldNoticeConfiguration().getNoticeId());
                Notice recurringNotice = this.notices.get(legalHold.getRecurringNoticeConfiguration().getNoticeId());
                if (recurringNotice == null) continue;
                List<LegalHoldParticipation> custodianParticipations = LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.CUSTODIAN);
                for (LegalHoldParticipation custodian : custodianParticipations) {
                    NoticeEvent recurringNoticeEvent;
                    if (custodian.getCustodianState() != CustodianState.ON_HOLD) continue;
                    long lastRecurringNoticeDate = 0L;
                    List<NoticeEvent> recurringNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(recurringNotice.getId(), custodian.getUserId());
                    if (recurringNoticeEvents != null && recurringNoticeEvents.size() > 0) {
                        for (NoticeEvent event : recurringNoticeEvents) {
                            lastRecurringNoticeDate = Math.max(event.getSentDate(), lastRecurringNoticeDate);
                        }
                    } else {
                        List<NoticeEvent> holdNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(holdNotice.getId(), custodian.getUserId());
                        lastRecurringNoticeDate = holdNoticeEvents.get(0).getSentDate();
                    }
                    if (currentTimeMillis - lastRecurringNoticeDate < recurringNoticePeriod || (recurringNoticeEvent = this.schedulerApplication.getNoticeUtils().buildNoticeEvent(new SystemBearerUser(), recurringNotice, custodian.getUserId())) == null) continue;
                    noticeEventCreated = true;
                    UserNotice eventResult = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, new SystemBearerUser(), recurringNotice, recurringNoticeEvent);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_NOTICE_RECURRING, eventResult);
                    this.schedulerApplication.getNoticeUtils().trackIssuedNoticeEventUtilization(new SystemBearerUser(), recurringNotice, recurringNoticeEvent);
                }
                if (!noticeEventCreated) continue;
                ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, recurringNotice.getLegalHoldId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Notice recurring task failed", (Throwable)e);
        }
    }

    private synchronized void handleNoticeRemindersAndEscalations() {
        if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.LEGAL_HOLD)) {
            return;
        }
        this.lastReminderWorkerTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LOGGER.info("Starting notice reminder and escalation check");
        try {
            long currentTimeMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            for (Notice noticeModel : this.notices.values()) {
                NoticeConfiguration noticeConfiguration;
                NoticeType type = noticeModel.getType();
                if (noticeModel.getEnabled() != Boolean.TRUE || NoticeType.REMINDER.equals((Object)type) || NoticeType.ESCALATION.equals((Object)type) || (noticeConfiguration = noticeModel.getConfiguration()) == null || noticeConfiguration.getEnableRemind() != Boolean.TRUE && noticeConfiguration.getEscalateOnResponseFail() != Boolean.TRUE) continue;
                boolean noticeEventCreated = false;
                boolean hasSurveyFormOptions = noticeModel.hasSurveyFormOptions();
                for (NoticeEvent noticeEvent : this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents(noticeModel.getId())) {
                    NoticeEvent reminderNoticeEvent;
                    String reminderNoticeId;
                    Notice reminderNoticeModel;
                    long remindEveryMillis;
                    Long lastRemindedDate;
                    long elapsedMillis;
                    if (!Boolean.TRUE.equals(noticeEvent.getEnabled()) || noticeEvent.getLastViewedDate() != null && (!hasSurveyFormOptions || noticeEvent.getLastRespondedDate() != null)) continue;
                    long sentDate = noticeEvent.getSentDate();
                    long respondByMillis = noticeConfiguration.getRespondByMillis(sentDate);
                    if (currentTimeMillis > respondByMillis) {
                        NoticeEvent escalateNoticeEvent;
                        String escalateNoticeId;
                        Notice escalateNoticeModel;
                        if (!Boolean.TRUE.equals(noticeConfiguration.getEscalateOnResponseFail()) || noticeEvent.getEscalatedDate() != null || !Boolean.TRUE.equals((escalateNoticeModel = this.getNotice(escalateNoticeId = noticeConfiguration.getEscalateNoticeId())).getEnabled()) || (escalateNoticeEvent = this.schedulerApplication.getNoticeUtils().buildNoticeEvent(new SystemBearerUser(), escalateNoticeModel, noticeEvent.getUserId())) == null) continue;
                        escalateNoticeEvent.setParentId(noticeEvent.getId());
                        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(escalateNoticeEvent);
                        noticeEvent.setEscalatedDate(escalateNoticeEvent.getSentDate());
                        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
                        noticeEventCreated = true;
                        UserNotice eventResult = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, new SystemBearerUser(), escalateNoticeModel, escalateNoticeEvent);
                        SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_NOTICE_ESCALATION, eventResult);
                        LegalHold escalationLegalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(escalateNoticeModel.getLegalHoldId());
                        this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(escalationLegalHold, JobTriggerType.ON_CUSTODIAN_ESCALATION, null, escalateNoticeModel, noticeEvent, null);
                        this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(new SystemBearerUser(), noticeModel, noticeEvent);
                        this.schedulerApplication.getNoticeUtils().trackIssuedNoticeEventUtilization(new SystemBearerUser(), escalateNoticeModel, escalateNoticeEvent);
                        continue;
                    }
                    if (!Boolean.TRUE.equals(noticeConfiguration.getEnableRemind()) || (elapsedMillis = currentTimeMillis - ((lastRemindedDate = noticeEvent.getLastRemindedDate()) == null ? sentDate : lastRemindedDate)) <= (remindEveryMillis = (long)noticeConfiguration.getRemindEveryNDays().intValue() * 86400000L) || !Boolean.TRUE.equals((reminderNoticeModel = this.getNotice(reminderNoticeId = noticeConfiguration.getReminderNoticeId())).getEnabled()) || (reminderNoticeEvent = this.schedulerApplication.getNoticeUtils().buildNoticeEvent(new SystemBearerUser(), reminderNoticeModel, noticeEvent.getUserId())) == null) continue;
                    reminderNoticeEvent.setParentId(noticeEvent.getId());
                    this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(reminderNoticeEvent);
                    noticeEvent.setLastRemindedDate(reminderNoticeEvent.getSentDate());
                    this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
                    noticeEventCreated = true;
                    UserNotice eventResult = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, new SystemBearerUser(), reminderNoticeModel, reminderNoticeEvent);
                    SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_NOTICE_REMINDER, eventResult);
                    LegalHold reminderNoticeLegalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(reminderNoticeModel.getLegalHoldId());
                    this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(reminderNoticeLegalHold, JobTriggerType.ON_CUSTODIAN_REMINDER, null, reminderNoticeModel, noticeEvent, null);
                    this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(new SystemBearerUser(), noticeModel, noticeEvent);
                    this.schedulerApplication.getNoticeUtils().trackIssuedNoticeEventUtilization(new SystemBearerUser(), reminderNoticeModel, reminderNoticeEvent);
                }
                if (!noticeEventCreated) continue;
                ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, noticeModel.getLegalHoldId());
            }
        }
        catch (Exception e) {
            LOGGER.error("Notice reminder and escalation task failed", (Throwable)e);
        }
    }

    public void initializeNoticeRespondedCheckPolling() {
        this.schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            if (currentMillis - this.lastReminderWorkerTime > this.schedulerApplication.getConfiguration().getNoticeReminderEscalationPollInterval()) {
                this.handleNoticeRemindersAndEscalations();
            }
            if (currentMillis - this.lastRecurringWorkerTime > this.schedulerApplication.getConfiguration().getNoticeReminderEscalationPollInterval()) {
                this.handleNoticeRecurring();
            }
        }, 0L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Operation(tags={"Notices"}, operationId="GetNoticesWithOutstandingWork", summary="Get Notices With Outstanding Work", description="Get list of outstanding notices for given user", responses={@ApiResponse(description="The list of notices with outstanding work", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserNotice.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/outstanding")
    @GET
    public Response getNoticesWithOutstandingWork(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (user.getId() == null) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
        }
        long lastUserNoticesModified = 0L;
        ArrayList<UserNotice> outstandingUserNotices = new ArrayList<UserNotice>();
        List<NoticeEvent> userNoticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getUserNoticeEvents(user.getId());
        for (NoticeEvent noticeEvent : userNoticeEvents) {
            LegalHold legalHold;
            Notice noticeModel = this.schedulerApplication.getNoticeResource().getNotice(noticeEvent.getNoticeId());
            if (noticeModel == null || noticeModel.getEnabled() != Boolean.TRUE || noticeEvent.getEnabled() != Boolean.TRUE || (legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId())) == null || !LegalHold.replyStates.contains(legalHold.getState())) continue;
            long noticesModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICES, legalHold.getId());
            long noticeCommentsModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICE_COMMENTS, noticeEvent.getId());
            if (noticesModified > lastUserNoticesModified) {
                lastUserNoticesModified = noticesModified;
            }
            if (noticeCommentsModified > lastUserNoticesModified) {
                lastUserNoticesModified = noticeCommentsModified;
            }
            if (noticeEvent.getLastViewedDate() != null && (!noticeModel.hasSurveyFormOptions() || noticeEvent.getLastRespondedDate() != null)) continue;
            UserNotice userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
            outstandingUserNotices.add(userNotice);
        }
        for (LegalHoldParticipation participationModel : LegalHoldParticipationCache.getInstance().getUserLegalHoldParticipations(user.getId(), LegalHoldRole.ADMINISTRATOR)) {
            LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(participationModel.getLegalHoldId());
            if (legalHold == null || !LegalHold.replyStates.contains(legalHold.getState())) continue;
            long noticesModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICES, legalHold.getId());
            if (noticesModified > lastUserNoticesModified) {
                lastUserNoticesModified = noticesModified;
            }
            for (Notice noticeModel : this.schedulerApplication.getSchedulerConfigurationDao().getLegalHoldNotices(legalHold.getId())) {
                if (noticeModel.getEnabled() != Boolean.TRUE) continue;
                for (NoticeEvent noticeEvent : this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvents(noticeModel.getId())) {
                    Long lastCommentedDate;
                    boolean outstanding;
                    Long lastAdminNoteDate = noticeEvent.getLastAdminNoteDate();
                    if (noticeEvent.getEnabled() != Boolean.TRUE || noticeEvent.getLastRespondedDate() != null && lastAdminNoteDate == null) continue;
                    long noticeCommentsModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICE_COMMENTS, noticeEvent.getId());
                    if (noticeCommentsModified > lastUserNoticesModified) {
                        lastUserNoticesModified = noticeCommentsModified;
                    }
                    boolean bl = outstanding = (lastCommentedDate = noticeEvent.getLastCommentedDate()) != null && noticeEvent.getUserId().equals(noticeEvent.getLastCommentedUserId());
                    if (!outstanding && lastAdminNoteDate != null && !user.getId().equals(noticeEvent.getLastAdminNoteUserId())) {
                        Long adminLastViewed = (Long)noticeEvent.getAdminLastViewedDate().get(user.getId());
                        boolean bl2 = outstanding = adminLastViewed == null || adminLastViewed <= lastAdminNoteDate;
                    }
                    if (!outstanding) continue;
                    UserNotice userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
                    outstandingUserNotices.add(userNotice);
                }
            }
        }
        try {
            return ResponseCache.getInstance().getResponse(lastUserNoticesModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            outstandingUserNotices.sort(Comparator.comparing(UserNotice::getSentDate));
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).header("ETag", (Object)(lastUserNoticesModified + "-" + user.getShortSessionId())).entity(outstandingUserNotices).build();
        }
    }

    @Operation(tags={"Notices"}, operationId="GetUsersWithNotices", summary="Get Users with Notices", description="Get users with Notices", responses={@ApiResponse(description="The list of users with notices", content={@Content(schema=@Schema(implementation=UserAccount.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/users")
    @GET
    public Response getUsersWithNotices(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list notice users");
        }
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.LEGAL_HOLDS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
        }
        boolean isAllowedAll = false;
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            isAllowedAll = true;
        }
        Set<String> allowedAuthenticationServiceIds = this.schedulerApplication.getSecurityPolicyUtil().getAllowedAuthenticationServiceIds(user.getIdentifiers(), Permission.VIEW, false);
        Set<String> noticeUserIds = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEventUserIds();
        ArrayList<UserAccount> users = new ArrayList<UserAccount>();
        for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getImmutableUsers().values()) {
            if (!noticeUserIds.contains(userAccount.getId()) || !isAllowedAll && !allowedAuthenticationServiceIds.contains(userAccount.getUserServiceId())) continue;
            users.add(userAccount);
        }
        String lastHash = ResponseCache.getInstance().hashObject(users);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(users).build();
        }
    }

    @Operation(tags={"Notices"}, operationId="SendUserNoticeCommand", summary="Send User Notice Command", description="Process user notice command", responses={@ApiResponse(description="The updated user notice", content={@Content(schema=@Schema(implementation=UserNotice.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}")
    @POST
    public Response sendUserNoticeCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId, @Parameter(description="The user notice command") UserNoticeCommand userNoticeCommand) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Command command = userNoticeCommand.getCommand();
        HashSet<Command> restrictedCommands = new HashSet<Command>(Arrays.asList(Command.CREATE_DATASET));
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, !restrictedCommands.contains(command));
        if (errorResponse != null) {
            return errorResponse;
        }
        Notice noticeModel = this.getNotice(noticeId);
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId());
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeEvent).getUserPermissions();
        if (!(Command.CREATE_DATASET.equals((Object)command) && permissions.contains(Permission.RESPOND) || permissions.contains(Permission.MANAGE))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEventId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        switch (command) {
            case ENABLE: {
                noticeEvent.setEnabled(Boolean.valueOf(true));
                break;
            }
            case DISABLE: {
                noticeEvent.setEnabled(Boolean.valueOf(false));
                break;
            }
            case ENABLE_COMMENTS: {
                noticeEvent.setDisableComments(Boolean.valueOf(false));
                break;
            }
            case DISABLE_COMMENTS: {
                noticeEvent.setDisableComments(Boolean.valueOf(true));
                break;
            }
            case RESET_SUBMISSION: {
                noticeEvent.resetSubmission(noticeModel.getSurveyFormOptions());
                UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
                if (!this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount) || !userAccount.hasEmail()) break;
                SmtpEmail smtpEmail = this.schedulerApplication.getNoticeUtils().buildNoticeEventEmailModel(noticeEvent, EmailType.NOTICE_SUBMISSION_RESET);
                smtpEmail.setTo(userAccount.getEmail());
                String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(userAccount, legalHold, legalHold.getNoticeUrl(noticeEvent.getId()));
                String emailDescription = this.iu.getFormattedString("EmailResource.ResetNoticeResponseSubmission", (Object)noticeModel.getSubject());
                smtpEmail.setHtmlFormat(Boolean.valueOf(true));
                smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(user.getName(), emailDescription, noticeUrl));
                this.schedulerApplication.getNoticeUtils().evaluateEmailParameters(smtpEmail, this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent));
                this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
                this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
                break;
            }
            case CREATE_DATASET: {
                String datasetId;
                String surveyFormKey = userNoticeCommand.getSurveyFormKey();
                List surveyFormOptions = noticeModel.getSurveyFormOptions();
                FormOption datasetFormOption = null;
                for (FormOption formOption : surveyFormOptions) {
                    if (!surveyFormKey.equals(formOption.getKey()) || !FormElementType.DATA_UPLOAD.equals((Object)formOption.getType())) continue;
                    datasetFormOption = formOption;
                    break;
                }
                if (datasetFormOption == null) {
                    return ExceptionUtils.toResponse((String)"didNotFindCorrespondingSurveyFormOption");
                }
                HashMap<String, String> surveyFormValues = noticeEvent.getSurveyFormValues();
                if (surveyFormValues == null) {
                    surveyFormValues = new HashMap<String, String>();
                    noticeEvent.setSurveyFormValues(surveyFormValues);
                }
                if ((datasetId = (String)surveyFormValues.get(surveyFormKey)) != null && this.schedulerApplication.getDatasetResource().containsDataset(datasetId)) {
                    return ExceptionUtils.toResponse((String)"datasetExists");
                }
                Dataset dataset = new Dataset();
                dataset.setState(DatasetState.DRAFT);
                dataset.setMatterId(legalHold.getMatterId());
                dataset.setDataRepositoryId(legalHold.getDataRepositoryId());
                dataset.setNoticeEventId(noticeEventId);
                Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeEventBuiltInParameters = this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
                String datasetNamingPattern = datasetFormOption.getModelNamingPattern();
                String datasetName = this.schedulerApplication.getNoticeUtils().evaluateParameters(noticeEventBuiltInParameters, datasetNamingPattern);
                UserAccount noticeEventUser = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
                if (noticeEventUser != null) {
                    dataset.setDatasetCustodian(noticeEventUser.getName());
                }
                Set<String> existingDatasetNames = this.schedulerApplication.getDatasetResource().getDatasetNames();
                datasetName = FormattingUtils.incrementName((String)datasetName, existingDatasetNames);
                dataset.setName(datasetName);
                errorResponse = this.schedulerApplication.getDatasetResource().addDataSetInternal(user, dataset, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
                if (Response.Status.OK.getStatusCode() != errorResponse.getStatus()) {
                    return errorResponse;
                }
                datasetId = dataset.getId();
                surveyFormValues.put(surveyFormKey, datasetId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command: " + String.valueOf(command));
            }
        }
        long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        noticeEvent.setLastViewedDate(user.getId(), permissions, currentTime);
        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
        this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(user, noticeModel, noticeEvent);
        UserNotice result = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, noticeModel.getLegalHoldId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Notices"}, operationId="GetUserNotice", summary="Get User Notice", description="Get the user notice with the corresponding id", responses={@ApiResponse(description="The user notice", content={@Content(schema=@Schema(implementation=UserNotice.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}")
    @GET
    public Response getUserNoticeModel(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        noticeEvent = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeEvent);
        if (!noticeEvent.canView()) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEvent);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        Notice noticeModel = this.getNotice(noticeId);
        UserNotice userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userNotice).build();
    }

    @Operation(tags={"Notices"}, operationId="GetUserNoticesWithFilter", summary="Get User Notice With Filter", description="Get the user notices that match the query filter", responses={@ApiResponse(description="The filtered user notices", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserNotice.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response getUserNoticesWithFilter(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The user notice query filter") UserNoticeQueryFilter noticeQueryFilter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        UserNoticeStateFilter userNoticeStateFilter = noticeQueryFilter.getStateFilter();
        if (noticeQueryFilter.getCount() <= 0) {
            LOGGER.warn("Detected invalid UserNotice filter count: " + noticeQueryFilter.getCount() + ", resetting to default value: 50");
            noticeQueryFilter.setCount(50);
        }
        HashSet<String> userIds = new HashSet<String>();
        if (noticeQueryFilter.getUserIds() != null) {
            userIds.addAll(noticeQueryFilter.getUserIds());
        }
        if (userIds.isEmpty()) {
            userIds.add("__EMPTY_LIST_SENTINEL__");
        }
        HashSet<String> legalHoldsInScope = new HashSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            LegalHold result;
            if (!noticeQueryFilter.isValid((Collection)noticeQueryFilter.getLegalHoldIds(), (Object)legalHold.getId()) || !noticeQueryFilter.isValid((Collection)noticeQueryFilter.getClientIds(), (Object)legalHold.getClientId()) || !noticeQueryFilter.isValid((Collection)noticeQueryFilter.getMatterIds(), (Object)legalHold.getMatterId()) || !(result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold)).canView()) continue;
            legalHoldsInScope.add(legalHold.getId());
        }
        List<Object> userNotices = new ArrayList();
        for (Notice notice : this.notices.values()) {
            if (!legalHoldsInScope.contains(notice.getLegalHoldId()) || !noticeQueryFilter.isValid((Collection)noticeQueryFilter.getTypes(), (Object)notice.getType())) continue;
            List<NoticeEvent> noticeEvents = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvents(notice.getId(), noticeQueryFilter.getCount(), userIds, noticeQueryFilter.getBeforeDate(), noticeQueryFilter.getAfterDate());
            for (NoticeEvent noticeEvent : noticeEvents) {
                UserNotice userNotice;
                if (!userNoticeStateFilter.isValid(notice, noticeEvent) || !(userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, notice, noticeEvent)).canView()) continue;
                userNotices.add(userNotice);
            }
        }
        userNotices = userNotices.stream().sorted(Comparator.comparing(UserNotice::getSentDate, Comparator.reverseOrder())).limit(noticeQueryFilter.getCount()).collect(Collectors.toList());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(userNotices).build();
    }

    @Operation(tags={"Notices"}, operationId="SendUserNoticeResponse", summary="Send User Notice Response", description="Post a response for the user notice", responses={@ApiResponse(description="The updated user notice", content={@Content(schema=@Schema(implementation=UserNotice.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}/response")
    @POST
    public Response postUserResponse(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId, @Parameter(description="Submit notice final responses?") @QueryParam(value="submit") boolean submit, @Parameter(description="The responses") Map<String, String> responseValues) throws FileTraversalException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, false);
        if (errorResponse != null) {
            return errorResponse;
        }
        Notice noticeModel = this.getNotice(noticeId);
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeEvent).getUserPermissions();
        if (!permissions.contains(Permission.RESPOND)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEvent);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (noticeEvent.getLastRespondedDate() != null) {
            return ExceptionUtils.toResponse((String)"noticeResponseAlreadySubmitted", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (submit) {
            List surveyFormOptions = noticeModel.getSurveyFormOptions();
            for (final FormOption formOption : surveyFormOptions) {
                boolean missingRequiredCheckbox;
                if (!formOption.getEnabled() || formOption.getOptional() || FormElementType.HEADER.equals((Object)formOption.getType())) continue;
                String value = responseValues.get(formOption.getKey());
                boolean bl = missingRequiredCheckbox = formOption.getType() == FormElementType.CHECKBOX && !Boolean.parseBoolean(value);
                if (value != null && value.trim().length() != 0 && !missingRequiredCheckbox) continue;
                return ExceptionUtils.toResponse((String)"missingRequiredSurveyFormValue", (Map)new HashMap<String, String>(){
                    {
                        this.put("description", formOption.getDescription());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            for (final FormOption formOption : surveyFormOptions) {
                Dataset dataset;
                String datasetId = responseValues.get(formOption.getKey());
                if (!FormElementType.DATA_UPLOAD.equals((Object)formOption.getType()) || datasetId == null || (dataset = this.schedulerApplication.getDatasetResource().getDataset(datasetId)) == null || !dataset.isDraft()) continue;
                DatasetCommand datasetCommand = new DatasetCommand();
                datasetCommand.setCommand(DatasetCommand.Command.FINALIZE);
                errorResponse = this.schedulerApplication.getDatasetResource().sendDatasetCommand(user, request, datasetId, true, datasetCommand);
                if (Response.Status.OK.getStatusCode() == errorResponse.getStatus()) continue;
                return errorResponse;
            }
            String legalHoldId = noticeModel.getLegalHoldId();
            LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(legalHoldId);
            if (legalHold.getSurveyNoticesTrigger() == SurveyNoticesTrigger.ON_HOLD_RESPONSE && noticeId.equals(legalHold.getHoldNoticeConfiguration().getNoticeId())) {
                List<Notice> surveyNotices = this.schedulerApplication.getNoticeUtils().getEnabledSurveyNotices(legalHold);
                this.schedulerApplication.getLegalHoldUtils().issueNotices(user, noticeEvent.getUserId(), surveyNotices);
            }
            this.schedulerApplication.getLegalHoldUtils().handleCustodianTriggerConfiguration(legalHold, JobTriggerType.ON_CUSTODIAN_RESPONSE, null, noticeModel, noticeEvent, responseValues);
            noticeEvent.setEnabled(Boolean.valueOf(false));
            long lastChangedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            noticeEvent.setLastRespondedDate(Long.valueOf(lastChangedDate));
            noticeEvent.setLastViewedDate(user.getId(), permissions, lastChangedDate);
            if (noticeEvent.getRespondedDate() == null) {
                noticeEvent.setRespondedDate(Long.valueOf(lastChangedDate));
            }
            this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(user, noticeModel, noticeEvent);
            Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeEventBuiltInParameters = this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
            for (LegalHoldParticipation adminParticipation : LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHoldId, LegalHoldRole.ADMINISTRATOR)) {
                UserAccount adminUserAccount = this.schedulerApplication.getUserServiceResource().getUser(adminParticipation.getUserId());
                if (!this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(adminUserAccount) || !adminUserAccount.hasEmail()) continue;
                SmtpEmail smtpEmail = this.schedulerApplication.getNoticeUtils().buildNoticeEventEmailModel(noticeEvent, EmailType.RESPONSE_SUBMITTED);
                smtpEmail.setTo(adminUserAccount.getEmail());
                String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(adminUserAccount, legalHold, legalHold.getNoticeUrl(noticeEvent.getId()));
                String emailDescription = this.iu.getFormattedString("LegalHoldResource.ResponseSubmittedEmailDescription." + noticeModel.getType().name(), (Object[])new String[]{user.getName(), legalHold.getName()});
                smtpEmail.setHtmlFormat(Boolean.valueOf(true));
                smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(user.getName(), emailDescription, noticeUrl));
                this.schedulerApplication.getNoticeUtils().evaluateEmailParameters(smtpEmail, noticeEventBuiltInParameters);
                this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
                this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
            }
        }
        noticeEvent.setSurveyFormValues(responseValues);
        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
        UserNotice userNotice = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, noticeModel.getLegalHoldId());
        UserNotice eventResult = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
        SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(EventType.Type.LEGAL_HOLD_NOTICE_CUSTODIAN_RESPONDED, eventResult, user.getName());
        this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(user, noticeModel, noticeEvent);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userNotice).build();
    }

    @Operation(tags={"Notices"}, operationId="MarkNoticeAsViewed", summary="Mark Notice As Viewed", description="Mark the specified notice as viewed", responses={@ApiResponse(description="Updated user notice", content={@Content(schema=@Schema(implementation=UserNotice.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}/viewed")
    @POST
    public Response markNoticeAsViewed(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeEvent).getUserPermissions();
        boolean canReply = permissions.contains(Permission.RESPOND);
        boolean canManage = permissions.contains(Permission.MANAGE);
        if (!canReply && !canManage) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEvent);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        long lastViewedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        noticeEvent.setLastViewedDate(user.getId(), permissions, lastViewedDate);
        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
        Notice notice = this.getNotice(noticeId);
        this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(user, notice, noticeEvent);
        Notice noticeModel = this.getNotice(noticeId);
        UserNotice result = SchedulerApplication.getInstance().getNoticeResource().buildUserNoticeModel(this.schedulerApplication, user, noticeModel, noticeEvent);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICES, noticeModel.getLegalHoldId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Notices"}, operationId="GetNoticeComments", summary="Get Notice Comments", description="Get notice comments", responses={@ApiResponse(description="User notice comments", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NoticeComment.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}/comments")
    @GET
    public Response getUserNoticeComments(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICE_COMMENTS, noticeEventId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            List<NoticeComment> noticeComments = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeComments(noticeEventId);
            ArrayList<NoticeComment> viewableNoticeComments = new ArrayList<NoticeComment>();
            for (NoticeComment noticeComment : noticeComments) {
                NoticeComment result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeComment);
                if (!result.canView()) continue;
                viewableNoticeComments.add(result);
                this.populateUsername(result);
            }
            viewableNoticeComments.sort(Comparator.comparing(NoticeComment::getCreatedDate));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(viewableNoticeComments).build();
        }
    }

    @Operation(tags={"Notices"}, operationId="SendNoticeComment", summary="Send Notice Comment", description="Post comment on the specified notice", responses={@ApiResponse(description="The user notice comment", content={@Content(schema=@Schema(implementation=NoticeComment.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeId}/events/{noticeEventId}/comments")
    @POST
    public Response sendNoticeComment(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notice ID") @PathParam(value="noticeId") String noticeId, @Parameter(description="The notice event ID") @PathParam(value="noticeEventId") String noticeEventId, @Parameter(description="The comment", schema=@Schema(implementation=NoticeCommentSubmission.class)) NoticeComment noticeComment) {
        EventType.Type eventType;
        EmailType emailType;
        String message;
        boolean noticeDisabled;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        NoticeEvent noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeEvent(noticeEventId);
        Response errorResponse = this.verifyNoticeEvent(noticeId, noticeEventId, noticeEvent, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        Notice noticeModel = this.getNotice(noticeId);
        boolean isAdminNote = noticeComment.getType() == CommentType.ADMIN_NOTE;
        boolean canCommentOnDisabledNotice = isAdminNote && noticeModel.getConfiguration().getDisableAdminNotes() != Boolean.TRUE;
        boolean bl = noticeDisabled = noticeModel.getEnabled() != Boolean.TRUE || noticeEvent.getEnabled() != Boolean.TRUE;
        if (!canCommentOnDisabledNotice && noticeDisabled) {
            return ExceptionUtils.toResponse((String)"noticeIsDisabled", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeEvent).getUserPermissions();
        if (isAdminNote) {
            if (!permissions.contains(Permission.MANAGE)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEvent);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (noticeModel.getConfiguration().getDisableAdminNotes() == Boolean.TRUE) {
                return ExceptionUtils.toResponse((String)"adminNotesAreDisabled", (Response.Status)Response.Status.BAD_REQUEST);
            }
        } else {
            if (!permissions.contains(Permission.MANAGE) && !permissions.contains(Permission.RESPOND)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeEvent);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (noticeModel.getConfiguration().getDisableComments() == Boolean.TRUE || noticeEvent.getDisableComments() == Boolean.TRUE) {
                return ExceptionUtils.toResponse((String)"commentsAreDisabled", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((message = noticeComment.getMessage()) == null || message.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"userCommentMessageEmpty", (Response.Status)Response.Status.BAD_REQUEST);
        }
        String noticeCommentId = UidUtils.getRandom();
        noticeComment.setId(noticeCommentId);
        long createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        noticeComment.setCreatedDate(Long.valueOf(createdDate));
        noticeComment.setNoticeEventId(noticeEventId);
        noticeComment.setUserId(user.getId());
        noticeEvent.setLastViewedDate(user.getId(), permissions, createdDate);
        if (isAdminNote) {
            noticeEvent.setLastAdminNoteDate(Long.valueOf(createdDate));
            noticeEvent.setLastAdminNoteUserId(user.getId());
            emailType = EmailType.ADMIN_NOTE_ADDED;
        } else {
            noticeEvent.setLastCommentedDate(Long.valueOf(createdDate));
            noticeEvent.setLastCommentedUserId(user.getId());
            emailType = EmailType.COMMENT_ADDED;
        }
        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeEvent(noticeEvent);
        this.schedulerApplication.getSchedulerConfigurationDao().addNoticeComment(noticeComment);
        this.schedulerApplication.getNoticeUtils().trackUpdatedNoticeEventUtilization(user, noticeModel, noticeEvent);
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId());
        Map<String, com.nuix.automate.utils.models.api.job.Parameter> noticeEventBuiltInParameters = this.schedulerApplication.getNoticeUtils().getNoticeEventBuiltInParameters(noticeEvent);
        if (!noticeEvent.getUserId().equals(user.getId())) {
            if (isAdminNote) {
                eventType = EventType.Type.LEGAL_HOLD_NOTICE_ADMIN_ADDED_ADMIN_NOTE;
            } else {
                eventType = EventType.Type.LEGAL_HOLD_NOTICE_ADMIN_ADDED_COMMENT;
                UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
                if (this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount) && userAccount.hasEmail()) {
                    SmtpEmail smtpEmail = this.schedulerApplication.getNoticeUtils().buildNoticeEventEmailModel(noticeEvent, emailType);
                    smtpEmail.setTo(userAccount.getEmail());
                    String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(userAccount, legalHold, legalHold.getNoticeUrl(noticeEvent.getId()));
                    String emailDescription = this.iu.getFormattedString("EmailResource.NoticeCommentEmailDescription", (Object)user.getName());
                    smtpEmail.setHtmlFormat(Boolean.valueOf(true));
                    smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(user.getName(), emailDescription, noticeUrl));
                    this.schedulerApplication.getNoticeUtils().evaluateEmailParameters(smtpEmail, noticeEventBuiltInParameters);
                    this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
                    this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
                }
            }
        } else {
            eventType = EventType.Type.LEGAL_HOLD_NOTICE_CUSTODIAN_ADDED_COMMENT;
        }
        for (LegalHoldParticipation adminParticipation : LegalHoldParticipationCache.getInstance().getLegalHoldParticipations(legalHold.getId(), LegalHoldRole.ADMINISTRATOR)) {
            UserAccount adminUserAccount = this.schedulerApplication.getUserServiceResource().getUser(adminParticipation.getUserId());
            if (adminUserAccount == null || adminUserAccount.getId().equals(user.getId()) || !this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(adminUserAccount) || !adminUserAccount.hasEmail()) continue;
            SmtpEmail smtpEmail = this.schedulerApplication.getNoticeUtils().buildNoticeEventEmailModel(noticeEvent, emailType);
            smtpEmail.setTo(adminUserAccount.getEmail());
            String noticeUrl = this.schedulerApplication.getUserResource().createLegalHoldLoginLink(adminUserAccount, legalHold, legalHold.getNoticeUrl(noticeEventId));
            String emailDescription = this.iu.getFormattedString("EmailResource.NoticeCommentEmailDescription", (Object)user.getName());
            smtpEmail.setHtmlFormat(Boolean.valueOf(true));
            smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(user.getName(), emailDescription, noticeUrl));
            this.schedulerApplication.getNoticeUtils().evaluateEmailParameters(smtpEmail, noticeEventBuiltInParameters);
            this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
            this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
        }
        NoticeComment eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeComment);
        SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(eventType, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_COMMENTS, noticeEventId);
        NoticeComment result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeComment);
        this.populateUsername(result);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void populateUsername(NoticeComment noticeComment) {
        OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(noticeComment.getUserId());
        if (offlineUser != null) {
            noticeComment.setUsername(offlineUser.getMainIdentifier().getIdentifierName());
        }
    }

    private Response verifyNoticeEvent(final String noticeId, final String noticeEventId, NoticeEvent noticeEvent, boolean allowDisabled) {
        if (noticeEvent == null) {
            return ExceptionUtils.toResponse((String)"cannotFindNoticeEvent", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeEventId", noticeEventId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!noticeEvent.getNoticeId().equals(noticeId)) {
            return ExceptionUtils.toResponse((String)"noticeEventIsNotNotices", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeEventId", noticeEventId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        final Notice noticeModel = this.getNotice(noticeId);
        if (noticeModel == null) {
            return ExceptionUtils.toResponse((String)"cannotFindNotice", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeId", noticeId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(noticeModel.getLegalHoldId());
        if (legalHold == null) {
            return ExceptionUtils.toResponse((String)"cannotFindLegalHold", (Map)new HashMap<String, String>(){
                {
                    this.put("legalHoldId", noticeModel.getLegalHoldId());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!(allowDisabled || noticeModel.getEnabled() == Boolean.TRUE && noticeEvent.getEnabled() == Boolean.TRUE)) {
            return ExceptionUtils.toResponse((String)"noticeIsDisabled", (Response.Status)Response.Status.BAD_REQUEST);
        }
        return null;
    }
}

