/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.SmtpServiceSession;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.notificationrule.DeprecatedEmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRuleSubmission;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.RuleType;
import com.nuix.automate.utils.models.api.notificationrule.WebhookNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.WebhookNotificationRuleSubmission;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.thirdparty.SmtpService;
import com.nuix.automate.utils.models.api.thirdparty.SmtpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/scheduler/resources/notificationRules")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationRuleResource
extends Versionable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NotificationRuleResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private Map<String, NotificationRule> notificationRules;

    public NotificationRuleResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.notificationRules = new LinkedHashMap<String, NotificationRule>();
        this.resetVersion();
    }

    public NotificationRule getNotificationRule(String id) {
        return this.notificationRules.get(id);
    }

    public void initializeNotificationRulesFromStore() {
        LOGGER.info("Initializing Notification Rules from store");
        List<NotificationRule> notificationRules = this.schedulerApplication.getSchedulerConfigurationDao().getNotificationRules();
        this.notificationRules = new LinkedHashMap<String, NotificationRule>();
        for (NotificationRule notificationRule : notificationRules) {
            if (notificationRule == null) continue;
            this.notificationRules.put(notificationRule.getId(), notificationRule);
            notificationRule.getStatus().reset();
        }
        this.resetVersion();
    }

    public void migrateDeprecatedEmailNotificationRules() {
        List<DeprecatedEmailNotificationRule> deprecatedNotificationRules = this.schedulerApplication.getSchedulerConfigurationDao().getDeprecatedEmailNotificationRules();
        deprecatedNotificationRules.removeIf(Objects::isNull);
        if (!deprecatedNotificationRules.isEmpty()) {
            LOGGER.info("Migrating deprecated Email Notification Rules to use SMTP Service");
            HashMap<CallSite, SmtpService> addedSmtpServices = new HashMap<CallSite, SmtpService>();
            for (DeprecatedEmailNotificationRule deprecatedRule : deprecatedNotificationRules) {
                try {
                    String smtpServiceKey = deprecatedRule.getSmtpServer() + deprecatedRule.getSmtpPort() + deprecatedRule.getSmtpAuthentication() + deprecatedRule.getSmtpUsername() + deprecatedRule.getSmtpPassword();
                    SmtpService smtpService = (SmtpService)addedSmtpServices.get(smtpServiceKey);
                    if (smtpService == null) {
                        smtpService = new SmtpService();
                        smtpService.setId(UUID.randomUUID().toString());
                        smtpService.setName(this.iu.getFormattedString("NotificationRule.MigratedSmtpServiceName", (Object)deprecatedRule.getName()));
                        smtpService.setDescription(this.iu.getFormattedString("NotificationRule.MigratedSmtpServiceDescription", (Object)deprecatedRule.getName()));
                        smtpService.setEnabled(Boolean.valueOf(true));
                        smtpService.setHost(deprecatedRule.getSmtpServer());
                        smtpService.setPort(deprecatedRule.getSmtpPort());
                        smtpService.setFrom(deprecatedRule.getFrom());
                        smtpService.setTls(deprecatedRule.getTls());
                        smtpService.setEmailRetryInterval(Integer.valueOf(this.schedulerApplication.getConfiguration().getSmtpServiceEmailRetryInterval()));
                        smtpService.setEmailMaxAttempts(Integer.valueOf(this.schedulerApplication.getConfiguration().getSmtpServiceEmailMaxAttempts()));
                        smtpService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                        smtpService.setAvailableByDefault(Boolean.valueOf(false));
                        if (Boolean.TRUE.equals(deprecatedRule.getSmtpAuthentication())) {
                            smtpService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
                            SmtpUserCredential userCredential = new SmtpUserCredential();
                            userCredential.setThirdPartyServiceId(smtpService.getId());
                            userCredential.setUserId(SmtpServiceSession.SYSTEM_USER_ID);
                            userCredential.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                            userCredential.setUsername(deprecatedRule.getSmtpUsername());
                            userCredential.setPassword(deprecatedRule.getSmtpPassword());
                            this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyUserCredential((ThirdPartyUserCredential)userCredential);
                        } else {
                            smtpService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.NONE);
                        }
                        this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyService((ThirdPartyService)smtpService);
                        addedSmtpServices.put((CallSite)((Object)smtpServiceKey), smtpService);
                    }
                    EmailNotificationRule updatedRule = (EmailNotificationRule)SerializationUtils.fromJson((String)SerializationUtils.toJson((Object)deprecatedRule), EmailNotificationRule.class);
                    updatedRule.setSmtpServiceId(smtpService.getId());
                    this.schedulerApplication.getSchedulerConfigurationDao().updateNotificationRule((NotificationRule)updatedRule);
                    LOGGER.info("Migrated deprecated Email Notification Rule: " + deprecatedRule.getName() + " (" + deprecatedRule.getId() + ")");
                }
                catch (Exception e) {
                    LOGGER.error("Error migrating deprecated Email Notification Rule: " + deprecatedRule.getName() + " (" + deprecatedRule.getId() + ")");
                }
            }
        }
    }

    public Collection<NotificationRule> getNotificationRules() {
        return this.notificationRules.values();
    }

    @Operation(tags={"Resources"}, operationId="GetNotificationRules", summary="Get Notification Rules", description="Get full information of all notification rules", responses={@ApiResponse(description="The list of notification rules", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NotificationRule.class)))})})
    @GET
    public Response getNotificationRules(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTIFICATION_RULES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<NotificationRule> allowedNotificationRules = new ArrayList<NotificationRule>();
            for (NotificationRule notificationRule : this.notificationRules.values()) {
                NotificationRule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                if (result instanceof WebhookNotificationRule && !result.getUserPermissions().contains(Permission.MODIFY) && !result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
                    String url = ((WebhookNotificationRule)result).getUrl();
                    ((WebhookNotificationRule)result).setUrl(FormattingUtils.anonymizeUrlPathAndParams((String)url));
                }
                allowedNotificationRules.add(result);
            }
            SortingUtils.sortList(allowedNotificationRules, NotificationRule::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedNotificationRules).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="GetEmailNotificationRules", summary="Get Email Notification Rules", description="Get full information of all email notification rules", responses={@ApiResponse(description="The list of email notification rules", content={@Content(array=@ArraySchema(schema=@Schema(implementation=EmailNotificationRule.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/email")
    @GET
    public Response getEmailNotificationRules(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTIFICATION_RULES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<EmailNotificationRule> allowedNotificationRules = new ArrayList<EmailNotificationRule>();
            for (NotificationRule notificationRule : this.notificationRules.values()) {
                NotificationRule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
                if (!result.getUserPermissions().contains(Permission.VIEW) || !(result instanceof EmailNotificationRule)) continue;
                allowedNotificationRules.add((EmailNotificationRule)result);
            }
            SortingUtils.sortList(allowedNotificationRules, NotificationRule::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedNotificationRules).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="GetWebhookNotificationRules", summary="Get Webhook Notification Rules", description="Get full information of all webhook notification rules", responses={@ApiResponse(description="The list of webhook notification rules", content={@Content(array=@ArraySchema(schema=@Schema(implementation=WebhookNotificationRule.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/webhook")
    @GET
    public Response getWebhookNotificationRules(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTIFICATION_RULES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<WebhookNotificationRule> allowedNotificationRules = new ArrayList<WebhookNotificationRule>();
            for (NotificationRule notificationRule : this.notificationRules.values()) {
                NotificationRule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
                if (!result.getUserPermissions().contains(Permission.VIEW) || !(result instanceof WebhookNotificationRule) || result.getUserPermissions().contains(Permission.MODIFY) || result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) continue;
                WebhookNotificationRule webhookNotificationRule = (WebhookNotificationRule)result;
                webhookNotificationRule.setUrl(null);
                allowedNotificationRules.add(webhookNotificationRule);
            }
            SortingUtils.sortList(allowedNotificationRules, NotificationRule::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedNotificationRules).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddEmailNotificationRule", summary="Add Email Notification Rule", description="Add a new email notification rule", responses={@ApiResponse(description="The notification rule that was added", content={@Content(schema=@Schema(implementation=EmailNotificationRule.class))}), @ApiResponse(responseCode="400", description="A notification rule with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/email")
    @POST
    @Consumes(value={"application/json"})
    public Response addEmailNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notification rule to add", schema=@Schema(implementation=EmailNotificationRuleSubmission.class)) EmailNotificationRule notificationRuleModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        notificationRuleModel.setRuleType(RuleType.EMAIL_SMTP);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        return this.addNotificationRule(user, (NotificationRule)notificationRuleModel);
    }

    @Operation(tags={"Resources"}, operationId="AddWebhookNotificationRule", summary="Add Webhook Notification Rule", description="Add a new webhook notification rule", responses={@ApiResponse(description="The notification rule that was added", content={@Content(schema=@Schema(implementation=WebhookNotificationRule.class))}), @ApiResponse(responseCode="400", description="A notification rule with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/webhook")
    @POST
    @Consumes(value={"application/json"})
    public Response addWebhookNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notification rule to add", schema=@Schema(implementation=WebhookNotificationRuleSubmission.class)) WebhookNotificationRule notificationRuleModel) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        notificationRuleModel.setRuleType(RuleType.WEBHOOK);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        return this.addNotificationRule(user, (NotificationRule)notificationRuleModel);
    }

    public Response addNotificationRule(BearerUser user, NotificationRule notificationRule) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)notificationRule);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        notificationRule.setId(UidUtils.getRandom());
        notificationRule.setDefaults();
        FormattingUtils.trimAllStrings((Object)notificationRule);
        if (notificationRule.getName() == null || notificationRule.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingNotificationRule", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (NotificationRule existingNotificationRule : this.notificationRules.values()) {
            if (!existingNotificationRule.getName().equals(notificationRule.getName())) continue;
            return ExceptionUtils.toResponse((String)"notificationRuleNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().addNotificationRule(notificationRule);
        this.notificationRules.put(notificationRule.getId(), notificationRule);
        NotificationRule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NOTIFICATION_RULE_ADDED, eventResult, user.getName());
        NotificationRule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateEmailNotificationRule", summary="Update Email Notification Rule", description="Update the email notification rule with the specified ID", responses={@ApiResponse(description="The updated notification rule", content={@Content(schema=@Schema(implementation=EmailNotificationRule.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/email/{notificationRuleId}")
    @PUT
    public Response updateEmailNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the notification rule to update") @PathParam(value="notificationRuleId") String notificationRuleId, @Parameter(description="The information to update the notification rule with", schema=@Schema(implementation=EmailNotificationRuleSubmission.class)) EmailNotificationRule notificationRule) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        return this.updateNotificationRule(user, notificationRuleId, (NotificationRule)notificationRule);
    }

    @Operation(tags={"Resources"}, operationId="UpdateWebhookNotificationRule", summary="Update Webhook Notification Rule", description="Update the Webhook Notification Rule with the specified ID", responses={@ApiResponse(description="The updated notification rule", content={@Content(schema=@Schema(implementation=WebhookNotificationRule.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/webhook/{notificationRuleId}")
    @PUT
    public Response updateWebhookNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the notification rule to update") @PathParam(value="notificationRuleId") String notificationRuleId, @Parameter(description="The information to update the notification rule with", schema=@Schema(implementation=WebhookNotificationRuleSubmission.class)) WebhookNotificationRule notificationRule) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        return this.updateNotificationRule(user, notificationRuleId, (NotificationRule)notificationRule);
    }

    @Operation(tags={"Resources"}, operationId="TestNotificationRule", summary="Test Notification Rule", description="Trigger the notification rule with the specified ID with test data", responses={@ApiResponse(description="The trigger response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{notificationRuleId}/test")
    @PUT
    public Response testNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the notification rule to test") @PathParam(value="notificationRuleId") String notificationRuleId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        resourceIdentifiers.add(new Identifier(IdentifierType.NOTIFICATION_RULE_ID, notificationRuleId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)notificationRuleId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        NotificationRule originalNotificationRule = this.notificationRules.get(notificationRuleId);
        if (originalNotificationRule == null) {
            return ExceptionUtils.toResponse((String)"invalidNotificationRuleId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        try {
            LinkedHashMap<String, String> notificationProperties = new LinkedHashMap<String, String>();
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.TestedBy"), user.getName());
            String response = this.schedulerApplication.getNotificationsHandler().testNotificationRule(originalNotificationRule, notificationProperties, user.getName());
            originalNotificationRule.getStatus().resetOkMessage(this.iu.getString("NotificationRule.NotificationSent"));
            if (response.length() > 0) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("message", response);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSentWithMessage", messages)).build();
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSent")).build();
        }
        catch (Exception e) {
            originalNotificationRule.getStatus().setError(this.iu.getFormattedString("NotificationRule.CannotSendNotification", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            LOGGER.error("Cannot send test notification", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotSendNotification", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @Operation(tags={"Resources"}, operationId="TestDraftEmailNotificationRule", summary="Test Draft Email Notification Rule", description="Trigger the specified draft notification rule with test data", responses={@ApiResponse(description="The trigger response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/email/test")
    @POST
    public Response testEmailNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notification rule to test", schema=@Schema(implementation=EmailNotificationRuleSubmission.class)) EmailNotificationRule notificationRule) {
        NotificationRule originalNotificationRule;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)notificationRule);
        }
        EmailNotificationRule originalEmailNotificationRule = null;
        if (notificationRule.getId() != null && (originalNotificationRule = this.notificationRules.get(notificationRule.getId())) instanceof EmailNotificationRule) {
            originalEmailNotificationRule = (EmailNotificationRule)originalNotificationRule;
        }
        try {
            LinkedHashMap<String, String> notificationProperties = new LinkedHashMap<String, String>();
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.TestedBy"), user.getName());
            String response = this.schedulerApplication.getNotificationsHandler().testNotificationRule((NotificationRule)notificationRule, notificationProperties, user.getName());
            if (originalEmailNotificationRule != null) {
                originalEmailNotificationRule.getStatus().resetOkMessage(this.iu.getString("NotificationRule.NotificationSent"));
            }
            if (!response.isEmpty()) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("message", response);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSentWithMessage", messages)).build();
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSent")).build();
        }
        catch (Exception e) {
            if (originalEmailNotificationRule != null) {
                originalEmailNotificationRule.getStatus().setError(this.iu.getFormattedString("NotificationRule.CannotSendNotification", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            LOGGER.error("Cannot send test notification", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotSendNotification", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @Operation(tags={"Resources"}, operationId="TestDraftWebhookNotificationRule", summary="Test Draft Webhook Notification Rule", description="Trigger the specified draft notification rule with test data", responses={@ApiResponse(description="The trigger response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/webhook/test")
    @POST
    public Response testWebhookNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The notification rule to test", schema=@Schema(implementation=WebhookNotificationRuleSubmission.class)) WebhookNotificationRule notificationRule) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)notificationRule);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        WebhookNotificationRule originalWebhookNotificationRuleModel = null;
        if (notificationRule.getId() != null) {
            originalWebhookNotificationRuleModel = (WebhookNotificationRule)this.notificationRules.get(notificationRule.getId());
        }
        try {
            LinkedHashMap<String, String> notificationProperties = new LinkedHashMap<String, String>();
            notificationProperties.put(this.iu.getString("JobResource.ModificationLabel.TestedBy"), user.getName());
            String response = this.schedulerApplication.getNotificationsHandler().testNotificationRule((NotificationRule)notificationRule, notificationProperties, user.getName());
            if (originalWebhookNotificationRuleModel != null) {
                originalWebhookNotificationRuleModel.getStatus().resetOkMessage(this.iu.getString("NotificationRule.NotificationSent"));
            }
            if (response.length() > 0) {
                HashMap<String, String> messages = new HashMap<String, String>();
                messages.put("message", response);
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSentWithMessage", messages)).build();
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationSent")).build();
        }
        catch (Exception e) {
            if (originalWebhookNotificationRuleModel != null) {
                originalWebhookNotificationRuleModel.getStatus().setError(this.iu.getFormattedString("NotificationRule.CannotSendNotification", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            LOGGER.error("Cannot send test notification", (Throwable)e);
            return ExceptionUtils.toResponse((String)"cannotSendNotification", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    public Response updateNotificationRule(BearerUser user, String notificationRuleId, NotificationRule notificationRule) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        resourceIdentifiers.add(new Identifier(IdentifierType.NOTIFICATION_RULE_ID, notificationRuleId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)notificationRule);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        NotificationRule originalNotificationRule = this.notificationRules.get(notificationRuleId);
        if (originalNotificationRule == null) {
            return ExceptionUtils.toResponse((String)"invalidNotificationRuleId", (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)notificationRule);
        if (notificationRule.getName() != null) {
            for (NotificationRule existingNotificationRule : this.notificationRules.values()) {
                if (existingNotificationRule.getId().equals(notificationRuleId) || !notificationRule.getName().equals(existingNotificationRule.getName())) continue;
                return ExceptionUtils.toResponse((String)"notificationRuleNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalNotificationRule.setName(notificationRule.getName());
        }
        if (notificationRule.getDescription() != null) {
            originalNotificationRule.setDescription(notificationRule.getDescription());
        }
        if (notificationRule.getTriggers() != null) {
            originalNotificationRule.setTriggers(notificationRule.getTriggers());
        }
        switch (originalNotificationRule.getRuleType()) {
            case EMAIL_SMTP: {
                if (!(originalNotificationRule instanceof EmailNotificationRule)) {
                    throw new IllegalArgumentException("Original notification is not of type " + String.valueOf(RuleType.EMAIL_SMTP));
                }
                if (!(notificationRule instanceof EmailNotificationRule)) {
                    throw new IllegalArgumentException("Updated notification is not of type " + String.valueOf(RuleType.EMAIL_SMTP));
                }
                EmailNotificationRule emailOriginalNotificationRule = (EmailNotificationRule)originalNotificationRule;
                EmailNotificationRule emailNotificationRule = (EmailNotificationRule)notificationRule;
                if (emailNotificationRule.getSmtpServiceId() != null) {
                    emailOriginalNotificationRule.setSmtpServiceId(emailNotificationRule.getSmtpServiceId());
                }
                if (emailNotificationRule.getCc() != null) {
                    emailOriginalNotificationRule.setCc(emailNotificationRule.getCc());
                }
                if (emailNotificationRule.getHtmlFormat() != null) {
                    emailOriginalNotificationRule.setHtmlFormat(emailNotificationRule.getHtmlFormat());
                }
                if (emailNotificationRule.getTo() != null) {
                    emailOriginalNotificationRule.setTo(emailNotificationRule.getTo());
                }
                emailOriginalNotificationRule.getStatus().reset();
                break;
            }
            case WEBHOOK: {
                if (!(originalNotificationRule instanceof WebhookNotificationRule)) {
                    throw new IllegalArgumentException("Original notification is not of type " + String.valueOf(RuleType.WEBHOOK));
                }
                if (!(notificationRule instanceof WebhookNotificationRule)) {
                    throw new IllegalArgumentException("Updated notification is not of type " + String.valueOf(RuleType.WEBHOOK));
                }
                WebhookNotificationRule webhookOriginalNotificationRule = (WebhookNotificationRule)originalNotificationRule;
                WebhookNotificationRule webhookNotificationRule = (WebhookNotificationRule)notificationRule;
                if (webhookNotificationRule.getUrl() != null) {
                    webhookOriginalNotificationRule.setUrl(webhookNotificationRule.getUrl());
                }
                if (webhookNotificationRule.getWebhookPlatform() != null) {
                    webhookOriginalNotificationRule.setWebhookPlatform(webhookNotificationRule.getWebhookPlatform());
                }
                webhookOriginalNotificationRule.getStatus().reset();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported notification rule type " + String.valueOf(originalNotificationRule.getRuleType()));
            }
        }
        this.schedulerApplication.getSchedulerConfigurationDao().updateNotificationRule(originalNotificationRule);
        NotificationRule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalNotificationRule);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NOTIFICATION_RULE_MODIFIED, eventResult, user.getName());
        NotificationRule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalNotificationRule);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, summary="Delete Notification Rule", operationId="DeleteNotificationRule", description="Delete the notification rule with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Notification Rule with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{notificationRuleId}")
    @DELETE
    public Response deleteNotificationRule(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the notification rule to delete") @PathParam(value="notificationRuleId") String notificationRuleId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)notificationRuleId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteNotificationRule(notificationRuleId);
        NotificationRule notificationRule = this.notificationRules.remove(notificationRuleId);
        NotificationRule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NOTIFICATION_RULE_DELETED, eventResult, user.getName());
        this.schedulerApplication.getExecutionProfileResource().removeNotificationRuleId(notificationRuleId);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("notificationRuleDeleted")).build();
    }
}

