/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import com.nuix.automate.utils.models.api.webhook.WebhookCall;
import com.nuix.automate.utils.models.api.webhook.WebhookEvent;
import com.nuix.automate.utils.models.api.webhook.WebhookSubmission;
import com.nuix.automate.utils.models.api.webhook.WebhookWithImplicitTriggerSubmission;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/resources/webhook")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OutgoingWebhookResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OutgoingWebhookResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, Webhook> webhookRegistrations;
    private final Map<String, List<WebhookEvent>> webhookEvents;

    public OutgoingWebhookResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.webhookRegistrations = new HashMap<String, Webhook>();
        this.webhookEvents = new HashMap<String, List<WebhookEvent>>();
    }

    public void initializeFromStore() {
        LOGGER.info("Initializing Webhooks from store");
        List<Webhook> webhooks = this.schedulerApplication.getSchedulerConfigurationDao().getWebhookRegistrations();
        for (Webhook Webhook2 : webhooks) {
            this.webhookRegistrations.put(Webhook2.getId(), Webhook2);
        }
        List<WebhookEvent> storeWebhookEvents = this.schedulerApplication.getAuditLogDao().getWebhookEvents();
        for (WebhookEvent webhookEvent : storeWebhookEvents) {
            List<WebhookEvent> eventsList = this.webhookEvents.get(webhookEvent.getWebhookId());
            if (eventsList == null) {
                eventsList = new ArrayList<WebhookEvent>();
                this.webhookEvents.put(webhookEvent.getWebhookId(), eventsList);
            }
            eventsList.add(webhookEvent);
            if (webhookEvent.getCalls() == null) continue;
            for (WebhookCall call : webhookEvent.getCalls()) {
                if (call.getResponseEpoch() != null) continue;
                call.setResponseEpoch(Long.valueOf(DateTime.now().getMillis()));
                call.setResponseStatus(502);
                call.setResponseHeaders("Exception: call reset");
                call.setResponseBody("");
                LOGGER.error("Webhook Event " + String.valueOf(webhookEvent.getTriggerType()) + " " + webhookEvent.getId() + " call #" + call.getAttemptNumber() + " reset");
            }
        }
    }

    public Webhook getWebhookRegistration(String id) {
        return this.webhookRegistrations.get(id);
    }

    public Collection<Webhook> getWebhooks() {
        return this.webhookRegistrations.values();
    }

    @Operation(tags={"Resources"}, operationId="GetWebhooks", summary="Get Webhooks", description="Get full information of all webhooks", responses={@ApiResponse(description="The list of webhooks", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Webhook.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getWebhooks(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WEBHOOKS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<Webhook> allowedWebhookRegistrations = new ArrayList<Webhook>();
            for (Webhook Webhook2 : this.getWebhooks()) {
                Webhook result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, Webhook2);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                if (!result.getUserPermissions().contains(Permission.MODIFY) && !result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
                    String callbackAddress = result.getCallbackAddress();
                    result.setCallbackAddress(FormattingUtils.anonymizeUrlPathAndParams((String)callbackAddress));
                    result.setAuditLog(null);
                } else {
                    List auditLog = result.getAuditLog();
                    auditLog.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(result.getId()));
                    auditLog.sort(Comparator.comparing(AuditEvent::getDate));
                }
                result.setSignatureKey(null);
                allowedWebhookRegistrations.add(result);
            }
            allowedWebhookRegistrations.sort(Comparator.comparing(Webhook::getName, String.CASE_INSENSITIVE_ORDER));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedWebhookRegistrations).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="GetEventTriggers", summary="Get Event Triggers", description="Get the list triggers that can be used to call webhooks", responses={@ApiResponse(description="The list of Triggers", content={@Content(schema=@Schema(ref="#/components/schemas/EventKindsTypes"))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/trigger")
    public Response getEventTriggers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WEBHOOK_TRIGGERS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            TreeMap<EventType.Kind, TreeSet<EventType.Type>> results = new TreeMap<EventType.Kind, TreeSet<EventType.Type>>();
            for (EventType.Type type : EventType.Type.values()) {
                EventType.Kind eventKind = type.getKind();
                TreeSet<EventType.Type> kind = (TreeSet<EventType.Type>)results.get(eventKind);
                if (kind == null) {
                    kind = new TreeSet<EventType.Type>();
                    results.put(eventKind, kind);
                }
                kind.add(type);
            }
            results.remove(EventType.Kind.LEGACY);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(results).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddWebhookWithTrigger", summary="Add Webhook With Trigger", description="Add a new webhook for the specified trigger event type", responses={@ApiResponse(responseCode="201", description="The Webhook that was added", content={@Content(schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="400", description="Webhook name is missing")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/utils/{triggerEventType}")
    @Consumes(value={"application/json"})
    public Response addWebhookWithTrigger(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The Webhook to add", schema=@Schema(implementation=WebhookWithImplicitTriggerSubmission.class)) Webhook webhook, @PathParam(value="triggerEventType") EventType.Type triggerEventType, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        TreeSet<EventType.Type> triggers = new TreeSet<EventType.Type>();
        triggers.add(triggerEventType);
        webhook.setTriggers(triggers);
        return this.addWebhookRegistrationInternal(user, webhook, request, uriInfo);
    }

    @Operation(tags={"Resources"}, operationId="AddWebhook", summary="Add Webhook", description="Add a new webhook with one or more triggers", responses={@ApiResponse(responseCode="201", description="The Webhook that was added", content={@Content(schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="400", description="Webhook name is missing")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addWebhook(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The Webhook to add", schema=@Schema(implementation=WebhookSubmission.class)) Webhook webhook, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        return this.addWebhookRegistrationInternal(user, webhook, request, uriInfo);
    }

    private Response addWebhookRegistrationInternal(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The Webhook to add") Webhook webhook, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        webhook.setDefaults();
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.WEBHOOKS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)webhook);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (webhook.getName() == null || webhook.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"webhookNameMissing", (Map)null);
        }
        for (Webhook existingWebhook : this.webhookRegistrations.values()) {
            if (!existingWebhook.getName().equals(webhook.getName()) || !existingWebhook.getCallbackAddress().equals(webhook.getCallbackAddress()) || existingWebhook.getTriggers() == null || webhook.getTriggers() == null || existingWebhook.getTriggers().size() != webhook.getTriggers().size()) continue;
            for (EventType.Type trigger : existingWebhook.getTriggers()) {
                if (webhook.getTriggers().contains(trigger)) continue;
            }
            if (existingWebhook.getActive().equals(false)) {
                existingWebhook.setActive(Boolean.valueOf(true));
                existingWebhook.setStatus(new Status());
                existingWebhook.getStatus().resetOkMessage("");
                StringBuilder details = new StringBuilder();
                details.append(this.iu.getFormattedString("WebhookRegistration.Details.Active", (Object)false));
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), existingWebhook.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WEBHOOK_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.storeUpdatedWebhook(existingWebhook);
                Webhook eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, existingWebhook);
                eventResult.setSignatureKey(null);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WEBHOOK_MODIFIED, eventResult, user.getName());
            }
            Webhook result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, existingWebhook);
            result.setSignatureKey(null);
            return Response.status((Response.Status)Response.Status.CREATED).type(MediaType.APPLICATION_JSON_TYPE).header("Location", (Object)(ResourceUtils.getBaseUriPath((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/scheduler/resources/webhook/soft/" + result.getId())).entity((Object)result).build();
        }
        webhook.setId(UidUtils.getRandom());
        webhook.setStatus(new Status());
        webhook.getStatus().resetOkMessage("");
        webhook.setSignatureKey(SecurityUtils.getSecureRandomSecret());
        this.normalizeTriggers(webhook);
        this.schedulerApplication.getSchedulerConfigurationDao().addWebhookRegistration(webhook);
        this.webhookRegistrations.put(webhook.getId(), webhook);
        Webhook eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhook);
        eventResult.setSignatureKey(null);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WEBHOOK_ADDED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOKS, "");
        Webhook result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhook);
        StringBuilder details = new StringBuilder();
        if (result.getName() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Name", (Object)result.getName()));
        }
        if (result.getActive() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Active", (Object)result.getActive()));
        }
        if (result.getTriggers() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Triggers", (Object)this.triggersToString(result.getTriggers())));
        }
        if (result.getCallbackAddress() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.CallbackAddress", (Object)result.getCallbackAddress()));
        }
        if (result.getHistoryEnabled() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.HistoryEnabled", (Object)result.getHistoryEnabled()));
        }
        if (result.getWhitelistedCertFingerprints() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.WhitelistedCertFingerprints", (Object)String.join((CharSequence)", ", result.getWhitelistedCertFingerprints())));
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), result.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WEBHOOK_ADDED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        return Response.status((Response.Status)Response.Status.CREATED).type(MediaType.APPLICATION_JSON_TYPE).header("Location", (Object)(ResourceUtils.getBaseUriPath((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/scheduler/resources/webhook/soft/" + result.getId())).entity((Object)result).build();
    }

    private void normalizeTriggers(Webhook registrationModel) {
        SortedSet triggers = registrationModel.getTriggers();
        TreeSet<EventType.Type> allowedTriggers = new TreeSet<EventType.Type>();
        if (triggers != null) {
            for (EventType.Type trigger : triggers) {
                if (trigger.getKind().equals((Object)EventType.Kind.LEGACY)) continue;
                allowedTriggers.add(trigger);
            }
        }
        registrationModel.setTriggers(allowedTriggers);
    }

    @Operation(tags={"Resources"}, operationId="UpdateWebhook", summary="Update Webhook", description="Update the webhook with the specified ID", responses={@ApiResponse(description="The updated Webhook", content={@Content(schema=@Schema(implementation=Webhook.class))}), @ApiResponse(responseCode="400", description="Webhook name is missing")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{webhookId}")
    @PUT
    public Response updateWebhook(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the webhook to update") @PathParam(value="webhookId") String webhookId, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The information to update the webhook with", schema=@Schema(implementation=WebhookSubmission.class)) Webhook webhookRegistration) {
        Webhook originalWebhook = this.webhookRegistrations.get(webhookId);
        if (originalWebhook == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindWebhook", (Map)new HashMap<String, String>(){
                {
                    this.put("webhookId", webhookId);
                }
            })).build();
        }
        webhookRegistration.setId(webhookId);
        Webhook result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhookRegistration);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)webhookId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (webhookRegistration.getName() == null) {
            webhookRegistration.setName(originalWebhook.getName());
        }
        if (webhookRegistration.getActive() == null) {
            webhookRegistration.setActive(originalWebhook.getActive());
        } else if (!originalWebhook.getActive().booleanValue() && webhookRegistration.getActive().booleanValue()) {
            webhookRegistration.setStatus(new Status());
            webhookRegistration.getStatus().resetOkMessage("");
        } else {
            webhookRegistration.setStatus(originalWebhook.getStatus());
        }
        if (webhookRegistration.getTriggers() == null) {
            webhookRegistration.setTriggers(originalWebhook.getTriggers());
        }
        if (webhookRegistration.getCallbackAddress() == null) {
            webhookRegistration.setCallbackAddress(originalWebhook.getCallbackAddress());
        }
        if (webhookRegistration.getHistoryEnabled() == null) {
            webhookRegistration.setHistoryEnabled(originalWebhook.getHistoryEnabled());
        }
        if (webhookRegistration.getWhitelistedCertFingerprints() == null) {
            webhookRegistration.setWhitelistedCertFingerprints(originalWebhook.getWhitelistedCertFingerprints());
        }
        if (webhookRegistration.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"webhookNameMissing", (Map)null);
        }
        webhookRegistration.setSignatureKey(originalWebhook.getSignatureKey());
        this.normalizeTriggers(webhookRegistration);
        this.storeUpdatedWebhook(webhookRegistration);
        Webhook eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhookRegistration);
        eventResult.setSignatureKey(null);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WEBHOOK_MODIFIED, eventResult, user.getName());
        if (!webhookRegistration.getHistoryEnabled().booleanValue() && originalWebhook.getHistoryEnabled().booleanValue()) {
            LOGGER.info(webhookRegistration.toString() + " deleting past stored events");
            List<WebhookEvent> events = this.webhookEvents.remove(webhookId);
            this.schedulerApplication.getAuditLogDao().deleteWebhookEvents(webhookId);
        }
        StringBuilder details = new StringBuilder();
        if (webhookRegistration.getName() != null && !webhookRegistration.getName().equals(originalWebhook.getName())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Name", (Object)webhookRegistration.getName()));
        }
        if (webhookRegistration.getActive() != null && !webhookRegistration.getActive().equals(originalWebhook.getActive())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Active", (Object)webhookRegistration.getActive()));
        }
        if (webhookRegistration.getTriggers() != null && !this.triggersToString(webhookRegistration.getTriggers()).equals(this.triggersToString(originalWebhook.getTriggers()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Triggers", (Object)this.triggersToString(webhookRegistration.getTriggers())));
        }
        if (webhookRegistration.getCallbackAddress() != null && !webhookRegistration.getCallbackAddress().equals(originalWebhook.getCallbackAddress())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.CallbackAddress", (Object)webhookRegistration.getCallbackAddress()));
        }
        if (webhookRegistration.getHistoryEnabled() != null && !webhookRegistration.getHistoryEnabled().equals(originalWebhook.getHistoryEnabled())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.HistoryEnabled", (Object)webhookRegistration.getHistoryEnabled()));
        }
        String textWhitelistedCertFingerprints = "";
        if (webhookRegistration.getWhitelistedCertFingerprints() != null) {
            textWhitelistedCertFingerprints = String.join((CharSequence)", ", webhookRegistration.getWhitelistedCertFingerprints());
        }
        String originalTextWhitelistedCertFingerprints = "";
        if (originalWebhook.getWhitelistedCertFingerprints() != null) {
            originalTextWhitelistedCertFingerprints = String.join((CharSequence)", ", originalWebhook.getWhitelistedCertFingerprints());
        }
        if (!textWhitelistedCertFingerprints.equals(originalTextWhitelistedCertFingerprints)) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.WhitelistedCertFingerprints", (Object)textWhitelistedCertFingerprints));
        }
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), webhookId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WEBHOOK_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhookRegistration);
        result.setSignatureKey(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void storeUpdatedWebhook(Webhook webhookRegistration) {
        this.webhookRegistrations.put(webhookRegistration.getId(), webhookRegistration);
        this.schedulerApplication.getSchedulerConfigurationDao().updateWebhookRegistration(webhookRegistration);
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOKS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOK, webhookRegistration.getId());
    }

    private String triggersToString(Set<EventType.Type> triggers) {
        StringBuilder result = new StringBuilder();
        if (triggers != null) {
            ArrayList<EventType.Type> sortedTriggers = new ArrayList<EventType.Type>(triggers);
            sortedTriggers.sort(Comparator.comparing(Objects::toString));
            for (EventType.Type trigger : sortedTriggers) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                result.append(trigger.toString());
            }
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Resources"}, operationId="DeleteWebhook", summary="Delete Webhook", description="Delete the webhook with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Webhook with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{webhookId}")
    @DELETE
    public Response deleteWebhook(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="webhookId") String webhookId) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
            Webhook originalWebhook = this.getWebhookRegistration(webhookId);
            if (originalWebhook == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWebhookRegistration", (Map)new HashMap<String, String>(){
                    {
                        this.put("webhookRegistrationId", webhookId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            Set webhookPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWebhook).getUserPermissions();
            if (!webhookPermissions.contains(Permission.MODIFY)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)webhookId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().deleteWebhookRegistration(webhookId);
            this.webhookRegistrations.remove(webhookId);
            Webhook eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWebhook);
            eventResult.setSignatureKey(null);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WEBHOOK_DELETED, eventResult, user.getName());
            this.schedulerApplication.getAuditLogDao().deleteWebhookEvents(webhookId);
            this.webhookEvents.remove(webhookId);
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), webhookId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WEBHOOK_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOKS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOK, webhookId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/soft/{webhookId}")
    @DELETE
    public Response softDeleteWebhook(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="webhookId") String webhookId) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
            Webhook originalWebhook = this.getWebhookRegistration(webhookId);
            if (originalWebhook == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWebhookRegistration", (Map)new HashMap<String, String>(){
                    {
                        this.put("webhookRegistrationId", webhookId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            Set webhookPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWebhook).getUserPermissions();
            if (!webhookPermissions.contains(Permission.MODIFY)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)webhookId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (!originalWebhook.getActive().booleanValue()) {
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            originalWebhook.setActive(Boolean.valueOf(false));
            StringBuilder details = new StringBuilder();
            details.append(this.iu.getFormattedString("WebhookRegistration.Details.Active", (Object)false));
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), webhookId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.WEBHOOK_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.storeUpdatedWebhook(originalWebhook);
            Webhook eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWebhook);
            eventResult.setSignatureKey(null);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.WEBHOOK_MODIFIED, eventResult, user.getName());
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOKS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOK, webhookId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public Map<String, List<WebhookEvent>> getWebhookEvents() {
        return this.webhookEvents;
    }

    @Operation(tags={"Resources"}, operationId="GetWebhookEvents", summary="Get Webhook Events", description="Get full information of all past webhooks events, if the webhook history is enabled", responses={@ApiResponse(description="The list of webhook events", content={@Content(array=@ArraySchema(schema=@Schema(implementation=WebhookEvent.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{webhookId}/event")
    @GET
    public Response getWebhookEvents(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="webhookId") String webhookId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.WEBHOOK, webhookId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Webhook originalWebhook = this.getWebhookRegistration(webhookId);
            if (originalWebhook == null) {
                return ExceptionUtils.toResponse((String)"cannotFindWebhookRegistration", (Map)new HashMap<String, String>(){
                    {
                        this.put("webhookRegistrationId", webhookId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            Set webhookPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalWebhook).getUserPermissions();
            if (!webhookPermissions.contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)webhookId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            ArrayList<WebhookEvent> allowedWebhookEvents = new ArrayList<WebhookEvent>();
            for (WebhookEvent webhookEvent : this.schedulerApplication.getAuditLogDao().getWebhookEvents(webhookId)) {
                WebhookEvent copiedWebhookEvent = webhookEvent.clone();
                if (!webhookPermissions.contains(Permission.VIEW_SENSITIVE)) {
                    for (WebhookCall call : copiedWebhookEvent.getCalls()) {
                        copiedWebhookEvent.setBody(null);
                        call.setResponseBody(null);
                    }
                }
                allowedWebhookEvents.add(copiedWebhookEvent);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedWebhookEvents).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebhookEvent(String webhookId, WebhookEvent event) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            Webhook webhook = this.webhookRegistrations.get(webhookId);
            if (webhook != null) {
                List<WebhookEvent> events = this.webhookEvents.get(webhookId);
                if (events == null) {
                    events = new ArrayList<WebhookEvent>();
                    this.webhookEvents.put(webhookId, events);
                }
                events.add(event);
                if (webhook.getHistoryEnabled().booleanValue()) {
                    this.schedulerApplication.getAuditLogDao().addWebhookEvent(event);
                }
                while (events.size() > this.schedulerApplication.getConfiguration().getMaxWebhookEventsHistoryCount()) {
                    WebhookEvent eventToRemove = events.remove(0);
                    this.schedulerApplication.getAuditLogDao().deleteWebhookEvent(eventToRemove.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWebhookErrors(String webhookId) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            Webhook webhook = this.webhookRegistrations.get(webhookId);
            if (webhook != null) {
                webhook.setStatus(new Status());
                webhook.getStatus().reset();
                this.storeUpdatedWebhook(webhook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebhookWarning(String webhookId) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            Webhook webhook = this.webhookRegistrations.get(webhookId);
            if (webhook != null) {
                if (webhook.getStatus() == null) {
                    webhook.setStatus(new Status());
                }
                webhook.getStatus().reset();
                webhook.getStatus().setWarningMessage(this.iu.getString("WebhookRegistration.Warning.LastCallbackWarning"));
                this.storeUpdatedWebhook(webhook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistWebhookEvent(WebhookEvent event) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            Webhook webhook = this.webhookRegistrations.get(event.getWebhookId());
            if (webhook != null) {
                if (webhook.getHistoryEnabled().booleanValue()) {
                    this.schedulerApplication.getAuditLogDao().updateWebhookEvent(event);
                }
                ResponseCache.getInstance().resetKeyId(CacheKey.WEBHOOK, event.getWebhookId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failWebhook(String webhookId) {
        Map<String, Webhook> map = this.webhookRegistrations;
        synchronized (map) {
            Webhook webhook = this.webhookRegistrations.get(webhookId);
            if (webhook != null) {
                if (!webhook.getActive().booleanValue()) {
                    LOGGER.info(String.valueOf(webhook) + " is already disabled");
                    return;
                }
                webhook.setActive(Boolean.valueOf(false));
                if (webhook.getStatus() == null) {
                    webhook.setStatus(new Status());
                }
                webhook.getStatus().setError(this.iu.getString("WebhookRegistration.Error.DisabledForCallbackErrors"));
                StringBuilder details = new StringBuilder();
                details.append(this.iu.getFormattedString("WebhookRegistration.Details.Active", (Object)false));
                if (details.length() > 0) {
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), webhookId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.WEBHOOK_MODIFIED, details.toString(), "N/A"));
                }
                this.storeUpdatedWebhook(webhook);
            }
        }
    }
}

