/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JavaUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.notificationrule.EmailNotificationRule;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailCounter;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.webhook.Webhook;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/scheduler/resources/status")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class StatusResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(StatusResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;

    public StatusResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    @Operation(tags={"Resources"}, operationId="ResourcesStatus", summary="Resources Status", description="Get the statuses of all the resources", responses={@ApiResponse(description="The resources status", content={@Content(schema=@Schema(ref="#/components/schemas/ResourcesStatus"))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getResourcesStatus(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        Set permissions;
        HashMap resourceToStatuses = new HashMap();
        HashMap<String, Status> rampivaLicenseToStatus = new HashMap<String, Status>();
        AutomateLicenceModel rampivaLicense = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence();
        if (rampivaLicense != null && rampivaLicense.getStatus() != null && (permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, rampivaLicense).getUserPermissions()).contains(Permission.VIEW)) {
            rampivaLicenseToStatus.put(rampivaLicense.getId(), rampivaLicense.getStatus());
        }
        if (rampivaLicenseToStatus.size() > 0) {
            resourceToStatuses.put("automateLicense", rampivaLicenseToStatus);
        }
        try {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
            HashMap<CallSite, Status> authenticationServiceToStatus = new HashMap<CallSite, Status>();
            for (UserService userService : this.schedulerApplication.getUserServiceResource().getUserServices()) {
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    authenticationServiceToStatus.put((CallSite)((Object)(userService.getId() + ":status")), userService.getStatus().cloneLimited());
                    authenticationServiceToStatus.put((CallSite)((Object)(userService.getId() + ":warningStatus")), userService.getWarningStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                authenticationServiceToStatus.put((CallSite)((Object)(userService.getId() + ":status")), userService.getStatus());
                authenticationServiceToStatus.put((CallSite)((Object)(userService.getId() + ":warningStatus")), userService.getWarningStatus());
            }
            if (authenticationServiceToStatus.size() > 0) {
                resourceToStatuses.put("authenticationServices", authenticationServiceToStatus);
            }
            HashMap<String, Status> nuixLicenseSourceToStatus = new HashMap<String, Status>();
            for (NuixLicenseSourceModel nuixLicenseSourceModel : this.schedulerApplication.getNuixLicenceSourceResource().getNuixLicenceSources()) {
                if (nuixLicenseSourceModel.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, nuixLicenseSourceModel).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    nuixLicenseSourceToStatus.put(nuixLicenseSourceModel.getId(), nuixLicenseSourceModel.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                nuixLicenseSourceToStatus.put(nuixLicenseSourceModel.getId(), nuixLicenseSourceModel.getStatus());
            }
            if (nuixLicenseSourceToStatus.size() > 0) {
                resourceToStatuses.put("nuixLicenseSources", nuixLicenseSourceToStatus);
            }
            HashMap hashMap = new HashMap();
            for (ServerWorker serverWorker : this.schedulerApplication.getServerResource().getServerWorkers().values()) {
                Server server = serverWorker.getModel();
                if (server == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, server).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    if (server.getError() != null && server.getError().trim().length() > 0) {
                        hashMap2.put("error", FormattingUtils.constantToCamelCaseFirstUpper((String)("ERROR Code " + SecurityUtils.computeShortSha256Hex((String)("Status message" + server.getError())))));
                    }
                    hashMap2.put("code", server.getStatus().toString());
                    hashMap2.put("maintenance", server.getMaintenanceStatus().toString());
                    hashMap.put(server.getId(), hashMap2);
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                if (server.getError() != null && server.getError().trim().length() > 0) {
                    hashMap3.put("error", server.getError());
                }
                hashMap3.put("code", server.getStatus().toString());
                hashMap3.put("maintenance", server.getMaintenanceStatus().toString());
                hashMap.put(server.getId(), hashMap3);
            }
            if (hashMap.size() > 0) {
                resourceToStatuses.put("engineServers", hashMap);
            }
            HashMap hashMap4 = new HashMap();
            for (EngineModel engineModel : this.schedulerApplication.getSchedulerEnginesResource().getEngines()) {
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, engineModel).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    HashMap<String, String> hashMap5 = new HashMap<String, String>();
                    if (engineModel.getError() != null && engineModel.getError().trim().length() > 0) {
                        hashMap5.put("error", FormattingUtils.constantToCamelCaseFirstUpper((String)("ERROR Code " + SecurityUtils.computeShortSha256Hex((String)("Status message" + engineModel.getError())))));
                    }
                    hashMap5.put("code", engineModel.getStatus().toString());
                    hashMap4.put(engineModel.getId(), hashMap5);
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                HashMap<String, String> hashMap6 = new HashMap<String, String>();
                if (engineModel.getError() != null && engineModel.getError().trim().length() > 0) {
                    hashMap6.put("error", engineModel.getError());
                }
                hashMap6.put("code", engineModel.getStatus().toString());
                hashMap4.put(engineModel.getId(), hashMap6);
            }
            if (hashMap4.size() > 0) {
                resourceToStatuses.put("engines", hashMap4);
            }
            HashMap<String, Status> hashMap7 = new HashMap<String, Status>();
            for (ResourcePoolModel resourcePoolModel : this.schedulerApplication.getResourcePoolResource().getResourcePools()) {
                if (resourcePoolModel.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePoolModel).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap7.put(resourcePoolModel.getId(), resourcePoolModel.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap7.put(resourcePoolModel.getId(), resourcePoolModel.getStatus());
            }
            if (hashMap7.size() > 0) {
                resourceToStatuses.put("resourcePools", hashMap7);
            }
            HashMap<String, Status> hashMap8 = new HashMap<String, Status>();
            for (ExecutionProfileModel executionProfileModel : this.schedulerApplication.getExecutionProfileResource().getExecutionProfiles()) {
                if (executionProfileModel.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfileModel).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap8.put(executionProfileModel.getId(), executionProfileModel.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap8.put(executionProfileModel.getId(), executionProfileModel.getStatus());
            }
            if (hashMap8.size() > 0) {
                resourceToStatuses.put("executionProfiles", hashMap8);
            }
            HashMap<String, Status> hashMap9 = new HashMap<String, Status>();
            for (ClientPool clientPool : this.schedulerApplication.getClientPoolResource().getClientPools()) {
                if (clientPool.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clientPool).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap9.put(clientPool.getId(), clientPool.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap9.put(clientPool.getId(), clientPool.getStatus());
            }
            if (hashMap9.size() > 0) {
                resourceToStatuses.put("clientPools", hashMap9);
            }
            HashMap<String, Status> hashMap10 = new HashMap<String, Status>();
            for (Client client : this.schedulerApplication.getClientResource().getClients()) {
                if (client.getStatus() != null) {
                    Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions();
                    if (set.contains(Permission.VIEW_LIMITED)) {
                        hashMap10.put(client.getId(), client.getStatus().cloneLimited());
                    } else if (set.contains(Permission.VIEW)) {
                        hashMap10.put(client.getId(), client.getStatus());
                    }
                }
                for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(client.getId())) {
                    if (matter.getStatus().getCode() != State.ERROR) continue;
                    Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions();
                    if (set.contains(Permission.VIEW_LIMITED)) {
                        hashMap10.put(client.getId(), matter.getStatus().cloneLimited());
                        continue;
                    }
                    if (!set.contains(Permission.VIEW)) continue;
                    hashMap10.put(client.getId(), matter.getStatus());
                }
            }
            if (hashMap10.size() > 0) {
                resourceToStatuses.put("clients", hashMap10);
            }
            HashMap<CallSite, Status> hashMap11 = new HashMap<CallSite, Status>();
            for (NotificationRule notificationRule : this.schedulerApplication.getNotificationRuleResource().getNotificationRules()) {
                SmtpEmailCounter smtpEmailCounter;
                NotificationRule notificationRule2 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule);
                Set set = notificationRule2.getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap11.put((CallSite)((Object)(notificationRule.getId() + ":status")), notificationRule.getStatus().cloneLimited());
                } else if (set.contains(Permission.VIEW)) {
                    hashMap11.put((CallSite)((Object)(notificationRule.getId() + ":status")), notificationRule.getStatus());
                }
                if (!(notificationRule instanceof EmailNotificationRule) || (smtpEmailCounter = ((EmailNotificationRule)notificationRule2).getEmailCounter()) == null) continue;
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap11.put((CallSite)((Object)(notificationRule.getId() + ":emailStatus")), smtpEmailCounter.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap11.put((CallSite)((Object)(notificationRule.getId() + ":emailStatus")), smtpEmailCounter.getStatus());
            }
            if (hashMap11.size() > 0) {
                resourceToStatuses.put("notificationRules", hashMap11);
            }
            HashMap<String, Status> hashMap12 = new HashMap<String, Status>();
            for (DataRepository dataRepository : this.schedulerApplication.getDataRepositoryResource().getDataRepositories()) {
                if (dataRepository.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap12.put(dataRepository.getId(), dataRepository.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap12.put(dataRepository.getId(), dataRepository.getStatus());
            }
            if (hashMap12.size() > 0) {
                resourceToStatuses.put("dataRepositories", hashMap12);
            }
            HashMap<String, Status> hashMap13 = new HashMap<String, Status>();
            for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
                ThirdPartyServiceSession<?, ?> session;
                ThirdPartyService thirdPartyService2 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService);
                Set set = thirdPartyService2.getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    try {
                        session = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService2.getId(), user.getId());
                        hashMap13.put(thirdPartyService2.getId(), session.getStatus().cloneLimited());
                    }
                    catch (IOException e) {
                        Status status2 = new Status();
                        status2.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                        hashMap13.put(thirdPartyService2.getId(), status2);
                    }
                    continue;
                }
                if (!set.contains(Permission.VIEW) || !set.contains(Permission.SUBMIT_JOB) && !set.contains(Permission.STAGE_JOB)) continue;
                try {
                    session = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService2.getId(), user.getId());
                    hashMap13.put(thirdPartyService2.getId(), session.getStatus());
                }
                catch (IOException e) {
                    Status status = new Status();
                    status.setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    hashMap13.put(thirdPartyService2.getId(), status);
                }
            }
            if (!hashMap13.isEmpty()) {
                resourceToStatuses.put("thirdPartyServices", hashMap13);
            }
            HashMap<String, Status> hashMap14 = new HashMap<String, Status>();
            for (ApiKeyWithSecret apiKeyWithSecret : this.schedulerApplication.getApiKeyResource().getApiKeys()) {
                if (apiKeyWithSecret.getStatus() == null) continue;
                Set set = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, apiKeyWithSecret).getUserPermissions();
                if (set.contains(Permission.VIEW_LIMITED)) {
                    hashMap14.put(apiKeyWithSecret.getId(), apiKeyWithSecret.getStatus().cloneLimited());
                    continue;
                }
                if (!set.contains(Permission.VIEW)) continue;
                hashMap14.put(apiKeyWithSecret.getId(), apiKeyWithSecret.getStatus());
            }
            if (hashMap14.size() > 0) {
                resourceToStatuses.put("apiKeys", hashMap14);
            }
            HashMap<String, Status> hashMap15 = new HashMap<String, Status>();
            for (Webhook webhook : this.schedulerApplication.getWebhookResource().getWebhooks()) {
                if (webhook.getStatus() == null) continue;
                Set permissions11 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, webhook).getUserPermissions();
                if (permissions11.contains(Permission.VIEW_LIMITED)) {
                    hashMap15.put(webhook.getId(), webhook.getStatus().cloneLimited());
                    continue;
                }
                if (!permissions11.contains(Permission.VIEW)) continue;
                hashMap15.put(webhook.getId(), webhook.getStatus());
            }
            if (hashMap15.size() > 0) {
                resourceToStatuses.put("webhooks", hashMap15);
            }
            HashMap<String, Status> hashMap16 = new HashMap<String, Status>();
            for (SecurityPolicy securityPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
                Set permissions12;
                if (!securityPolicy.isHasWarnings() || securityPolicy.getEnabled() == null || !securityPolicy.getEnabled().booleanValue() || (permissions12 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy).getUserPermissions()).contains(Permission.VIEW_LIMITED) || !permissions12.contains(Permission.VIEW)) continue;
                Status securityPolicyStatus = new Status();
                securityPolicyStatus.setCode(State.WARNING);
                hashMap16.put(securityPolicy.getId(), securityPolicyStatus);
            }
            if (hashMap16.size() > 0) {
                resourceToStatuses.put("policies", hashMap16);
            }
            HashMap<String, Status> hashMap17 = new HashMap<String, Status>();
            boolean canViewSensitiveJob = this.schedulerApplication.getUserResource().getUserFeatures(user).contains(ApplicationFeatures.VIEW_SENSITIVE_JOB);
            Boolean showWorkflowOptions = this.schedulerApplication.getUserSettingsResource().getUserCategorySetting(user.getName(), "workflowOption", "showWorkflowOptions", Boolean.class);
            if (showWorkflowOptions != null && !canViewSensitiveJob && showWorkflowOptions.booleanValue()) {
                Status systemResourceStatus = new Status();
                systemResourceStatus.setCode(State.WARNING);
                hashMap17.put("workflowOption", systemResourceStatus);
            }
            if (hashMap17.size() > 0) {
                resourceToStatuses.put("userSettings", hashMap17);
            }
            HashMap<String, Status> systemResourcesToStatus = new HashMap<String, Status>();
            if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES), Permission.VIEW)) {
                if (JavaUtils.isVersionBelowRecommended()) {
                    Status systemResourceStatus = new Status();
                    systemResourceStatus.setCode(State.WARNING);
                    systemResourcesToStatus.put("javaVersionBelowRecommended", systemResourceStatus);
                }
                if (systemResourcesToStatus.size() > 0) {
                    resourceToStatuses.put("systemResources", systemResourcesToStatus);
                }
            }
            HashMap<String, Status> scheduleToStatus = new HashMap<String, Status>();
            for (Schedule schedule : this.schedulerApplication.getScheduleResource().getSchedules()) {
                if (schedule.getStatus() == null) continue;
                Set permissions13 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule).getUserPermissions();
                if (permissions13.contains(Permission.VIEW_LIMITED)) {
                    scheduleToStatus.put(schedule.getId(), schedule.getStatus().cloneLimited());
                    continue;
                }
                if (!permissions13.contains(Permission.VIEW)) continue;
                scheduleToStatus.put(schedule.getId(), schedule.getStatus());
            }
            if (scheduleToStatus.size() > 0) {
                resourceToStatuses.put("scheduleJobs", scheduleToStatus);
            }
            HashMap<CallSite, Status> legalHoldsToStatus = new HashMap<CallSite, Status>();
            for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
                LegalHold result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                Set permissions14 = result.getUserPermissions();
                if (permissions14.contains(Permission.VIEW_LIMITED)) {
                    legalHoldsToStatus.put((CallSite)((Object)(legalHold.getId() + ":status")), legalHold.getStatus().cloneLimited());
                    if (result.getEmailCounter() == null) continue;
                    legalHoldsToStatus.put((CallSite)((Object)(legalHold.getId() + ":emailStatus")), result.getEmailCounter().getStatus().cloneLimited());
                    continue;
                }
                if (!permissions14.contains(Permission.VIEW)) continue;
                legalHoldsToStatus.put((CallSite)((Object)(legalHold.getId() + ":status")), legalHold.getStatus());
                if (result.getEmailCounter() == null) continue;
                legalHoldsToStatus.put((CallSite)((Object)(legalHold.getId() + ":emailStatus")), result.getEmailCounter().getStatus());
            }
            if (legalHoldsToStatus.size() > 0) {
                resourceToStatuses.put("legalHolds", legalHoldsToStatus);
            }
        }
        catch (LicenceValidationException authenticationServiceToStatus) {
            // empty catch block
        }
        String lastHash = ResponseCache.getInstance().hashObject(resourceToStatuses);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(resourceToStatuses).build();
        }
    }
}

