/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.base.CaseFormat;
import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.OidcBearerUser;
import com.nuix.automate.scheduler.security.oidc.google.GoogleOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftBearerUser;
import com.nuix.automate.scheduler.security.thirdparty.DerbyControlServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.DiscoverServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.EccServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ElasticsearchServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.GenAiServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.GraphServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.InvestigateServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.LinkServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.NlpServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.PurviewServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.RelativityServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.SemanticServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.SmtpServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.VaultServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.VeritoneServiceSession;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.thirdparty.ActionRequest;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.DerbyControlService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.EccService;
import com.nuix.automate.utils.models.api.thirdparty.EccUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ElasticsearchService;
import com.nuix.automate.utils.models.api.thirdparty.ElasticsearchUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.GenAiService;
import com.nuix.automate.utils.models.api.thirdparty.GenAiUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.GraphService;
import com.nuix.automate.utils.models.api.thirdparty.GraphUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ImportedObjectsParseResult;
import com.nuix.automate.utils.models.api.thirdparty.InvestigateService;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.LinkService;
import com.nuix.automate.utils.models.api.thirdparty.NlpService;
import com.nuix.automate.utils.models.api.thirdparty.NlpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.PurviewDownloadUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.PurviewService;
import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.SemanticService;
import com.nuix.automate.utils.models.api.thirdparty.SmtpService;
import com.nuix.automate.utils.models.api.thirdparty.SmtpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyDetails;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.UserCredentialAction;
import com.nuix.automate.utils.models.api.thirdparty.VaultService;
import com.nuix.automate.utils.models.api.thirdparty.VaultUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneService;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneUserCredential;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.internal.cache.CachedObject;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.ecc.EccProfileModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.smtp.SmtpServerModel;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/resources/thirdPartyService")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ThirdPartyServiceResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyServiceResource.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, ThirdPartyService> thirdPartyServices;
    private final CachedObjectMap<ThirdPartyServiceSession<?, ?>> sessionCache;
    private final CachedObjectMap<ThirdPartyUserCredential> userCredentialCache;

    public ThirdPartyServiceResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.thirdPartyServices = new ConcurrentHashMap<String, ThirdPartyService>();
        long cacheLifeTimeSeconds = schedulerApplication.getConfiguration().getThirdPartyServiceUserCredentialCacheLifeTimeSeconds();
        this.sessionCache = new CachedObjectMap(cacheLifeTimeSeconds * 1000L, Integer.valueOf(1024));
        this.userCredentialCache = new CachedObjectMap(cacheLifeTimeSeconds * 1000L, Integer.valueOf(1024));
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(this::clearExpiredThirdPartyServiceSessions, cacheLifeTimeSeconds, 120L, TimeUnit.SECONDS);
        this.migrateOldRelativityServices();
        this.migrateOldEccProfiles();
        this.migrateSmtpServers();
        this.initializeThirdPartyServicesFromStore();
        this.initializeThirdPartyServicesFromConfiguration();
        this.migrateMicrosoftUserServices();
        this.initializeSmtpServiceEmailReattemptTask();
        this.initializeUserCredentialRefreshWorker();
    }

    public void submitEmails(Collection<SmtpEmail> smtpEmails) {
        smtpEmails.forEach(this::submitEmail);
    }

    public Future<SmtpEmail> submitEmail(String smtpServiceId, SmtpEmail smtpEmail) {
        smtpEmail.setSmtpServerId(smtpServiceId);
        return this.submitEmail(smtpEmail);
    }

    public Future<SmtpEmail> submitEmail(SmtpEmail smtpEmail) {
        String userId = smtpEmail.getSubmittedUserId() != null ? smtpEmail.getSubmittedUserId() : SmtpServiceSession.SYSTEM_USER_ID;
        SmtpServiceSession smtpServiceSession = (SmtpServiceSession)this.getThirdPartyServiceSessionOrNull(smtpEmail.getSmtpServerId(), userId, true);
        if (smtpServiceSession != null) {
            return smtpServiceSession.submitEmail(smtpEmail);
        }
        String errorMessage = iu.getFormattedString("SmtpServiceSession.Error.CouldNotSubmitSmtpEmailDidNotFindSmtpServiceSession", new Object[]{smtpEmail.getSmtpServerId(), userId});
        LOGGER.error(errorMessage);
        smtpEmail.getStatus().setError(errorMessage);
        smtpEmail.setState(EmailState.ERROR);
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateSmtpEmail(smtpEmail) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
        }
        return CompletableFuture.completedFuture(smtpEmail);
    }

    public ThirdPartyServiceSession<?, ?> getThirdPartyServiceSessionOrNull(String thirdPartyServiceId, String userId, boolean initializeSession) {
        try {
            ThirdPartyService thirdPartyService = this.getThirdPartyService(thirdPartyServiceId);
            if (thirdPartyService == null) {
                return null;
            }
            return this.getThirdPartyServiceSession(thirdPartyServiceId, userId, initializeSession);
        }
        catch (IOException e) {
            LOGGER.error("Error getting third-party service session", (Throwable)e);
            return null;
        }
    }

    public ThirdPartyServiceSession<?, ?> getThirdPartyServiceSession(String thirdPartyServiceId, String userId) throws IOException {
        return this.getThirdPartyServiceSession(thirdPartyServiceId, userId, false);
    }

    public synchronized ThirdPartyServiceSession<?, ?> getThirdPartyServiceSession(String thirdPartyServiceId, String userId, boolean initializeSession) throws IOException {
        ThirdPartyService thirdPartyService = this.getThirdPartyService(thirdPartyServiceId);
        String userCredentialId = ThirdPartyUserCredential.getId((ThirdPartyService)thirdPartyService, (String)userId);
        String sessionId = ThirdPartyServiceSession.getId(thirdPartyService, userId);
        ThirdPartyServiceSession<?, ?> session = (ThirdPartyServiceSession<?, ?>)this.sessionCache.get(sessionId, true);
        if (session == null) {
            ThirdPartyUserCredential userCredential = (ThirdPartyUserCredential)this.userCredentialCache.get(userCredentialId, true);
            if (userCredential == null) {
                try {
                    userCredential = this.schedulerApplication.getSchedulerConfigurationDao().getThirdPartyUserCredential(userCredentialId);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse third-party credential", (Throwable)e);
                }
                if (userCredential == null) {
                    userCredential = thirdPartyService.initializeDefaultUserCredential();
                    userCredential.setId(userCredentialId);
                }
                this.userCredentialCache.put(userCredentialId, (Object)userCredential);
            }
            session = this.createSession(userId, thirdPartyService, userCredential);
            this.sessionCache.put(sessionId, session);
            if (thirdPartyService.getEnabled().booleanValue() && session.getSignedIn()) {
                ThirdPartyServiceSession<?, ?> finalSession = session;
                Thread testSessionThread = new Thread(() -> {
                    try {
                        this.testSession(finalSession);
                    }
                    catch (ResponseException e) {
                        LOGGER.warn("Cannot test newly created third-party session", (Throwable)e);
                    }
                });
                testSessionThread.setName("Test user " + userId + " third-party session, service " + thirdPartyServiceId);
                testSessionThread.start();
                if (initializeSession) {
                    try {
                        testSessionThread.join(SchedulerApplication.getInstance().getConfiguration().getThirdPartyServiceInitializeTimeoutMs());
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Sleep interrupted", (Throwable)e);
                    }
                }
            }
        } else {
            this.userCredentialCache.resetExpiry(userCredentialId);
        }
        if (initializeSession) {
            ThirdPartyServiceSession<?, ?> finalSession1 = session;
            Thread initializeSessionThread = new Thread(() -> {
                try {
                    finalSession1.initialize();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot initialize session", (Throwable)e);
                }
                this.resetCache(thirdPartyServiceId);
                finalSession1.calculateStatus(false);
                finalSession1.calculateAuthStatus();
            });
            initializeSessionThread.start();
            if (initializeSession) {
                try {
                    initializeSessionThread.join(SchedulerApplication.getInstance().getConfiguration().getThirdPartyServiceInitializeTimeoutMs());
                }
                catch (InterruptedException e) {
                    LOGGER.error("Sleep interrupted", (Throwable)e);
                }
            }
        }
        session.calculateStatus(false);
        session.calculateAuthStatus();
        return session;
    }

    public synchronized void addUserCredential(ThirdPartyService thirdPartyService, ThirdPartyUserCredential userCredential, BearerUser schedulerUser) throws ResponseException {
        userCredential.setThirdPartyServiceId(thirdPartyService.getId());
        userCredential.setAuthenticationScope(thirdPartyService.getAuthenticationScope());
        String sessionId = ThirdPartyServiceSession.getId(thirdPartyService, schedulerUser.getId());
        ThirdPartyServiceSession<?, ?> session = (ThirdPartyServiceSession<?, ?>)this.sessionCache.get(sessionId, true);
        if (session != null) {
            session.setUserCredential(userCredential);
        } else {
            session = this.createSession(schedulerUser.getId(), thirdPartyService, userCredential);
        }
        if (thirdPartyService.getAuthenticationScope() == ThirdPartyAuthenticationScope.SERVICE) {
            this.clearThirdPartyServiceSessionCache(thirdPartyService.getId());
        }
        this.sessionCache.put(sessionId, session);
        this.userCredentialCache.put(userCredential.getId(), (Object)userCredential);
        session.getLogger().addLog(iu.getFormattedString(thirdPartyService.getTranslationKey("Log.SigningInAs"), new Object[]{userCredential.getUsername(), thirdPartyService.getAuthenticationScope().toLocalizedString()}));
        try {
            this.testSession(session);
        }
        catch (Exception e) {
            String licensesWarningMessage = null;
            if (session.getLicenseException() != null) {
                licensesWarningMessage = session.getStatus().getMessage();
            }
            session.signOut();
            if (licensesWarningMessage != null) {
                session.getStatus().setWarningMessage(licensesWarningMessage);
            }
            throw e;
        }
        session.getLogger().addLog(iu.getFormattedString(thirdPartyService.getTranslationKey("Log.SignedInAs"), new Object[]{userCredential.getUsername(), thirdPartyService.getAuthenticationScope().toLocalizedString()}));
        LOGGER.info(schedulerUser.getName() + " signed into userCredential with user: " + session.getUserCredential().getUsername());
        ThirdPartyUserCredential eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(schedulerUser, userCredential);
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential(userCredential) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyUserCredential(userCredential);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_USER_CREDENTIALS_ADDED, eventResult, schedulerUser.getName());
        } else {
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_USER_CREDENTIALS_MODIFIED, eventResult, schedulerUser.getName());
        }
        this.resetCache(userCredential.getThirdPartyServiceId());
    }

    private void updateThirdPartyServiceInternal(ThirdPartyService originalThirdPartyService, ThirdPartyService updatedThirdPartyService) {
        if (updatedThirdPartyService != null) {
            LOGGER.info("Updating third-party service " + updatedThirdPartyService.getName());
            originalThirdPartyService.update(updatedThirdPartyService);
            this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyService(originalThirdPartyService);
            this.resetCache(originalThirdPartyService.getId());
        }
    }

    public void setUserCredentialsStale(String thirdPartyServiceId) {
        this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredentialStale(thirdPartyServiceId, true);
        this.clearThirdPartyServiceSessionCache(thirdPartyServiceId);
    }

    public List<ThirdPartyService> getThirdPartyServicesUsingOidcAuthenticationService(UserService userService) {
        return this.thirdPartyServices.values().stream().filter(thirdPartyService -> thirdPartyService.usingOidcAuthenticationMethod() && thirdPartyService.getOidcAuthMethodType() == userService.getAuthMethodType() && userService.getId().equals(thirdPartyService.getAuthenticationServiceId())).collect(Collectors.toList());
    }

    public ThirdPartyService getResponseThirdPartyService(final String id) throws ResponseException {
        ThirdPartyService thirdPartyService = this.getThirdPartyService(id);
        if (thirdPartyService == null) {
            throw new ResponseException(ExceptionUtils.toResponse((String)"thirdPartyServiceCannotFind", (Map)new HashMap<String, String>(){
                {
                    this.put("id", id);
                }
            }, (Response.Status)Response.Status.NOT_FOUND));
        }
        return thirdPartyService;
    }

    public ThirdPartyService getThirdPartyService(String id) {
        if (id != null) {
            return this.thirdPartyServices.get(id);
        }
        return null;
    }

    public Collection<ThirdPartyService> getThirdPartyServices() {
        return this.thirdPartyServices.values();
    }

    public List<String> getAvailableByDefaultThirdPartyServiceIds() {
        ArrayList<String> thirdPartyServiceIds = new ArrayList<String>();
        for (ThirdPartyService thirdPartyService : this.thirdPartyServices.values()) {
            if (!Boolean.TRUE.equals(thirdPartyService.getEnabled()) || !Boolean.TRUE.equals(thirdPartyService.getAvailableByDefault())) continue;
            thirdPartyServiceIds.add(thirdPartyService.getId());
        }
        return thirdPartyServiceIds;
    }

    public void initializeThirdPartyServicesFromConfiguration() {
        LOGGER.info("Initializing Third-Party Services from configuration");
        DerbyControlService derbyControlServiceConfiguration = this.schedulerApplication.getConfiguration().getDerbyControlServiceConfiguration();
        if (derbyControlServiceConfiguration != null) {
            derbyControlServiceConfiguration.setReadOnly(true);
            derbyControlServiceConfiguration.setId(this.getServiceIdForType((ThirdPartyService)derbyControlServiceConfiguration));
            this.thirdPartyServices.put(derbyControlServiceConfiguration.getId(), (ThirdPartyService)derbyControlServiceConfiguration);
        }
    }

    public void initializeThirdPartyServicesFromStore() {
        LOGGER.info("Initializing Third-Party Services from store");
        List<ThirdPartyService> thirdPartyServices = this.schedulerApplication.getSchedulerConfigurationDao().getThirdPartyServices();
        for (ThirdPartyService thirdPartyService : thirdPartyServices) {
            if (thirdPartyService == null) continue;
            thirdPartyService.normalize();
            this.thirdPartyServices.put(thirdPartyService.getId(), thirdPartyService);
            if (thirdPartyService.getAuthenticationScope() == null) {
                thirdPartyService.setAuthenticationScope(ThirdPartyAuthenticationScope.USER);
            }
            this.enableUserServiceSynchronization(thirdPartyService);
        }
    }

    public void createAndSaveOidcThirdPartyUserCredential(ThirdPartyService thirdPartyService, BearerUser userCredentialUser, BearerUser createdByUser) throws ResponseException {
        ThirdPartyUserCredential userCredential = thirdPartyService.initializeDefaultUserCredential();
        Map<String, Object> tokenResponse = this.getTokenResponse(userCredentialUser);
        if (tokenResponse == null) {
            throw new IllegalArgumentException("BearerUser type not supported, " + userCredentialUser.getClass().getSimpleName() + " for " + thirdPartyService.getClass().getSimpleName());
        }
        boolean triggerUserServiceObjectSynchronization = false;
        UserServiceClient userServiceClient = this.schedulerApplication.getUserServiceResource().getUserServiceClient(thirdPartyService.getAuthenticationServiceId());
        if (userServiceClient instanceof GoogleOidcUserServiceClient && ((GoogleOidcUserServiceClient)userServiceClient).getFirstThirdPartyServiceSession() == null) {
            triggerUserServiceObjectSynchronization = true;
        }
        userCredential.setOidcTokenResponse(tokenResponse);
        userCredential.setUsername(userCredentialUser.getName());
        userCredential.setUserId(createdByUser.getId());
        this.addUserCredential(thirdPartyService, userCredential, createdByUser);
        if (triggerUserServiceObjectSynchronization) {
            this.schedulerApplication.getScheduledExecutorService().schedule(() -> this.schedulerApplication.getUserServiceResource().triggerGoogleOidcSynchronization(thirdPartyService.getAuthenticationServiceId()), 5L, TimeUnit.SECONDS);
        }
    }

    public void savePurviewDownloadUserCredential(ThirdPartyService thirdPartyService, BearerUser userCredentialUser, BearerUser createdByUser) throws IOException {
        String userCredentialId = ThirdPartyUserCredential.getId((ThirdPartyService)thirdPartyService, (String)createdByUser.getId());
        PurviewUserCredential userCredential = (PurviewUserCredential)this.userCredentialCache.get(userCredentialId);
        PurviewDownloadUserCredential downloadUserCredential = new PurviewDownloadUserCredential();
        downloadUserCredential.setOidcTokenResponse(((OidcMicrosoftBearerUser)userCredentialUser).getTokenResponse());
        downloadUserCredential.setUsername(userCredentialUser.getName());
        userCredential.setDownloadUserCredential(downloadUserCredential);
        this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential((ThirdPartyUserCredential)userCredential);
        ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), createdByUser.getId());
        session.calculateStatus();
        session.getLogger().addLog(iu.getFormattedString(thirdPartyService.getTranslationKey("Log.SignedInAsDownload"), new Object[]{downloadUserCredential.getUsername(), thirdPartyService.getAuthenticationScope().toLocalizedString()}));
        LOGGER.info(createdByUser.getName() + " signed into Purview downloadUserCredential with user: " + downloadUserCredential.getUsername());
        this.resetCache(thirdPartyService.getId());
    }

    public void verifyUserCredentialAddPermissions(BearerUser user, ThirdPartyService thirdPartyService) throws ResponseException {
        this.verifyUserCredentialAddPermissions(user, thirdPartyService, false);
    }

    @Operation(tags={"Resources"}, operationId="ParseImportedObjects", summary="Parse Imported Third Party Objects", responses={@ApiResponse(description="The parsed third party objects", content={@Content(schema=@Schema(implementation=ImportedObjectsParseResult.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/{thirdPartyServiceId}/parseImportedObjects")
    public Response parseImportedObjects(@Parameter(hidden=true) @Auth BearerUser user, @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @QueryParam(value="objectType") String serviceObjectType, @Parameter(description="The list of imported objects") List<String[]> objectRows) throws IOException {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            final ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!thirdPartyServicePermissions.contains(Permission.VIEW)) {
                throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService));
            }
            String userServiceId = thirdPartyService.getAuthenticationServiceId();
            if (userServiceId != null && !userServiceId.trim().isEmpty()) {
                UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userServiceId);
                if (userService == null) {
                    throw new ResponseException(ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                        {
                            this.put("userServiceId", thirdPartyService.getAuthenticationServiceId());
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND));
                }
                Set userServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
                if (!userServicePermissions.contains(Permission.VIEW)) {
                    throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)userService));
                }
            }
            ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            LOGGER.info("Parsing " + serviceObjectType + " imported objects for " + thirdPartyService.getName());
            ImportedObjectsParseResult<?> parseResult = session.parseImportedObjects(serviceObjectType, objectRows);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(parseResult).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
    }

    @Operation(tags={"Resources"}, operationId="ThirdPartyServiceObjects", summary="Service Objects ", description="Get objects used in the Third Party Service", responses={@ApiResponse(description="The list of objects from the third party API", content={@Content(array=@ArraySchema(schema=@Schema(implementation=List.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/{thirdPartyServiceId}/serviceObjects")
    public Response getThirdPartyServiceObjects(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @QueryParam(value="objectType") String serviceObjectType, @Parameter(description="The API request parameters") Map<String, Object> parameters) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set serviceUserPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!serviceUserPermissions.contains(Permission.SUBMIT_JOB)) {
                return ExceptionUtils.buildForbiddenResponse();
            }
            ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            LOGGER.info("Requesting API resource " + serviceObjectType + ", with user: " + session.getUserCredential().getUsername());
            Object serviceObjects = session.getObjects(serviceObjectType, parameters);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(serviceObjects).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            LOGGER.error("Error getting third-party service objects", (Throwable)e);
            return ExceptionUtils.toResponse((String)"thirdPartyGetServiceObjectsError", (Exception)e);
        }
    }

    @Operation(tags={"Resources"}, operationId="ThirdPartyServiceApiProxy", summary="Third-Party API Proxy", description="Make a proxy call to the Third-Party Service API", responses={@ApiResponse(description="The response from the Third-Party Service API", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Map.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/{thirdPartyServiceId}/apiProxy")
    public Response proxyApiRequest(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The API proxy request") ApiProxyRequest apiProxyRequest) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set serviceUserPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!serviceUserPermissions.contains(Permission.SUBMIT_JOB)) {
                return ExceptionUtils.buildForbiddenResponse();
            }
            if (!thirdPartyService.getEnabled().booleanValue()) {
                throw new IllegalStateException("Service is not enabled");
            }
            LOGGER.info("Proxying " + thirdPartyService.getPrintableServiceType() + " API " + apiProxyRequest.getMethod() + " " + apiProxyRequest.getEndpoint());
            ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            session.assertInstanceLicensed();
            Object apiResult = session.proxy(apiProxyRequest);
            if (apiResult instanceof Response) {
                return (Response)apiResult;
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(apiResult).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        catch (ThirdPartyRestException e) {
            LOGGER.error("Error during API request", (Throwable)e);
            TranslationResponseStatus translationResponse = new TranslationResponseStatus("thirdPartyApiRequestError");
            translationResponse.setCode(e.getStatus());
            translationResponse.setValues(new HashMap());
            translationResponse.getValues().put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
            translationResponse.getValues().put("response", e.getResponse());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)translationResponse).build();
        }
        catch (Exception e) {
            LOGGER.error("Error during API request", (Throwable)e);
            return ExceptionUtils.toResponse((String)"thirdPartyApiRequestError", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Resources"}, operationId="SendThirdPartyServiceActionRequest", summary="Send Third-Party Action Request", responses={@ApiResponse(responseCode="401", description="Incorrect user credentials, or user is not authorized to use this Third-Party Service")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}/action")
    @POST
    public Response handleActionRequest(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the Third-Party Service") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The action") ActionRequest<String> actionRequest) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!thirdPartyServicePermissions.contains(Permission.MODIFY)) {
                throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService));
            }
            ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            LOGGER.info("Handling action " + (String)actionRequest.getAction() + " for " + thirdPartyService.getName());
            Map<String, String> result = session.handleAction(actionRequest);
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)SerializationUtils.toJson(result)).type(MediaType.APPLICATION_JSON_TYPE).build();
            return response;
        }
        catch (ResponseException e) {
            Response response = e.getResponse();
            return response;
        }
        catch (Exception e) {
            LOGGER.error("Error during third-party action request, " + (String)actionRequest.getAction(), (Throwable)e);
            Response response = ExceptionUtils.toResponse((String)"thirdPartyServiceGenericError", (Exception)e);
            return response;
        }
        finally {
            this.resetCache(thirdPartyServiceId);
        }
    }

    @Operation(tags={"Resources"}, operationId="ExportThirdPartyServiceCsv", summary="Export Third-Party Service CSV ", responses={@ApiResponse(responseCode="401", description="Incorrect user credentials, or user is not authorized to use this Third-Party Service")})
    @SecurityRequirement(name="Bearer_Token")
    @Produces(value={"application/octet-stream"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    @Path(value="/{thirdPartyServiceId}/exportCsv")
    public Response exportThirdPartyCsv(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token, @Parameter(description="The ID of the Third-Party Service") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @FormParam(value="optionsJson") String optionsJson) throws AuthenticationException {
        Optional<BearerUser> userOptional = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (userOptional.isEmpty()) {
            return ExceptionUtils.buildForbiddenResponse((String)"Unauthenticated", (Object)thirdPartyServiceId);
        }
        BearerUser user = userOptional.get();
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!thirdPartyServicePermissions.contains(Permission.VIEW_SENSITIVE)) {
                throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService));
            }
            ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            LOGGER.info("Exporting third-party service CSV for " + thirdPartyService.getName());
            StreamingOutput streamingOutput = outputStream -> {
                try (StringWriter writer = new StringWriter();
                     CSVWriter csvWriter = new CSVWriter((Writer)writer);
                     BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
                    session.exportAsCsv(csvWriter, optionsJson);
                    bufferedOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOGGER.error("Error during third-party service CSV export for " + thirdPartyService.getName(), (Throwable)e);
                }
            };
            DateTimeFormatter fileDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss").withZone(ZoneId.of("UTC"));
            String fileName = thirdPartyService.getName() + "-" + FormattingUtils.getShortId((String)thirdPartyService.getId(), (int)8) + " " + fileDateTimeFormatter.format(Instant.ofEpochMilli(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            String sanitizedFileName = FormattingUtils.sanitizeFilename((String)fileName);
            return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)streamingOutput, (String)(sanitizedFileName + ".csv"));
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            LOGGER.error("Error during third-party service CSV export", (Throwable)e);
            return ExceptionUtils.toResponse((String)"thirdPartyServiceGenericError", (Exception)e);
        }
    }

    @Operation(tags={"Resources"}, operationId="SaveThirdPartyUserCredential", summary="Save Third-Party User Credential", description="Save User Credential for Third-Party Service", responses={@ApiResponse(responseCode="401", description="Incorrect user credential, or user is not authorized to use this Third-Party Service")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}/userCredential")
    @POST
    public Response saveThirdPartyUserCredential(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the ThirdPartyService") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The user credential", schema=@Schema(implementation=ThirdPartyUserCredential.class)) String userCredentialString) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        ThirdPartyUserCredential userCredential = (ThirdPartyUserCredential)SerializationUtils.fromJson((String)userCredentialString, ThirdPartyUserCredential.class);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            this.verifyUserCredentialAddPermissions(user, thirdPartyService);
            this.schedulerApplication.getUserSettingsResource().getUser().set(user);
            userCredential.setUserId(user.getId());
            this.addUserCredential(thirdPartyService, userCredential, user);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Resources"}, operationId="SendThirdPartyUserCredentialCommand", summary="Send Third-Party User Credential Command", description="Send a command for a third-party user credential", responses={@ApiResponse(responseCode="401", description="Incorrect user credentials, or user is not authorized to use this Third-Party Service")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}/userCredential/command")
    @POST
    public Response sendThirdPartyUserCredentialCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the Third-Party Service") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The command") ActionRequest<UserCredentialAction> actionRequest) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        UserCredentialAction action = (UserCredentialAction)actionRequest.getAction();
        ThirdPartyServiceSession<?, ?> session = null;
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            this.verifyUserCredentialAddPermissions(user, thirdPartyService, true);
            session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId(), true);
            switch (action) {
                case RESET: {
                    session.getLog().clear();
                    session.initialize(true);
                    this.testSession(session);
                    break;
                }
                case TEST: {
                    if (actionRequest.getBody() instanceof Map) {
                        Map values = (Map)actionRequest.getBody();
                        values.put("submittedBy", user.getName());
                        this.testSession(session, values);
                        break;
                    }
                    this.testSession(session);
                    break;
                }
                case REFRESH: {
                    if (!session.refreshToken()) {
                        Response values = ExceptionUtils.toResponse((String)thirdPartyService.getUiTranslationKey("FailedToRefresh"), (Response.Status)Response.Status.BAD_REQUEST);
                        return values;
                    }
                    this.testSession(session);
                }
            }
            ThirdPartyDetails result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session);
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)SerializationUtils.toJson((Object)result)).type(MediaType.APPLICATION_JSON_TYPE).build();
            return response;
        }
        catch (ResponseException e) {
            Response result = e.getResponse();
            return result;
        }
        catch (Exception e) {
            Object errorKey;
            LOGGER.error("Error running third-party user credential action: " + String.valueOf(action), (Throwable)e);
            if (session != null) {
                session.getLogger().addError(iu.getFormattedString("ThirdPartySession.Error.Command", new Object[]{action.toLocalizableString().toLowerCase(), ExceptionUtils.getExceptionPrintableMessage((Throwable)e)}));
                errorKey = "thirdPartyServiceSessionError" + action.name();
            } else {
                errorKey = "thirdPartyServiceGenericError";
            }
            Response response = ExceptionUtils.toResponse((String)errorKey, (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
            return response;
        }
        finally {
            this.resetCache(thirdPartyServiceId);
        }
    }

    @Operation(tags={"Resources"}, operationId="DeleteThirdPartyUserCredential", summary="Delete Third-Party User Credential", description="Delete User Credential for Third-Party Service")
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}/userCredential/{scope}")
    @DELETE
    public Response deleteThirdPartyUserCredential(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the ThirdPartyService") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The scope of the user credential") @PathParam(value="scope") String scope, @Parameter(hidden=true) @Context HttpServletRequest req, @Context UriInfo uriInfo) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            String responseKey;
            scope = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, scope);
            ThirdPartyAuthenticationScope authenticationScope = ThirdPartyAuthenticationScope.valueOf((String)scope);
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set serviceUserPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (authenticationScope == ThirdPartyAuthenticationScope.SERVICE && !serviceUserPermissions.contains(Permission.MODIFY)) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService);
            }
            String sessionId = ThirdPartyServiceSession.getId(thirdPartyService, user.getId());
            ThirdPartyServiceSession session = (ThirdPartyServiceSession)this.sessionCache.get(sessionId);
            if (thirdPartyService.getAuthenticationScope() == ThirdPartyAuthenticationScope.SERVICE) {
                this.clearThirdPartyServiceSessionCache(thirdPartyService.getId());
            }
            if (session != null) {
                String userCredentialUsername = session.getUserCredential().getUsername();
                session.signOut();
                session.getLogger().addLog(iu.getFormattedString(session.getTranslationKey("Log.SignedOut"), (Object)userCredentialUsername));
                this.sessionCache.put(sessionId, (Object)session);
                LOGGER.info(user.getName() + " signed out of userCredential user: " + userCredentialUsername);
            }
            String userCredentialId = ThirdPartyUserCredential.getId((String)thirdPartyServiceId, (String)user.getId(), (ThirdPartyAuthenticationScope)authenticationScope);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteThirdPartyUserCredential(userCredentialId);
            ThirdPartyUserCredential eventResult = null;
            if (session != null) {
                responseKey = session.getUiTranslationKey("SignedOut");
                eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (ThirdPartyUserCredential)session.getUserCredential());
            } else {
                responseKey = "thirdPartySessionSignedOut";
            }
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_USER_CREDENTIALS_DELETED, eventResult == null ? "" : eventResult, user.getName());
            this.resetCache(thirdPartyServiceId);
            TranslationResponseStatus statusModel = new TranslationResponseStatus(responseKey, new HashMap());
            statusModel.getValues().put("scope", authenticationScope.toLocalizedString());
            if (thirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
                String baseUri = ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo);
                URI redirectUri = UriBuilder.fromUri((String)baseUri.replace("/api/", "/#oidcUserSignOut")).build(new Object[0]);
                OidcUserServiceClient oidcUserServiceClient = (OidcUserServiceClient)this.schedulerApplication.getUserServiceResource().getUserServiceClient(thirdPartyService.getAuthenticationServiceId());
                statusModel.setRedirectUrl(oidcUserServiceClient.getOAuthSignOutUrl(redirectUri.toString(), null));
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)statusModel).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
    }

    @Operation(tags={"Resources", "Job Submission"}, operationId="ListThirdPartyServices", summary="List Third-Party Services", description="List active Third-Party Services", responses={@ApiResponse(description="The list of Third-Party Services", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ThirdPartyDetails.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/list")
    @GET
    public Response ListThirdPartyServices(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.THIRD_PARTY_SERVICES);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<ThirdPartyService> allowedThirdPartyServices = new ArrayList<ThirdPartyService>();
            for (ThirdPartyService thirdPartyService : this.thirdPartyServices.values()) {
                if (thirdPartyService.getEnabled() == null || !thirdPartyService.getEnabled().booleanValue()) continue;
                try {
                    this.assertThirdPartyServiceLicensed(thirdPartyService);
                    try {
                        ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId());
                        ThirdPartyDetails result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session);
                        if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                        ThirdPartyService conciseThirdPartyService = result.getService();
                        allowedThirdPartyServices.add(conciseThirdPartyService);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot handle " + String.valueOf(thirdPartyService), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {}
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)SerializationUtils.toJson((Object)ResponseUtils.getConciseList(allowedThirdPartyServices, (Integer)Integer.MAX_VALUE))).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="GetThirdPartyServices", summary="Get Third-Party Services", description="Get full information of all Third-Party Services. Only use this method if the information returned by ListThirdPartyServices is not sufficient", responses={@ApiResponse(description="The list of Third-Party Services", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ThirdPartyDetails.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getThirdPartyServices(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.THIRD_PARTY_SERVICES);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<ThirdPartyDetails> allowedThirdPartyDetails = new ArrayList<ThirdPartyDetails>();
            for (ThirdPartyService thirdPartyService : this.thirdPartyServices.values()) {
                try {
                    this.assertThirdPartyServiceLicensed(thirdPartyService);
                    try {
                        ThirdPartyServiceSession<?, ?> session2 = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId());
                        ThirdPartyDetails result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session2);
                        if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                        allowedThirdPartyDetails.add(result);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot handle " + String.valueOf(thirdPartyService), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {}
            }
            SortingUtils.sortList(allowedThirdPartyDetails, session -> session.getService().getName());
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)SerializationUtils.toJson(allowedThirdPartyDetails)).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddThirdPartyService", summary="Add Third-Party Service", description="Add a new Third-Party Service", responses={@ApiResponse(description="The Third-Party Service that was added", content={@Content(schema=@Schema(implementation=ThirdPartyDetails.class))}), @ApiResponse(responseCode="400", description="A Third-Party Service with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addThirdPartyService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The Third-Party Service to add", schema=@Schema(implementation=ThirdPartyService.class)) String thirdPartyServiceString) throws IOException {
        thirdPartyServiceString = this.patchThirdPartyServiceJson(thirdPartyServiceString);
        ThirdPartyService thirdPartyService = (ThirdPartyService)SerializationUtils.fromJson((String)thirdPartyServiceString, ThirdPartyService.class);
        thirdPartyService.normalize();
        this.assertThirdPartyServiceLicensed(thirdPartyService);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_THIRD_PARTY_SERVICES));
        if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService);
        }
        try {
            FormattingUtils.trimAllStrings((Object)thirdPartyService);
            thirdPartyService.isValid(false);
            for (ThirdPartyService existingService : this.thirdPartyServices.values()) {
                if (!existingService.getClass().equals(thirdPartyService.getClass()) || !existingService.getName().equals(thirdPartyService.getName())) continue;
                return ExceptionUtils.toResponse((String)thirdPartyService.getUiTranslationKey("NameExists"), (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        thirdPartyService.setId(this.getServiceIdForType(thirdPartyService));
        if (thirdPartyService.getAuthenticationScope() == null) {
            thirdPartyService.setAuthenticationScope(ThirdPartyAuthenticationScope.USER);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyService(thirdPartyService);
        this.thirdPartyServices.put(thirdPartyService.getId(), thirdPartyService);
        ThirdPartyServiceSession<?, ?> session = this.initAddedThirdPartyService(thirdPartyService, user);
        ThirdPartyService eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_SERVICE_ADDED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES);
        ThirdPartyDetails result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session);
        if (!eventResult.getEnabled().booleanValue()) {
            result.getStatus().reset();
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)SerializationUtils.toJson((Object)result)).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateThirdPartyService", summary="Update Third-Party Service", description="Update the Third-Party Service with the specified ID", responses={@ApiResponse(description="The updated Third-Party Service", content={@Content(schema=@Schema(implementation=ThirdPartyDetails.class))}), @ApiResponse(responseCode="404", description="Cannot find Third-Party Service with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}")
    @PUT
    public Response updateThirdPartyService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the Third-Party Service to update") @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId, @Parameter(description="The information to update the Third-Party Service with", schema=@Schema(implementation=ThirdPartyService.class)) String thirdPartyServiceString) throws IOException {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        ThirdPartyService thirdPartyService = (ThirdPartyService)SerializationUtils.fromJson((String)thirdPartyServiceString, ThirdPartyService.class);
        try {
            ThirdPartyServiceSession<?, ?> session;
            ThirdPartyService originalThirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalThirdPartyService).getUserPermissions();
            if (!thirdPartyServicePermissions.contains(Permission.MODIFY)) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService);
            }
            FormattingUtils.trimAllStrings((Object)thirdPartyService);
            thirdPartyService.isValid(true);
            String name = FormattingUtils.getTrimmedText((String)thirdPartyService.getName());
            if (name != null) {
                for (ThirdPartyService existingService : this.thirdPartyServices.values()) {
                    if (existingService.getId().equals(thirdPartyServiceId) || !existingService.getClass().equals(thirdPartyService.getClass()) || !existingService.getName().equals(thirdPartyService.getName())) continue;
                    return ExceptionUtils.toResponse((String)thirdPartyService.getUiTranslationKey("NameExists"), (Response.Status)Response.Status.BAD_REQUEST);
                }
            }
            if (thirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS) {
                if (ThirdPartyAuthenticationScope.USER.equals((Object)thirdPartyService.getAuthenticationScope())) {
                    try {
                        ThirdPartyServiceSession<?, ?> session2 = this.getThirdPartyServiceSession(originalThirdPartyService.getId(), user.getId());
                        session2.getLogger().addLog(iu.getFormattedString("ThirdPartyService.Log.OverwritingAuthScope", (Object)ThirdPartyAuthenticationScope.SERVICE.toLocalizedString()));
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot retrieve session", (Throwable)e);
                    }
                }
                thirdPartyService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
            }
            originalThirdPartyService.update(thirdPartyService);
            boolean userCredentialsStale = originalThirdPartyService.updateUserCredentialSensitiveFields(thirdPartyService);
            originalThirdPartyService.normalize();
            this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyService(originalThirdPartyService);
            if (originalThirdPartyService.getEnabled().booleanValue()) {
                if (userCredentialsStale) {
                    this.setUserCredentialsStale(thirdPartyServiceId);
                }
                if (originalThirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS) {
                    this.signInWithOidcClientCredentials(user, originalThirdPartyService);
                } else {
                    try {
                        session = this.getThirdPartyServiceSession(originalThirdPartyService.getId(), user.getId());
                        if (!userCredentialsStale && originalThirdPartyService.getEnabled().booleanValue() && session.getSignedIn()) {
                            session.initialize(true);
                            this.testSession(session);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error testing third-party user credential after update", (Throwable)e);
                    }
                }
            }
            session = this.getThirdPartyServiceSession(originalThirdPartyService.getId(), user.getId());
            this.enableUserServiceSynchronization(originalThirdPartyService);
            ThirdPartyService eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalThirdPartyService);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_SERVICE_MODIFIED, eventResult, user.getName());
            this.resetCache(thirdPartyServiceId);
            ThirdPartyDetails result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, session);
            if (!eventResult.getEnabled().booleanValue()) {
                result.getStatus().reset();
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)SerializationUtils.toJson((Object)result)).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
    }

    @Operation(tags={"Resources"}, operationId="DeleteThirdPartyService", summary="Delete Third-Party Service", description="Delete the Third-Party Service with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Third-Party Service with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{thirdPartyServiceId}")
    @DELETE
    public Response deleteThirdPartyService(@Parameter(hidden=true) @Auth BearerUser user, @PathParam(value="thirdPartyServiceId") String thirdPartyServiceId) {
        this.assertThirdPartyServiceIdLicensed(thirdPartyServiceId);
        try {
            ThirdPartyService thirdPartyService = this.getResponseThirdPartyService(thirdPartyServiceId);
            Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (!thirdPartyServicePermissions.contains(Permission.MODIFY)) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService);
            }
            this.verifyNotUsedInJobs(user, thirdPartyService);
            this.verifyNotUsedInLegalHolds(user, thirdPartyService);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteThirdPartyUserCredentials(thirdPartyServiceId);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteThirdPartyService(thirdPartyServiceId);
            this.thirdPartyServices.remove(thirdPartyServiceId);
            this.clearThirdPartyServiceSessionCache(thirdPartyServiceId);
            ThirdPartyService eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.THIRD_PARTY_SERVICE_MODIFIED, eventResult, user.getName());
            this.resetCache(thirdPartyServiceId);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
    }

    private void testSession(ThirdPartyServiceSession<?, ?> session) throws ResponseException {
        this.testSession(session, null);
    }

    private void testSession(ThirdPartyServiceSession<?, ?> session, Map<String, Object> values) throws ResponseException {
        if (session instanceof LinkServiceSession) {
            return;
        }
        try {
            if (session.getSignedIn()) {
                long startMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                String testResponse = session.test(values);
                double durationSeconds = (double)(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - startMillis) / 1000.0;
                session.getLogger().addLog(iu.getFormattedString(session.getTranslationKey("Log.TestSuccess"), (Object)String.format("%.2f", durationSeconds)));
                if (testResponse != null && !testResponse.isEmpty()) {
                    session.getLogger().addLog(testResponse);
                }
                if (session.getStale()) {
                    session.setStale(false);
                    this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential((ThirdPartyUserCredential)session.getUserCredential());
                }
            } else {
                throw new ResponseException(ExceptionUtils.toResponse((String)"thirdPartyServiceSessionErrorTEST", (Exception)new IllegalStateException(iu.getString("ThirdPartySession.Error.NotSignedIn")), (Response.Status)Response.Status.BAD_REQUEST));
            }
            session.calculateStatus();
            session.calculateAuthStatus();
            Thread updateThread = new Thread(() -> {
                Object T1 = session.getService();
                synchronized (T1) {
                    this.updateThirdPartyServiceInternal((ThirdPartyService)session.getService(), session.getUpdatedThirdPartyService());
                }
            });
            updateThread.start();
        }
        catch (ResponseException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Error testing third-party service user credential", (Throwable)e);
            session.getLogger().addError(iu.getFormattedString("ThirdPartySession.Error.Test", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            throw new ResponseException(ExceptionUtils.toResponse((String)"thirdPartyServiceSessionErrorTEST", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST));
        }
        finally {
            this.resetCache(session.getServiceId());
        }
    }

    public void resetCache(String serviceId) {
        ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICE, serviceId);
        ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES);
    }

    private void verifyUserCredentialAddPermissions(BearerUser user, ThirdPartyService thirdPartyService, boolean ignoreModify) throws ResponseException {
        Set serviceUserPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
        if (!serviceUserPermissions.contains(Permission.VIEW) || !serviceUserPermissions.contains(Permission.SUBMIT_JOB) && !serviceUserPermissions.contains(Permission.STAGE_JOB)) {
            throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService));
        }
        if (!ignoreModify && thirdPartyService.getAuthenticationScope() == ThirdPartyAuthenticationScope.SERVICE && !serviceUserPermissions.contains(Permission.MODIFY)) {
            throw new ResponseException(ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)thirdPartyService));
        }
    }

    private void signInWithOidcClientCredentials(BearerUser user, ThirdPartyService thirdPartyService) throws IOException {
        ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId());
        if (session instanceof OidcThirdPartyServiceSession) {
            try {
                session.getStatus().reset();
                OidcThirdPartyServiceSession oidcSession = (OidcThirdPartyServiceSession)session;
                oidcSession.initialize(true);
                ThirdPartyUserCredential userCredential = oidcSession.createOidcClientCredential();
                if (userCredential != null) {
                    userCredential.setUserId(user.getId());
                    this.addUserCredential(thirdPartyService, userCredential, user);
                }
            }
            catch (Exception e) {
                session.getStatus().setError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                LOGGER.error("Error signing with oidc client credential", (Throwable)e);
            }
        }
    }

    private void enableUserServiceSynchronization(ThirdPartyService thirdPartyService) {
        if (Boolean.TRUE.equals(thirdPartyService.getEnabled()) && thirdPartyService.usingOidcAuthenticationMethod()) {
            UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(thirdPartyService.getAuthenticationServiceId());
            if (userService == null) {
                return;
            }
            if (Boolean.TRUE.equals(userService.getSynchronizeUsers()) && Boolean.TRUE.equals(userService.getSynchronizeObjects())) {
                return;
            }
            try {
                switch (thirdPartyService.getOidcAuthMethodType()) {
                    case OIDC_MICROSOFT: {
                        MicrosoftUserService microsoftUserServiceUpdate = new MicrosoftUserService();
                        microsoftUserServiceUpdate.setId(thirdPartyService.getAuthenticationServiceId());
                        microsoftUserServiceUpdate.setSynchronizeUsers(true);
                        microsoftUserServiceUpdate.setSynchronizeObjects(true);
                        this.schedulerApplication.getUserServiceResource().updateMicrosoftUserService(new SystemBearerUser(), true, microsoftUserServiceUpdate).close();
                        break;
                    }
                    case OIDC_GOOGLE: {
                        OidcUserService oidcUserServiceUpdate = new OidcUserService();
                        oidcUserServiceUpdate.setId(thirdPartyService.getAuthenticationServiceId());
                        oidcUserServiceUpdate.setSynchronizeUsers(Boolean.valueOf(true));
                        oidcUserServiceUpdate.setSynchronizeObjects(Boolean.valueOf(true));
                        oidcUserServiceUpdate.setLinkProfilesWithSyncedUsers(Boolean.valueOf(true));
                        if (oidcUserServiceUpdate.getSearchDelay() == null || oidcUserServiceUpdate.getSearchDelay() < 5) {
                            oidcUserServiceUpdate.setSearchDelay(Integer.valueOf(30));
                        }
                        this.schedulerApplication.getUserServiceResource().updateOidcUserService(new SystemBearerUser(), true, oidcUserServiceUpdate).close();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to auto-enable user and object synchronization for " + thirdPartyService.getName() + " (" + thirdPartyService.getId() + ") userService: " + thirdPartyService.getAuthenticationServiceId(), (Throwable)e);
            }
        }
    }

    private String getServiceIdForType(ThirdPartyService thirdPartyService) {
        Object serviceId = UidUtils.fromString((String)thirdPartyService.getClass().getSimpleName());
        if (this.thirdPartyServices.containsKey(serviceId = "1000" + ((String)serviceId).substring(4))) {
            serviceId = UidUtils.getRandom();
        }
        return serviceId;
    }

    private ThirdPartyServiceSession<?, ?> initAddedThirdPartyService(ThirdPartyService thirdPartyService, BearerUser user) throws IOException {
        ThirdPartyServiceSession<?, ?> session = this.getThirdPartyServiceSession(thirdPartyService.getId(), user.getId());
        if (thirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS) {
            if (ThirdPartyAuthenticationScope.USER.equals((Object)thirdPartyService.getAuthenticationScope())) {
                session.getLogger().addLog(iu.getFormattedString("ThirdPartyService.Log.OverwritingAuthScope", (Object)ThirdPartyAuthenticationScope.SERVICE.toLocalizedString()));
            }
            thirdPartyService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
        }
        if (thirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS) {
            this.signInWithOidcClientCredentials(user, thirdPartyService);
        }
        this.enableUserServiceSynchronization(thirdPartyService);
        return session;
    }

    private void verifyNotUsedInJobs(BearerUser user, ThirdPartyService thirdPartyService) throws ResponseException {
        Set<String> jobNames = this.getNamesOfJobsUsingThirdPartyService(user, thirdPartyService);
        if (jobNames.isEmpty()) {
            return;
        }
        String errorKey = jobNames.size() == 1 ? "ErrorDeletingUsedByJob" : "ErrorDeletingUsedByJobs";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jobNames", String.join((CharSequence)", ", jobNames));
        throw new ResponseException(ExceptionUtils.toResponse((String)thirdPartyService.getUiTranslationKey(errorKey), properties));
    }

    private void verifyNotUsedInLegalHolds(BearerUser user, ThirdPartyService thirdPartyService) throws ResponseException {
        Set<String> legalHoldNames = this.getNamesOfLegalHoldsUsingThirdPartyService(user, thirdPartyService);
        if (legalHoldNames.isEmpty()) {
            return;
        }
        String errorKey = legalHoldNames.size() == 1 ? "ErrorDeletingUsedByLegalHold" : "ErrorDeletingUsedByLegalHolds";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("names", String.join((CharSequence)", ", legalHoldNames));
        throw new ResponseException(ExceptionUtils.toResponse((String)thirdPartyService.getUiTranslationKey(errorKey), properties));
    }

    private Set<String> getNamesOfJobsUsingThirdPartyService(BearerUser user, ThirdPartyService thirdPartyService) {
        TreeSet<String> jobNames = new TreeSet<String>();
        ParameterType parameterType = thirdPartyService.getParameterType();
        if (parameterType != null) {
            for (JobDetailsModel job : this.schedulerApplication.getJobResource().getNonFinishedJobs()) {
                boolean containsServiceParameter = false;
                for (com.nuix.automate.utils.models.api.job.Parameter sessionParameter : job.getSettings().getSessionParameters()) {
                    if (!sessionParameter.getDisplayCondition().getDisplayable() || !sessionParameter.getParameterType().equals((Object)parameterType)) continue;
                    containsServiceParameter = thirdPartyService.getId().equals(sessionParameter.getValue());
                    break;
                }
                if (!containsServiceParameter) continue;
                if (user == null) {
                    jobNames.add(iu.getString("Job.Name.Other"));
                    continue;
                }
                JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, job.getSettings());
                if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                    jobNames.add(jobModel.getName());
                    continue;
                }
                jobNames.add(iu.getString("Job.Name.Other"));
            }
        }
        return jobNames;
    }

    private Set<String> getNamesOfLegalHoldsUsingThirdPartyService(BearerUser user, ThirdPartyService thirdPartyService) {
        TreeSet<String> legalHoldNames = new TreeSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            Set legalHoldPermissions;
            if (legalHold.getSmtpServerId() == null || !legalHold.getSmtpServerId().equals(thirdPartyService.getId()) || legalHold.getState() != LegalHoldState.DRAFT && legalHold.getState() != LegalHoldState.ACTIVE) continue;
            String legalHoldName = null;
            if (user != null && (legalHoldPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold).getUserPermissions()).contains(Permission.VIEW)) {
                legalHoldName = legalHold.getName();
            }
            if (legalHoldName == null) {
                legalHoldName = iu.getString("LegalHold.Name.Other");
            }
            legalHoldNames.add(legalHoldName);
        }
        return legalHoldNames;
    }

    private Map<String, Object> getTokenResponse(BearerUser userCredentialUser) {
        Map<String, Object> tokenResponse = null;
        if (userCredentialUser instanceof OidcMicrosoftBearerUser) {
            tokenResponse = ((OidcMicrosoftBearerUser)userCredentialUser).getTokenResponse();
        } else if (userCredentialUser instanceof OidcBearerUser) {
            tokenResponse = ((OidcBearerUser)userCredentialUser).getTokenInfo();
        }
        return tokenResponse;
    }

    private void assertThirdPartyServiceIdLicensed(String thirdPartyServiceId) {
        ThirdPartyService thirdPartyService = this.getThirdPartyService(thirdPartyServiceId);
        this.assertThirdPartyServiceLicensed(thirdPartyService);
    }

    private void assertThirdPartyServiceLicensed(ThirdPartyService thirdPartyService) {
        if (thirdPartyService != null) {
            if (thirdPartyService instanceof InvestigateService) {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.INVESTIGATE);
                return;
            }
            if (thirdPartyService instanceof DerbyControlService) {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.NEO_MANAGEMENT);
                return;
            }
            if (thirdPartyService instanceof SemanticService) {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SEMANTIC);
                return;
            }
            if (thirdPartyService instanceof DiscoverService) {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DISCOVER_REVIEW);
                return;
            }
            if (thirdPartyService instanceof ElasticsearchService) {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.ELASTICSEARCH);
                return;
            }
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.THIRD_PARTY_SERVICES);
    }

    private void clearExpiredThirdPartyServiceSessions() {
        this.userCredentialCache.getUnderlyingMap().values().removeIf(CachedObject::isExpired);
        this.sessionCache.getUnderlyingMap().values().removeIf(cache -> {
            if (cache.isExpired()) {
                ((ThirdPartyServiceSession)cache.getObject()).close();
                return true;
            }
            ((ThirdPartyServiceSession)cache.getObject()).clearExpiredCache();
            return false;
        });
    }

    private void clearThirdPartyServiceSessionCache(String thirdPartyServiceId) {
        this.userCredentialCache.getUnderlyingMap().values().removeIf(cache -> ((ThirdPartyUserCredential)cache.getObject()).getThirdPartyServiceId().equals(thirdPartyServiceId));
        this.sessionCache.getUnderlyingMap().values().removeIf(cache -> {
            if (((ThirdPartyServiceSession)cache.getObject()).getServiceId().equals(thirdPartyServiceId)) {
                ((ThirdPartyServiceSession)cache.getObject()).close();
                return true;
            }
            ((ThirdPartyServiceSession)cache.getObject()).clearExpiredCache();
            return false;
        });
    }

    private void initializeUserCredentialRefreshWorker() {
        this.schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            List<ThirdPartyUserCredential> userCredentials = this.schedulerApplication.getSchedulerConfigurationDao().getThirdPartyUserCredentials();
            for (ThirdPartyUserCredential userCredential : userCredentials) {
                if (userCredential.getRefreshToken() == null) continue;
                boolean refresh = false;
                if (userCredential.getTokenLastRefreshDate() != null) {
                    long millisSinceLastRefresh = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - userCredential.getTokenLastRefreshDate();
                    long daysSinceLastRefresh = millisSinceLastRefresh / 86400000L;
                    if (daysSinceLastRefresh >= (long)this.schedulerApplication.getConfiguration().getRefreshThirdPartyUserCredentialEveryNDays()) {
                        refresh = true;
                    }
                } else {
                    refresh = true;
                }
                if (!refresh) continue;
                try {
                    this.getThirdPartyServiceSession(userCredential.getThirdPartyServiceId(), userCredential.getUserId(), true);
                }
                catch (IOException e) {
                    LOGGER.error("Error refreshing third-party service session for userCredential " + userCredential.getId(), (Throwable)e);
                }
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    private void initializeSmtpServiceEmailReattemptTask() {
        this.schedulerApplication.getScheduledExecutorService().submit(() -> {
            List<SmtpEmail> pendingEmails = this.schedulerApplication.getSchedulerConfigurationDao().getSmtpEmails(EmailState.PENDING);
            if (!pendingEmails.isEmpty()) {
                LOGGER.info("Adding " + pendingEmails.size() + " PENDING SmtpEmails to email queue");
                this.submitEmails(pendingEmails);
            }
        });
        this.schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (ThirdPartyService thirdPartyService : this.thirdPartyServices.values()) {
                List<SmtpEmail> failedEmails;
                if (!(thirdPartyService instanceof SmtpService)) continue;
                SmtpService smtpService = (SmtpService)thirdPartyService;
                Integer retryInterval = smtpService.getEmailRetryInterval();
                if (retryInterval == null || retryInterval == 0) {
                    retryInterval = this.schedulerApplication.getConfiguration().getSmtpServiceEmailRetryInterval();
                }
                long retryIntervalSeconds = (long)retryInterval.intValue() * 60L * 60L;
                long currentSeconds = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() / 1000L;
                long secondsSinceLastReattempt = currentSeconds - smtpService.getLastReattemptSeconds();
                if (secondsSinceLastReattempt <= retryIntervalSeconds || (failedEmails = this.schedulerApplication.getSchedulerConfigurationDao().getSmtpEmails(null, smtpService.getId(), EmailState.ERROR)).isEmpty()) continue;
                LOGGER.info("Reattempting " + failedEmails.size() + " ERROR emails for smtpService " + smtpService.getName() + " (" + smtpService.getId() + ")");
                LOGGER.info("Seconds since last reattempt: " + secondsSinceLastReattempt);
                smtpService.setLastReattemptSeconds(currentSeconds);
                this.submitEmails(failedEmails);
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    private void migrateSmtpServers() {
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testSmtpServersTable("");
            LOGGER.info("Migrating SMTP Servers to Third-Party SMTP Services");
            for (SmtpServerModel smtpServer : this.schedulerApplication.getSchedulerConfigurationDao().getSmtpServers()) {
                try {
                    SmtpService smtpService = new SmtpService();
                    smtpService.setId(smtpServer.getId());
                    smtpService.setName(smtpServer.getName());
                    smtpService.setDescription(smtpServer.getDescription());
                    smtpService.setEnabled(Boolean.valueOf(true));
                    smtpService.setHost(smtpServer.getHost());
                    smtpService.setPort(smtpServer.getPort());
                    smtpService.setFrom(smtpServer.getFrom());
                    smtpService.setTls(smtpServer.getTls());
                    smtpService.setAvailableByDefault(Boolean.valueOf(false));
                    smtpService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                    if (Boolean.TRUE.equals(smtpServer.getAuthentication())) {
                        smtpService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
                        SmtpUserCredential userCredential = new SmtpUserCredential();
                        userCredential.setThirdPartyServiceId(smtpService.getId());
                        userCredential.setUserId(SmtpServiceSession.SYSTEM_USER_ID);
                        userCredential.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                        userCredential.setUsername(smtpServer.getUsername());
                        userCredential.setPassword(smtpServer.getPassword());
                        this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyUserCredential((ThirdPartyUserCredential)userCredential);
                    } else {
                        smtpService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.NONE);
                    }
                    this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyService((ThirdPartyService)smtpService);
                }
                catch (StatementException statementException) {}
            }
            this.schedulerApplication.getSchedulerConfigurationDao().dropSmtpServersTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    private void migrateOldEccProfiles() {
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testEccProfileTable("");
            LOGGER.info("Migrating old ECC Profiles to new Third-Party services");
            List<EccProfileModel> eccProfiles = this.schedulerApplication.getSchedulerConfigurationDao().getEccProfiles();
            for (EccProfileModel eccProfile : eccProfiles) {
                EccService thirdPartyService = new EccService();
                thirdPartyService.setId(eccProfile.getId());
                thirdPartyService.setName(eccProfile.getName());
                thirdPartyService.setDescription(eccProfile.getDescription());
                thirdPartyService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                thirdPartyService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
                thirdPartyService.setEnabled(Boolean.valueOf(true));
                thirdPartyService.setAvailableByDefault(Boolean.valueOf(false));
                thirdPartyService.setUrl(eccProfile.getServerUrl());
                this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyService((ThirdPartyService)thirdPartyService);
                EccUserCredential userCredential = new EccUserCredential();
                userCredential.setThirdPartyServiceId(thirdPartyService.getId());
                userCredential.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
                userCredential.setUsername(eccProfile.getUsername());
                userCredential.setPassword(eccProfile.getPassword());
                this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyUserCredential((ThirdPartyUserCredential)userCredential);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().dropEccProfilesTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testCollectionTable("");
            this.schedulerApplication.getSchedulerConfigurationDao().dropCollectionsTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testCollectionTemplateTable("");
            this.schedulerApplication.getSchedulerConfigurationDao().dropCollectionTemplatesTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    private void migrateOldRelativityServices() {
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testRelativityServicesTable("");
            LOGGER.info("Migrating old Relativity services to new Third-Party services");
            for (ThirdPartyService relativityService : this.schedulerApplication.getSchedulerConfigurationDao().getRelativityServices()) {
                this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyService(relativityService);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().dropRelativityServiceTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().testRelativityServiceUserCredentialsTable("");
            LOGGER.info("Migrating old Relativity services user credentials to new Third-Party services");
            try {
                this.schedulerApplication.getSchedulerConfigurationDao().updateRelativityServiceUserCredentialsTable_72_1a();
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ThirdPartyUserCredential relativityUserCredential : this.schedulerApplication.getSchedulerConfigurationDao().getRelativityServiceUserCredentials()) {
                this.schedulerApplication.getSchedulerConfigurationDao().addThirdPartyUserCredential(relativityUserCredential);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().dropRelativityServiceUserCredentialsTable();
        }
        catch (StatementException statementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateMicrosoftUserServices() {
        for (UserService userService : this.schedulerApplication.getUserServiceResource().getUserServices()) {
            if (userService.getUserServiceType() != UserServiceType.MICROSOFT || !Boolean.TRUE.equals(userService.getEnableCollections())) continue;
            MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
            this.schedulerApplication.getUserServiceResource().getOidcWellKnownConfigurationWorker(microsoftUserService.getId()).pingWellKnownConfiguration(this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(microsoftUserService.getId()));
            try {
                PurviewService purviewService = this.getMigratedPurviewService(microsoftUserService);
                try (Response response = this.addThirdPartyService(new SystemBearerUser(), SerializationUtils.toJson((Object)purviewService));){
                    if (response.getStatus() != 200) {
                        String error = ResourceUtils.getResponseErrorMessage((Response)response);
                        throw new IllegalStateException("Error creating migrated Purview Service, " + error);
                    }
                    ThirdPartyDetails details = (ThirdPartyDetails)SerializationUtils.fromJson((String)((String)response.getEntity()), ThirdPartyDetails.class);
                    purviewService = (PurviewService)details.getService();
                }
                if (microsoftUserService.getRefreshToken() == null || microsoftUserService.getRefreshToken().isEmpty()) continue;
                PurviewUserCredential userCredential = new PurviewUserCredential();
                userCredential.setUsername(microsoftUserService.getEDiscoveryManager());
                userCredential.setRefreshToken(microsoftUserService.getRefreshToken());
                this.addUserCredential((ThirdPartyService)purviewService, (ThirdPartyUserCredential)userCredential, new SystemBearerUser());
            }
            catch (Exception e) {
                LOGGER.error("Error migrating Microsoft Authentication Service to Purview Service: " + microsoftUserService.getName(), (Throwable)e);
            }
            finally {
                microsoftUserService.setEnableCollections(null);
                microsoftUserService.setRefreshToken(null);
                this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((UserService)microsoftUserService);
            }
        }
    }

    private PurviewService getMigratedPurviewService(MicrosoftUserService microsoftUserService) {
        PurviewService purviewService = new PurviewService();
        purviewService.setName(microsoftUserService.getName());
        purviewService.setDescription(microsoftUserService.getDescription());
        purviewService.setEnabled(microsoftUserService.getEnabled());
        purviewService.setAvailableByDefault(Boolean.valueOf(false));
        purviewService.setAuthenticationServiceId(microsoftUserService.getId());
        purviewService.setAuthenticationMethod(ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE);
        purviewService.setAuthenticationScope(ThirdPartyAuthenticationScope.SERVICE);
        return purviewService;
    }

    private ThirdPartyServiceSession<?, ?> createSession(String userId, ThirdPartyService thirdPartyService, ThirdPartyUserCredential userCredential) {
        ThirdPartyServiceSession session;
        int expireWarningThresholdHours = 0;
        if (thirdPartyService instanceof PurviewService) {
            session = new PurviewServiceSession(userId, (PurviewService)thirdPartyService, (PurviewUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getPurviewServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof RelativityService) {
            session = new RelativityServiceSession(userId, (RelativityService)thirdPartyService, (RelativityUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getRelativityServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof DiscoverService) {
            session = new DiscoverServiceSession(userId, (DiscoverService)thirdPartyService, (DiscoverUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getDiscoverServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof ElasticsearchService) {
            session = new ElasticsearchServiceSession(userId, (ElasticsearchService)thirdPartyService, (ElasticsearchUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getElasticsearchServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof NlpService) {
            session = new NlpServiceSession(userId, (NlpService)thirdPartyService, (NlpUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getNlpUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof EccService) {
            session = new EccServiceSession(userId, (EccService)thirdPartyService, (EccUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getEccServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof VaultService) {
            session = new VaultServiceSession(userId, (VaultService)thirdPartyService, (VaultUserCredential)userCredential, this.schedulerApplication);
            expireWarningThresholdHours = this.schedulerApplication.getConfiguration().getVaultServiceUserCredentialExpireWarningThreshold();
        } else if (thirdPartyService instanceof VeritoneService) {
            session = new VeritoneServiceSession(userId, (VeritoneService)thirdPartyService, (VeritoneUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof DerbyControlService) {
            session = new DerbyControlServiceSession(userId, (DerbyControlService)thirdPartyService, (JwtTokenUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof GraphService) {
            session = new GraphServiceSession(userId, (GraphService)thirdPartyService, (GraphUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof GenAiService) {
            session = new GenAiServiceSession(userId, (GenAiService)thirdPartyService, (GenAiUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof InvestigateService) {
            session = new InvestigateServiceSession(userId, (InvestigateService)thirdPartyService, (JwtTokenUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof SmtpService) {
            session = new SmtpServiceSession(userId, (SmtpService)thirdPartyService, (SmtpUserCredential)userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof LinkService) {
            session = new LinkServiceSession(userId, (LinkService)thirdPartyService, userCredential, this.schedulerApplication);
        } else if (thirdPartyService instanceof SemanticService) {
            session = new SemanticServiceSession(userId, (SemanticService)thirdPartyService, userCredential, this.schedulerApplication);
        } else {
            throw new IllegalArgumentException("Third-Party session not supported for type " + thirdPartyService.getClass().getSimpleName());
        }
        session.setExpireWarningThreshold((long)expireWarningThresholdHours * 60L * 1000L);
        return session;
    }

    private String patchThirdPartyServiceJson(String json) {
        json = json.replace("\"MemgraphGraphService\"", "\"GraphService\"");
        return json;
    }
}

