/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.workers.UserDataDirWatcher;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.userdatadir.FileInfo;
import com.nuix.automate.utils.models.api.userdatadir.UserDataDir;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/scheduler/resources/userDataDir")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserDataDirResource
extends Versionable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserDataDirResource.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final UserDataDirWatcher userDataDirWatcher;
    private UserDataDir userDataDir;

    public UserDataDirResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.userDataDirWatcher = new UserDataDirWatcher(updatedPaths -> {
            LOGGER.info("UserDataDir updated, resetting version");
            this.resetVersion();
        });
        this.initializeFromStore();
        this.resetVersion();
    }

    private void initializeFromStore() {
        LOGGER.info("Initializing User Data Dir from store");
        List<UserDataDir> userDataDirs = this.schedulerApplication.getSchedulerConfigurationDao().getUserDataDirs();
        if (!userDataDirs.isEmpty()) {
            if (this.getInstanceLicensed()) {
                this.userDataDir = userDataDirs.get(0);
                try {
                    this.userDataDirWatcher.start(this.userDataDir);
                }
                catch (IOException e) {
                    LOGGER.error("Error starting userDataDirWatcher", (Throwable)e);
                    this.userDataDir.getStatus().setError(iu.getFormattedString("UserDataDirWatcher.ErrorStartingWatcher", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
                }
            } else {
                this.userDataDir = null;
            }
        }
    }

    public boolean getInstanceLicensed() {
        try {
            LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
            LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
            licenceUtils.assertModuleLicensed(ModuleType.NEO_MANAGEMENT, false);
            return true;
        }
        catch (LicenceValidationException e) {
            this.userDataDir = new UserDataDir();
            this.userDataDir.setId(UidUtils.getRandom());
            this.userDataDir.getStatus().setError(e.getMessage());
            return false;
        }
    }

    public UserDataDir getUserDataDir() {
        return this.userDataDir;
    }

    public Map<String, FileInfo> getFileInfos() {
        return this.userDataDirWatcher.getFileInfoMap();
    }

    public boolean validateFileExists(String relativePath) {
        return Files.exists(Paths.get(this.userDataDir.getPath(), relativePath), new LinkOption[0]);
    }

    public Map<LibraryNuixFileType, Set<String>> getNuixProfileNames() {
        HashMap<LibraryNuixFileType, Set<String>> typeToProfiles = new HashMap<LibraryNuixFileType, Set<String>>();
        if (this.userDataDir != null) {
            for (FileInfo fileInfo : this.userDataDirWatcher.getFileInfoMap().values()) {
                if (!LibraryNuixFileType.isNuixProfileType((LibraryNuixFileType)fileInfo.getFileType())) continue;
                Set profileNames = typeToProfiles.computeIfAbsent(fileInfo.getFileType(), k -> new HashSet());
                profileNames.add(fileInfo.getName());
            }
        }
        return typeToProfiles;
    }

    @Operation(tags={"UserDataDir"}, operationId="GetUserDataDir", summary="Get User Data Dir", description="Get user data dir", responses={@ApiResponse(description="User data dir", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserDataDir.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getUserDataDir(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        UserDataDir result;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        UserDataDir allowedUserDataDir = null;
        if (this.userDataDir != null && (result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.userDataDir)).getUserPermissions().contains(Permission.VIEW)) {
            allowedUserDataDir = result;
        }
        String lastHash = ResponseCache.getInstance().hashObject(allowedUserDataDir);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)allowedUserDataDir).build();
        }
    }

    @Operation(tags={"UserDataDir"}, operationId="GetUserDataDirFiles", summary="Get User Data Dir Files", description="Get the files in the user data dir", responses={@ApiResponse(description="User data dir files", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileInfo.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/files")
    @GET
    public Response getUserDataDirFiles(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        UserDataDir result;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        if (this.userDataDir != null && (result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.userDataDir)).getUserPermissions().contains(Permission.VIEW)) {
            fileInfos.addAll(this.userDataDirWatcher.getFileInfos());
        }
        fileInfos.sort(Comparator.comparing(FileInfo::getFileType, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(FileInfo::getRelativePath, Comparator.nullsLast(Comparator.naturalOrder())));
        String lastHash = ResponseCache.getInstance().hashObject(fileInfos);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(fileInfos).build();
        }
    }

    @Operation(tags={"UserDataDir"}, operationId="UpdateUserDataDirPath", summary="Update User Data Dir Path", description="Update the user data dir path", responses={@ApiResponse(description="The updated User Data Dir", content={@Content(schema=@Schema(implementation=UserDataDir.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    public Response updateUserDataDir(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The updated userDataDir") UserDataDir updatedUserDataDir) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (this.userDataDir == null) {
            this.userDataDir = new UserDataDir();
            this.userDataDir.setId(UidUtils.getRandom());
        }
        if (this.getInstanceLicensed()) {
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_DATA_DIR));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)"");
            }
            try {
                java.nio.file.Path dirPath = Paths.get(updatedUserDataDir.getPath(), new String[0]).toAbsolutePath().normalize();
                LOGGER.info("UserDataDir setting to: " + String.valueOf(dirPath));
                updatedUserDataDir.setPath(dirPath.toString());
                this.validateUserDataDirPath(updatedUserDataDir.getPath());
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
            catch (IOException e) {
                return ExceptionUtils.toResponse((String)"userDataDirIoError", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (this.userDataDir == null) {
                this.userDataDir = new UserDataDir();
                this.userDataDir.setId(UidUtils.getRandom());
            }
            this.userDataDir.setPath(updatedUserDataDir.getPath());
            if (this.schedulerApplication.getSchedulerConfigurationDao().updateUserDataDir(this.userDataDir) == 0) {
                this.schedulerApplication.getSchedulerConfigurationDao().addUserDataDir(this.userDataDir);
            }
            try {
                this.userDataDirWatcher.start(this.userDataDir);
                this.resetVersion();
            }
            catch (IOException e) {
                LOGGER.error("Error starting userDataDirWatcher", (Throwable)e);
                this.userDataDir.getStatus().setError(iu.getFormattedString("UserDataDirWatcher.ErrorStartingWatcher", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            }
            UserDataDir eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.userDataDir);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.USER_DATA_DIR_UPDATED, eventResult, user.getName());
        }
        UserDataDir result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.userDataDir);
        if (this.userDataDir.getStatus() != null && this.userDataDir.getStatus().getCode().equals((Object)State.ERROR)) {
            String message = this.userDataDir.getStatus().getMessage();
            this.userDataDir = null;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)message).build();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"UserDataDir"}, operationId="RemoveUserDataDir", summary="Remove User Data Dir", description="Remove the user data dir path")
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{id}")
    @DELETE
    public Response removeUserDataDir(@Parameter(hidden=true) @Auth BearerUser user, @PathParam(value="id") String userDataDirId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_DATA_DIR));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)"");
        }
        if (this.userDataDir != null && userDataDirId.equals(this.userDataDir.getId())) {
            LOGGER.info("UserDataDir deleting");
            this.schedulerApplication.getSchedulerConfigurationDao().deleteUserDataDir(userDataDirId);
            this.userDataDir = null;
            this.resetVersion();
            try {
                this.userDataDirWatcher.close();
            }
            catch (IOException e) {
                LOGGER.error("Error closing userDataDirWatcher", (Throwable)e);
            }
        } else {
            return ExceptionUtils.toResponse((String)"invalidUserDataDir", (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.USER_DATA_DIR_REMOVED, "", user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void validateUserDataDirPath(final String dirPath) throws ResponseException, IOException {
        java.nio.file.Path dir;
        try {
            dir = Paths.get(dirPath, new String[0]);
        }
        catch (Exception e) {
            throw new ResponseException(ExceptionUtils.toResponse((String)"userDataDirInvalidPath", (Map)new HashMap<String, String>(){
                {
                    this.put("path", dirPath);
                }
            }));
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new ResponseException(ExceptionUtils.toResponse((String)"userDataDirPathDoesNotExist", (Map)new HashMap<String, String>(){
                {
                    this.put("path", dirPath);
                }
            }));
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new ResponseException(ExceptionUtils.toResponse((String)"userDataDirPathNotADirectory", (Map)new HashMap<String, String>(){
                {
                    this.put("path", dirPath);
                }
            }));
        }
    }
}

