/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import au.com.bytecode.opencsv.CSVWriter;
import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.AuthType;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.security.internal.InternalCredentialsConfiguration;
import com.nuix.automate.scheduler.security.ldap.LdapClient;
import com.nuix.automate.scheduler.security.managed.ManagedServiceUtil;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.GenericOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.OidcConfig;
import com.nuix.automate.scheduler.security.oidc.google.GoogleOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftConfig;
import com.nuix.automate.scheduler.security.ums.UmsUtil;
import com.nuix.automate.scheduler.workers.GoogleUserServiceWorker;
import com.nuix.automate.scheduler.workers.LdapUserServiceWorker;
import com.nuix.automate.scheduler.workers.MicrosoftUserServiceWorker;
import com.nuix.automate.scheduler.workers.OidcWellKnownConfigurationWorker;
import com.nuix.automate.scheduler.workers.UserServiceWorker;
import com.nuix.automate.utils.api.automatelicense.FileContents;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.paging.FilteredResult;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.ecc.internal.UserComputerMapping;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizableEnumUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldParticipation;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.user.LoginLinkScope;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.user.UserServiceType;
import com.nuix.automate.utils.models.api.userservice.GoogleChatSpace;
import com.nuix.automate.utils.models.api.userservice.GoogleDrive;
import com.nuix.automate.utils.models.api.userservice.GoogleGroup;
import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.api.userservice.LdapComputer;
import com.nuix.automate.utils.models.api.userservice.LdapUserServiceSubmission;
import com.nuix.automate.utils.models.api.userservice.LdapUserServiceUpdateSubmission;
import com.nuix.automate.utils.models.api.userservice.MicrosoftSharePointSite;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUnifiedGroup;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUserServiceSubmission;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUserServiceUpdateSubmission;
import com.nuix.automate.utils.models.api.userservice.OidcUserServiceSubmission;
import com.nuix.automate.utils.models.api.userservice.OidcUserServiceUpdateSubmission;
import com.nuix.automate.utils.models.api.userservice.RelativityUserImpersonationServiceSubmission;
import com.nuix.automate.utils.models.api.userservice.RelativityUserImpersonationServiceUpdateSubmission;
import com.nuix.automate.utils.models.api.userservice.UmsUserServiceSubmission;
import com.nuix.automate.utils.models.api.userservice.UmsUserServiceUpdateSubmission;
import com.nuix.automate.utils.models.api.userservice.UpdateUsersResponse;
import com.nuix.automate.utils.models.api.userservice.UserService;
import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.InternalUserService;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.ManagedUserService;
import com.nuix.automate.utils.models.internal.user.MicrosoftOAuthVersion;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.OidcUserServiceType;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserRecord;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/users")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserServiceResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserServiceResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, UserAccount> users;
    private final Map<UserServiceObjectType, CachedObjectMap<Map<String, ? extends UserServiceObject>>> typeToCachedObjectMap;
    private final Map<String, com.nuix.automate.utils.models.internal.user.UserService> userServices;
    private final Map<String, UserServiceWorker> userServiceWorkers;
    private final Map<String, UserServiceClient> userServiceClients;
    private final Map<String, OidcWellKnownConfigurationWorker> wellKnownConfigurationWorkers;

    public UserServiceResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.users = new ConcurrentHashMap<String, UserAccount>();
        this.userServices = new ConcurrentHashMap<String, com.nuix.automate.utils.models.internal.user.UserService>();
        this.userServiceWorkers = new ConcurrentHashMap<String, UserServiceWorker>();
        this.userServiceClients = new ConcurrentHashMap<String, UserServiceClient>();
        this.wellKnownConfigurationWorkers = new ConcurrentHashMap<String, OidcWellKnownConfigurationWorker>();
        this.typeToCachedObjectMap = new ConcurrentHashMap<UserServiceObjectType, CachedObjectMap<Map<String, ? extends UserServiceObject>>>();
        long cacheLifeTimeSeconds = schedulerApplication.getConfiguration().getUserServiceObjectsCacheLifeTimeSeconds();
        for (UserServiceObjectType type : UserServiceObjectType.values()) {
            this.typeToCachedObjectMap.put(type, (CachedObjectMap<Map<String, ? extends UserServiceObject>>)new CachedObjectMap(cacheLifeTimeSeconds * 1000L));
        }
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(this::clearExpiredUserServiceObjectCache, cacheLifeTimeSeconds, cacheLifeTimeSeconds / 2L, TimeUnit.SECONDS);
    }

    public void initializeUsersFromStore() {
        LOGGER.info("Initializing Users from store");
        List<UserAccount> userAccounts = this.schedulerApplication.getUsersDao().getUsers();
        for (UserAccount userAccount : userAccounts) {
            if (userAccount.getPlatform().equals((Object)UserAccountPlatform.INTERNAL)) continue;
            this.users.put(userAccount.getId(), userAccount);
        }
    }

    public void initializeUserServicesFromStore() {
        LOGGER.info("Initializing Authentication Services from store");
        List<com.nuix.automate.utils.models.internal.user.UserService> userServices = this.schedulerApplication.getSchedulerConfigurationDao().getUserServices();
        block18: for (com.nuix.automate.utils.models.internal.user.UserService userService : userServices) {
            userService.getStatus().reset();
            FormattingUtils.trimAllStrings((Object)userService);
            if (userService.getUserServiceType() == UserServiceType.MICROSOFT && ((MicrosoftUserService)userService).getOidcUserServiceType() != null) {
                ((MicrosoftUserService)userService).setOidcUserServiceType(null);
                this.schedulerApplication.getSchedulerConfigurationDao().updateUserService(userService);
            }
            UserServiceClient client = null;
            UserServiceWorker worker = null;
            switch (userService.getUserServiceType()) {
                case LDAP: {
                    LdapUserService ldapUserService = (LdapUserService)userService;
                    if (userService.isSynchronizeActive() && (ldapUserService.getServiceAccountPassword() == null || ldapUserService.getServiceAccountPassword().trim().length() == 0)) {
                        ldapUserService.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
                    }
                    try {
                        client = new LdapClient(ldapUserService);
                        if (ldapUserService.getEnabled() == Boolean.TRUE) {
                            this.schedulerApplication.getAuthScopeTypes().put(ldapUserService.getName(), AuthType.LDAP);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        LOGGER.error("Unable to create LDAP Client for " + ldapUserService.getName(), (Throwable)e);
                    }
                    worker = new LdapUserServiceWorker(this.schedulerApplication, ldapUserService);
                    break;
                }
                case UMS: {
                    UmsUserService umsUserService = (UmsUserService)userService;
                    if (userService.isSynchronizeActive() && (umsUserService.getServiceAccountPassword() == null || umsUserService.getServiceAccountPassword().trim().length() == 0)) {
                        umsUserService.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
                    }
                    try {
                        client = new UmsUtil(umsUserService);
                        if (umsUserService.getEnabled() != Boolean.TRUE) break;
                        this.schedulerApplication.getAuthScopeTypes().put(umsUserService.getName(), AuthType.UMS);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create UMS Client for " + umsUserService.getName(), (Throwable)e);
                    }
                    break;
                }
                case MANAGED: {
                    ManagedUserService managedUserService = (ManagedUserService)userService;
                    try {
                        client = new ManagedServiceUtil(managedUserService);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create UMS Client for " + managedUserService.getName(), (Throwable)e);
                    }
                    break;
                }
                case OIDC: {
                    OidcUserService oidcUserService = (OidcUserService)userService;
                    if (oidcUserService.getEnableAuthorizationCodeFlow() == null) {
                        oidcUserService.setEnableAuthorizationCodeFlow(Boolean.valueOf(true));
                    }
                    if (oidcUserService.getEnableJwtAccessToken() == null) {
                        oidcUserService.setEnableJwtAccessToken(Boolean.valueOf(true));
                    }
                    if (oidcUserService.getLinkProfilesWithSyncedUsers() == null) {
                        oidcUserService.setLinkProfilesWithSyncedUsers(Boolean.valueOf(false));
                    }
                    if (oidcUserService.getDefaultAuthenticationProvider() == null) {
                        oidcUserService.setDefaultAuthenticationProvider(Boolean.valueOf(false));
                    }
                    try {
                        client = oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE ? new GoogleOidcUserServiceClient(this.schedulerApplication, oidcUserService) : new GenericOidcUserServiceClient(this.schedulerApplication, oidcUserService);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create OIDC Client for " + oidcUserService.getName(), (Throwable)e);
                    }
                    if (oidcUserService.getAuthMethodType() != AuthMethodType.OIDC_GOOGLE) break;
                    worker = new GoogleUserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
                    break;
                }
                case MICROSOFT: {
                    MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
                    try {
                        client = new MicrosoftOidcUserServiceClient(this.schedulerApplication, microsoftUserService);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create Microsoft OIDC Client for " + microsoftUserService.getName(), (Throwable)e);
                    }
                    worker = new MicrosoftUserServiceWorker(this.schedulerApplication, microsoftUserService);
                    break;
                }
                case RELATIVITY_IMPERSONATION: {
                    RelativityUserImpersonationService relativityUserImpersonationService = (RelativityUserImpersonationService)userService;
                    if (relativityUserImpersonationService.getSecret() != null && relativityUserImpersonationService.getSecret().trim().length() != 0) break;
                    relativityUserImpersonationService.getStatus().setError(this.iu.getString("UserService.SecretInaccessible"));
                    break;
                }
                default: {
                    continue block18;
                }
            }
            this.userServices.put(userService.getId(), userService);
            if (client == null) continue;
            this.userServiceClients.put(userService.getId(), client);
            if (userService instanceof OidcUserService) {
                this.wellKnownConfigurationWorkers.put(userService.getId(), new OidcWellKnownConfigurationWorker(this.schedulerApplication, (OidcUserService)userService));
            }
            if (worker == null) {
                worker = new UserServiceWorker(this.schedulerApplication, userService);
            }
            this.userServiceWorkers.put(userService.getId(), worker);
        }
    }

    public void setGoogleVaultServiceMissingWarningsToUserServices() {
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            this.setWarningIfMissingGoogleVaultServiceForSync(userService);
        }
    }

    private void setWarningIfMissingGoogleVaultServiceForSync(com.nuix.automate.utils.models.internal.user.UserService userService) {
        String warningMessage = null;
        if (userService instanceof OidcUserService && userService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE) {
            GoogleOidcUserServiceClient oidcClient;
            if (userService.isSynchronizeActive() && ((oidcClient = (GoogleOidcUserServiceClient)this.userServiceClients.get(userService.getId())) == null || oidcClient.getFirstThirdPartyServiceSession() == null)) {
                warningMessage = this.iu.getFormattedString("OidcGoogleUserService.MissingRequiredGoogleVaultService", new Object[0]);
            }
            if (warningMessage != null) {
                userService.getWarningStatus().setWarningMessage(warningMessage);
            } else {
                userService.getWarningStatus().reset();
                this.resetUserServiceWellKnownConfigurationWorker(userService);
            }
        }
    }

    private void resetUserServiceWellKnownConfigurationWorker(com.nuix.automate.utils.models.internal.user.UserService userService) {
        if (userService instanceof OidcUserService) {
            OidcWellKnownConfigurationWorker worker = this.wellKnownConfigurationWorkers.remove(userService.getId());
            if (worker != null) {
                try {
                    worker.close();
                }
                catch (IOException e) {
                    LOGGER.error("Cannot close worker, ", (Throwable)e);
                }
            }
            this.wellKnownConfigurationWorkers.put(userService.getId(), new OidcWellKnownConfigurationWorker(this.schedulerApplication, (OidcUserService)userService));
        }
    }

    public void triggerGoogleOidcSynchronization(String userServiceId) {
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (!(userService instanceof OidcUserService) || userService.getAuthMethodType() != AuthMethodType.OIDC_GOOGLE) {
            return;
        }
        if (!Boolean.TRUE.equals(userService.getSynchronizeUsers()) && !Boolean.TRUE.equals(userService.getSynchronizeObjects())) {
            return;
        }
        GoogleOidcUserServiceClient oidcClient = (GoogleOidcUserServiceClient)this.userServiceClients.get(userService.getId());
        if (oidcClient != null && oidcClient.getFirstThirdPartyServiceSession() != null) {
            this.userServiceWorkers.get(userServiceId).tryRun();
            userService.getWarningStatus().reset();
            this.resetUserServiceWellKnownConfigurationWorker(userService);
        }
    }

    public void initializeUserServicesFromConfiguration() {
        block6: {
            try {
                Set<String> existingNames = this.getUserServiceNames("");
                if (this.schedulerApplication.getConfiguration().getOidc() == null) break block6;
                OidcConfig oidc = this.schedulerApplication.getConfiguration().getOidc();
                OidcUserService oidcUserService = new OidcUserService();
                oidcUserService.setReadOnly(true);
                oidcUserService.setEnabled(Boolean.valueOf(true));
                oidcUserService.setDescription(oidc.getDescription());
                oidcUserService.setUserServiceType(UserServiceType.OIDC);
                oidcUserService.setOidcUserServiceType(OidcUserServiceType.GENERIC);
                oidcUserService.setId("10009291-ab9b-4a4d-a6c7-356658be58c0");
                oidcUserService.setName(oidc.getDisplayName());
                oidcUserService.setSynchronizeUsers(Boolean.valueOf(false));
                oidcUserService.setSynchronizeComputers(Boolean.valueOf(false));
                oidcUserService.setEnableAuthentication(Boolean.valueOf(true));
                oidcUserService.setEnableJwtAccessToken(Boolean.valueOf(oidc.getEnableJwtAccessToken()));
                oidcUserService.setDefaultAuthenticationProvider(Boolean.valueOf(oidc.getDefaultAuthenticationProvider()));
                oidcUserService.setEnableAuthorizationCodeFlow(Boolean.valueOf(oidc.getEnableAuthorizationCodeFlow()));
                oidcUserService.setLinkProfilesWithSyncedUsers(Boolean.valueOf(true));
                if (!existingNames.contains(oidcUserService.getName())) {
                    oidcUserService.setWellKnownConfiguration(oidc.getWellKnownConfigurationUri());
                    oidcUserService.setClientId(oidc.getClientId());
                    oidcUserService.setClientSecret(oidc.getClientSecret());
                    oidcUserService.setScope(oidc.getScope());
                    oidcUserService.setUsernameClaim(oidc.getUsernameClaim());
                    oidcUserService.setGroupClaim(oidc.getGroupClaim());
                    oidcUserService.getStatus().reset();
                    this.userServices.put(oidcUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
                    try {
                        this.wellKnownConfigurationWorkers.put(oidcUserService.getId(), new OidcWellKnownConfigurationWorker(this.schedulerApplication, oidcUserService));
                        if (oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE) {
                            this.userServiceClients.put(oidcUserService.getId(), new GoogleOidcUserServiceClient(this.schedulerApplication, oidcUserService));
                            this.userServiceWorkers.put(oidcUserService.getId(), new GoogleUserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService));
                            break block6;
                        }
                        this.userServiceClients.put(oidcUserService.getId(), new GenericOidcUserServiceClient(this.schedulerApplication, oidcUserService));
                        this.userServiceWorkers.put(oidcUserService.getId(), new UserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService));
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create OIDC Client for " + oidcUserService.getName(), (Throwable)e);
                    }
                    break block6;
                }
                LOGGER.error("Unable to create OIDC Service with name " + oidcUserService.getName() + " because another user service with the same name already exists");
            }
            catch (Exception e) {
                LOGGER.error("Unable to initialize OIDC authentication service", (Throwable)e);
            }
        }
    }

    public void migrateUserServicesFromConfiguration() {
        block5: {
            LOGGER.info("Migrating OIDC configuration to Authentication Services");
            boolean allowedOidcUserServices = this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
            int oidcUserServicesCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.OIDC);
            Set<String> existingNames = this.getUserServiceNames("");
            try {
                if (this.schedulerApplication.getConfiguration().getOidcMicrosoft() == null) break block5;
                OidcMicrosoftConfig oidc = this.schedulerApplication.getConfiguration().getOidcMicrosoft();
                MicrosoftUserService microsoftUserService = new MicrosoftUserService();
                microsoftUserService.setUserServiceType(UserServiceType.MICROSOFT);
                microsoftUserService.setId(UidUtils.getRandom());
                microsoftUserService.setName("Microsoft");
                microsoftUserService.setSynchronizeUsers(false);
                microsoftUserService.setSynchronizeComputers(false);
                if (existingNames.contains("Microsoft")) {
                    microsoftUserService.setName("Microsoft " + UidUtils.getShortId((String)UidUtils.getRandom()));
                }
                microsoftUserService.setTenant(oidc.getTenant());
                microsoftUserService.setClientId(oidc.getClientId());
                microsoftUserService.setClientSecret(oidc.getClientSecret());
                microsoftUserService.setScope("openid " + microsoftUserService.getGraphUrl() + "/user.read offline_access");
                microsoftUserService.setoAuthVersion(MicrosoftOAuthVersion.V1);
                boolean enabled = allowedOidcUserServices || oidcUserServicesCount == 0;
                microsoftUserService.setEnabled(enabled);
                microsoftUserService.getStatus().reset();
                microsoftUserService.setEnableAuthentication(true);
                this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)microsoftUserService);
                this.userServices.put(microsoftUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)microsoftUserService);
                existingNames.add(microsoftUserService.getName());
                try {
                    this.userServiceClients.put(microsoftUserService.getId(), new MicrosoftOidcUserServiceClient(this.schedulerApplication, microsoftUserService));
                    this.wellKnownConfigurationWorkers.put(microsoftUserService.getId(), new OidcWellKnownConfigurationWorker(this.schedulerApplication, microsoftUserService));
                    this.userServiceWorkers.put(microsoftUserService.getId(), new MicrosoftUserServiceWorker(this.schedulerApplication, microsoftUserService));
                }
                catch (Exception e) {
                    LOGGER.error("Unable to create Microsoft Client for " + microsoftUserService.getName(), (Throwable)e);
                }
                ++oidcUserServicesCount;
            }
            catch (Exception e) {
                LOGGER.error("Unable to migrate Microsoft OIDC authentication service", (Throwable)e);
            }
        }
        this.schedulerApplication.getSettingsResource().setOidcMigrated();
    }

    public UserServiceWorker getUserServiceWorker(String userServiceId) {
        return this.userServiceWorkers.get(userServiceId);
    }

    public boolean getUserAndServiceIsEnabled(String userId) {
        UserAccount user = this.getUser(userId);
        return this.getUserAndServiceIsEnabled(user);
    }

    public boolean getUserAndServiceIsEnabled(UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        com.nuix.automate.utils.models.internal.user.UserService userService = this.getUserService(userAccount.getUserServiceId());
        return userAccount.getUserAccountState() == UserAccountState.ACTIVE && userService != null && userService.getEnabled() != false;
    }

    public boolean getUserAndServiceIsEnabledOrInactive(String userId) {
        UserAccount user = this.getUser(userId);
        return this.getUserAndServiceIsEnabledOrInactive(user);
    }

    public boolean getUserAndServiceIsEnabledOrInactive(UserAccount userAccount) {
        if (userAccount == null) {
            return false;
        }
        com.nuix.automate.utils.models.internal.user.UserService userService = this.getUserService(userAccount.getUserServiceId());
        return (userAccount.getUserAccountState() == UserAccountState.ACTIVE || userAccount.getUserAccountState() == UserAccountState.INACTIVE || userAccount.getUserAccountState() == UserAccountState.DELETED) && userService != null && userService.getEnabled() != false;
    }

    public UserAccount getUser(String userId) {
        UserAccount user = this.users.get(userId);
        if (user == null) {
            user = this.getInternalUserAccounts().get(userId);
        }
        return user;
    }

    public UserAccount getUserWithEmail(String email) {
        for (UserAccount user : this.users.values()) {
            if (!email.equalsIgnoreCase(user.getEmail())) continue;
            return user;
        }
        return null;
    }

    public Map<String, UserAccount> getUsers() {
        return this.users;
    }

    public List<UserAccount> getUsers(String userServiceId) {
        return this.users.values().stream().filter(user -> user.getUserAccountState() == UserAccountState.ACTIVE && userServiceId.equals(user.getUserServiceId())).collect(Collectors.toList());
    }

    public synchronized <T extends UserServiceObject> T getUserServiceObject(UserServiceObjectType type, String userServiceId, String key) {
        Map<String, T> objectsCachedMap = this.getUserServiceObjects(type, userServiceId);
        return (T)((UserServiceObject)objectsCachedMap.get(key));
    }

    public synchronized <T extends UserServiceObject> Map<String, T> getUserServiceObjects(UserServiceObjectType type, String userServiceId) {
        CachedObjectMap<Map<String, ? extends UserServiceObject>> cachedObjectMap = this.typeToCachedObjectMap.get(type);
        HashMap<String, UserServiceObject> objects = (HashMap<String, UserServiceObject>)cachedObjectMap.get(userServiceId);
        if (objects == null) {
            objects = new HashMap<String, UserServiceObject>();
            cachedObjectMap.put(userServiceId, objects);
            for (UserServiceObject userServiceObject : this.schedulerApplication.getUsersDao().getUserServiceObjects(userServiceId, type)) {
                objects.put(userServiceObject.getId(), userServiceObject);
            }
        }
        return objects;
    }

    public <T extends UserServiceObject> Map<String, T> getAllUserServiceObjects(UserServiceObjectType objectType) {
        HashMap<String, T> userServiceObjects = new HashMap<String, T>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            userServiceObjects.putAll(this.getUserServiceObjects(objectType, userService.getId()));
        }
        return userServiceObjects;
    }

    private void clearExpiredUserServiceObjectCache() {
        for (CachedObjectMap<Map<String, ? extends UserServiceObject>> cachedObjectMap : this.typeToCachedObjectMap.values()) {
            cachedObjectMap.clearExpired();
        }
    }

    private Map<String, UserAccount> getInternalUserAccounts() {
        HashMap<String, UserAccount> internalUsers = new HashMap<String, UserAccount>();
        InternalCredentialsConfiguration internalCredentials = this.schedulerApplication.getConfiguration().getInternalCredentials();
        if (internalCredentials != null) {
            for (UserAccount userAccount : internalCredentials.getUserAccounts()) {
                internalUsers.put(userAccount.getId(), userAccount);
            }
        }
        return internalUsers;
    }

    public Map<String, UserAccount> getImmutableUsers() {
        HashMap<String, UserAccount> allUsers = new HashMap<String, UserAccount>(this.users);
        allUsers.putAll(this.getInternalUserAccounts());
        return allUsers;
    }

    public List<UserAccount> getUserServiceUsers(String userServiceId) {
        return this.users.values().stream().filter(userAccount -> userServiceId.equals(userAccount.getUserServiceId())).collect(Collectors.toCollection(ArrayList::new));
    }

    @GET
    @Path(value="/{type}/submitters")
    public Response listUsers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The model type") @PathParam(value="type") String type) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list users");
        }
        HashSet<String> userNamesSet = new HashSet<String>();
        userNamesSet.add(user.getName());
        if (type.equalsIgnoreCase("job")) {
            for (Job jobModel : this.schedulerApplication.getJobResource().getJobsVisibleBy(user)) {
                if (jobModel.getSubmittedBy() != null) {
                    userNamesSet.add(jobModel.getSubmittedBy());
                }
                if (jobModel.getStagedBy() != null) {
                    userNamesSet.add(jobModel.getStagedBy());
                }
                if (jobModel.getModifiedBy() == null) continue;
                userNamesSet.add(jobModel.getModifiedBy());
            }
        }
        ArrayList userNames = new ArrayList(userNamesSet);
        userNames.sort(String::compareToIgnoreCase);
        for (String username : userNames) {
            this.schedulerApplication.getMediaResources().getUserImageWorker().getUserImage(user, username);
        }
        String lastHash = ResponseCache.getInstance().hashObject(userNames);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).header("ETag", (Object)lastHash).entity(userNames).build();
        }
    }

    public Set<String> getUserSyncEnabledUserServiceIds() {
        HashSet<String> userSyncEnabledUserServiceIds = new HashSet<String>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (!userService.isUserSynchronizeActive()) continue;
            userSyncEnabledUserServiceIds.add(userService.getId());
        }
        com.nuix.automate.utils.models.internal.user.UserService internalUserService = this.getInternalUserService();
        if (internalUserService.isUserSynchronizeActive()) {
            userSyncEnabledUserServiceIds.add(internalUserService.getId());
        }
        return userSyncEnabledUserServiceIds;
    }

    @Operation(tags={"Users"}, operationId="GetUsers", summary="Get Users", description="Get list of users available from the various configured platforms", responses={@ApiResponse(description="The list of users", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserAccount.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getUsers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="Include disabled users") @QueryParam(value="disabled") boolean includeDisabled) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.USERS);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Object legalHoldAdminUserIds;
            boolean isAllowedAll = false;
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
            if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
                isAllowedAll = true;
            }
            Set<String> userSyncEnabledUserServiceIds = this.getUserSyncEnabledUserServiceIds();
            Set<String> allowedAuthenticationServiceIds = this.schedulerApplication.getSecurityPolicyUtil().getAllowedAuthenticationServiceIds(user.getIdentifiers(), Permission.VIEW, includeDisabled);
            HashSet<String> legalHoldUserIds = new HashSet<String>();
            if (!isAllowedAll && this.schedulerApplication.getConfiguration().getReturnUsersFromRelatedLegalHolds()) {
                Set<String> legalHoldParticipantUserIds = this.schedulerApplication.getLegalHoldUtils().getUserIdsOfLegalHoldsAdminOf(user.getId());
                legalHoldAdminUserIds = this.schedulerApplication.getLegalHoldUtils().getAdminIdsOfLegalHoldsMemberOf(user.getId());
                legalHoldUserIds.addAll(legalHoldParticipantUserIds);
                legalHoldUserIds.addAll((Collection<String>)legalHoldAdminUserIds);
            }
            HashSet<UserAccount> userSet = new HashSet<UserAccount>();
            legalHoldAdminUserIds = this.getImmutableUsers().values().iterator();
            while (legalHoldAdminUserIds.hasNext()) {
                UserAccount userAccount;
                UserAccount cloneAccount = userAccount = legalHoldAdminUserIds.next();
                boolean isAllowedUser = isAllowedAll;
                if (!isAllowedUser && (allowedAuthenticationServiceIds.contains(cloneAccount.getUserServiceId()) || legalHoldUserIds.contains(cloneAccount.getId()))) {
                    isAllowedUser = true;
                }
                if (!isAllowedUser) continue;
                UserAccount effectiveUserAccount = userAccount;
                boolean userIsActiveOrInactive = UserAccountState.ACTIVE.equals((Object)userAccount.getUserAccountState()) || UserAccountState.INACTIVE.equals((Object)userAccount.getUserAccountState());
                boolean accountCloned = false;
                if (userIsActiveOrInactive && (userAccount.getUserServiceId() == null || !userSyncEnabledUserServiceIds.contains(userAccount.getUserServiceId()))) {
                    cloneAccount = userAccount.clone();
                    cloneAccount.setUserAccountState(UserAccountState.DELETED);
                    effectiveUserAccount = cloneAccount;
                    accountCloned = true;
                }
                if (!includeDisabled && !UserAccountState.ACTIVE.equals((Object)userAccount.getUserAccountState()) && (!UserAccountState.DELETED.equals((Object)userAccount.getUserAccountState()) || !this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId()).getIncludeDeletedUsers().booleanValue()) && (!UserAccountState.INACTIVE.equals((Object)userAccount.getUserAccountState()) || !this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId()).getIncludeInactiveUsers().booleanValue())) continue;
                effectiveUserAccount = this.renderNameSuffixEmailPrefixFromStatus(effectiveUserAccount);
                userSet.add(effectiveUserAccount);
            }
            UserAccount currentUser = this.getUser(user.getId());
            if (currentUser != null) {
                userSet.add(currentUser);
            }
            ArrayList response = new ArrayList(userSet);
            response.sort(UserAccount::compareTo);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).entity(response).build();
        }
    }

    @Operation(tags={"Users"}, operationId="TestLDAPAuthenticationService", summary="Test LDAP Authentication Service", responses={@ApiResponse(description="The test status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userService/ldap/test")
    @PUT
    public Response testLdapUserServiceEdit(@Parameter(hidden=true) @Auth BearerUser user, LdapUserService ldapUserService) {
        ldapUserService.setUserServiceType(UserServiceType.LDAP);
        ldapUserService.normalize();
        return this.testUserServiceEdit(user, (com.nuix.automate.utils.models.internal.user.UserService)ldapUserService);
    }

    @Operation(tags={"Users"}, operationId="TestUMSAuthenticationService", summary="Test UMS Authentication Service", responses={@ApiResponse(description="The test status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userService/ums/test")
    @PUT
    public Response testUmsUserServiceEdit(@Parameter(hidden=true) @Auth BearerUser user, UmsUserService umsUserService) {
        umsUserService.setUserServiceType(UserServiceType.UMS);
        umsUserService.normalize();
        return this.testUserServiceEdit(user, (com.nuix.automate.utils.models.internal.user.UserService)umsUserService);
    }

    @Operation(tags={"Users"}, operationId="TestMicrosoftMicrosoftAuthenticationService", summary="Test Microsoft Authentication Service", responses={@ApiResponse(description="The test status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userService/microsoft/test")
    @PUT
    public Response testMicrosoftUserServiceEdit(@Parameter(hidden=true) @Auth BearerUser user, MicrosoftUserService microsoftUserService) {
        microsoftUserService.setUserServiceType(UserServiceType.MICROSOFT);
        microsoftUserService.normalize();
        return this.testUserServiceEdit(user, (com.nuix.automate.utils.models.internal.user.UserService)microsoftUserService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response testUserServiceEdit(BearerUser user, com.nuix.automate.utils.models.internal.user.UserService userService) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        try {
            com.nuix.automate.utils.models.internal.user.UserService originalUserService;
            if (userService.getId() != null && (originalUserService = this.userServices.get(userService.getId())) != null && originalUserService.isSameScope(userService)) {
                if (userService instanceof LdapUserService) {
                    ((LdapUserService)userService).setServiceAccountPassword(((LdapUserService)originalUserService).getServiceAccountPassword());
                }
                if (userService instanceof UmsUserService) {
                    ((UmsUserService)userService).setServiceAccountPassword(((UmsUserService)originalUserService).getServiceAccountPassword());
                }
                if (userService instanceof OidcUserService) {
                    ((OidcUserService)userService).setClientSecret(((OidcUserService)originalUserService).getClientSecret());
                }
            }
            UserServiceClient userServiceClient = null;
            OidcWellKnownConfigurationWorker worker = null;
            try {
                Response response;
                switch (userService.getUserServiceType()) {
                    case UMS: {
                        userServiceClient = new UmsUtil((UmsUserService)userService);
                        break;
                    }
                    case LDAP: {
                        userServiceClient = new LdapClient((LdapUserService)userService);
                        break;
                    }
                    case MICROSOFT: {
                        MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
                        userServiceClient = new MicrosoftOidcUserServiceClient(this.schedulerApplication, microsoftUserService);
                        worker = new OidcWellKnownConfigurationWorker(this.schedulerApplication, microsoftUserService);
                        worker.pingWellKnownConfiguration((OidcUserServiceClient)userServiceClient);
                        break;
                    }
                }
                if (userServiceClient == null) {
                    response = ExceptionUtils.toResponse((String)"cantTestUserService");
                    return response;
                }
                response = this.testUserService(userService, userServiceClient);
                return response;
            }
            finally {
                if (userServiceClient != null) {
                    userServiceClient.close();
                }
                if (worker != null) {
                    worker.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(userService.getUserServiceType().name() + " Authentication Service test failed", (Throwable)e);
            return ExceptionUtils.toResponse((String)"userServiceTestError", (Exception)e);
        }
    }

    @Operation(tags={"Users"}, operationId="TestAuthenticationService", summary="Test Authentication Service", responses={@ApiResponse(description="The user service tested", content={@Content(schema=@Schema(implementation=UserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/{userServiceId}/test")
    public Response testUserService(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="userServiceId") String userServiceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        com.nuix.automate.utils.models.internal.user.UserService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        UserServiceClient userServiceClient = this.userServiceClients.get(userService.getId());
        return this.testUserService(userService, userServiceClient);
    }

    @Operation(tags={"Users"}, operationId="ExecuteAuthenticationService", summary="Execute Authentication Service", responses={@ApiResponse(description="The updated user service", content={@Content(schema=@Schema(implementation=UserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userService/{userServiceId}/execute")
    @PUT
    public Response executeUserService(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="userServiceId") String userServiceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        final com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        com.nuix.automate.utils.models.internal.user.UserService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        this.setWarningIfMissingGoogleVaultServiceForSync(userService);
        if (userService.getWarningStatus().getCode() == State.WARNING) {
            return ExceptionUtils.toResponse((String)"userServiceExecutionWarning", (Map)new HashMap<String, String>(){
                {
                    this.put("message", userService.getWarningStatus().getMessage());
                }
            });
        }
        boolean syncResult = this.userServiceWorkers.get(userService.getId()).tryRun();
        if (!syncResult) {
            return ExceptionUtils.toResponse((String)"userServiceExecutionError", (Map)new HashMap<String, String>(){
                {
                    this.put("error", UserServiceResource.this.iu.getString("UserServiceWorker.AnotherSyncInProgress"));
                }
            });
        }
        if (userService.getStatus().getCode() == State.ERROR) {
            return ExceptionUtils.toResponse((String)"userServiceExecutionError", (Map)new HashMap<String, String>(){
                {
                    this.put("error", userService.getStatus().getMessage());
                }
            });
        }
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="GetFilteredUserServiceObjects", summary="Get Filtered User Service Objects", responses={@ApiResponse(description="The filtered user service objects", content={@Content(schema=@Schema(implementation=UserServiceObject.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userService/{userServiceId}/objects")
    @GET
    public Response getUserServiceObjects(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="userServiceId") String userServiceId, @QueryParam(value="objectType") UserServiceObjectType objectType, @QueryParam(value="filterText") String filterText, @QueryParam(value="limit") int limit) {
        ArrayList<Object> userServiceObjects;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        com.nuix.automate.utils.models.internal.user.UserService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)userService);
        }
        if (objectType == null) {
            return ExceptionUtils.toResponse((String)"invalidUserServiceObjectType", (Response.Status)Response.Status.BAD_REQUEST);
        }
        FilteredResult filteredObjects = new FilteredResult(limit);
        if (objectType == UserServiceObjectType.USER_ACCOUNT) {
            userServiceObjects = new ArrayList();
            for (UserAccount userAccount : this.users.values()) {
                if (!userServiceId.equals(userAccount.getUserServiceId()) || !UserAccountState.ACTIVE.equals((Object)userAccount.getUserAccountState()) && (!UserAccountState.DELETED.equals((Object)userAccount.getUserAccountState()) || !this.userServices.get(userAccount.getUserServiceId()).getIncludeDeletedUsers().booleanValue()) && (!UserAccountState.INACTIVE.equals((Object)userAccount.getUserAccountState()) || !this.userServices.get(userAccount.getUserServiceId()).getIncludeInactiveUsers().booleanValue())) continue;
                UserAccount renderedUserAccount = this.renderNameSuffixEmailPrefixFromStatus(userAccount);
                userServiceObjects.add(renderedUserAccount);
            }
        } else {
            userServiceObjects = new ArrayList(this.getUserServiceObjects(objectType, userServiceId).values());
        }
        SortingUtils.sortList(userServiceObjects, UserServiceObject::sortKey);
        if (filterText == null || filterText.trim().isEmpty()) {
            int end = Math.min(limit, userServiceObjects.size());
            filteredObjects.setResult(userServiceObjects.subList(0, end));
            filteredObjects.setRemaining(userServiceObjects.size() - end);
        } else {
            filterText = filterText.toLowerCase();
            for (UserServiceObject userServiceObject : userServiceObjects) {
                String text = userServiceObject.getText();
                if (text == null || text.trim().isEmpty() || !this.searchText(filterText, text = text.trim().toLowerCase())) continue;
                filteredObjects.add((Object)userServiceObject);
            }
        }
        String lastHash = ResponseCache.getInstance().hashObject((Object)filteredObjects);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)filteredObjects).build();
        }
    }

    private boolean searchText(String filterText, String text) {
        return text.contains(filterText);
    }

    @Operation(tags={"Users"}, operationId="GetAuthenticationServices", summary="Get Authentication Services", responses={@ApiResponse(description="The list of Authentication Services", content={@Content(schema=@Schema(implementation=UserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/userService")
    public Response getUserServices(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        com.nuix.automate.utils.models.internal.user.UserService result;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ArrayList<com.nuix.automate.utils.models.internal.user.UserService> allowedUserServices = new ArrayList<com.nuix.automate.utils.models.internal.user.UserService>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            com.nuix.automate.utils.models.internal.user.UserService result2 = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
            if (!result2.getUserPermissions().contains(Permission.VIEW)) continue;
            allowedUserServices.add(result2);
        }
        com.nuix.automate.utils.models.internal.user.UserService internalUserService = this.getInternalUserService();
        if (internalUserService.getEnabled().booleanValue() && (result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, internalUserService)).getUserPermissions().contains(Permission.VIEW)) {
            result.getUserPermissions().clear();
            result.getUserPermissions().add(Permission.VIEW);
            allowedUserServices.add(result);
        }
        SortingUtils.sortList(allowedUserServices, com.nuix.automate.utils.models.internal.user.UserService::getName);
        String lastHash = ResponseCache.getInstance().hashObject(allowedUserServices);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedUserServices).build();
        }
    }

    @Operation(tags={"Users"}, operationId="UpdateLDAPAuthenticationService", summary="Update LDAP Authentication Service with the specified ID", responses={@ApiResponse(description="The updated LDAP Authentication Service", content={@Content(schema=@Schema(implementation=LdapUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/ldap")
    public Response updateLdapUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, final @Parameter(description="The service to update", schema=@Schema(implementation=LdapUserServiceUpdateSubmission.class)) LdapUserService updatedLdapUserService) throws Exception {
        Integer computerSearchScope;
        String computerBaseDn;
        Integer userSearchScope;
        String userBaseDn;
        Set whitelistedCertFingerprints;
        Boolean secureLdap;
        String domainDn;
        Integer ldapPort;
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        updatedLdapUserService.normalize();
        LdapUserService originalLdapUserService = (LdapUserService)this.userServices.get(updatedLdapUserService.getId());
        if (originalLdapUserService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", updatedLdapUserService.getId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (updatedLdapUserService.getEnabled() == Boolean.TRUE && originalLdapUserService.getEnabled() != Boolean.TRUE) {
            int ldapUserServiceCount;
            boolean userServiceLimited;
            boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
            if (userServiceLimited && (ldapUserServiceCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.LDAP)) > 0) {
                return ExceptionUtils.toResponse((String)"userServiceLicenseMultipleError", (Map)new HashMap<String, String>(){
                    {
                        this.put("type", "LDAP");
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.verifyAndUpdateUserService(user, (com.nuix.automate.utils.models.internal.user.UserService)originalLdapUserService, (com.nuix.automate.utils.models.internal.user.UserService)updatedLdapUserService, force)) != null) {
            return errorResponse;
        }
        String ldapHost = updatedLdapUserService.getLdapHost();
        if (ldapHost != null) {
            originalLdapUserService.setLdapHost(ldapHost);
        }
        if ((ldapPort = updatedLdapUserService.getLdapPort()) != null) {
            originalLdapUserService.setLdapPort(ldapPort);
        }
        if ((domainDn = updatedLdapUserService.getDomainDn()) != null) {
            originalLdapUserService.setDomainDn(domainDn);
        }
        if ((secureLdap = updatedLdapUserService.getSecureLdap()) != null) {
            originalLdapUserService.setSecureLdap(secureLdap);
        }
        if ((whitelistedCertFingerprints = updatedLdapUserService.getWhitelistedCertFingerprints()) != null) {
            originalLdapUserService.setWhitelistedCertFingerprints(whitelistedCertFingerprints);
        }
        if ((userBaseDn = updatedLdapUserService.getUserBaseDn()) != null) {
            originalLdapUserService.setUserBaseDn(userBaseDn);
        }
        if ((userSearchScope = updatedLdapUserService.getUserSearchScope()) != null) {
            originalLdapUserService.setUserSearchScope(userSearchScope);
        }
        if ((computerBaseDn = updatedLdapUserService.getComputerBaseDn()) != null) {
            originalLdapUserService.setComputerBaseDn(computerBaseDn);
        }
        if ((computerSearchScope = updatedLdapUserService.getComputerSearchScope()) != null) {
            originalLdapUserService.setComputerSearchScope(computerSearchScope);
        }
        this.userServiceClients.get(originalLdapUserService.getId()).update((com.nuix.automate.utils.models.internal.user.UserService)originalLdapUserService);
        this.userServiceWorkers.get(originalLdapUserService.getId()).reset();
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((com.nuix.automate.utils.models.internal.user.UserService)originalLdapUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, originalLdapUserService.getId());
        LdapUserService result = (LdapUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)originalLdapUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="AddLDAPAuthenticationService", summary="Add LDAP Authentication Service", responses={@ApiResponse(description="The added LDAP Authentication Service", content={@Content(schema=@Schema(implementation=LdapUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/ldap")
    public Response addLdapUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The service to add", schema=@Schema(implementation=LdapUserServiceSubmission.class)) LdapUserService ldapUserService) {
        String name;
        int ldapUserServiceCount;
        boolean userServiceLimited;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.verifyUserServiceLicenseUsage((com.nuix.automate.utils.models.internal.user.UserService)ldapUserService);
        FormattingUtils.trimAllStrings((Object)ldapUserService);
        ldapUserService.normalize();
        ldapUserService.setReadOnly(false);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)ldapUserService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
        if (userServiceLimited && (ldapUserServiceCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.LDAP)) > 0) {
            ldapUserService.setEnabled(Boolean.valueOf(false));
        }
        if ((name = ldapUserService.getName()) == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidAuthenticationServiceName", (Map)new HashMap<String, String>(){
                {
                    this.put("name", name);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ldapUserService.setName(name.trim());
        Set<String> existingNames = this.getUserServiceNames(null);
        if (existingNames.contains(ldapUserService.getName())) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        ldapUserService.setId(UidUtils.getRandom());
        ldapUserService.setStatus(new Status());
        ldapUserService.setUserServiceType(UserServiceType.LDAP);
        if (ldapUserService.getEnabled().booleanValue()) {
            this.schedulerApplication.getAuthScopeTypes().put(ldapUserService.getName(), AuthType.LDAP);
        }
        this.userServices.put(ldapUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)ldapUserService);
        try {
            this.userServiceClients.put(ldapUserService.getId(), new LdapClient(ldapUserService));
            this.userServiceWorkers.put(ldapUserService.getId(), new LdapUserServiceWorker(this.schedulerApplication, ldapUserService));
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Unable to create LDAP Client for " + ldapUserService.getName(), (Throwable)e);
        }
        ldapUserService.normalize();
        this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)ldapUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        LdapUserService result = (LdapUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)ldapUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="AddRelativityUserImpersonationService", summary="Add Relativity User Impersonation Service", responses={@ApiResponse(description="The added Relativity User Impersonation Service", content={@Content(schema=@Schema(implementation=RelativityUserImpersonationService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/relativityImpersonation")
    public Response addRelativityUserImpersonationService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The service to add", schema=@Schema(implementation=RelativityUserImpersonationServiceSubmission.class)) RelativityUserImpersonationService relativityUserImpersonationService) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.RELATIVITY_ADVANCED);
        FormattingUtils.trimAllStrings((Object)relativityUserImpersonationService);
        relativityUserImpersonationService.normalize();
        relativityUserImpersonationService.setReadOnly(false);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)relativityUserImpersonationService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final String name = relativityUserImpersonationService.getName();
        if (name == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidAuthenticationServiceName", (Map)new HashMap<String, String>(){
                {
                    this.put("name", name);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        relativityUserImpersonationService.setName(name.trim());
        Set<String> existingNames = this.getUserServiceNames(null);
        if (existingNames.contains(relativityUserImpersonationService.getName())) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        relativityUserImpersonationService.setId(UidUtils.getRandom());
        relativityUserImpersonationService.setStatus(new Status());
        relativityUserImpersonationService.setUserServiceType(UserServiceType.RELATIVITY_IMPERSONATION);
        if (relativityUserImpersonationService.getSecret() == null) {
            relativityUserImpersonationService.setSecret(SecurityUtils.getSecureRandomSecret());
        }
        this.userServices.put(relativityUserImpersonationService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)relativityUserImpersonationService);
        this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)relativityUserImpersonationService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        RelativityUserImpersonationService result = (RelativityUserImpersonationService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)relativityUserImpersonationService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        result.setSecret(relativityUserImpersonationService.getSecret());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="UpdateRelativityUserImpersonationService", summary="Update Relativity User Impersonation Service", responses={@ApiResponse(description="The updated Relativity User Impersonation Service", content={@Content(schema=@Schema(implementation=RelativityUserImpersonationService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/relativityImpersonation")
    public Response updateRelativityUserImpersonationService(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The service to update", schema=@Schema(implementation=RelativityUserImpersonationServiceUpdateSubmission.class)) RelativityUserImpersonationService updatedRelativityUserImpersonationService) throws Exception {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        FormattingUtils.trimAllStrings((Object)updatedRelativityUserImpersonationService);
        updatedRelativityUserImpersonationService.normalize();
        RelativityUserImpersonationService originalRelativityUserImpersonationService = (RelativityUserImpersonationService)this.userServices.get(updatedRelativityUserImpersonationService.getId());
        if (originalRelativityUserImpersonationService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", updatedRelativityUserImpersonationService.getId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Response errorResponse = this.verifyAndUpdateUserService(user, (com.nuix.automate.utils.models.internal.user.UserService)originalRelativityUserImpersonationService, (com.nuix.automate.utils.models.internal.user.UserService)updatedRelativityUserImpersonationService, false);
        if (errorResponse != null) {
            return errorResponse;
        }
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((com.nuix.automate.utils.models.internal.user.UserService)originalRelativityUserImpersonationService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, originalRelativityUserImpersonationService.getId());
        RelativityUserImpersonationService result = (RelativityUserImpersonationService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)originalRelativityUserImpersonationService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="UpdateUMSAuthenticationService", summary="Update UMS Authentication Service with the specified ID", responses={@ApiResponse(description="The updated UMS Authentication Service", content={@Content(schema=@Schema(implementation=UmsUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/ums")
    public Response updateUmsUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, final @Parameter(description="The service to update", schema=@Schema(implementation=UmsUserServiceUpdateSubmission.class)) UmsUserService updatedUmsUserService) throws Exception {
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        FormattingUtils.trimAllStrings((Object)updatedUmsUserService);
        updatedUmsUserService.normalize();
        UmsUserService originalUmsUserService = (UmsUserService)this.userServices.get(updatedUmsUserService.getId());
        if (originalUmsUserService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", updatedUmsUserService.getId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (updatedUmsUserService.getEnabled() == Boolean.TRUE && originalUmsUserService.getEnabled() != Boolean.TRUE) {
            int umsUserServiceCount;
            boolean userServiceLimited;
            boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
            if (userServiceLimited && (umsUserServiceCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.UMS)) > 0) {
                return ExceptionUtils.toResponse((String)"userServiceLicenseMultipleError", (Map)new HashMap<String, String>(){
                    {
                        this.put("type", "UMS");
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.verifyAndUpdateUserService(user, (com.nuix.automate.utils.models.internal.user.UserService)originalUmsUserService, (com.nuix.automate.utils.models.internal.user.UserService)updatedUmsUserService, force)) != null) {
            return errorResponse;
        }
        String url = updatedUmsUserService.getUrl();
        if (url != null) {
            originalUmsUserService.setUrl(url);
        }
        this.userServiceClients.get(originalUmsUserService.getId()).update((com.nuix.automate.utils.models.internal.user.UserService)originalUmsUserService);
        this.userServiceWorkers.get(originalUmsUserService.getId()).reset();
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((com.nuix.automate.utils.models.internal.user.UserService)originalUmsUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, originalUmsUserService.getId());
        UmsUserService result = (UmsUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)originalUmsUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="AddUMSAuthenticationService", summary="Add UMS Authentication Service", responses={@ApiResponse(description="The added UMS Authentication Service", content={@Content(schema=@Schema(implementation=UmsUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/ums")
    public Response addUmsUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The service to add", schema=@Schema(implementation=UmsUserServiceSubmission.class)) UmsUserService umsUserService) {
        String name;
        int umsUserServiceCount;
        boolean userServiceLimited;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        FormattingUtils.trimAllStrings((Object)umsUserService);
        umsUserService.normalize();
        umsUserService.setReadOnly(false);
        this.verifyUserServiceLicenseUsage((com.nuix.automate.utils.models.internal.user.UserService)umsUserService);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)umsUserService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
        if (userServiceLimited && (umsUserServiceCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.UMS)) > 0) {
            umsUserService.setEnabled(Boolean.valueOf(false));
        }
        if ((name = umsUserService.getName()) == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidAuthenticationServiceName", (Map)new HashMap<String, String>(){
                {
                    this.put("name", name);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        umsUserService.setName(name.trim());
        Set<String> existingNames = this.getUserServiceNames(null);
        if (existingNames.contains(umsUserService.getName())) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        umsUserService.setId(UidUtils.getRandom());
        umsUserService.setStatus(new Status());
        umsUserService.setUserServiceType(UserServiceType.UMS);
        if (umsUserService.getEnabled().booleanValue()) {
            this.schedulerApplication.getAuthScopeTypes().put(umsUserService.getName(), AuthType.UMS);
        }
        this.userServices.put(umsUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)umsUserService);
        try {
            this.userServiceClients.put(umsUserService.getId(), new UmsUtil(umsUserService));
            this.userServiceWorkers.put(umsUserService.getId(), new UserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)umsUserService));
        }
        catch (Exception e) {
            LOGGER.error("Unable to create UMS Client for " + umsUserService.getName(), (Throwable)e);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)umsUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        UmsUserService result = (UmsUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)umsUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="UpdateMicrosoftMicrosoftService", summary="Update Microsoft Authentication Service with the specified ID", responses={@ApiResponse(description="The updated Microsoft Authentication Service", content={@Content(schema=@Schema(implementation=MicrosoftUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/microsoft")
    public Response updateMicrosoftUserService(@Parameter(hidden=true) @Auth BearerUser user, @QueryParam(value="force") boolean force, @Parameter(description="The service to update", schema=@Schema(implementation=MicrosoftUserServiceUpdateSubmission.class)) MicrosoftUserService microsoftUserService) throws Exception {
        FormattingUtils.trimAllStrings((Object)((Object)microsoftUserService));
        return this.internalUpdateOidcUserService(user, microsoftUserService, force);
    }

    @Operation(tags={"Users"}, operationId="UpdateManagedAuthenticationService", summary="Update Managed Authentication Service with the specified ID", responses={@ApiResponse(description="The updated Managed Authentication Service", content={@Content(schema=@Schema(implementation=ManagedUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/managed")
    public Response updateManagedUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, final ManagedUserService updatedManagedUserService) throws Exception {
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        FormattingUtils.trimAllStrings((Object)updatedManagedUserService);
        updatedManagedUserService.normalize();
        ManagedUserService originalManagedUserService = (ManagedUserService)this.userServices.get(updatedManagedUserService.getId());
        if (originalManagedUserService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", updatedManagedUserService.getId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (updatedManagedUserService.getEnabled() == Boolean.TRUE && originalManagedUserService.getEnabled() != Boolean.TRUE) {
            int managedUserServiceCount;
            boolean userServiceLimited;
            boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
            if (userServiceLimited && (managedUserServiceCount = this.getEnabledUserServicesOfTypeCount(UserServiceType.MANAGED)) > 0) {
                return ExceptionUtils.toResponse((String)"userServiceLicenseMultipleError", (Map)new HashMap<String, String>(){
                    {
                        this.put("type", "Managed");
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.verifyAndUpdateUserService(user, (com.nuix.automate.utils.models.internal.user.UserService)originalManagedUserService, (com.nuix.automate.utils.models.internal.user.UserService)updatedManagedUserService, force)) != null) {
            return errorResponse;
        }
        this.userServiceClients.get(originalManagedUserService.getId()).update((com.nuix.automate.utils.models.internal.user.UserService)originalManagedUserService);
        this.userServiceWorkers.get(originalManagedUserService.getId()).reset();
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((com.nuix.automate.utils.models.internal.user.UserService)originalManagedUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, originalManagedUserService.getId());
        ManagedUserService result = (ManagedUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)originalManagedUserService);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="AddManagedAuthenticationService", summary="Add Managed Authentication Service", responses={@ApiResponse(description="The added Managed Authentication Service", content={@Content(schema=@Schema(implementation=ManagedUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/managed")
    public Response addManagedUserService(@Parameter(hidden=true) @Auth BearerUser user, ManagedUserService managedUserService) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        FormattingUtils.trimAllStrings((Object)managedUserService);
        managedUserService.normalize();
        managedUserService.setReadOnly(false);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)managedUserService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final String name = managedUserService.getName();
        if (name == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidAuthenticationServiceName", (Map)new HashMap<String, String>(){
                {
                    this.put("name", name);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        managedUserService.setName(name.trim());
        Set<String> existingNames = this.getUserServiceNames(null);
        if (existingNames.contains(managedUserService.getName())) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        managedUserService.setId(UidUtils.getRandom());
        managedUserService.setStatus(new Status());
        managedUserService.setUserServiceType(UserServiceType.MANAGED);
        managedUserService.setSynchronizeUsers(Boolean.valueOf(true));
        managedUserService.setEnableLoginLinks(Boolean.valueOf(true));
        if (managedUserService.getLoginLinkScope() == null) {
            managedUserService.setLoginLinkScope(LoginLinkScope.LEGAL_HOLD);
        }
        if (managedUserService.getLoginLinkAutoExpireInterval() == null || managedUserService.getLoginLinkAutoExpireInterval() <= 0) {
            managedUserService.setLoginLinkAutoExpireInterval(Integer.valueOf(4));
        }
        this.userServices.put(managedUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)managedUserService);
        try {
            this.userServiceClients.put(managedUserService.getId(), new ManagedServiceUtil(managedUserService));
            this.userServiceWorkers.put(managedUserService.getId(), new UserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)managedUserService));
        }
        catch (Exception e) {
            LOGGER.error("Unable to create Managed Client for " + managedUserService.getName(), (Throwable)e);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)managedUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ManagedUserService result = (ManagedUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)managedUserService);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="GetManagedAuthenticationServiceUsers", summary="Get Managed Authentication Service Users", responses={@ApiResponse(description="The list of users", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserRecord.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/userService/managed/{userServiceId}/users")
    public Response getManagedServiceUsers(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="userServiceId") String userServiceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
        if (!permissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ArrayList<UserRecord> result = new ArrayList<UserRecord>();
        List<UserAccount> serviceUsers = this.schedulerApplication.getUsersDao().getUsers(userServiceId);
        for (UserAccount serviceUser : serviceUsers) {
            if (!serviceUser.getUserAccountState().equals((Object)UserAccountState.ACTIVE)) continue;
            UserRecord userRecord = new UserRecord();
            userRecord.setEmail(serviceUser.getEmail());
            userRecord.setName(serviceUser.getName());
            result.add(userRecord);
        }
        result.sort(UserRecord::compareTo);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
    }

    private boolean checkUsersPartOfActiveLegalHold(Set<String> userIds) {
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            if (!legalHold.getState().equals((Object)LegalHoldState.ACTIVE)) continue;
            List<LegalHoldParticipation> participations = this.schedulerApplication.getLegalHoldResource().getParticipations(legalHold.getId());
            for (LegalHoldParticipation participation : participations) {
                if (!userIds.contains(participation.getUserId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUsersPartOfActiveLegalHold(com.nuix.automate.utils.models.internal.user.UserService userService) {
        List<UserAccount> serviceUsers = this.getUserServiceUsers(userService.getId());
        HashSet<String> serviceUserIds = new HashSet<String>();
        for (UserAccount userAccount : serviceUsers) {
            serviceUserIds.add(userAccount.getId());
        }
        return this.checkUsersPartOfActiveLegalHold(serviceUserIds);
    }

    private boolean checkUsersPartOfLegalHold(Set<String> userIds) {
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            List<LegalHoldParticipation> participations = this.schedulerApplication.getLegalHoldResource().getParticipations(legalHold.getId());
            for (LegalHoldParticipation participation : participations) {
                if (!userIds.contains(participation.getUserId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkUsersPartOfLegalHold(com.nuix.automate.utils.models.internal.user.UserService userService) {
        List<UserAccount> serviceUsers = this.getUserServiceUsers(userService.getId());
        HashSet<String> serviceUserIds = new HashSet<String>();
        for (UserAccount userAccount : serviceUsers) {
            serviceUserIds.add(userAccount.getId());
        }
        return this.checkUsersPartOfLegalHold(serviceUserIds);
    }

    /*
     * WARNING - void declaration
     */
    @Operation(tags={"Users"}, operationId="SetManagedAuthenticationServiceUsers", summary="Set Managed Authentication Service Users", responses={@ApiResponse(description="The updated Managed Authentication Service", content={@Content(schema=@Schema(implementation=ManagedUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/managed/{userServiceId}/users")
    public Response setManagedUserServiceUsers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, final @PathParam(value="userServiceId") String userServiceId, Set<UserRecord> userRecords) {
        void var11_18;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        ArrayList<UserAccount> serviceUsers = new ArrayList<UserAccount>();
        HashSet<String> newUserIds = new HashSet<String>();
        for (UserRecord userRecord : userRecords) {
            UserAccount userAccount = new UserAccount();
            userAccount.setEmail(userRecord.getEmail());
            userAccount.setName(userRecord.getName());
            userAccount.setPlatform(UserAccountPlatform.MANAGED);
            userAccount.setUserAccountState(UserAccountState.ACTIVE);
            userAccount.setUserServiceId(userServiceId);
            userAccount.setId(UidUtils.fromString((String)(userServiceId + "_" + userRecord.getEmail().toLowerCase())).toString());
            serviceUsers.add(userAccount);
            newUserIds.add(userAccount.getId());
        }
        HashSet<String> previousUserIds = new HashSet<String>();
        for (UserAccount userAccount : this.users.values()) {
            if (userAccount.getUserServiceId() == null || !userAccount.getUserServiceId().equals(userServiceId)) continue;
            previousUserIds.add(userAccount.getId());
        }
        HashSet<String> hashSet = new HashSet<String>(previousUserIds);
        hashSet.removeAll(newUserIds);
        if (!force && this.checkUsersPartOfActiveLegalHold(hashSet)) {
            return ExceptionUtils.toResponse((String)"usersPartOfActiveLegalHolds");
        }
        this.schedulerApplication.getUsersDao().deleteUserServiceUsers(userServiceId);
        for (String string : hashSet) {
            UserAccount previousUser = this.users.remove(string);
            previousUser.setUserAccountState(UserAccountState.DELETED);
            if (newUserIds.contains(string)) continue;
            serviceUsers.add(previousUser);
            newUserIds.add(string);
        }
        this.schedulerApplication.getUsersDao().addOrUpdateUsers(serviceUsers);
        boolean bl = false;
        for (UserAccount serviceUser : serviceUsers) {
            this.users.put(serviceUser.getId(), serviceUser);
            if (!serviceUser.getUserAccountState().equals((Object)UserAccountState.ACTIVE)) continue;
            ++var11_18;
        }
        userService.setObjectCount(Integer.valueOf((int)var11_18));
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService(userService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
        ManagedUserService managedUserService = (ManagedUserService)this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)managedUserService).build();
    }

    @Operation(tags={"Users"}, operationId="UpdateOIDCAuthenticationService", summary="Update OIDC Authentication Service with the specified ID", responses={@ApiResponse(description="The updated OIDC Authentication Service", content={@Content(schema=@Schema(implementation=OidcUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    @Path(value="/userService/oidc")
    public Response updateOidcUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, @Parameter(description="The service to update", schema=@Schema(implementation=OidcUserServiceUpdateSubmission.class)) OidcUserService oidcUserService) throws Exception {
        FormattingUtils.trimAllStrings((Object)oidcUserService);
        oidcUserService.normalize();
        return this.internalUpdateOidcUserService(user, oidcUserService, force);
    }

    private Response internalUpdateOidcUserService(BearerUser user, final OidcUserService oidcUserService, boolean force) throws Exception {
        Set whitelistedCertFingerprints;
        String clientSecret;
        String clientId;
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        final OidcUserService originalOidcUserService = (OidcUserService)this.userServices.get(oidcUserService.getId());
        if (originalOidcUserService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", oidcUserService.getId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (oidcUserService.getEnabled() == Boolean.TRUE && originalOidcUserService.getEnabled() != Boolean.TRUE) {
            int oidcUserServiceCount;
            boolean userServiceLimited;
            boolean bl = userServiceLimited = !this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_ADVANCED);
            if (userServiceLimited && (oidcUserServiceCount = this.getEnabledUserServicesOfTypeCount(originalOidcUserService.getUserServiceType())) > 0) {
                return ExceptionUtils.toResponse((String)"userServiceLicenseMultipleError", (Map)new HashMap<String, String>(){
                    {
                        this.put("type", LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)originalOidcUserService.getUserServiceType()));
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.verifyAndUpdateUserService(user, (com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService, force)) != null) {
            return errorResponse;
        }
        Response response = this.verifyDefaultAuthenticationProvider(oidcUserService);
        if (response != null) {
            return response;
        }
        boolean thirdPartyUserCredentialStale = false;
        if (originalOidcUserService instanceof MicrosoftUserService) {
            String tenant;
            MicrosoftOAuthVersion oAuthVersion;
            MicrosoftUserService microsoftUserService = (MicrosoftUserService)oidcUserService;
            MicrosoftUserService originalMicrosoftUserService = (MicrosoftUserService)originalOidcUserService;
            String environment = microsoftUserService.getEnvironment();
            if (environment != null) {
                thirdPartyUserCredentialStale = !environment.equals(originalMicrosoftUserService.getEnvironment());
                originalMicrosoftUserService.setEnvironment(environment);
            }
            if ((oAuthVersion = microsoftUserService.getoAuthVersion()) != null) {
                thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !oAuthVersion.equals((Object)originalMicrosoftUserService.getoAuthVersion());
                originalMicrosoftUserService.setoAuthVersion(oAuthVersion);
            }
            if ((tenant = microsoftUserService.getTenant()) != null) {
                thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !tenant.equals(originalMicrosoftUserService.getTenant());
                originalMicrosoftUserService.setTenant(tenant);
            }
        }
        if (originalOidcUserService.getUserServiceType() == UserServiceType.OIDC) {
            Object groupClaim;
            String usernameClaim;
            String scope;
            String wellKnownConfiguration = oidcUserService.getWellKnownConfiguration();
            if (wellKnownConfiguration != null) {
                thirdPartyUserCredentialStale = !wellKnownConfiguration.equals(originalOidcUserService.getWellKnownConfiguration());
                originalOidcUserService.setWellKnownConfiguration(wellKnownConfiguration);
            }
            if ((scope = oidcUserService.getScope()) != null) {
                thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !scope.equals(originalOidcUserService.getScope());
                originalOidcUserService.setScope(scope);
            }
            if ((usernameClaim = oidcUserService.getUsernameClaim()) != null) {
                thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !usernameClaim.equals(originalOidcUserService.getUsernameClaim());
                originalOidcUserService.setUsernameClaim(usernameClaim);
            }
            if ((groupClaim = oidcUserService.getGroupClaim()) != null) {
                thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !((String)groupClaim).equals(originalOidcUserService.getGroupClaim()) && (!((String)groupClaim).trim().equals("") || originalOidcUserService.getGroupClaim() != null);
                originalOidcUserService.setGroupClaim((String)groupClaim);
            }
            if (originalOidcUserService.getGroupClaim() != null && originalOidcUserService.getGroupClaim().trim().equals("")) {
                originalOidcUserService.setGroupClaim(null);
            }
            if (oidcUserService.getEnableAuthorizationCodeFlow() != null) {
                originalOidcUserService.setEnableAuthorizationCodeFlow(oidcUserService.getEnableAuthorizationCodeFlow());
            }
            if (oidcUserService.getEnableJwtAccessToken() != null) {
                originalOidcUserService.setEnableJwtAccessToken(oidcUserService.getEnableJwtAccessToken());
            }
            if (oidcUserService.getDefaultAuthenticationProvider() != null) {
                originalOidcUserService.setDefaultAuthenticationProvider(oidcUserService.getDefaultAuthenticationProvider());
            }
            if (oidcUserService.getLinkProfilesWithSyncedUsers() != null) {
                originalOidcUserService.setLinkProfilesWithSyncedUsers(oidcUserService.getLinkProfilesWithSyncedUsers());
            }
        }
        if ((clientId = oidcUserService.getClientId()) != null) {
            thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !clientId.equals(originalOidcUserService.getClientId());
            originalOidcUserService.setClientId(clientId);
        }
        if ((clientSecret = oidcUserService.getClientSecret()) != null) {
            thirdPartyUserCredentialStale = thirdPartyUserCredentialStale || !clientSecret.equals(originalOidcUserService.getClientSecret());
            originalOidcUserService.setClientSecret(clientSecret);
        }
        if ((whitelistedCertFingerprints = oidcUserService.getWhitelistedCertFingerprints()) != null) {
            originalOidcUserService.setWhitelistedCertFingerprints(whitelistedCertFingerprints);
        }
        if (thirdPartyUserCredentialStale) {
            for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServicesUsingOidcAuthenticationService((com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService)) {
                this.schedulerApplication.getThirdPartyServiceResource().setUserCredentialsStale(thirdPartyService.getId());
            }
        }
        this.setWarningIfMissingGoogleVaultServiceForSync((com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService);
        this.resetUserServiceWellKnownConfigurationWorker((com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService);
        this.userServiceClients.get(originalOidcUserService.getId()).update((com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService);
        this.userServiceWorkers.get(originalOidcUserService.getId()).reset();
        this.schedulerApplication.getSchedulerConfigurationDao().updateUserService((com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, originalOidcUserService.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
        com.nuix.automate.utils.models.internal.user.UserService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)originalOidcUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Users"}, operationId="AddMicrosoftAuthenticationService", summary="Add Microsoft Authentication Service", responses={@ApiResponse(description="The added Microsoft Authentication Service", content={@Content(schema=@Schema(implementation=MicrosoftUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/microsoft")
    public Response addMicrosoftUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The service to add", schema=@Schema(implementation=MicrosoftUserServiceSubmission.class)) MicrosoftUserService microsoftUserService) {
        microsoftUserService.setUserServiceType(UserServiceType.MICROSOFT);
        FormattingUtils.trimAllStrings((Object)((Object)microsoftUserService));
        microsoftUserService.normalize();
        microsoftUserService.setReadOnly(false);
        return this.internalAddOidcUserService(user, microsoftUserService);
    }

    private void verifyUserServiceLicenseUsage(com.nuix.automate.utils.models.internal.user.UserService userService) {
    }

    @Operation(tags={"Users"}, operationId="AddOIDCAuthenticationService", summary="Add OIDC Authentication Service", responses={@ApiResponse(description="The added OIDC Authentication Service", content={@Content(schema=@Schema(implementation=OidcUserService.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/oidc")
    public Response addOidcUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The service to add", schema=@Schema(implementation=OidcUserServiceSubmission.class)) OidcUserService oidcUserService) {
        oidcUserService.setUserServiceType(UserServiceType.OIDC);
        oidcUserService.setOidcUserServiceType(OidcUserServiceType.GENERIC);
        FormattingUtils.trimAllStrings((Object)oidcUserService);
        oidcUserService.normalize();
        oidcUserService.setReadOnly(false);
        return this.internalAddOidcUserService(user, oidcUserService);
    }

    private Response internalAddOidcUserService(BearerUser user, OidcUserService oidcUserService) {
        UserServiceWorker worker;
        Response response;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.verifyUserServiceLicenseUsage((com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final String name = oidcUserService.getName();
        if (name == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidAuthenticationServiceName", (Map)new HashMap<String, String>(){
                {
                    this.put("name", name);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        oidcUserService.setName(name.trim());
        Set<String> existingNames = this.getUserServiceNames(null);
        if (existingNames.contains(oidcUserService.getName())) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        int oidcServicesCount = 0;
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (!userService.getUserServiceType().equals((Object)UserServiceType.OIDC)) continue;
            ++oidcServicesCount;
        }
        if (oidcServicesCount == 0 && this.userServices.get("10009291-ab9b-4a4d-a6c7-356658be58c0") == null) {
            oidcUserService.setId("10009291-ab9b-4a4d-a6c7-356658be58c0");
        } else {
            oidcUserService.setId(UidUtils.getRandom());
        }
        oidcUserService.setStatus(new Status());
        if (oidcUserService.getGroupClaim() != null && oidcUserService.getGroupClaim().trim().equals("")) {
            oidcUserService.setGroupClaim(null);
        }
        if ((response = this.verifyDefaultAuthenticationProvider(oidcUserService)) != null) {
            return response;
        }
        OidcUserServiceClient client = null;
        if (oidcUserService instanceof MicrosoftUserService) {
            try {
                client = new MicrosoftOidcUserServiceClient(this.schedulerApplication, oidcUserService);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create Microsoft OIDC Client for " + oidcUserService.getName(), (Throwable)e);
            }
            worker = new MicrosoftUserServiceWorker(this.schedulerApplication, (MicrosoftUserService)oidcUserService);
        } else {
            try {
                client = oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE ? new GoogleOidcUserServiceClient(this.schedulerApplication, oidcUserService) : new GenericOidcUserServiceClient(this.schedulerApplication, oidcUserService);
            }
            catch (Exception e) {
                LOGGER.error("Unable to create OIDC Client for " + oidcUserService.getName(), (Throwable)e);
            }
            worker = oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE ? new GoogleUserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService) : new UserServiceWorker(this.schedulerApplication, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        }
        this.setWarningIfMissingGoogleVaultServiceForSync((com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        this.userServices.put(oidcUserService.getId(), (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        this.userServiceClients.put(oidcUserService.getId(), client);
        this.wellKnownConfigurationWorkers.put(oidcUserService.getId(), new OidcWellKnownConfigurationWorker(this.schedulerApplication, oidcUserService));
        this.userServiceWorkers.put(oidcUserService.getId(), worker);
        this.schedulerApplication.getSchedulerConfigurationDao().addUserService((com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        com.nuix.automate.utils.models.internal.user.UserService result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (com.nuix.automate.utils.models.internal.user.UserService)oidcUserService);
        if (!result.getEnabled().booleanValue()) {
            result.getStatus().reset();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private Response verifyDefaultAuthenticationProvider(OidcUserService oidcUserService) {
        if (oidcUserService.getDefaultAuthenticationProvider().booleanValue()) {
            for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
                if (userService.getUserServiceType() != UserServiceType.OIDC || userService.getId().equals(oidcUserService.getId()) || !((OidcUserService)userService).getDefaultAuthenticationProvider().booleanValue()) continue;
                return ExceptionUtils.toResponse((String)"multipleDefaultAuthentication", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        return null;
    }

    @Operation(tags={"Users", "Computers"}, operationId="ResolveUsersToComputers", summary="Resolve Authentication Service Users to Computers", responses={@ApiResponse(description="The added OIDC Authentication Service", content={@Content(schema=@Schema(implementation=List.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/{userServiceId}/resolveComputers")
    public Response resolveComputers(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the Authentication Service to query") @PathParam(value="userServiceId") String userServiceId, @Parameter(description="The IDs of the users to resolve computers for") Set<String> userIds) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
        if (!permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        List<Object> mappings = new ArrayList();
        switch (userService.getUserServiceType()) {
            case LDAP: {
                mappings = this.resolveLdapUsersToComputers(userService.getId(), userIds);
                break;
            }
        }
        SortingUtils.sortList(mappings, UserComputerMapping::getComputerName);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(mappings).build();
    }

    private List<UserComputerMapping> resolveLdapUsersToComputers(String userServiceId, Set<String> userIds) {
        ArrayList<UserComputerMapping> mappings = new ArrayList<UserComputerMapping>();
        HashMap<String, LdapComputer> computers = new HashMap<String, LdapComputer>();
        Map ldapComputers = this.getUserServiceObjects(UserServiceObjectType.COMPUTER, userServiceId);
        for (LdapComputer computer : ldapComputers.values()) {
            if (computer.getManagedBy() == null || computer.getManagedBy().trim().equals("")) continue;
            computers.put(computer.getManagedBy(), computer);
        }
        for (UserAccount userAccount : this.getUsers(userServiceId)) {
            LdapComputer managedByComputerModel;
            String userAccountDn;
            if (userIds != null && !userIds.contains(userAccount.getId()) || (userAccountDn = (String)userAccount.getAttributes().get("distinguishedName")) == null || userAccountDn.trim().equals("") || (managedByComputerModel = (LdapComputer)computers.get(userAccountDn)) == null) continue;
            mappings.add(new UserComputerMapping(userAccount.getId(), userAccount.getUserServiceId(), managedByComputerModel.getName(), managedByComputerModel.getId()));
        }
        return mappings;
    }

    @Operation(tags={"Users"}, operationId="DeleteAuthenticationService", summary="Delete Authentication Service", description="Delete the Authentication Service with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Authentication Service with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @DELETE
    @Path(value="/userService/{userServiceId}")
    public Response deleteUserService(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="Force modification if users are part of a Legal Hold") @QueryParam(value="force") boolean force, final @Parameter(description="The ID of the LDAP Authentication Service to delete") @PathParam(value="userServiceId") String userServiceId) {
        OidcWellKnownConfigurationWorker worker;
        UserServiceWorker userServiceWorker;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
        if (!permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (userService.getUserServiceType() == UserServiceType.OIDC) {
            try {
                this.verifyNotUsedInThirdPartyServices(user, userService);
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
        }
        if (!force && this.checkUsersPartOfLegalHold(userService)) {
            return ExceptionUtils.toResponse((String)"usersPartOfLegalHolds");
        }
        UserServiceClient userServiceClient = this.userServiceClients.remove(userServiceId);
        if (userServiceClient != null) {
            userServiceClient.close();
        }
        if ((userServiceWorker = this.userServiceWorkers.remove(userServiceId)) != null) {
            try {
                userServiceWorker.cancel();
            }
            catch (Exception e) {
                LOGGER.error("Cannot cancel " + String.valueOf(userService.getUserServiceType()) + " Authentication Service worker" + userService.getName(), (Throwable)e);
            }
        }
        if ((worker = this.wellKnownConfigurationWorkers.remove(userServiceId)) != null) {
            try {
                worker.close();
            }
            catch (IOException e) {
                LOGGER.error("Cannot close worker, ", (Throwable)e);
            }
        }
        this.schedulerApplication.getUsersDao().deleteUserServiceUsers(userService.getId());
        this.schedulerApplication.getUsersDao().deleteUserServiceObjects(userService.getId());
        this.schedulerApplication.getAuthScopeTypes().remove(userService.getName());
        this.schedulerApplication.getSchedulerConfigurationDao().deleteUserService(userService.getId());
        this.users.values().removeIf(userAccount -> userService.getId().equals(userAccount.getUserServiceId()));
        this.userServices.remove(userServiceId);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATIONS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SERVICE_CONFIGURATION, userService.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.USERS);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void verifyNotUsedInThirdPartyServices(BearerUser user, com.nuix.automate.utils.models.internal.user.UserService userService) throws ResponseException {
        TreeSet<String> serviceNames = new TreeSet<String>();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServicesUsingOidcAuthenticationService(userService)) {
            Set servicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
            if (servicePermissions.contains(Permission.VIEW)) {
                serviceNames.add(thirdPartyService.getName());
                continue;
            }
            serviceNames.add(this.iu.getString("Job.Name.Other"));
        }
        if (serviceNames.isEmpty()) {
            return;
        }
        String errorKey = serviceNames.size() == 1 ? "cannotDeleteUserServiceUsedInThirdPartyService" : "cannotDeleteUserServiceUsedInThirdPartyServices";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("names", String.join((CharSequence)", ", serviceNames));
        throw new ResponseException(ExceptionUtils.toResponse((String)errorKey, properties));
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/userService/{userServiceId}/csv")
    public Response exportUserServiceCsv(@Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="userServiceId") String userServiceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
        if (!permissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        DateTimeFormatter fileDateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC"));
        String fileName = FormattingUtils.sanitizeFilename((String)(fileDateTimeFormatter.format(Instant.ofEpochMilli(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis())) + " " + userService.getName() + " (" + UidUtils.getShortId((String)userService.getId()) + ")"));
        StreamingOutput stream = outputStream -> {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);){
                zipOutputStream.setLevel(1);
                if (userService.getSynchronizeUsers() == Boolean.TRUE) {
                    ZipEntry userEntry = new ZipEntry("Users.csv");
                    zipOutputStream.putNextEntry(userEntry);
                    FormattingUtils.appendBOM((OutputStream)zipOutputStream);
                    try (StringWriter writer = new StringWriter();
                         CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                        List<UserAccount> userAccounts = this.getUserServiceUsers(userServiceId);
                        if (userAccounts == null) {
                            userAccounts = new ArrayList<UserAccount>();
                        }
                        switch (userService.getUserServiceType()) {
                            case LDAP: {
                                this.writeLdapUsersCsv(csvWriter, userAccounts);
                                break;
                            }
                            case UMS: {
                                this.writeUmsUsersCsv(csvWriter, userAccounts);
                                break;
                            }
                            case MANAGED: {
                                this.writeManagedUsersCsv(csvWriter, userAccounts);
                                break;
                            }
                            case MICROSOFT: {
                                this.writeMicrosoftUsersCsv(csvWriter, userAccounts);
                                break;
                            }
                            case OIDC: {
                                if (userService.getAuthMethodType() != AuthMethodType.OIDC_GOOGLE) break;
                                this.writeGoogleUsersCsv(csvWriter, userAccounts);
                                break;
                            }
                        }
                        zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to create user accounts csv for" + String.valueOf(userService.getUserServiceType()) + "authentication service: " + userService.getName(), (Throwable)e);
                    }
                }
                if (userService.getSynchronizeObjects() != Boolean.TRUE) return;
                switch (userService.getUserServiceType()) {
                    case LDAP: {
                        this.writeLdapComputersCsv(zipOutputStream, userService);
                        return;
                    }
                    case MICROSOFT: {
                        this.writeMicrosoftSharePointsCsv(zipOutputStream, userService);
                        this.writeMicrosoftUnifiedGroupsCsv(zipOutputStream, userService);
                        return;
                    }
                    case OIDC: {
                        if (userService.getAuthMethodType() != AuthMethodType.OIDC_GOOGLE) return;
                        this.writeGoogleGroupsCsv(zipOutputStream, userService);
                        this.writeGoogleOrgUnitsCsv(zipOutputStream, userService);
                        this.writeGoogleSharedDrivesCsv(zipOutputStream, userService);
                        this.writeGoogleChatSpacesCsv(zipOutputStream, userService);
                        return;
                    }
                }
                return;
            }
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)(fileName + ".zip"));
    }

    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/userService/{userServiceId}/csv")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response exportUserServiceCsv(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token, @PathParam(value="userServiceId") String userServiceId) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.exportUserServiceCsv(user.get(), userServiceId);
        }
        return ExceptionUtils.buildForbiddenResponse();
    }

    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Path(value="/userService/{userServiceId}/csv")
    @PUT
    public Response uploadUserServiceCsv(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="userServiceId") String userServiceId, @Parameter(description="The CSV with the list of users") FileContents fileContentsModel) throws IOException {
        String[] requiredColumns;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        com.nuix.automate.utils.models.internal.user.UserService userService = this.userServices.get(userServiceId);
        if (userService == null) {
            return ExceptionUtils.toResponse((String)"cannotFindAuthenticationService", (Map)new HashMap<String, String>(){
                {
                    this.put("userServiceId", userServiceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions();
        if (!permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)userServiceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        String fileContents = fileContentsModel.getContents();
        LOGGER.info("Loading Users from CSV file");
        UpdateUsersResponse response = new UpdateUsersResponse();
        List records = FileUtils.loadVariableColumnCsv((String)fileContents);
        Object[] header = (Object[])records.get(0);
        records.remove(0);
        HashMap<String, Integer> columnIndex = new HashMap<String, Integer>();
        for (int i = 0; i < header.length; ++i) {
            columnIndex.put(header[i].toString(), i);
        }
        ArrayList<String> missingColumns = new ArrayList<String>();
        for (String requiredColumn : requiredColumns = new String[]{"ExchangeGuid", "ExternalDirectoryObjectId", "UserPrincipalName", "DisplayName", "PrimarySmtpAddress"}) {
            if (columnIndex.containsKey(requiredColumn)) continue;
            missingColumns.add(requiredColumn);
        }
        if (missingColumns.size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.iu.getFormattedString("UserService.CSV.missingColumn", (Object)String.join((CharSequence)", ", missingColumns))).build();
        }
        boolean syncResult = this.userServiceWorkers.get(userService.getId()).tryUpdateUsers(columnIndex, records, response);
        if (!syncResult) {
            return ExceptionUtils.toResponse((String)"userServiceExecutionError", (Map)new HashMap<String, String>(){
                {
                    this.put("error", UserServiceResource.this.iu.getString("UserServiceWorker.AnotherSyncInProgress"));
                }
            });
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)response).build();
    }

    private Response verifyAndUpdateUserService(BearerUser user, com.nuix.automate.utils.models.internal.user.UserService originalUserService, com.nuix.automate.utils.models.internal.user.UserService userServiceUpdate, boolean force) {
        Set<String> existingNames;
        String name;
        this.verifyUserServiceLicenseUsage(userServiceUpdate);
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userServiceUpdate).getUserPermissions();
        if (!(user instanceof SystemBearerUser) && !permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalUserService.getId());
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (userServiceUpdate.getEnabled() != null && !userServiceUpdate.getEnabled().booleanValue()) {
            String userServiceId;
            if (user instanceof UserServiceUser && (userServiceId = ((UserServiceUser)user).getUserServiceId()).equals(userServiceUpdate.getId())) {
                return ExceptionUtils.toResponse((String)"cannotRemoveCurrentUserServiceAccess", (Response.Status)Response.Status.FORBIDDEN);
            }
            if (!force && this.checkUsersPartOfActiveLegalHold(originalUserService)) {
                return ExceptionUtils.toResponse((String)"usersPartOfActiveLegalHolds");
            }
        }
        if ((name = userServiceUpdate.getName()) != null) {
            name = name.trim();
        }
        if (name != null && name.length() > 0 && (existingNames = this.getUserServiceNames(userServiceUpdate.getId())).contains(name)) {
            return ExceptionUtils.toResponse((String)"authenticationServiceNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (userServiceUpdate.getSearchDelay() != null && userServiceUpdate.getSearchDelay() <= 0) {
            return ExceptionUtils.toResponse((String)"authenticationServiceInvalidSearchDelay", (Response.Status)Response.Status.BAD_REQUEST);
        }
        String oldName = originalUserService.getName();
        originalUserService.update(userServiceUpdate);
        this.schedulerApplication.getAuthScopeTypes().remove(oldName);
        if (originalUserService.getEnabled() == Boolean.TRUE) {
            switch (originalUserService.getUserServiceType()) {
                case LDAP: {
                    this.schedulerApplication.getAuthScopeTypes().put(originalUserService.getName(), AuthType.LDAP);
                    break;
                }
                case UMS: {
                    this.schedulerApplication.getAuthScopeTypes().put(originalUserService.getName(), AuthType.UMS);
                }
            }
        }
        return null;
    }

    private Response testUserService(com.nuix.automate.utils.models.internal.user.UserService userService, UserServiceClient userServiceClient) {
        try {
            if (!userServiceClient.supportsPasswordAuthentication()) {
                return ExceptionUtils.toResponse((String)"cantTestUserService", (Response.Status)Response.Status.BAD_REQUEST);
            }
            PasswordAuthenticationSubmission passwordAuthenticationSubmission = new PasswordAuthenticationSubmission("test", "test");
            try {
                userServiceClient.authenticateUser(passwordAuthenticationSubmission);
            }
            catch (LDAPException e) {
                if (e.getResultCode() == ResultCode.CONNECT_ERROR) {
                    throw e;
                }
            }
            catch (com.nuix.automate.utils.exceptions.AuthenticationException e) {
                // empty catch block
            }
            if (userService.getStatus().getCode() == State.ERROR) {
                userService.getStatus().reset();
            }
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("type", LocalizableEnumUtils.getLocalizedString((String)"SchedulerText", (Enum)userService.getUserServiceType()));
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userServiceTestOk", keys)).build();
        }
        catch (Exception e) {
            LOGGER.error(String.valueOf(userService.getUserServiceType()) + " authentication service configuration test failed", (Throwable)e);
            String translationString = "UserService." + userService.getUserServiceType().name() + ".UnableToConnect";
            userService.getStatus().setError(this.iu.getFormattedString(translationString, (Object)e));
            return ExceptionUtils.toResponse((String)"userServiceTestError", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    private void writeLdapUsersCsv(CSVWriter csvWriter, Collection<UserAccount> userAccounts) {
        String[] headers = new String[]{"ID", "State", "Distinguished Name", "SAM Account Name", "Name", "Email"};
        csvWriter.writeNext(headers);
        for (UserAccount userAccount : userAccounts) {
            String[] line = new String[]{userAccount.getId(), "", "", "", userAccount.getName(), userAccount.getEmail()};
            line[1] = this.iu.getString("UserAccountState." + userAccount.getUserAccountState().name());
            line[2] = String.valueOf(userAccount.getNonNullAttributeValue("distinguishedName"));
            line[3] = String.valueOf(userAccount.getNonNullAttributeValue("sAMAccountName"));
            csvWriter.writeNext(line);
        }
    }

    private void writeUmsUsersCsv(CSVWriter csvWriter, Collection<UserAccount> userAccounts) {
        String[] headers = new String[]{"ID", "State", "Name", "Email"};
        csvWriter.writeNext(headers);
        for (UserAccount userAccount : userAccounts) {
            String[] line = new String[]{userAccount.getId(), "", userAccount.getName(), userAccount.getEmail()};
            line[1] = this.iu.getString("UserAccountState." + userAccount.getUserAccountState().name());
            csvWriter.writeNext(line);
        }
    }

    private void writeManagedUsersCsv(CSVWriter csvWriter, Collection<UserAccount> userAccounts) {
        String[] headers = new String[]{"ID", "State", "Name", "Email"};
        csvWriter.writeNext(headers);
        for (UserAccount userAccount : userAccounts) {
            String[] line = new String[]{userAccount.getId(), "", userAccount.getName(), userAccount.getEmail()};
            line[1] = this.iu.getString("UserAccountState." + userAccount.getUserAccountState().name());
            csvWriter.writeNext(line);
        }
    }

    private void writeMicrosoftUsersCsv(CSVWriter csvWriter, Collection<UserAccount> userAccounts) {
        String[] headers = new String[]{"ID", "State", "User Type", "User Principal Name", "Display Name", "Email"};
        csvWriter.writeNext(headers);
        for (UserAccount userAccount : userAccounts) {
            String[] line = new String[]{userAccount.getId(), "", "", userAccount.getName(), "", userAccount.getEmail()};
            line[1] = this.iu.getString("UserAccountState." + userAccount.getUserAccountState().name());
            line[2] = String.valueOf(userAccount.getNonNullAttributeValue("userType"));
            line[4] = String.valueOf(userAccount.getNonNullAttributeValue("displayName"));
            csvWriter.writeNext(line);
        }
    }

    private void writeGoogleUsersCsv(CSVWriter csvWriter, Collection<UserAccount> userAccounts) {
        String[] headers = new String[]{"ID", "State", "Name", "Display Name", "Email", "Org Unit Path"};
        csvWriter.writeNext(headers);
        for (UserAccount userAccount : userAccounts) {
            String[] line = new String[]{userAccount.getId(), "", userAccount.getName(), "", userAccount.getEmail(), ""};
            line[1] = this.iu.getString("UserAccountState." + userAccount.getUserAccountState().name());
            line[3] = String.valueOf(userAccount.getNonNullAttributeValue("displayName"));
            line[5] = String.valueOf(userAccount.getNonNullAttributeValue("orgUnitPath"));
            csvWriter.writeNext(line);
        }
    }

    private void writeLdapComputersCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.COMPUTER, "Computers", new String[]{"ID", "SAM Account Name", "Name", "Distinguished Name", "Managed By"}, userServiceObject -> {
            LdapComputer computer = (LdapComputer)userServiceObject;
            return new String[]{computer.getId(), computer.getSAMAccountName(), computer.getName(), computer.getDN(), computer.getManagedBy()};
        });
    }

    private void writeMicrosoftSharePointsCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.SHARE_POINT_SITE, "SharePoint Sites", new String[]{"ID", "Web URL"}, userServiceObject -> {
            MicrosoftSharePointSite sharePointSite = (MicrosoftSharePointSite)userServiceObject;
            return new String[]{sharePointSite.getId(), sharePointSite.getWebUrl()};
        });
    }

    private void writeMicrosoftUnifiedGroupsCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.UNIFIED_GROUP, "Unified Groups", new String[]{"ID", "Email"}, userServiceObject -> {
            MicrosoftUnifiedGroup unifiedGroup = (MicrosoftUnifiedGroup)userServiceObject;
            return new String[]{unifiedGroup.getId(), unifiedGroup.getEmail()};
        });
    }

    private void writeGoogleGroupsCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.GOOGLE_GROUP, "Groups", new String[]{"ID", "Name", "Email"}, userServiceObject -> {
            GoogleGroup group = (GoogleGroup)userServiceObject;
            return new String[]{group.getId(), group.getName(), group.getEmail()};
        });
    }

    private void writeGoogleOrgUnitsCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.GOOGLE_ORG_UNIT, "Org Units", new String[]{"ID", "Name", "Path"}, userServiceObject -> {
            GoogleOrgUnit orgUnit = (GoogleOrgUnit)userServiceObject;
            return new String[]{orgUnit.getId(), orgUnit.getName(), orgUnit.getPath()};
        });
    }

    private void writeGoogleSharedDrivesCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.GOOGLE_SHARED_DRIVE, "Shared Drives", new String[]{"ID", "Name"}, userServiceObject -> {
            GoogleDrive drive = (GoogleDrive)userServiceObject;
            return new String[]{drive.getId(), drive.getName()};
        });
    }

    private void writeGoogleChatSpacesCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService) throws IOException {
        this.writeUserServiceObjectsCsv(zipOutputStream, userService, UserServiceObjectType.GOOGLE_CHAT_SPACE, "Chat Spaces", new String[]{"ID", "Name", "Display Name"}, userServiceObject -> {
            GoogleChatSpace chatSpace = (GoogleChatSpace)userServiceObject;
            return new String[]{chatSpace.getId(), chatSpace.getName(), chatSpace.getDisplayName()};
        });
    }

    private void writeUserServiceObjectsCsv(ZipOutputStream zipOutputStream, com.nuix.automate.utils.models.internal.user.UserService userService, UserServiceObjectType objectType, String csvFileName, String[] csvHeaders, Function<UserServiceObject, String[]> csvLineGenerator) throws IOException {
        ZipEntry computerEntry = new ZipEntry(csvFileName + ".csv");
        zipOutputStream.putNextEntry(computerEntry);
        FormattingUtils.appendBOM((OutputStream)zipOutputStream);
        Map userServiceObjects = this.getUserServiceObjects(objectType, userService.getId());
        try (StringWriter writer = new StringWriter();
             CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            csvWriter.writeNext(csvHeaders);
            for (UserServiceObject userServiceObject : userServiceObjects.values()) {
                String[] line = csvLineGenerator.apply(userServiceObject);
                csvWriter.writeNext(line);
            }
            zipOutputStream.write(((Object)writer).toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Failed to create " + csvFileName + " CSV for " + String.valueOf(userService.getUserServiceType()) + " authentication service: " + userService.getName(), (Throwable)e);
        }
    }

    public LdapClient getLdapClientForScope(String scope, String requestUrl) {
        for (com.nuix.automate.utils.models.internal.user.UserService service : this.getUserServicesOfType(UserServiceType.LDAP)) {
            if (!service.getEnabledForUserTriggerdAuth() || !service.getName().equals(scope) || !service.getAvailableForUrl(requestUrl)) continue;
            return (LdapClient)this.userServiceClients.get(service.getId());
        }
        return null;
    }

    public UmsUtil getUmsClientForScope(String scope, String requestUrl) {
        for (com.nuix.automate.utils.models.internal.user.UserService service : this.getUserServicesOfType(UserServiceType.UMS)) {
            if (!service.getEnabledForUserTriggerdAuth() || !service.getName().equals(scope) || !service.getAvailableForUrl(requestUrl)) continue;
            return (UmsUtil)this.userServiceClients.get(service.getId());
        }
        return null;
    }

    public boolean isLdapAuthenticationEnabled() {
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getEnabled() != Boolean.TRUE || userService.getUserServiceType() != UserServiceType.LDAP) continue;
            return true;
        }
        return false;
    }

    public boolean isUmsAuthenticationEnabled() {
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getEnabled() != Boolean.TRUE || userService.getUserServiceType() != UserServiceType.UMS) continue;
            return true;
        }
        return false;
    }

    public boolean isOidcAuthenticationEnabled() {
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getEnabled() != Boolean.TRUE || userService.getUserServiceType() != UserServiceType.OIDC) continue;
            return true;
        }
        return false;
    }

    public Collection<com.nuix.automate.utils.models.internal.user.UserService> getUserServices() {
        return this.userServices.values();
    }

    private com.nuix.automate.utils.models.internal.user.UserService getInternalUserService() {
        InternalUserService internalUserService = new InternalUserService();
        internalUserService.setId(UidUtils.fromString((String)UserAccountPlatform.INTERNAL.name()).toString());
        internalUserService.setUserServiceType(UserServiceType.INTERNAL);
        InternalCredentialsConfiguration internalCredentials = this.schedulerApplication.getConfiguration().getInternalCredentials();
        if (internalCredentials != null) {
            internalUserService.setName(internalCredentials.getDisplayName());
            internalUserService.setEnabled(Boolean.valueOf(true));
            internalUserService.setUsersEligibleLegalHoldAdministrator(Boolean.valueOf(internalCredentials.getUsersEligibleLegalHoldAdministrator()));
            internalUserService.setUsersEligibleLegalHoldCustodian(Boolean.valueOf(internalCredentials.getUsersEligibleLegalHoldCustodian()));
            internalUserService.setSynchronizeUsers(Boolean.valueOf(true));
            internalUserService.setEnableAuthentication(Boolean.valueOf(true));
            internalUserService.setObjectCount(Integer.valueOf(0));
            if (internalCredentials.getCredentials() != null) {
                internalUserService.setObjectCount(Integer.valueOf(internalCredentials.getCredentials().size()));
            }
        } else {
            internalUserService.setEnabled(Boolean.valueOf(false));
            internalUserService.setName("Internal");
        }
        return internalUserService;
    }

    public com.nuix.automate.utils.models.internal.user.UserService getUserService(String userServiceId) {
        if (userServiceId != null) {
            if (userServiceId.equals(UidUtils.fromString((String)UserAccountPlatform.INTERNAL.name()).toString())) {
                return this.getInternalUserService();
            }
            return this.userServices.get(userServiceId);
        }
        return null;
    }

    public Collection<LdapUserService> getLdapUserServices() {
        ArrayList<LdapUserService> ldapUserServices = new ArrayList<LdapUserService>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getUserServiceType() != UserServiceType.LDAP) continue;
            ldapUserServices.add((LdapUserService)userService);
        }
        return ldapUserServices;
    }

    public UserServiceClient getUserServiceClient(String userServiceId) {
        return this.userServiceClients.get(userServiceId);
    }

    public OidcUserServiceClient getOidcUserServiceClient(String oidcUserServiceId) {
        UserServiceClient userServiceClient = this.userServiceClients.get(oidcUserServiceId);
        if (userServiceClient instanceof OidcUserServiceClient) {
            return (OidcUserServiceClient)userServiceClient;
        }
        return null;
    }

    public String getEnabledOidcUserServiceIdForDisplayName(String displayName, String requestUrl) {
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (!(userService instanceof OidcUserService) || !userService.getName().equals(displayName) || !userService.getEnabledForUserTriggerdAuth() || !userService.getAvailableForUrl(requestUrl)) continue;
            return userService.getId();
        }
        return null;
    }

    public Collection<MicrosoftOidcUserServiceClient> getEnabledMicrosoftOidcClients() {
        ArrayList<MicrosoftOidcUserServiceClient> microsoftClients = new ArrayList<MicrosoftOidcUserServiceClient>();
        for (com.nuix.automate.utils.models.internal.user.UserService service : this.userServices.values()) {
            if (service.getEnabled() != Boolean.TRUE || service.getUserServiceType() != UserServiceType.MICROSOFT) continue;
            MicrosoftOidcUserServiceClient client = (MicrosoftOidcUserServiceClient)this.userServiceClients.get(service.getId());
            microsoftClients.add(client);
        }
        return microsoftClients;
    }

    public Collection<MicrosoftUserService> getEnabledMicrosoftUserServices() {
        ArrayList<MicrosoftUserService> microsoftUserServices = new ArrayList<MicrosoftUserService>();
        for (com.nuix.automate.utils.models.internal.user.UserService service : this.userServices.values()) {
            if (service.getEnabled() != Boolean.TRUE || service.getUserServiceType() != UserServiceType.MICROSOFT) continue;
            microsoftUserServices.add((MicrosoftUserService)service);
        }
        return microsoftUserServices;
    }

    public Collection<RelativityUserImpersonationService> getEnabledRelativityUserImpersonationService() {
        ArrayList<RelativityUserImpersonationService> relativityUserImpersonationServices = new ArrayList<RelativityUserImpersonationService>();
        for (com.nuix.automate.utils.models.internal.user.UserService service : this.userServices.values()) {
            if (service.getEnabled() != Boolean.TRUE || service.getUserServiceType() != UserServiceType.RELATIVITY_IMPERSONATION) continue;
            relativityUserImpersonationServices.add((RelativityUserImpersonationService)service);
        }
        return relativityUserImpersonationServices;
    }

    public OidcWellKnownConfigurationWorker getOidcWellKnownConfigurationWorker(String id) {
        return this.wellKnownConfigurationWorkers.get(id);
    }

    private Set<String> getUserServiceNames(String id) {
        HashSet<String> existingNames = new HashSet<String>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getId().equals(id)) continue;
            existingNames.add(userService.getName());
        }
        existingNames.add("Internal");
        return existingNames;
    }

    private List<com.nuix.automate.utils.models.internal.user.UserService> getUserServicesOfType(UserServiceType type) {
        ArrayList<com.nuix.automate.utils.models.internal.user.UserService> userServiceTypeList = new ArrayList<com.nuix.automate.utils.models.internal.user.UserService>();
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getUserServiceType() != type) continue;
            userServiceTypeList.add(userService);
        }
        return userServiceTypeList;
    }

    private int getEnabledUserServicesOfTypeCount(UserServiceType type) {
        int count = 0;
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (userService.getUserServiceType() != type || userService.getEnabled() != Boolean.TRUE) continue;
            ++count;
        }
        return count;
    }

    public Map<String, AuthType> getAuthScopeTypes() {
        LinkedHashMap<String, AuthType> authScopeTypes = new LinkedHashMap<String, AuthType>();
        InternalCredentialsConfiguration internalCredentials = this.schedulerApplication.getConfiguration().getInternalCredentials();
        if (internalCredentials != null) {
            authScopeTypes.put(internalCredentials.getDisplayName(), AuthType.INTERNAL);
        }
        for (com.nuix.automate.utils.models.internal.user.UserService userService : this.userServices.values()) {
            if (!userService.getEnabledForUserTriggerdAuth()) continue;
            switch (userService.getUserServiceType()) {
                case UMS: {
                    authScopeTypes.put(userService.getName(), AuthType.UMS);
                    break;
                }
                case LDAP: {
                    authScopeTypes.put(userService.getName(), AuthType.LDAP);
                }
            }
        }
        return authScopeTypes;
    }

    public UserAccount renderNameSuffixEmailPrefixFromStatus(UserAccount userAccount) {
        if (UserAccountState.INACTIVE.equals((Object)userAccount.getUserAccountState()) || UserAccountState.DELETED.equals((Object)userAccount.getUserAccountState())) {
            UserAccount clone = userAccount.clone();
            clone.setEmail("." + userAccount.getEmail());
            clone.setName("." + userAccount.getName());
            Object displayName = userAccount.getAttributes().get("displayName");
            if (displayName != null) {
                clone.getAttributes().put("displayName", this.iu.getFormattedString("User.SuffixName." + userAccount.getUserAccountState().name(), displayName));
            }
            return clone;
        }
        return userAccount;
    }
}

