/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.utils.api.configuration.Setting;
import com.nuix.automate.utils.api.internal.configuration.UserSettingLineModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.user.UserSettings;
import com.nuix.automate.utils.models.internal.job.JobQueueSortSettings;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/v1/scheduler")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserSettingsResource {
    public static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserSettingsResource.class);
    public static final String BUILTIN_CATEGORY_NAME = "BUILTIN";
    public static final String TROUBLESHOOT = "troubleshoot";
    public static final String TIMEZONE_SETTING = "TIMEZONE";
    public static final String JOB_CARD_DESIGNER_CATEGORY = "jobCardDesigner";
    public static final String DEFAULT_VALUES_CATEGORY = "defaultValues";
    public static final String RESOURCE_POOL_ID_SETTING = "resourcePoolId";
    public static final String EXECUTION_PROFILE_ID_SETTING = "executionProfileId";
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;
    private Map<String, UserSettings> userSettings;
    private ThreadLocal<BearerUser> user;

    public UserSettingsResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerApplication.getConfiguration();
        this.initializeUserSettingsFromStore();
        this.user = new ThreadLocal();
    }

    private void initializeUserSettingsFromStore() {
        LOGGER.info("Initializing User Settings from store");
        this.userSettings = new HashMap<String, UserSettings>();
        List<String> userSettingsUsernames = this.schedulerApplication.getUserSettingsDao().getUsernames();
        for (String username : userSettingsUsernames) {
            UserSettings settings = new UserSettings();
            List<UserSettingLineModel> userSettingsLineModels = this.schedulerApplication.getUserSettingsDao().getUserSettings(username);
            for (UserSettingLineModel userSettingLineModel : userSettingsLineModels) {
                if (!settings.containsKey((Object)userSettingLineModel.getCategory())) {
                    settings.put((Object)userSettingLineModel.getCategory(), (Object)new Setting());
                }
                ((Setting)settings.get((Object)userSettingLineModel.getCategory())).put((Object)userSettingLineModel.getKey(), (Object)userSettingLineModel.getValue());
            }
            boolean changePerformed = this.removeDuplicateJobCardDesignerSettings(settings);
            if (changePerformed) {
                this.schedulerApplication.getUserSettingsDao().deleteUserCategorySettings(username, JOB_CARD_DESIGNER_CATEGORY);
                Setting updatedJobCardSettings = (Setting)settings.get((Object)JOB_CARD_DESIGNER_CATEGORY);
                for (String key : updatedJobCardSettings.keySet()) {
                    this.schedulerApplication.getUserSettingsDao().addSetting(username, JOB_CARD_DESIGNER_CATEGORY, key, updatedJobCardSettings.get((Object)key).toString());
                }
            }
            this.userSettings.put(username, settings);
        }
    }

    public void initializeJobQueueSortSettings() {
        JobQueueSortSettings sortSettings = this.getUserCategorySetting(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), "JOB_QUEUE_SORT", JobQueueSortSettings.Queue.BACKLOG.name(), JobQueueSortSettings.class);
        if (sortSettings == null) {
            sortSettings = new JobQueueSortSettings();
            sortSettings.setSortField(JobQueueSortSettings.Field.PRIORITY_SUBMISSION_DATE);
            sortSettings.setSortOrder(JobQueueSortSettings.Order.NORMAL);
            this.updateDefaultSettingInternal("JOB_QUEUE_SORT", JobQueueSortSettings.Queue.BACKLOG.name(), sortSettings);
        }
        if ((sortSettings = this.getUserCategorySetting(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), "JOB_QUEUE_SORT", JobQueueSortSettings.Queue.RUNNING.name(), JobQueueSortSettings.class)) == null) {
            sortSettings = new JobQueueSortSettings();
            sortSettings.setSortField(JobQueueSortSettings.Field.PRIORITY_CHANGED_DATE);
            sortSettings.setSortOrder(JobQueueSortSettings.Order.NORMAL);
            this.updateDefaultSettingInternal("JOB_QUEUE_SORT", JobQueueSortSettings.Queue.RUNNING.name(), sortSettings);
        }
        if ((sortSettings = this.getUserCategorySetting(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), "JOB_QUEUE_SORT", JobQueueSortSettings.Queue.FINISHED.name(), JobQueueSortSettings.class)) == null) {
            sortSettings = new JobQueueSortSettings();
            sortSettings.setSortField(JobQueueSortSettings.Field.CHANGED_DATE);
            sortSettings.setSortOrder(JobQueueSortSettings.Order.REVERSED);
            this.updateDefaultSettingInternal("JOB_QUEUE_SORT", JobQueueSortSettings.Queue.FINISHED.name(), sortSettings);
        }
    }

    public <T> T getUserCategorySetting(String username, String category, String settingKey, Class<T> type) {
        String value = null;
        if (this.userSettings.containsKey(username) && this.userSettings.get(username) != null && this.userSettings.get(username).containsKey((Object)category) && this.userSettings.get(username).get((Object)category) != null) {
            value = (String)((Setting)this.userSettings.get(username).get((Object)category)).get((Object)settingKey);
        }
        if (value == null && this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()) != null && this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).containsKey((Object)category) && this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).get((Object)category) != null) {
            value = (String)((Setting)this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).get((Object)category)).get((Object)settingKey);
        }
        if (value != null) {
            try {
                Object deserializedValue = SerializationUtils.fromJson(value, type);
                return (T)deserializedValue;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot deserialize user " + username + " category " + category + " setting " + settingKey, (Throwable)e);
            }
        }
        return null;
    }

    @Operation(tags={"Settings"}, operationId="GetUserSettings", summary="Get User Settings", description="Get full information of all of the settings of the current user, or the default value if the current user does not define a specific setting", responses={@ApiResponse(description="The settings", content={@Content(schema=@Schema(ref="#/components/schemas/SettingsCategoriesNamesValues"))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userSettings")
    @GET
    public Response getUserSettings(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get user settings");
        }
        UserSettings specificUserSettings = this.getUserSettingsInternal(user);
        String lastHash = ResponseCache.getInstance().hashObject((Object)specificUserSettings);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)specificUserSettings).build();
        }
    }

    public UserSettings getUserSettingsInternal(@Parameter(hidden=true) @Auth BearerUser user) {
        UserSettings specificUserSettings = this.getDefaultUserSettings();
        if (this.userSettings.containsKey(user.getName())) {
            specificUserSettings.putAll(this.deserializeSettings((Map)this.userSettings.get(user.getName())));
        }
        List<UserSettingLineModel> defaultUserSettingLines = this.schedulerApplication.getUserSettingsDao().getUserSettings(BuiltInPrincipalIdentifiers.DEFAULT_USER.name());
        for (UserSettingLineModel userSettingLineModel : defaultUserSettingLines) {
            if (!specificUserSettings.containsKey((Object)userSettingLineModel.getCategory())) {
                specificUserSettings.put((Object)userSettingLineModel.getCategory(), (Object)new Setting());
            }
            Object value = SerializationUtils.fromJson((String)userSettingLineModel.getValue(), Object.class);
            ((Setting)specificUserSettings.get((Object)userSettingLineModel.getCategory())).put((Object)userSettingLineModel.getKey(), value);
        }
        List<UserSettingLineModel> userSettingLines = this.schedulerApplication.getUserSettingsDao().getUserSettings(user.getName());
        for (UserSettingLineModel userSettingLineModel : userSettingLines) {
            if (!specificUserSettings.containsKey((Object)userSettingLineModel.getCategory())) {
                specificUserSettings.put((Object)userSettingLineModel.getCategory(), (Object)new Setting());
            }
            Object value = SerializationUtils.fromJson((String)userSettingLineModel.getValue(), Object.class);
            ((Setting)specificUserSettings.get((Object)userSettingLineModel.getCategory())).put((Object)userSettingLineModel.getKey(), value);
        }
        this.migrateUserSettings(specificUserSettings);
        return specificUserSettings;
    }

    private UserSettings getDefaultUserSettings() {
        UserSettings userSettings = new UserSettings();
        for (String category : this.schedulerConfiguration.getDefaultUserSettings().keySet()) {
            Map<String, Object> defaultSettings = this.schedulerConfiguration.getDefaultUserSettings().get(category);
            Setting settings = new Setting();
            settings.putAll(defaultSettings);
            userSettings.put((Object)category, (Object)settings);
        }
        userSettings.putAll(this.deserializeSettings((Map)this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name())));
        return userSettings;
    }

    private Map<String, Setting> deserializeSettings(Map<String, Setting> serializedSettings) {
        HashMap<String, Setting> deserializedSettings = new HashMap<String, Setting>();
        for (Map.Entry<String, Setting> entry : serializedSettings.entrySet()) {
            Setting serializedSetting = entry.getValue();
            Setting deserializedSetting = new Setting();
            for (Map.Entry settingEntry : serializedSetting.entrySet()) {
                Object value = null;
                if (settingEntry.getValue() != null) {
                    try {
                        value = SerializationUtils.fromJson((String)((String)settingEntry.getValue()), Object.class);
                    }
                    catch (Exception e) {
                        value = null;
                    }
                }
                deserializedSetting.put((Object)((String)settingEntry.getKey()), value);
            }
            deserializedSettings.put(entry.getKey(), deserializedSetting);
        }
        return deserializedSettings;
    }

    private boolean removeDuplicateJobCardDesignerSettings(UserSettings userSettings) {
        boolean changePerformed = false;
        HashSet<CallSite> typePositions = new HashSet<CallSite>();
        HashSet<String> duplicateKeys = new HashSet<String>();
        Map<String, Setting> deserializedSettings = this.deserializeSettings((Map<String, Setting>)userSettings);
        Map jobCardDesignerSettings = (Map)deserializedSettings.get(JOB_CARD_DESIGNER_CATEGORY);
        if (jobCardDesignerSettings != null) {
            for (String jobCardKey : jobCardDesignerSettings.keySet()) {
                try {
                    Map jobCardMap = (Map)jobCardDesignerSettings.get(jobCardKey);
                    String typePosition = String.valueOf(jobCardMap.get("type")) + "_" + String.valueOf(jobCardMap.get("position"));
                    if (typePositions.contains(typePosition)) {
                        duplicateKeys.add(jobCardKey);
                    }
                    typePositions.add((CallSite)((Object)typePosition));
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot normalize user settings key " + jobCardKey, (Throwable)e);
                }
            }
            for (String duplicateKey : duplicateKeys) {
                try {
                    ((Setting)userSettings.get((Object)JOB_CARD_DESIGNER_CATEGORY)).remove((Object)duplicateKey);
                    changePerformed = true;
                }
                catch (Exception e) {
                    LOGGER.error("Cannot remove duplicate key");
                }
            }
        }
        return changePerformed;
    }

    private void migrateUserSettings(UserSettings userSettings) {
        ArrayList<String> migrateKeys = new ArrayList<String>();
        migrateKeys.add("position");
        migrateKeys.add("size");
        Map jobCardDesignerSettings = (Map)userSettings.get((Object)JOB_CARD_DESIGNER_CATEGORY);
        if (jobCardDesignerSettings != null) {
            for (String jobCardKey : jobCardDesignerSettings.keySet()) {
                try {
                    Map jobCardMap = (Map)jobCardDesignerSettings.get(jobCardKey);
                    for (String migrateKey : migrateKeys) {
                        String migratedSetting;
                        String setting = (String)jobCardMap.get(migrateKey);
                        if (setting.equals(migratedSetting = FormattingUtils.toConstantName((String)setting))) continue;
                        jobCardMap.put(migrateKey, migratedSetting);
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Cannot normalize user settings key " + jobCardKey, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefaultSettingInternal(String category, String setting, Object value) {
        Map<String, UserSettings> map = this.userSettings;
        synchronized (map) {
            if (category == null || setting == null) {
                return;
            }
            if (!this.userSettings.containsKey(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()) || this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()) == null) {
                this.userSettings.put(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), new UserSettings());
            }
            if (!this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).containsKey((Object)category) || this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).get((Object)category) == null) {
                this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).put((Object)category, (Object)new Setting());
            }
            String encodedValue = SerializationUtils.toJson((Object)value);
            ((Setting)this.userSettings.get(BuiltInPrincipalIdentifiers.DEFAULT_USER.name()).get((Object)category)).put((Object)setting, (Object)encodedValue);
            if (this.schedulerApplication.getUserSettingsDao().updateSetting(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), category, setting, encodedValue) == 0) {
                this.schedulerApplication.getUserSettingsDao().addSetting(BuiltInPrincipalIdentifiers.DEFAULT_USER.name(), category, setting, encodedValue);
            }
        }
    }

    @Operation(tags={"Settings"}, operationId="UpdateDefaultUserSetting", summary="Update Default User Setting", description="Update the default user setting from the category with the specified name", responses={@ApiResponse(description="The update status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/defaultUserSettings/{category}/{setting}")
    @PUT
    public Response updateDefaultUserSetting(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The category from which to update the setting") @PathParam(value="category") String category, @Parameter(description="The name of the setting to update") @PathParam(value="setting") String setting, @Parameter(description="The new value of the setting") Object value) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SETTINGS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)(category + " " + setting));
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.updateDefaultSettingInternal(category, setting, value);
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SETTINGS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingUpdatedSuccessfully")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Settings"}, operationId="UpdateUserSetting", summary="Update User Setting", description="Update the specified user setting from the category with the specified name", responses={@ApiResponse(description="The update status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userSettings/{category}/{setting}")
    @PUT
    public Response updateUserSetting(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The category from which to update the setting") @PathParam(value="category") String category, @Parameter(description="The name of the setting to update") @PathParam(value="setting") String setting, @Parameter(description="The new value of the setting") Object value) {
        Map<String, UserSettings> map = this.userSettings;
        synchronized (map) {
            if (!this.userSettings.containsKey(user.getName()) || this.userSettings.get(user.getName()) == null) {
                this.userSettings.put(user.getName(), new UserSettings());
            }
            if (!this.userSettings.get(user.getName()).containsKey((Object)category) || this.userSettings.get(user.getName()).get((Object)category) == null) {
                this.userSettings.get(user.getName()).put((Object)category, (Object)new Setting());
            }
            if (category.equals(JOB_CARD_DESIGNER_CATEGORY)) {
                Map<String, Setting> currentUserSettings;
                Setting currentUserJobCardDesigner;
                UserSettings previousUserSettings = this.getDefaultUserSettings();
                Setting previousJobCardDesignerSettings = (Setting)previousUserSettings.get((Object)JOB_CARD_DESIGNER_CATEGORY);
                if (this.userSettings.containsKey(user.getName()) && (currentUserJobCardDesigner = (currentUserSettings = this.deserializeSettings((Map)this.userSettings.get(user.getName()))).get(JOB_CARD_DESIGNER_CATEGORY)).keySet().size() > 0) {
                    previousJobCardDesignerSettings = currentUserJobCardDesigner;
                }
                if (previousJobCardDesignerSettings != null) {
                    for (String key : previousJobCardDesignerSettings.keySet()) {
                        String encodedValue = SerializationUtils.toJson((Object)previousJobCardDesignerSettings.get((Object)key));
                        ((Setting)this.userSettings.get(user.getName()).get((Object)category)).put((Object)key, (Object)encodedValue);
                        if (this.schedulerApplication.getUserSettingsDao().updateSetting(user.getName(), category, key, encodedValue) != 0) continue;
                        this.schedulerApplication.getUserSettingsDao().addSetting(user.getName(), category, key, encodedValue);
                    }
                }
            }
            String encodedValue = SerializationUtils.toJson((Object)value);
            ((Setting)this.userSettings.get(user.getName()).get((Object)category)).put((Object)setting, (Object)encodedValue);
            if (this.schedulerApplication.getUserSettingsDao().updateSetting(user.getName(), category, setting, encodedValue) == 0) {
                this.schedulerApplication.getUserSettingsDao().addSetting(user.getName(), category, setting, encodedValue);
            }
            if (category.equals(BUILTIN_CATEGORY_NAME) && setting.equals(TIMEZONE_SETTING)) {
                this.trackUserTimezone(user.getName().toLowerCase(), value.toString());
            }
            if (category.equals(TROUBLESHOOT) && setting.startsWith("logApi")) {
                Boolean logEnabled = Boolean.parseBoolean(value.toString());
                this.schedulerApplication.getLogsResource().getWriter().setApiLogEnabled(setting, user.getName(), logEnabled != null && logEnabled != false);
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.USER_SETTINGS, "");
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingUpdatedSuccessfully")).build();
    }

    private void trackUserTimezone(String username, String timezone) {
        User user = new User();
        user.setUserName(username.toLowerCase());
        user.setUserTimeZone(timezone);
        user.setUserId(User.getIdFromName((String)username, (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<User> users = new HashSet<User>();
        utilizationRecords.setUsers(users);
        users.add(user);
        LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
        if (licenseSession != null) {
            licenseSession.tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
        this.schedulerApplication.getUtilizationDaoV2().replaceUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Settings"}, operationId="ResetUserSetting", summary="Reset UserSetting", description="Reset the specified user setting from the category with the specified name", responses={@ApiResponse(description="The reset status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userSettings/{category}/{setting}")
    @DELETE
    public Response resetAllUserSettings(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The category from which to reset the setting") @PathParam(value="category") String category, @Parameter(description="The name of the setting to reset") @PathParam(value="setting") String setting) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Map<String, UserSettings> map = this.userSettings;
        synchronized (map) {
            if (this.userSettings.containsKey(user.getName()) && this.userSettings.get(user.getName()) != null && this.userSettings.get(user.getName()).containsKey((Object)category)) {
                ((Setting)this.userSettings.get(user.getName()).get((Object)category)).remove((Object)setting);
            }
            this.schedulerApplication.getUserSettingsDao().deleteUserSetting(user.getName(), category, setting);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SETTINGS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingResetSuccessfully")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Settings"}, operationId="ResetUserSettings", summary="Reset User Settings", description="Reset the all user settings from the category with the specified name", responses={@ApiResponse(description="The reset status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userSettings/{category}")
    @DELETE
    public Response resetAllUserSettings(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The category for which to reset the settings") @PathParam(value="category") String category) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Map<String, UserSettings> map = this.userSettings;
        synchronized (map) {
            if (this.userSettings.containsKey(user.getName()) && this.userSettings.get(user.getName()) != null) {
                this.userSettings.get(user.getName()).remove((Object)category);
            }
            this.schedulerApplication.getUserSettingsDao().deleteUserCategorySettings(user.getName(), category);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SETTINGS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingResetSuccessfully")).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Settings"}, operationId="ResetAllUserSettings", summary="Reset All User Settings", description="Reset the all user settings from all categories", responses={@ApiResponse(description="The reset status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/userSettings")
    @DELETE
    public Response resetAllUserSettings(@Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Map<String, UserSettings> map = this.userSettings;
        synchronized (map) {
            this.userSettings.put(user.getName(), new UserSettings());
            this.schedulerApplication.getUserSettingsDao().deleteAllUserSettings(user.getName());
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.USER_SETTINGS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingResetSuccessfully")).build();
    }

    public ThreadLocal<BearerUser> getUser() {
        return this.user;
    }
}

