/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.bearer;

import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.nuix.automate.dropwizard.utils.security.bearer.ApiBearerUser;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.bearer.ApiKeyUser;
import com.nuix.automate.scheduler.security.bearer.BearerUserToken;
import com.nuix.automate.scheduler.security.bearer.OAuthBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.GenericOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.InvalidTokenException;
import com.nuix.automate.scheduler.security.oidc.generic.OidcJwtUser;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.relativity.RelativityImpersonatedBearerUser;
import com.nuix.automate.scheduler.security.relativity.RelativityImpersonationUtils;
import com.nuix.automate.scheduler.workers.OidcWellKnownConfigurationWorker;
import com.nuix.automate.utils.exceptions.AuthenticationResponseException;
import com.nuix.automate.utils.exceptions.JwtException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.JwtUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.user.Logout;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.user.UserSession;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.security.SecurityUtils;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BearerAuthenticator
implements Authenticator<String, BearerUser> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BearerAuthenticator.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final String SSO_SERVICE_USER_NAME = "__SSO";
    private final SchedulerApplication schedulerApplication;
    private final SchedulerConfiguration schedulerConfiguration;
    private JwkProvider jwkProvider;
    private final Map<String, BearerUserToken> tokenToBearerUserToken;
    private final Map<String, String> uiTokenToToken;

    public BearerAuthenticator(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
        this.tokenToBearerUserToken = new ConcurrentHashMap<String, BearerUserToken>();
        this.uiTokenToToken = new ConcurrentHashMap<String, String>();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleWithFixedDelay(this::expireTokens, 0L, 10L, TimeUnit.SECONDS);
    }

    public BearerUserToken getBearerUserToken(String token) {
        return this.tokenToBearerUserToken.get(token);
    }

    public String getTokenFromApiSecret() {
        return this.getTokenFromApiSecret(this.schedulerApplication.getInstanceId());
    }

    private String getJobApiHeaderData(JobModel jobModel) {
        try {
            String unhashedData = jobModel.getSubmittedDate() + ":" + jobModel.getId();
            String hashedData = SecurityUtils.computeSha256Hex((String)unhashedData);
            return hashedData;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public String getJobApiBearerToken(JobModel jobModel) {
        try {
            String jobApiBearerToken = "job:" + jobModel.getId() + ":" + this.schedulerApplication.getEncryptor().encrypt(this.getJobApiHeaderData(jobModel));
            return jobApiBearerToken;
        }
        catch (IOException e) {
            LOGGER.error("Cannot set jobApiSecret");
            return null;
        }
    }

    public String getTokenFromApiSecret(String instanceId) {
        return SecurityUtils.getTokenFromApiSecret((String)this.schedulerConfiguration.getApiSecret(), (String)instanceId);
    }

    public String getTokenFromApiSecret(String instanceId, String nonce) {
        return SecurityUtils.getTokenFromApiSecret((String)this.schedulerConfiguration.getApiSecret(), (String)instanceId, (String)nonce);
    }

    public UserSession registerUser(BearerUser bearerUser) {
        BearerUserToken bearerUserToken = new BearerUserToken(bearerUser);
        bearerUserToken.generateTokens(this.schedulerConfiguration.getDowngradeWebWorkerToken());
        try {
            if (this.schedulerConfiguration.isEnforceSingleUserSession() && !(bearerUser instanceof ApiBearerUser) && !(bearerUser instanceof ApiKeyUser) && !(bearerUser instanceof OAuthBearerUser)) {
                String invalidateUserToken = null;
                for (Map.Entry<String, BearerUserToken> entry : this.tokenToBearerUserToken.entrySet()) {
                    String otherName;
                    BearerUser compareUser = entry.getValue().getBearerUser();
                    String name = this.normalizeUsername(compareUser.getName());
                    if (!name.equals(otherName = this.normalizeUsername(bearerUser.getName())) && (compareUser.getId() == null || !compareUser.getId().equals(bearerUser.getId()))) continue;
                    invalidateUserToken = entry.getKey();
                    break;
                }
                if (invalidateUserToken != null) {
                    this.invalidateUserToken(invalidateUserToken);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to invalidate session", (Throwable)e);
        }
        this.tokenToBearerUserToken.put(bearerUserToken.getToken(), bearerUserToken);
        this.uiTokenToToken.put(bearerUserToken.getUiToken(), bearerUserToken.getToken());
        this.trackOfflineUser(bearerUser);
        return new UserSession(bearerUserToken.getBearerUser().getName(), bearerUserToken.getToken(), bearerUserToken.getUiToken());
    }

    private String normalizeUsername(String username) {
        username = username.toLowerCase();
        username = username.trim();
        return username;
    }

    public UserSession refreshUserToken(String token) {
        BearerUserToken bearerUserToken = this.tokenToBearerUserToken.get(token);
        if (bearerUserToken == null) {
            throw new IllegalStateException("Cannot get BearerToken from token, the token likely expired");
        }
        bearerUserToken.setInvalidatedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        BearerUserToken refreshedToken = new BearerUserToken(bearerUserToken.getBearerUser());
        refreshedToken.generateTokens(this.schedulerConfiguration.getDowngradeWebWorkerToken());
        this.tokenToBearerUserToken.put(refreshedToken.getToken(), refreshedToken);
        this.uiTokenToToken.put(refreshedToken.getUiToken(), refreshedToken.getToken());
        return new UserSession(refreshedToken.getBearerUser().getName(), refreshedToken.getToken(), refreshedToken.getUiToken());
    }

    public void invalidateUserToken(String token) {
        this.invalidateUserToken(token, false);
    }

    public void invalidateUserToken(String token, boolean trackExpired) {
        BearerUserToken bearerUserToken = this.tokenToBearerUserToken.get(token);
        if (!trackExpired) {
            this.tokenToBearerUserToken.remove(token);
        }
        if (bearerUserToken != null) {
            BearerUser user;
            bearerUserToken.setInvalidatedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            if (!trackExpired && bearerUserToken.getUiToken() != null) {
                this.uiTokenToToken.remove(bearerUserToken.getUiToken());
            }
            if ((user = bearerUserToken.getBearerUser()) != null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), user.getSessionId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.AUTH_LOGOUT, "", "N/A"));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGOUT, new Logout(user.getName(), user.getSessionId()), user.getName());
                user.invalidate();
                this.schedulerApplication.getUserResource().handleUtilizationUserLogOut(user.getName());
                this.schedulerApplication.getJobResource().removeJobFilterForSession(user.getSessionId());
            }
        }
    }

    public Optional<BearerUser> authenticateWithUiToken(String uiToken, HttpServletRequest req) throws AuthenticationException {
        String token;
        if (uiToken == null) {
            try {
                BearerUser user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(req);
                return Optional.of(user);
            }
            catch (AuthenticationResponseException e) {
                LOGGER.warn("Cannot authenticate user from header", (Throwable)e);
            }
        }
        if ((token = this.uiTokenToToken.get(uiToken)) != null) {
            return this.authenticate(token);
        }
        return this.authenticate(uiToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<BearerUser> authenticate(String token) throws AuthenticationException {
        BearerUser user;
        BearerUserToken bearerUserToken;
        block40: {
            String jobHandle;
            String keySecret;
            String[] splits;
            block39: {
                bearerUserToken = this.tokenToBearerUserToken.get(token);
                user = null;
                if (bearerUserToken != null) {
                    user = bearerUserToken.getBearerUser();
                    user.setBearerToken(token);
                    Long invalidatedDate = bearerUserToken.getInvalidatedDate();
                    long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    if (invalidatedDate != null && currentTime - invalidatedDate > this.schedulerApplication.getConfiguration().getExpiredAuthTokenGracePeriod()) {
                        String sessionId = bearerUserToken.getBearerUser().getSessionId();
                        Iterator<BearerUserToken> iterator = this.tokenToBearerUserToken.values().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)iu.getString("UserResource.TokenExpired")).build());
                            }
                            BearerUserToken t = iterator.next();
                            if (t.getInvalidatedDate() != null || !sessionId.equals(t.getBearerUser().getSessionId())) continue;
                            LOGGER.warn("Attempting to login with with invalid token on session " + sessionId + ". Invalidating active token for this session.");
                            this.invalidateUserToken(t.getToken(), true);
                        }
                    }
                }
                if (user == null && token.equals(this.getTokenFromApiSecret())) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Token is for SSO authentication");
                    }
                    user = new ApiBearerUser();
                }
                if (user == null) {
                    try {
                        Map tokenClaims = JwtUtils.getTokenClaimsNoVerify((String)token);
                        Object userTokenIssuerObject = tokenClaims.get("iss");
                        if (userTokenIssuerObject == null) break block39;
                        String userTokenIssuer = userTokenIssuerObject.toString();
                        for (UserService userService : this.schedulerApplication.getUserServiceResource().getUserServices()) {
                            if (!(userService instanceof OidcUserService)) continue;
                            OidcUserService oidcUserService = (OidcUserService)userService;
                            OidcWellKnownConfigurationWorker userServiceWorker = this.schedulerApplication.getUserServiceResource().getOidcWellKnownConfigurationWorker(oidcUserService.getId());
                            Object userServiceIssuerObject = userServiceWorker.getWellKnownConfiguration().get("issuer");
                            if (userServiceIssuerObject == null || !userServiceIssuerObject.toString().equals(userTokenIssuer)) continue;
                            try {
                                OidcUserServiceClient userServiceClient;
                                if (!Boolean.TRUE.equals(oidcUserService.getEnableJwtAccessToken()) || !Boolean.TRUE.equals(oidcUserService.getEnabled()) || !((userServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(oidcUserService.getId())) instanceof GenericOidcUserServiceClient)) continue;
                                GenericOidcUserServiceClient genericOidcUserServiceClient = (GenericOidcUserServiceClient)userServiceClient;
                                OidcJwtUser oidcJwtUser = genericOidcUserServiceClient.getUserFromAccessToken(token);
                                user = oidcJwtUser;
                                bearerUserToken = new BearerUserToken(user);
                                this.tokenToBearerUserToken.put(token, bearerUserToken);
                                this.schedulerApplication.getBearerAuthenticator().registerUser(user);
                                break;
                            }
                            catch (JwkException ex) {
                                throw new InvalidTokenException(ex);
                            }
                        }
                    }
                    catch (JwtException tokenClaims) {
                    }
                    catch (InvalidTokenException e) {
                        LOGGER.error("Cannot authentication user", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot parse JWT token", (Throwable)e);
                    }
                }
            }
            if (user == null && this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients().size() > 0) {
                for (MicrosoftOidcUserServiceClient microsoftOidcUserServiceClient : this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients()) {
                    try {
                        user = microsoftOidcUserServiceClient.getUserFromToken(token);
                        break;
                    }
                    catch (JWTDecodeException e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Token is not JWT");
                    }
                    catch (JwkException | JWTVerificationException e) {
                        LOGGER.debug("Token is not valid for service " + microsoftOidcUserServiceClient.getOidcUserService().getId(), e);
                    }
                }
            }
            if (user == null && (splits = token.split(":")).length == 2) {
                String keyId = splits[0];
                keySecret = splits[1];
                user = this.schedulerApplication.getApiKeyResource().authenticateWithApiKey(keyId, keySecret);
            }
            if (user == null && (splits = token.split(":")).length == 2) {
                String keyId = splits[0];
                keySecret = splits[1];
                user = this.schedulerApplication.getApiKeyResource().authenticateWithEphemeralApiKey(keyId, keySecret);
            }
            if (user == null && (splits = token.split(":")).length == 2) {
                String keyId = splits[0];
                String jwtToken = splits[1];
                for (RelativityUserImpersonationService relativityUserImpersonationService : this.schedulerApplication.getUserServiceResource().getEnabledRelativityUserImpersonationService()) {
                    if (!relativityUserImpersonationService.getId().equals(keyId)) continue;
                    try {
                        user = RelativityImpersonationUtils.getUserFromToken(relativityUserImpersonationService, jwtToken);
                        break;
                    }
                    catch (JWTDecodeException e) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("Token is not JWT");
                    }
                    catch (JwkException | JWTVerificationException e) {
                        LOGGER.warn("Token is not valid for service " + relativityUserImpersonationService.getId(), e);
                    }
                }
            }
            if (user == null && (splits = token.split(":")).length == 3 && (jobHandle = splits[0]).equals("job")) {
                try {
                    String jobId = splits[1];
                    JobDetailsModel job = this.schedulerApplication.getJobResource().getRunningJobModel(jobId);
                    if (job != null) {
                        String jobSubmittedSecretEncrypted = splits[2];
                        String jobSubmittedSecret = this.schedulerApplication.getEncryptor().decrypt(jobSubmittedSecretEncrypted);
                        String jobExpectedSecret = this.getJobApiHeaderData(job.getSettings());
                        if (jobSubmittedSecret != null && jobSubmittedSecret.equals(jobExpectedSecret)) {
                            OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(job.getSettings().getSubmitterUserId());
                            user = new OfflineBearerUser(offlineUser);
                            LOGGER.info("Authenticated with job id " + jobId + " API bearer token");
                        }
                        break block40;
                    }
                    LOGGER.warn("Received request to authenticate with job id " + jobId + " API bearer token, but job does not exist or is not running.");
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot decrypt job secret ", (Throwable)e);
                }
            }
        }
        if (user == null) {
            return Optional.empty();
        }
        if (!(user instanceof ApiBearerUser || user instanceof ApiKeyUser || user instanceof OAuthBearerUser || user instanceof RelativityImpersonatedBearerUser || user instanceof OfflineBearerUser || user instanceof OidcJwtUser)) {
            String userNameLock = String.valueOf(this.getClass()) + "_" + user.getName();
            long entryMillis = System.currentTimeMillis();
            String string = userNameLock.intern();
            synchronized (string) {
                long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                String tokenPastValidityReason = bearerUserToken.isTokenPastValidity();
                if (tokenPastValidityReason != null && bearerUserToken.getInvalidatedDate() == null) {
                    LOGGER.warn("User " + user.getName() + ", session " + user.getSessionId() + ", token expired," + tokenPastValidityReason + ", invalidating token, entry millis: " + entryMillis);
                    this.invalidateUserToken(token, true);
                    if (currentMillis - bearerUserToken.getExpiryMillis() > this.schedulerApplication.getConfiguration().getExpiredAuthTokenGracePeriod()) {
                        throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)iu.getString("UserResource.TokenExpired")).build());
                    }
                }
                if (!bearerUserToken.refreshUser()) {
                    LOGGER.info("Failed to refresh " + user.getName() + " user token, invalidating session");
                    this.invalidateUserToken(token, true);
                    return Optional.empty();
                }
                bearerUserToken.setLastAccessedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User session is valid: " + user.toString());
        }
        return Optional.of(user);
    }

    private void trackOfflineUser(BearerUser user) {
        if (user.getId() != null) {
            OfflineUser offlineUser = new OfflineUser();
            offlineUser.setId(user.getId());
            offlineUser.setMainIdentifier(user.getIdentifier());
            offlineUser.setIdentifiers(user.getIdentifiers());
            if (this.schedulerApplication.getSecurityDao().updateOfflineUser(offlineUser) == 0) {
                this.schedulerApplication.getSecurityDao().addOfflineUser(offlineUser);
            }
        }
    }

    private void expireTokens() {
        HashSet<String> expiredTokens = new HashSet<String>();
        ArrayList<BearerUserToken> expiredUsersToRemove = new ArrayList<BearerUserToken>();
        long expiredTokenTtlMillis = this.schedulerConfiguration.getExpiredAuthTokenTombstone() * 1000L;
        for (String token : this.tokenToBearerUserToken.keySet()) {
            BearerUserToken bearerUserToken = this.tokenToBearerUserToken.get(token);
            Long expiredDate = bearerUserToken.getInvalidatedDate();
            String tokenPastValidityReason = bearerUserToken.isTokenPastValidity();
            if (expiredDate == null && tokenPastValidityReason != null) {
                LOGGER.warn("User " + bearerUserToken.getBearerUser().getName() + ", session " + bearerUserToken.getBearerUser().getSessionId() + ", token expired," + tokenPastValidityReason + ", invalidating token");
                expiredTokens.add(token);
                continue;
            }
            if (expiredDate == null || DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - expiredDate <= expiredTokenTtlMillis) continue;
            expiredUsersToRemove.add(bearerUserToken);
        }
        for (String token : expiredTokens) {
            this.invalidateUserToken(token, true);
        }
        for (BearerUserToken bearerUserToken : expiredUsersToRemove) {
            this.tokenToBearerUserToken.remove(bearerUserToken.getToken());
            this.uiTokenToToken.remove(bearerUserToken.getUiToken());
        }
    }

    public UserAccount getCachedUser(String currentUserEmail) {
        Map<String, UserAccount> cachedUsers = this.schedulerApplication.getUserServiceResource().getUsers();
        for (UserAccount cachedUser : cachedUsers.values()) {
            UserService cachedUserUserService;
            if (cachedUser.getEmail() == null || !cachedUser.getEmail().equalsIgnoreCase(currentUserEmail) || !cachedUser.getUserAccountState().equals((Object)UserAccountState.ACTIVE) || (cachedUserUserService = this.schedulerApplication.getUserServiceResource().getUserService(cachedUser.getUserServiceId())) == null || !cachedUserUserService.getEnabled().booleanValue()) continue;
            LOGGER.info("Mapped OIDC user with email " + currentUserEmail + " to existing user " + cachedUser.getId() + " from service " + cachedUser.getUserServiceId());
            return cachedUser;
        }
        return null;
    }

    public Set<String> getActiveUserNames() {
        HashSet<String> userNames = new HashSet<String>();
        for (String token : this.tokenToBearerUserToken.keySet()) {
            BearerUser user = this.tokenToBearerUserToken.get(token).getBearerUser();
            if (user.getName().equals(SSO_SERVICE_USER_NAME)) continue;
            userNames.add(user.getName());
        }
        return userNames;
    }
}

