/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.bearer;

import com.nuix.automate.dropwizard.utils.security.bearer.ApiBearerUser;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.bearer.ApiKeyUser;
import com.nuix.automate.scheduler.security.bearer.OAuthBearerUser;
import com.nuix.automate.scheduler.security.oidc.generic.OidcJwtUser;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.security.SecurityUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class BearerUserToken {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(BearerUserToken.class);
    private String token;
    private String uiToken;
    private BearerUser bearerUser;
    private long createdDate;
    private long lastAccessedDate;
    private long lastUserRefresh;
    private Long invalidatedDate;

    public BearerUserToken(BearerUser bearerUser) {
        this.bearerUser = bearerUser;
        this.lastUserRefresh = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public void generateTokens(boolean sameTokenAndUiToken) {
        this.lastAccessedDate = this.createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.token = this.generateToken();
        this.uiToken = !sameTokenAndUiToken ? this.generateToken() : this.token;
        this.bearerUser.setBearerToken(this.token);
    }

    public String isTokenPastValidity() {
        SchedulerConfiguration schedulerConfiguration = SchedulerApplication.getInstance().getConfiguration();
        Object expired = "Default Token Expired";
        try {
            if (this.bearerUser instanceof ApiBearerUser || this.bearerUser instanceof ApiKeyUser || this.bearerUser instanceof OAuthBearerUser) {
                return null;
            }
            long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            if (this.bearerUser instanceof OidcJwtUser) {
                OidcJwtUser oidcJwtUser = (OidcJwtUser)this.bearerUser;
                long tokenExpirationEpoch = oidcJwtUser.getExpirationEpoch();
                expired = currentTime > oidcJwtUser.getExpirationEpoch() ? "currentTime > tokenExpirationEpoch:  " + currentTime + " > " + tokenExpirationEpoch : null;
            } else {
                boolean isExpired;
                long tokenTimeToLive = schedulerConfiguration.getAuthTokenTtl() * 1000L;
                long userSessionTimeout = schedulerConfiguration.getUserSessionTimeout() * 1000L;
                if (!schedulerConfiguration.getDisableAuthTokenExpiration() && schedulerConfiguration.getAuthTokenTtl() > 0L) {
                    boolean bl = isExpired = currentTime - this.createdDate > tokenTimeToLive;
                    expired = isExpired ? "(currentTime - createdDate) > tokenTimeToLive: (" + currentTime + " - " + this.createdDate + ") > " + tokenTimeToLive : null;
                } else {
                    expired = null;
                }
                boolean bl = isExpired = currentTime - this.lastAccessedDate > userSessionTimeout;
                if (isExpired) {
                    expired = "(currentTime - lastAccessedDate) > userSessionTimeout: (" + currentTime + " - " + this.lastAccessedDate + ") > " + userSessionTimeout;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not determine if token is expired", (Throwable)e);
        }
        return expired;
    }

    public long getExpiryMillis() {
        SchedulerConfiguration schedulerConfiguration = SchedulerApplication.getInstance().getConfiguration();
        if (this.bearerUser instanceof OidcJwtUser) {
            return ((OidcJwtUser)this.bearerUser).getExpirationEpoch();
        }
        if (!schedulerConfiguration.getDisableAuthTokenExpiration() && schedulerConfiguration.getAuthTokenTtl() > 0L) {
            return this.createdDate + schedulerConfiguration.getAuthTokenTtl() * 1000L;
        }
        return this.lastAccessedDate + schedulerConfiguration.getUserSessionTimeout() * 1000L;
    }

    public boolean refreshUser() {
        SchedulerConfiguration schedulerConfiguration = SchedulerApplication.getInstance().getConfiguration();
        boolean refreshed = false;
        try {
            if (this.bearerUser instanceof ApiBearerUser || this.bearerUser instanceof ApiKeyUser || this.bearerUser instanceof OAuthBearerUser) {
                return true;
            }
            if (DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.lastUserRefresh > schedulerConfiguration.getAuthRefresh() * 1000L) {
                refreshed = this.bearerUser.refresh();
                this.lastUserRefresh = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            } else {
                refreshed = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to refresh user: " + this.bearerUser.getName(), (Throwable)e);
        }
        return refreshed;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getUiToken() {
        return this.uiToken;
    }

    public void setUiToken(String uiToken) {
        this.uiToken = uiToken;
    }

    public BearerUser getBearerUser() {
        return this.bearerUser;
    }

    public void setBearerUser(BearerUser bearerUser) {
        this.bearerUser = bearerUser;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    public void setLastAccessedDate(long lastAccessedDate) {
        this.lastAccessedDate = lastAccessedDate;
    }

    public long getLastUserRefresh() {
        return this.lastUserRefresh;
    }

    public void setLastUserRefresh(long lastUserRefresh) {
        this.lastUserRefresh = lastUserRefresh;
    }

    public Long getInvalidatedDate() {
        return this.invalidatedDate;
    }

    public void setInvalidatedDate(Long invalidatedDate) {
        this.invalidatedDate = invalidatedDate;
    }

    private String generateToken() {
        return this.bearerUser.getSessionId() + ":" + SecurityUtils.getSecureRandomSecret();
    }
}

