/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.ldap;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.scheduler.security.ldap.LdapBearerUser;
import com.nuix.automate.utils.exceptions.AuthenticationException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.WhitelistedX509TrustManager;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.userservice.LdapComputer;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RoundRobinServerSet;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.util.LDAPTestUtils;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.bind.DatatypeConverter;

public class LdapClient
extends UserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LdapClient.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private ServerSet serverSet;
    private WhitelistedX509TrustManager trustManager;
    private LdapUserService ldapUserService;

    public LdapClient(LdapUserService ldapUserService) throws GeneralSecurityException {
        this.update((UserService)ldapUserService);
    }

    public void update(UserService userService) throws GeneralSecurityException {
        this.ldapUserService = (LdapUserService)userService;
        String[] bindHost = new String[]{this.ldapUserService.getLdapHost()};
        int[] bindPort = new int[]{this.ldapUserService.getLdapPort()};
        if (this.ldapUserService.getSecureLdap().booleanValue()) {
            LOGGER.info("Initializing secure LDAP client");
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{DropwizardRestClientFactory.getTrustManager((Set)this.ldapUserService.getWhitelistedCertFingerprints())}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslcontext.getSocketFactory();
            this.serverSet = new RoundRobinServerSet(bindHost, bindPort, (SocketFactory)sslSocketFactory);
        } else {
            LOGGER.info("Initializing LDAP client");
            this.serverSet = new RoundRobinServerSet(bindHost, bindPort);
        }
    }

    public void close() {
    }

    public boolean supportsPasswordAuthentication() {
        return true;
    }

    public LdapBearerUser authenticateUser(PasswordAuthenticationSubmission passwordAuthenticationSubmission) throws LDAPException, AuthenticationException {
        Filter usernameFilter;
        String domainDn = this.ldapUserService.getDomainDn();
        String username = passwordAuthenticationSubmission.getUsername();
        LOGGER.info("Authenticating user " + username + " against LDAP");
        LDAPConnection connection = this.serverSet.getConnection();
        SimpleBindRequest simpleBindRequest = new SimpleBindRequest(username, passwordAuthenticationSubmission.getPassword());
        BindResult bindResult = connection.bind((BindRequest)simpleBindRequest);
        if (!ResultCode.SUCCESS.equals((Object)bindResult.getResultCode())) {
            throw new AuthenticationException(iu.getString("LdapClient.AuthenticationException"));
        }
        String[] usernameSplit = username.split("\\\\");
        if (usernameSplit.length > 1) {
            usernameFilter = Filter.createEqualityFilter((String)"sAMAccountName", (String)this.encodeLdapFilterValue(usernameSplit[1]));
        } else {
            String encodedUsername = this.encodeLdapFilterValue(username);
            usernameFilter = Filter.createORFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"distinguishedName", (String)encodedUsername), Filter.createEqualityFilter((String)"userPrincipalName", (String)encodedUsername)});
        }
        Filter userFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectClass", (String)"user"), Filter.createEqualityFilter((String)"objectCategory", (String)"person"), usernameFilter});
        SearchResult searchResult = connection.search(domainDn, SearchScope.SUB, userFilter, new String[0]);
        List entries = searchResult.getSearchEntries();
        if (entries.size() == 0) {
            LOGGER.error("Could not authenticate user against user class and person category filter");
            throw new AuthenticationException(iu.getString("LdapClient.AuthenticationException"));
        }
        SearchResultEntry userEntry = (SearchResultEntry)entries.get(0);
        String guid = this.getDashedGuidFromBytes(userEntry.getAttributeValueBytes("objectGuid"));
        String name = userEntry.getAttributeValue("name");
        Filter nestedGroupFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectCategory", (String)"group"), Filter.createEqualityFilter((String)"objectClass", (String)"group"), Filter.create((String)this.encodeLdapFilterValue("member:1.2.840.113556.1.4.1941:=" + userEntry.getAttributeValue("distinguishedName")))});
        SearchResult nestedGroupSearchResult = connection.search(domainDn, SearchScope.SUB, nestedGroupFilter, new String[]{"distinguishedName"});
        ArrayList<String> groupDns = new ArrayList<String>();
        for (SearchResultEntry groupEntry : nestedGroupSearchResult.getSearchEntries()) {
            String groupName = groupEntry.getAttributeValue("distinguishedName");
            groupDns.add(groupName);
        }
        LdapBearerUser ldapBearerUser = new LdapBearerUser(guid, name, this.ldapUserService);
        ldapBearerUser.setGroupDns(groupDns);
        connection.close();
        return ldapBearerUser;
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly) throws LDAPException {
        LOGGER.info("Getting LDAP users");
        try (LDAPConnection connection = this.serverSet.getConnection();){
            LdapUserService ldapUserService = (LdapUserService)userService;
            if (ldapUserService == null) {
                LOGGER.error("Missing ldapUserService");
                throw new IllegalArgumentException("Missing ldapUserService");
            }
            SimpleBindRequest simpleBindRequest = new SimpleBindRequest(ldapUserService.getServiceAccountName(), ldapUserService.getServiceAccountPassword());
            connection.bind((BindRequest)simpleBindRequest);
            Filter usersFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectClass", (String)"user"), Filter.createEqualityFilter((String)"objectCategory", (String)"person")});
            SearchScope searchScope = SearchScope.definedValueOf((int)ldapUserService.getUserSearchScope());
            SearchRequest searchRequest = new SearchRequest(ldapUserService.getUserBaseDn(), searchScope, usersFilter, new String[0]);
            ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
            ASN1OctetString resumeCookie = null;
            while (true) {
                searchRequest.setControls(new Control[]{new SimplePagedResultsControl(250, resumeCookie)});
                SearchResult searchResult = connection.search(searchRequest);
                for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                    UserAccount userAccount = new UserAccount();
                    userAccount.setPlatform(UserAccountPlatform.LDAP);
                    userAccount.setId(this.getDashedGuidFromBytes(entry.getAttributeValueBytes("objectGuid")));
                    userAccount.setName(entry.getAttributeValue("name"));
                    userAccount.setEmail(entry.getAttributeValue("mail"));
                    userAccount.setUserServiceId(userService.getId());
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("distinguishedName", entry.getAttributeValue("distinguishedName"));
                    attributes.put("sAMAccountName", entry.getAttributeValue("sAMAccountName"));
                    userAccount.setAttributes(attributes);
                    userAccount.setUserAccountState(UserAccountState.ACTIVE);
                    userAccounts.add(userAccount);
                }
                LDAPTestUtils.assertHasControl((LDAPResult)searchResult, (String)"1.2.840.113556.1.4.319");
                SimplePagedResultsControl responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
                if (firstPageOnly || !responseControl.moreResultsToReturn()) break;
                resumeCookie = responseControl.getCookie();
            }
            ArrayList<UserAccount> arrayList = userAccounts;
            return arrayList;
        }
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly, boolean inactive) throws Exception {
        if (!inactive) {
            return this.getUserAccounts(userService, firstPageOnly);
        }
        return new ArrayList<UserAccount>();
    }

    public List<LdapComputer> getComputers(UserService userService) throws LDAPException {
        LOGGER.info("Getting LDAP computers");
        try (LDAPConnection connection = this.serverSet.getConnection();){
            LdapUserService ldapUserService = (LdapUserService)userService;
            if (ldapUserService == null) {
                LOGGER.error("Missing ldapUserService");
                throw new IllegalArgumentException("Missing ldapUserService");
            }
            SimpleBindRequest simpleBindRequest = new SimpleBindRequest(ldapUserService.getServiceAccountName(), ldapUserService.getServiceAccountPassword());
            connection.bind((BindRequest)simpleBindRequest);
            Filter computersFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"objectClass", (String)"computer"), Filter.createEqualityFilter((String)"objectCategory", (String)"computer")});
            SearchScope searchScope = SearchScope.definedValueOf((int)ldapUserService.getComputerSearchScope());
            SearchRequest searchRequest = new SearchRequest(ldapUserService.getComputerBaseDn(), searchScope, computersFilter, new String[0]);
            ArrayList<LdapComputer> computerModels = new ArrayList<LdapComputer>();
            ASN1OctetString resumeCookie = null;
            while (true) {
                searchRequest.setControls(new Control[]{new SimplePagedResultsControl(250, resumeCookie)});
                SearchResult searchResult = connection.search(searchRequest);
                for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                    LdapComputer model = new LdapComputer();
                    model.setId(this.getDashedGuidFromBytes(entry.getAttributeValueBytes("objectGUID")));
                    model.setName(entry.getAttributeValue("name"));
                    model.setDN(entry.getAttributeValue("distinguishedName"));
                    model.setHostName(entry.getAttributeValue("dNSHostName"));
                    model.setManagedBy(entry.getAttributeValue("managedBy"));
                    model.setSAMAccountName(entry.getAttributeValue("sAMAccountName"));
                    model.setUserServiceId(userService.getId());
                    computerModels.add(model);
                }
                LDAPTestUtils.assertHasControl((LDAPResult)searchResult, (String)"1.2.840.113556.1.4.319");
                SimplePagedResultsControl responseControl = SimplePagedResultsControl.get((SearchResult)searchResult);
                if (!responseControl.moreResultsToReturn()) break;
                resumeCookie = responseControl.getCookie();
            }
            ArrayList<LdapComputer> arrayList = computerModels;
            return arrayList;
        }
    }

    private String encodeLdapFilterValue(String value) {
        return Filter.encodeValue((String)value);
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.trustManager.setWhitelistedCertFingerprints(whitelistedCertFingerprints);
    }

    private String getDashedGuidFromBytes(byte[] guidBytes) {
        String guid = DatatypeConverter.printHexBinary((byte[])guidBytes).toLowerCase();
        return guid.substring(8, 16) + "-" + guid.substring(4, 8) + "-" + guid.substring(0, 4) + "-" + guid.substring(16, 20) + "-" + guid.substring(20, 32);
    }
}

