/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc;

import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.OidcPartialUser;
import com.nuix.automate.scheduler.workers.OidcWellKnownConfigurationWorker;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.user.OidcLoginMode;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.UriInfo;

public abstract class OidcUserServiceClient
extends UserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OidcUserServiceClient.class);
    protected final SchedulerApplication schedulerApplication;
    protected OidcUserService oidcUserService;
    protected Client client;
    protected final Map<String, OidcPartialUser> stateToPartialUser;
    protected final Map<String, Exception> stateToError;
    private final CountDownLatch configurationLatch;
    private Map<String, Object> wellKnownConfiguration;
    private JwkProvider jwkProvider;

    public OidcUserServiceClient(SchedulerApplication schedulerApplication, OidcUserService oidcUserService) throws GeneralSecurityException {
        this.schedulerApplication = schedulerApplication;
        this.update((UserService)oidcUserService);
        this.initializeClient();
        this.stateToPartialUser = new HashMap<String, OidcPartialUser>();
        this.stateToError = new HashMap<String, Exception>();
        this.configurationLatch = new CountDownLatch(1);
    }

    public OidcUserServiceClient(SchedulerApplication schedulerApplication, OidcUserService oidcUserService, OidcWellKnownConfigurationWorker worker) throws GeneralSecurityException {
        this(schedulerApplication, oidcUserService);
        this.updateWellKnownConfiguration(worker);
    }

    public boolean isStateTracked(String state) {
        return this.stateToPartialUser.containsKey(state);
    }

    public boolean isUiNonceTracked(String uiNonce) {
        return this.stateToPartialUser.containsKey(uiNonce);
    }

    public Exception removeException(String nonce) {
        return this.stateToError.remove(nonce);
    }

    public OidcPartialUser getPartialUser(String state) {
        return this.stateToPartialUser.get(state);
    }

    public BearerUser removeUser(String state) {
        OidcPartialUser partialUser = this.stateToPartialUser.remove(state);
        this.stateToError.remove(state);
        if (partialUser == null) {
            return null;
        }
        return partialUser.getBearerUser();
    }

    protected void checkEnabled() throws JwkException {
        if (!this.oidcUserService.getEnabled().booleanValue()) {
            throw new JwkException("Authentication service is not enabled");
        }
    }

    public abstract boolean refresh(BearerUser var1);

    public abstract Map<String, Object> refreshToken(String var1) throws IOException;

    public abstract BearerUser trackAuthenticationCode(String var1, String var2, OidcPartialUser var3) throws Exception;

    public abstract String getOAuthAuthorizeUrl(String var1, String var2, String var3, OidcLoginMode var4) throws UnsupportedEncodingException, NoSuchAlgorithmException;

    public abstract void processOidcOAuthResponse(HttpServletRequest var1, UriInfo var2, String var3, String var4, String var5, String var6, String var7, String var8);

    public abstract void revokeToken(String var1);

    public String getOAuthSignOutUrl(String redirectUrl, String idTokenHint) {
        String oAuthSignOutUrl = (String)this.getWellKnownConfiguration().get("end_session_endpoint");
        if (oAuthSignOutUrl == null) {
            return redirectUrl;
        }
        ArrayList<CallSite> queryParams = new ArrayList<CallSite>();
        if (idTokenHint != null) {
            queryParams.add((CallSite)((Object)("id_token_hint=" + URLEncoder.encode(idTokenHint, StandardCharsets.UTF_8))));
        }
        if (redirectUrl != null) {
            queryParams.add((CallSite)((Object)("post_logout_redirect_uri=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8))));
        }
        if (queryParams.size() > 0) {
            return oAuthSignOutUrl + "?" + String.join((CharSequence)"&", queryParams);
        }
        return oAuthSignOutUrl;
    }

    public boolean valid() {
        return this.wellKnownConfiguration != null && this.wellKnownConfiguration.size() > 0;
    }

    protected Map<String, Object> getWellKnownConfiguration() {
        try {
            this.configurationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for first wellknownConfiguration update", (Throwable)e);
        }
        return this.wellKnownConfiguration;
    }

    protected JwkProvider getJwkProvider() {
        try {
            this.configurationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for first wellknownConfiguration update", (Throwable)e);
        }
        return this.jwkProvider;
    }

    public void updateWellKnownConfiguration(OidcWellKnownConfigurationWorker worker) {
        this.wellKnownConfiguration = worker.getWellKnownConfiguration();
        this.jwkProvider = worker.getJwkProvider();
        this.configurationLatch.countDown();
    }

    public void close() {
        block3: {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
    }

    public void update(UserService userService) {
        this.oidcUserService = (OidcUserService)userService;
        this.initializeClient();
    }

    private void initializeClient() {
        block5: {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
        try {
            this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)(((Object)((Object)this)).getClass().getSimpleName() + this.oidcUserService.getId()), (Set)this.oidcUserService.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        }
        catch (Exception e) {
            LOGGER.error("Cannot create client", (Throwable)e);
        }
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly) throws Exception {
        return null;
    }

    public boolean supportsPasswordAuthentication() {
        return false;
    }

    public BearerUser authenticateUser(PasswordAuthenticationSubmission passwordAuthenticationSubmission) throws Exception {
        return null;
    }

    public OidcUserService getOidcUserService() {
        return this.oidcUserService;
    }
}

