/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.generic;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.OidcPartialUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.InvalidTokenException;
import com.nuix.automate.scheduler.security.oidc.generic.OidcBearerUser;
import com.nuix.automate.scheduler.security.oidc.generic.OidcJwtUser;
import com.nuix.automate.scheduler.utils.JwtUtils;
import com.nuix.automate.utils.exceptions.AuthenticationException;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.user.LoginAttempt;
import com.nuix.automate.utils.models.api.user.LoginFailure;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.OidcLoginMode;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.security.SecurityUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class GenericOidcUserServiceClient
extends OidcUserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GenericOidcUserServiceClient.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public GenericOidcUserServiceClient(SchedulerApplication schedulerApplication, OidcUserService oidcUserService) throws GeneralSecurityException {
        super(schedulerApplication, oidcUserService);
    }

    @Override
    public boolean refresh(BearerUser bearerUser) {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            return false;
        }
        if (!(bearerUser instanceof OidcBearerUser)) {
            return false;
        }
        OidcBearerUser oidcBearerUser = (OidcBearerUser)bearerUser;
        String refreshToken = oidcBearerUser.getRefreshToken();
        Long expiresIn = oidcBearerUser.getExpiresIn();
        if (refreshToken != null && expiresIn != null && expiresIn <= this.schedulerApplication.getConfiguration().getOidcMinShelfLife()) {
            LOGGER.info("Refreshing OIDC token " + bearerUser.getName());
            try {
                Map<String, Object> refreshTokenResponse = this.refreshToken(refreshToken);
                oidcBearerUser.setTokenInfo(refreshTokenResponse);
            }
            catch (IllegalStateException e) {
                LOGGER.error("Cannot refresh token", (Throwable)e);
                return false;
            }
        }
        if (this.oidcUserService.getScope().contains("offline_access") && (refreshToken == null || expiresIn == null)) {
            LOGGER.warn("User session is missing a refresh_token");
        }
        LOGGER.info("Refreshing OIDC user " + bearerUser.getName());
        if (this.getWellKnownConfiguration().get("userinfo_endpoint") != null) {
            try {
                try {
                    Map<String, Object> userInfo = this.getUserInfo(oidcBearerUser.getAccessToken());
                    this.testUserClaim(userInfo);
                    this.testUserGroupClaim(userInfo);
                    oidcBearerUser.setUserInfo(userInfo);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot get user info from access token", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot refresh user information", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, Object> refreshToken(String refreshToken) {
        Form form = new Form();
        form.param("refresh_token", refreshToken);
        form.param("grant_type", "refresh_token");
        return this.getTokenResponse(form);
    }

    private Map<String, Object> getAuthCodeTokenResponse(String code, String redirectUrl) {
        Form form = new Form();
        form.param("redirect_uri", redirectUrl);
        form.param("grant_type", "authorization_code");
        form.param("code", code);
        return this.getTokenResponse(form);
    }

    private Map<String, Object> getTokenResponse(Form form) {
        try (Response response = this.prepareClientRequest(this.getWellKnownConfiguration().get("token_endpoint").toString()).post(Entity.form((Form)form));){
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new IllegalStateException("Post Token Endpoint with Code HTTP/" + response.getStatus() + " " + error);
            }
            Map map = (Map)response.readEntity((GenericType)new GenericType<Map<String, Object>>(){});
            return map;
        }
    }

    @Override
    public void revokeToken(String token) {
        String revocationEndpoint = (String)this.getWellKnownConfiguration().get("revocation_endpoint");
        if (revocationEndpoint != null) {
            Form form = new Form();
            form.param("token", token);
            try (Response response = this.prepareClientRequest(revocationEndpoint).post(Entity.form((Form)form));){
                LOGGER.info("Revoked refresh token for " + this.oidcUserService.getClientId());
            }
            catch (Exception e) {
                LOGGER.error("Error revoking refresh token for " + this.oidcUserService.getClientId(), (Throwable)e);
            }
        }
    }

    private Invocation.Builder prepareClientRequest(String url) {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IllegalStateException(e);
        }
        String auth = this.oidcUserService.getClientId() + ":" + this.oidcUserService.getClientSecret();
        String basicToken = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        return this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicToken));
    }

    private void testUserClaim(Map<String, Object> userInfo) {
        if (userInfo.get(this.oidcUserService.getUsernameClaim()) == null) {
            throw new InvalidTokenException(this.iu.getFormattedString("OidcUtil.OidcAccesTokenDoesNotHaveClaim", (Object[])new String[]{this.oidcUserService.getUsernameClaim(), String.join((CharSequence)", ", userInfo.keySet())}));
        }
    }

    private void testUserGroupClaim(Map<String, Object> userInfo) {
        if (this.oidcUserService.getGroupClaim() != null && !this.oidcUserService.getGroupClaim().equals("")) {
            try {
                this.getGroupsFromClaim(this.oidcUserService.getGroupClaim(), userInfo);
            }
            catch (JWTDecodeException e) {
                LOGGER.error("Cannot get group claim", (Throwable)e);
                throw new InvalidTokenException(this.iu.getFormattedString("OidcUtil.OidcAccesTokenDoesNotHaveGroupClaim", (Object[])new String[]{this.oidcUserService.getGroupClaim(), String.join((CharSequence)", ", userInfo.keySet()), FormattingUtils.getExceptionPrintableMessage((Exception)((Object)e))}));
            }
        }
    }

    private Map<String, Object> getUserInfo(String accessToken) {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IllegalStateException(e);
        }
        Object userInfoEndpoint = this.getWellKnownConfiguration().get("userinfo_endpoint");
        if (userInfoEndpoint == null) {
            LOGGER.warn("WellKnownConfiguration does not have userinfo_endpoint");
            return new HashMap<String, Object>();
        }
        WebTarget webTarget = this.client.target(userInfoEndpoint.toString());
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken));
        Response response = invocationBuilder.get();
        if (response.getStatus() != 200) {
            String error = (String)response.readEntity(String.class);
            throw new IllegalStateException("Get User Info HTTP/" + response.getStatus() + " " + error);
        }
        return (Map)response.readEntity((GenericType)new GenericType<Map<String, Object>>(){});
    }

    private Set<String> getGroupsFromClaim(String groupClaimName, DecodedJWT jwt) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        for (String claimName : jwt.getClaims().keySet()) {
            claims.put(claimName, jwt.getClaim(claimName).as(Object.class));
        }
        return this.getGroupsFromClaim(groupClaimName, claims);
    }

    public Set<String> getGroupsFromClaim(String groupClaimName, Map<String, Object> claims) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        if (groupClaimName != null && groupClaimName.length() > 0) {
            String[] claimSplits = groupClaimName.split("[\\s,]");
            Object rootClaim = claims.get(claimSplits[0]);
            if (rootClaim != null) {
                try {
                    if (claimSplits.length == 1) {
                        if (rootClaim instanceof Collection) {
                            for (Object o : (Collection)rootClaim) {
                                groups.add(o.toString());
                            }
                            return groups;
                        }
                        String groupName = rootClaim.toString();
                        groups.add(groupName);
                        return groups;
                    }
                    if (rootClaim instanceof Map) {
                        Map groupMap;
                        Map subClaim = groupMap = (Map)rootClaim;
                        for (int i = 1; i < claimSplits.length; ++i) {
                            if (claimSplits[i].length() == 0) continue;
                            if (subClaim != null && subClaim instanceof Map) {
                                subClaim = subClaim.get(claimSplits[i]);
                                continue;
                            }
                            throw new JWTDecodeException("Cannot match subclaim #" + i + " " + claimSplits[i] + " from group claim " + groupClaimName);
                        }
                        if (subClaim != null && subClaim instanceof Collection) {
                            for (Object value : (Collection)((Object)subClaim)) {
                                groups.add(value.toString());
                            }
                        }
                        return groups;
                    }
                    throw new JWTDecodeException("JWT root claim is not a map");
                }
                catch (Exception e) {
                    LOGGER.error("Cannot parse JWT groups", (Throwable)e);
                }
            } else {
                throw new JWTDecodeException("JWT does not have claim " + claimSplits[0]);
            }
        }
        return groups;
    }

    public OidcJwtUser getUserFromAccessToken(String token) throws JwkException {
        Map<String, Object> claims;
        String username;
        DecodedJWT jwt = this.validateJwtToken(token);
        this.testUserClaim(JwtUtils.getClaimsFromToken(jwt));
        Claim usernameClaim = jwt.getClaim(this.oidcUserService.getUsernameClaim());
        String id = username = usernameClaim.asString();
        if (this.oidcUserService.getLinkProfilesWithSyncedUsers().booleanValue() && (claims = JwtUtils.getClaimsFromToken(jwt)).get("email") != null) {
            String currentUserEmail = claims.get("email").toString();
            UserAccount cachedUser = this.schedulerApplication.getBearerAuthenticator().getCachedUser(currentUserEmail);
            if (cachedUser != null) {
                id = cachedUser.getId();
                username = cachedUser.getName();
            }
        }
        Set<String> groups = this.getGroupsFromClaim(this.oidcUserService.getGroupClaim(), jwt);
        OidcJwtUser user = new OidcJwtUser(id, username, groups, this.oidcUserService, jwt.getExpiresAt().getTime(), token);
        user.setBearerToken(token);
        return user;
    }

    public DecodedJWT validateJwtToken(String token) throws JwkException {
        DecodedJWT jwt = JWT.decode((String)token);
        Jwk jwk = this.getJwkProvider().get(jwt.getKeyId());
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        algorithm.verify(jwt);
        if (jwt.getExpiresAt().before(new Date())) {
            throw new JwkException("Token expired");
        }
        if (jwt.getNotBefore() != null && jwt.getNotBefore().after(new Date())) {
            throw new JwkException("Token not valid yet");
        }
        return jwt;
    }

    @Override
    public BearerUser trackAuthenticationCode(String redirectUrl, String code, OidcPartialUser partialUser) throws JwkException {
        String username;
        this.checkEnabled();
        Map<String, Object> jsonResponse = this.getAuthCodeTokenResponse(code, redirectUrl);
        String idToken = (String)jsonResponse.get("id_token");
        String accessToken = (String)jsonResponse.get("access_token");
        DecodedJWT iDJwt = this.validateJwtToken(idToken);
        String tokenNonce = iDJwt.getClaim("nonce").asString();
        if (!partialUser.getOidcNonce().equals(tokenNonce)) {
            throw new JwkException("Invalid token nonce " + tokenNonce);
        }
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        try {
            userInfo.putAll(JwtUtils.getClaimsFromToken(iDJwt));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get user info from id token", (Throwable)e);
        }
        try {
            userInfo.putAll(this.getUserInfo(accessToken));
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get user info from access token", (Throwable)e);
        }
        try {
            DecodedJWT decodedAccessJwt = this.validateJwtToken(accessToken);
            for (String claimName : decodedAccessJwt.getClaims().keySet()) {
                Claim claim = (Claim)decodedAccessJwt.getClaims().get(claimName);
                try {
                    Object claimObject = claim.as(Object.class);
                    if (claimObject == null) continue;
                    userInfo.put(claimName, claimObject);
                }
                catch (JWTDecodeException jWTDecodeException) {}
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot get user info from access token", (Throwable)e);
        }
        this.testUserClaim(userInfo);
        this.testUserGroupClaim(userInfo);
        String id = username = userInfo.get(this.oidcUserService.getUsernameClaim()).toString();
        if (this.oidcUserService.getLinkProfilesWithSyncedUsers().booleanValue() && userInfo.get("email") != null) {
            String currentUserEmail = userInfo.get("email").toString();
            UserAccount cachedUser = this.schedulerApplication.getBearerAuthenticator().getCachedUser(currentUserEmail);
            if (cachedUser != null) {
                id = cachedUser.getId();
                username = cachedUser.getName();
            }
        }
        OidcBearerUser bearerUser = new OidcBearerUser(id, username, userInfo, this, this.oidcUserService, jsonResponse);
        bearerUser.setSessionId(partialUser.getSessionId());
        return bearerUser;
    }

    @Override
    public String getOAuthAuthorizeUrl(String redirectUrl, String state, String sessionId, OidcLoginMode loginMode) {
        String extraScope = null;
        if (this.oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE && loginMode == OidcLoginMode.VAULT_USER) {
            extraScope = String.join((CharSequence)" ", Arrays.asList("https://www.googleapis.com/auth/ediscovery", "https://www.googleapis.com/auth/ediscovery.readonly", "https://www.googleapis.com/auth/devstorage.read_only", "https://www.googleapis.com/auth/admin.directory.user.readonly", "https://www.googleapis.com/auth/admin.directory.group.readonly", "https://www.googleapis.com/auth/admin.directory.orgunit.readonly", "https://www.googleapis.com/auth/drive.readonly", "https://www.googleapis.com/auth/chat.spaces.readonly", "https://www.googleapis.com/auth/chat.memberships.readonly"));
        }
        if (this.stateToPartialUser.containsKey(state)) {
            this.stateToPartialUser.remove(state);
            throw new IllegalArgumentException("uiNonce value is already in use");
        }
        OidcPartialUser oidcPartialUser = new OidcPartialUser(sessionId, loginMode);
        String nonce = SecurityUtils.getSecureRandomSecret();
        oidcPartialUser.setOidcNonce(nonce);
        oidcPartialUser.setOidcState(state);
        this.stateToPartialUser.put(state, oidcPartialUser);
        String oAuthAuthorizeUrl = String.valueOf(this.getWellKnownConfiguration().get("authorization_endpoint")) + "?response_type=code&response_mode=form_post&redirect_uri=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8) + "&client_id=" + URLEncoder.encode(this.oidcUserService.getClientId(), StandardCharsets.UTF_8) + "&state=" + URLEncoder.encode(state, StandardCharsets.UTF_8) + "&nonce=" + URLEncoder.encode(nonce, StandardCharsets.UTF_8);
        Object scope = this.oidcUserService.getScope();
        if (extraScope != null) {
            scope = (String)scope + " " + extraScope;
        }
        if (this.oidcUserService.getAuthMethodType() == AuthMethodType.OIDC_GOOGLE && ((String)scope).contains("offline_access")) {
            scope = Arrays.stream(((String)scope).split("\\s+")).filter(_scope -> !_scope.equals("offline_access")).collect(Collectors.joining(" "));
            oAuthAuthorizeUrl = oAuthAuthorizeUrl + "&access_type=offline";
            oAuthAuthorizeUrl = oAuthAuthorizeUrl + "&prompt=consent";
        }
        oAuthAuthorizeUrl = oAuthAuthorizeUrl + "&scope=" + URLEncoder.encode((String)scope, StandardCharsets.UTF_8);
        return oAuthAuthorizeUrl;
    }

    @Override
    public void processOidcOAuthResponse(HttpServletRequest request, UriInfo uriInfo, String access_token, String state, String code, String session_state, String error, String error_description) {
        block6: {
            try {
                this.checkEnabled();
                OidcPartialUser partialUser = (OidcPartialUser)this.stateToPartialUser.get(state);
                if (error == null) {
                    try {
                        BearerUser bearerUser = this.trackAuthenticationCode(ResourceUtils.getBaseUri((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/users/oidcResponse", code, partialUser);
                        if (bearerUser != null) {
                            partialUser.setBearerUser(bearerUser);
                            partialUser.setOidcState(null);
                            partialUser.setOidcNonce(null);
                            this.stateToError.remove(state);
                            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), bearerUser.getSessionId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), bearerUser.getName(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                            LOGGER.info("User " + bearerUser.getName() + ", session " + bearerUser.getSessionId() + ", logged in");
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("OIDC", "Generic", bearerUser.getName(), bearerUser.getSessionId()), bearerUser.getName());
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot authenticate user against OIDC", (Throwable)e);
                        this.stateToError.put(state, e);
                        String affectedId = partialUser.getSessionId();
                        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), affectedId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("OIDC", "Generic", "N/A", affectedId, e.getLocalizedMessage()), "N/A");
                    }
                    break block6;
                }
                AuthenticationException e = new AuthenticationException(error + "\n" + error_description);
                this.stateToError.put(state, e);
            }
            catch (JwkException e) {
                AuthenticationException ex = new AuthenticationException(e.getMessage());
                this.stateToError.put(state, ex);
            }
        }
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly, boolean inactive) throws Exception {
        if (!inactive) {
            return this.getUserAccounts(userService, firstPageOnly);
        }
        return new ArrayList<UserAccount>();
    }
}

