/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.generic;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.Set;

public class OidcJwtUser
extends BearerUser
implements UserServiceUser {
    OidcUserService oidcUserService;
    String username;
    Set<String> groups;
    long expirationEpoch;
    String jwtToken;

    public OidcJwtUser(String id, String username, Set<String> groups, OidcUserService oidcUserService, long expirationEpoch, String jwtToken) {
        super(new Identifier(IdentifierType.OIDC_USERNAME, username));
        this.oidcUserService = oidcUserService;
        this.username = username;
        this.groups = groups;
        this.expirationEpoch = expirationEpoch;
        this.jwtToken = jwtToken;
        this.setSessionId(UidUtils.fromString((String)username));
        this.setId(id);
    }

    public void invalidate() {
    }

    public boolean refresh() {
        return true;
    }

    public Set<Identifier> getIdentifiers() {
        HashSet<Identifier> identifiers = new HashSet<Identifier>(super.getIdentifiers());
        identifiers.add(new Identifier(IdentifierType.OIDC_USERNAME, this.username));
        if (this.oidcUserService.getGroupClaim() != null && this.groups != null) {
            for (String group : this.groups) {
                identifiers.add(new Identifier(IdentifierType.OIDC_GROUP, group));
            }
        }
        return identifiers;
    }

    public String getUserServiceId() {
        return this.oidcUserService.getId();
    }

    public long getExpirationEpoch() {
        return this.expirationEpoch;
    }

    public void setExpirationEpoch(long expirationEpoch) {
        this.expirationEpoch = expirationEpoch;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }
}

