/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.google;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.generic.GenericOidcUserServiceClient;
import com.nuix.automate.scheduler.security.thirdparty.VaultServiceSession;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.VaultService;
import com.nuix.automate.utils.models.api.thirdparty.VaultUserCredential;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.userservice.GoogleChatSpace;
import com.nuix.automate.utils.models.api.userservice.GoogleDrive;
import com.nuix.automate.utils.models.api.userservice.GoogleGroup;
import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.internal.googleapi.ChatSpace;
import com.nuix.automate.utils.models.internal.googleapi.Drive;
import com.nuix.automate.utils.models.internal.googleapi.Group;
import com.nuix.automate.utils.models.internal.googleapi.OrgUnit;
import com.nuix.automate.utils.models.internal.googleapi.User;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoogleOidcUserServiceClient
extends GenericOidcUserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(GoogleOidcUserServiceClient.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");

    public GoogleOidcUserServiceClient(SchedulerApplication schedulerApplication, OidcUserService oidcUserService) throws GeneralSecurityException {
        super(schedulerApplication, oidcUserService);
    }

    @Override
    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly) throws IOException {
        LOGGER.info("Getting Google Workspace users");
        ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
        VaultServiceSession vaultServiceSession = this.getFirstThirdPartyServiceSession();
        if (vaultServiceSession == null) {
            return userAccounts;
        }
        LOGGER.info("Querying google users with thirdPartyService " + vaultServiceSession.getServiceId() + " userCredential, signed in as: " + ((VaultUserCredential)vaultServiceSession.getUserCredential()).getUsername());
        for (User googleUser : vaultServiceSession.getUsers(true)) {
            UserAccount userAccount = GoogleOidcUserServiceClient.createGoogleUser(userService, googleUser);
            userAccounts.add(userAccount);
        }
        this.oidcUserService.setUpdateMessage(null);
        boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
        if (mockOptionsEnabled) {
            userAccounts.addAll(this.buildMockUserAccounts(userService.getId(), UserAccountPlatform.GOOGLE_WORKSPACE, this.schedulerApplication.getConfiguration().getMockOptionsCount(), this.schedulerApplication.getConfiguration().getMockOptionsChangingValues()));
        }
        return userAccounts;
    }

    @NotNull
    private static UserAccount createGoogleUser(UserService userService, User googleUser) {
        UserAccount userAccount = new UserAccount();
        userAccount.setUserServiceId(userService.getId());
        userAccount.setUserAccountState(UserAccountState.ACTIVE);
        userAccount.setPlatform(UserAccountPlatform.GOOGLE_WORKSPACE);
        userAccount.setId(googleUser.getId());
        userAccount.setName(googleUser.getPrimaryEmail());
        userAccount.setEmail(googleUser.getPrimaryEmail());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("orgUnitPath", googleUser.getOrgUnitPath());
        attributes.put("displayName", googleUser.getName().getFullName());
        userAccount.setAttributes(attributes);
        return userAccount;
    }

    public List<GoogleGroup> getGroups() throws IOException {
        LOGGER.info("Getting Google Groups for: " + this.oidcUserService.getName());
        ArrayList<GoogleGroup> googleGroups = new ArrayList<GoogleGroup>();
        VaultServiceSession vaultServiceSession = this.getFirstThirdPartyServiceSession();
        if (vaultServiceSession == null) {
            return googleGroups;
        }
        LOGGER.info("Querying google groups with thirdPartyService " + vaultServiceSession.getServiceId() + " userCredential, signed in as: " + ((VaultUserCredential)vaultServiceSession.getUserCredential()).getUsername());
        for (Group group : vaultServiceSession.getGroups(true)) {
            GoogleGroup googleGroup = new GoogleGroup(group);
            googleGroup.setUserServiceId(this.oidcUserService.getId());
            googleGroups.add(googleGroup);
        }
        this.oidcUserService.setUpdateMessage(null);
        boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
        if (mockOptionsEnabled) {
            googleGroups.addAll(this.buildMockGoogleGroups(this.oidcUserService.getId(), this.schedulerApplication.getConfiguration().getMockOptionsCount()));
        }
        return googleGroups;
    }

    public List<GoogleOrgUnit> getOrgUnits() throws IOException {
        LOGGER.info("Getting Google OrgUnits for: " + this.oidcUserService.getName());
        ArrayList<GoogleOrgUnit> googleOrgUnits = new ArrayList<GoogleOrgUnit>();
        VaultServiceSession vaultServiceSession = this.getFirstThirdPartyServiceSession();
        if (vaultServiceSession == null) {
            return googleOrgUnits;
        }
        LOGGER.info("Querying google orgUnits with thirdPartyService " + vaultServiceSession.getServiceId() + " userCredential, signed in as: " + ((VaultUserCredential)vaultServiceSession.getUserCredential()).getUsername());
        for (OrgUnit orgUnit : vaultServiceSession.getOrgUnits(true)) {
            GoogleOrgUnit googleOrgUnit = new GoogleOrgUnit(orgUnit);
            googleOrgUnit.setUserServiceId(this.oidcUserService.getId());
            googleOrgUnits.add(googleOrgUnit);
        }
        this.oidcUserService.setUpdateMessage(null);
        return googleOrgUnits;
    }

    public List<GoogleChatSpace> getChatSpaces() throws IOException {
        LOGGER.info("Getting Google Chat Spaces for: " + this.oidcUserService.getName());
        ArrayList<GoogleChatSpace> googleChatSpaces = new ArrayList<GoogleChatSpace>();
        VaultServiceSession vaultServiceSession = this.getFirstThirdPartyServiceSession();
        if (vaultServiceSession == null) {
            return googleChatSpaces;
        }
        LOGGER.info("Querying google chat spaces with thirdPartyService " + vaultServiceSession.getServiceId() + " userCredential, signed in as: " + ((VaultUserCredential)vaultServiceSession.getUserCredential()).getUsername());
        for (ChatSpace chatSpace : vaultServiceSession.getChatSpaces(true)) {
            GoogleChatSpace googleChatSpace = new GoogleChatSpace(chatSpace);
            googleChatSpace.setUserServiceId(this.oidcUserService.getId());
            googleChatSpaces.add(googleChatSpace);
        }
        this.oidcUserService.setUpdateMessage(null);
        return googleChatSpaces;
    }

    public List<GoogleDrive> getSharedDrives() throws IOException {
        LOGGER.info("Getting Google SharedDrives for: " + this.oidcUserService.getName());
        ArrayList<GoogleDrive> googleDrives = new ArrayList<GoogleDrive>();
        VaultServiceSession vaultServiceSession = this.getFirstThirdPartyServiceSession();
        if (vaultServiceSession == null) {
            return googleDrives;
        }
        LOGGER.info("Querying google shared drives with thirdPartyService " + vaultServiceSession.getServiceId() + " userCredential, signed in as: " + ((VaultUserCredential)vaultServiceSession.getUserCredential()).getUsername());
        for (Drive drive : vaultServiceSession.getSharedDrives(true)) {
            GoogleDrive googleDrive = new GoogleDrive(drive);
            googleDrive.setUserServiceId(this.oidcUserService.getId());
            googleDrives.add(googleDrive);
        }
        this.oidcUserService.setUpdateMessage(null);
        return googleDrives;
    }

    private List<GoogleGroup> buildMockGoogleGroups(String userServiceId, int count) {
        ArrayList<GoogleGroup> mockGroups = new ArrayList<GoogleGroup>();
        for (int i = 0; i < count; ++i) {
            GoogleGroup googleGroup = new GoogleGroup();
            googleGroup.setUserServiceId(userServiceId);
            String name = "mock.group." + i;
            if (this.schedulerApplication.getConfiguration().getMockOptionsChangingValues()) {
                name = name + this.random.nextInt(5);
            }
            String email = name + "@example.com";
            googleGroup.setId(UidUtils.fromString((String)email));
            googleGroup.setName(name);
            googleGroup.setEmail(email);
            mockGroups.add(googleGroup);
        }
        return mockGroups;
    }

    public VaultServiceSession getFirstThirdPartyServiceSession() {
        if (this.schedulerApplication.getThirdPartyServiceResource() != null) {
            for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServicesUsingOidcAuthenticationService((UserService)this.oidcUserService)) {
                if (!(thirdPartyService instanceof VaultService) || !Boolean.TRUE.equals(thirdPartyService.getEnabled())) continue;
                if (thirdPartyService.getAuthenticationScope() == ThirdPartyAuthenticationScope.SERVICE) {
                    try {
                        VaultServiceSession session = (VaultServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), this.oidcUserService.getId(), true);
                        if (!session.getSignedIn()) continue;
                        return session;
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot retrieve client", (Throwable)e);
                        continue;
                    }
                }
                for (ThirdPartyUserCredential userCredential : this.schedulerApplication.getSchedulerConfigurationDao().getThirdPartyUserCredentials(thirdPartyService.getId(), ThirdPartyAuthenticationScope.USER)) {
                    if (!userCredential.getSignedIn()) continue;
                    try {
                        return (VaultServiceSession)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), userCredential.getUserId(), true);
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot retrieve client", (Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

