/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.microsoft;

import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nuix.automate.scheduler.security.oidc.microsoft.AuthParameterNames;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public final class AuthHelper {
    public static final String PRINCIPAL_SESSION_NAME = "principal";

    private AuthHelper() {
    }

    public static boolean isAuthenticated(HttpServletRequest request) {
        return request.getSession().getAttribute(PRINCIPAL_SESSION_NAME) != null;
    }

    public static boolean containsAuthenticationData(HttpServletRequest httpRequest) {
        Map parameterMap = httpRequest.getParameterMap();
        return httpRequest.getMethod().equalsIgnoreCase("POST") && (parameterMap.containsKey(AuthParameterNames.ERROR) || parameterMap.containsKey(AuthParameterNames.ID_TOKEN) || parameterMap.containsKey(AuthParameterNames.CODE));
    }

    public static boolean isAuthenticationSuccessful(AuthenticationResponse authResponse) {
        return authResponse instanceof AuthenticationSuccessResponse;
    }
}

