/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.microsoft;

import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.text.WordUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONHelper {
    private static LoggerWrapper logger = LogManagerUtils.getLogger(JSONHelper.class);

    JSONHelper() {
    }

    public static JSONArray fetchDirectoryObjectJSONArray(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray = new JSONArray();
        jsonArray = jsonObject.optJSONObject("responseMsg").optJSONArray("value");
        return jsonArray;
    }

    public static JSONObject fetchDirectoryObjectJSONObject(JSONObject jsonObject) throws Exception {
        JSONObject jObj = new JSONObject();
        jObj = jsonObject.optJSONObject("responseMsg");
        return jObj;
    }

    public static String fetchNextSkiptoken(JSONObject jsonObject) throws Exception {
        String skipToken = "";
        skipToken = jsonObject.optJSONObject("responseMsg").optString("odata.nextLink");
        if (!skipToken.equalsIgnoreCase("")) {
            int index = skipToken.indexOf("$skiptoken=") + new String("$skiptoken=").length();
            skipToken = skipToken.substring(index);
        }
        return skipToken;
    }

    public static String fetchDeltaLink(JSONObject jsonObject) throws Exception {
        String deltaLink = "";
        deltaLink = jsonObject.optJSONObject("responseMsg").optString("aad.deltaLink");
        if (deltaLink == null || deltaLink.length() == 0) {
            deltaLink = jsonObject.optJSONObject("responseMsg").optString("aad.nextLink");
            logger.info("deltaLink empty, nextLink ->" + deltaLink);
        }
        if (!deltaLink.equalsIgnoreCase("")) {
            int index = deltaLink.indexOf("deltaLink=") + new String("deltaLink=").length();
            deltaLink = deltaLink.substring(index);
        }
        return deltaLink;
    }

    public static String createJSONString(HttpServletRequest request, String controller) throws Exception {
        JSONObject obj = new JSONObject();
        try {
            Field[] allFields = Class.forName("com.microsoft.windowsazure.activedirectory.sdk.graph.models." + controller).getDeclaredFields();
            String[] allFieldStr = new String[allFields.length];
            for (int i = 0; i < allFields.length; ++i) {
                allFieldStr[i] = allFields[i].getName();
            }
            List<String> allFieldStringList = Arrays.asList(allFieldStr);
            Enumeration fields = request.getParameterNames();
            while (fields.hasMoreElements()) {
                String fieldName = (String)fields.nextElement();
                String param = request.getParameter(fieldName);
                if (!allFieldStringList.contains(fieldName)) continue;
                if (param == null || param.length() == 0) {
                    if (fieldName.equalsIgnoreCase("password")) continue;
                    obj.put(fieldName, JSONObject.NULL);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("password")) {
                    obj.put("passwordProfile", (Object)new JSONObject("{\"password\": " + SerializationUtils.toJson((Object)param) + "}"));
                    continue;
                }
                obj.put(fieldName, (Object)param);
            }
        }
        catch (JSONException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        return obj.toString();
    }

    public static String createJSONString(String key, String value) throws Exception {
        JSONObject obj = new JSONObject();
        try {
            obj.put(key, (Object)value);
        }
        catch (JSONException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        return obj.toString();
    }

    public static <T> void convertJSONObjectToDirectoryObject(JSONObject jsonObject, T destObject) throws Exception {
        Field[] fieldList = destObject.getClass().getDeclaredFields();
        for (int i = 0; i < fieldList.length; ++i) {
            if (!fieldList[i].getType().equals(String.class)) continue;
            destObject.getClass().getMethod(String.format("set%s", WordUtils.capitalize((String)fieldList[i].getName())), String.class).invoke(destObject, jsonObject.optString(fieldList[i].getName()));
        }
    }

    public static JSONArray joinJSONArrays(JSONArray a, JSONArray b) {
        int i;
        JSONArray comb = new JSONArray();
        for (i = 0; i < a.length(); ++i) {
            comb.put((Object)a.optJSONObject(i));
        }
        for (i = 0; i < b.length(); ++i) {
            comb.put((Object)b.optJSONObject(i));
        }
        return comb;
    }
}

