/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.microsoft;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OAuthBearerUser;
import com.nuix.automate.scheduler.security.oidc.OidcPartialUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.Group;
import com.nuix.automate.scheduler.security.oidc.microsoft.HttpClientHelper;
import com.nuix.automate.scheduler.security.oidc.microsoft.JSONHelper;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftBearerUser;
import com.nuix.automate.scheduler.security.oidc.microsoft.User;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.user.LoginAttempt;
import com.nuix.automate.utils.models.api.user.LoginFailure;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.userservice.MicrosoftSharePointSite;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUnifiedGroup;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.graphapi.Team;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.user.MicrosoftOAuthVersion;
import com.nuix.automate.utils.models.internal.user.OidcLoginMode;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import io.dropwizard.auth.AuthenticationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class MicrosoftOidcUserServiceClient
extends OidcUserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(MicrosoftOidcUserServiceClient.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final Map<String, String> stateToCodeVerifier = new HashMap<String, String>();
    private final String oDataUsernameClain = "upn";
    private MicrosoftUserService microsoftUserService;

    public MicrosoftOidcUserServiceClient(SchedulerApplication schedulerApplication, OidcUserService oidcUserService) throws GeneralSecurityException {
        super(schedulerApplication, oidcUserService);
        this.microsoftUserService = (MicrosoftUserService)oidcUserService;
    }

    @Override
    public boolean refresh(BearerUser bearerUser) {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            return false;
        }
        if (!(bearerUser instanceof OidcMicrosoftBearerUser)) {
            return false;
        }
        OidcMicrosoftBearerUser microsoftBearerUser = (OidcMicrosoftBearerUser)bearerUser;
        Long expiresInMillis = microsoftBearerUser.getExpiresInMillis();
        if (expiresInMillis != null && expiresInMillis <= this.schedulerApplication.getConfiguration().getOidcMinShelfLife()) {
            LOGGER.info("Refreshing OIDC token " + bearerUser.getName());
            try {
                Map<String, Object> refreshTokenResponse = this.refreshToken(microsoftBearerUser.getRefreshToken());
                microsoftBearerUser.setTokenResponse(refreshTokenResponse);
            }
            catch (IOException e) {
                LOGGER.error("Cannot refresh token", (Throwable)e);
                return false;
            }
        }
        LOGGER.info("Refreshing OIDC user " + bearerUser.getName());
        try {
            User user = this.getMicrosoftUser(microsoftBearerUser.getAccessToken());
            Set<Group> groups = this.getUserGroups(microsoftBearerUser.getAccessToken());
            microsoftBearerUser.setUser(user);
            microsoftBearerUser.setGroups(groups);
        }
        catch (Exception e) {
            LOGGER.error("Cannot refresh user information", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> refreshToken(String refreshToken) throws IOException {
        if (this.microsoftUserService.getoAuthVersion() == MicrosoftOAuthVersion.V1) {
            return this.getRefreshTokenResponseV1(refreshToken);
        }
        return this.getRefreshTokenResponse(refreshToken);
    }

    private Set<Group> getUserGroups(String accessToken) throws Exception {
        this.checkEnabled();
        HashSet<Group> groups = new HashSet<Group>();
        URL url = new URL(this.microsoftUserService.getGraphUrl() + "/v1.0/me/memberOf");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestProperty("Accept", "application/json");
        int httpResponseCode = conn.getResponseCode();
        String goodRespStr = HttpClientHelper.getResponseStringFromConn(conn, true);
        int responseCode = conn.getResponseCode();
        JSONObject response = HttpClientHelper.processGoodRespStr(responseCode, goodRespStr);
        JSONArray jsonGroups = JSONHelper.fetchDirectoryObjectJSONArray(response);
        for (int i = 0; i < jsonGroups.length(); ++i) {
            JSONObject thisGroupJSONObject = jsonGroups.optJSONObject(i);
            Group group = new Group();
            JSONHelper.convertJSONObjectToDirectoryObject(thisGroupJSONObject, group);
            groups.add(group);
        }
        return groups;
    }

    private User getMicrosoftUser(String accessToken) throws Exception {
        String microsoftUserMail;
        this.checkEnabled();
        URL url = new URL(this.microsoftUserService.getGraphUrl() + "/v1.0/me");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestProperty("Accept", "application/json");
        int httpResponseCode = conn.getResponseCode();
        String goodRespStr = HttpClientHelper.getResponseStringFromConn(conn, true);
        int responseCode = conn.getResponseCode();
        JSONObject response = HttpClientHelper.processGoodRespStr(responseCode, goodRespStr);
        User user = new User();
        JSONHelper.convertJSONObjectToDirectoryObject(JSONHelper.fetchDirectoryObjectJSONObject(response), user);
        if (this.schedulerApplication.getConfiguration().getForceMicrosoftOidcUsernameFromMail() && (microsoftUserMail = user.getMail()) != null && microsoftUserMail.length() > 0) {
            user.setUserPrincipalName(microsoftUserMail);
        }
        try {
            if (BuiltInPrincipalIdentifiers.valueOf((String)user.getUserPrincipalName()) != null) {
                throw new AuthenticationException(this.iu.getString("OidcMicrosoftUtil.InvalidUsername"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (BuiltInPrincipalIdentifiers.fromString((String)user.getUserPrincipalName()) != null) {
            throw new AuthenticationException(this.iu.getString("OidcMicrosoftUtil.InvalidUsername"));
        }
        return user;
    }

    private String authenticateAsApplication(MicrosoftUserService microsoftUserService) {
        String tokenEndpoint = microsoftUserService.getAuthorityUrl() + URLEncoder.encode(microsoftUserService.getTenant(), StandardCharsets.UTF_8) + "/oauth2/v2.0/token";
        Form form = new Form();
        form.param("scope", microsoftUserService.getGraphUrl() + "/.default");
        form.param("grant_type", "client_credentials");
        form.param("client_id", microsoftUserService.getClientId());
        form.param("client_secret", microsoftUserService.getClientSecret());
        Response response = this.client.target(tokenEndpoint).request(new String[]{"application/json"}).post(Entity.form((Form)form));
        if (response.getStatus() != 200) {
            String error = (String)response.readEntity(String.class);
            throw new IllegalStateException("Failed to authenticate as client with Code HTTP/" + response.getStatus() + " " + error);
        }
        Map tokenResponse = (Map)response.readEntity((GenericType)new GenericType<Map<String, Object>>(){});
        return (String)tokenResponse.get("access_token");
    }

    public List<MicrosoftUnifiedGroup> getUnifiedGroups(MicrosoftUserService microsoftUserService) throws IOException {
        LOGGER.info("Getting Unified Groups for: " + microsoftUserService.getName());
        ArrayList<MicrosoftUnifiedGroup> groups = new ArrayList<MicrosoftUnifiedGroup>();
        String accessToken = this.authenticateAsApplication(microsoftUserService);
        Object getUnifiedGroupsUrl = microsoftUserService.getGraphUrl() + "/v1.0/groups?$filter=" + URLEncoder.encode("groupTypes/any(c:c eq 'Unified')", StandardCharsets.UTF_8) + "&$select=" + URLEncoder.encode("id,displayName,mail", StandardCharsets.UTF_8);
        try {
            while (getUnifiedGroupsUrl != null) {
                microsoftUserService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.SyncGroups", (Object)groups.size()));
                Response response = this.client.target((String)getUnifiedGroupsUrl).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
                ListValueResponse responseObject = (ListValueResponse)response.readEntity((GenericType)new GenericType<ListValueResponse<Map<String, Object>>>(){});
                for (Map groupEntry : responseObject.getValue()) {
                    MicrosoftUnifiedGroup group = new MicrosoftUnifiedGroup(groupEntry);
                    group.setUserServiceId(microsoftUserService.getId());
                    groups.add(group);
                }
                getUnifiedGroupsUrl = responseObject.getNextLink();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting unified groups", (Throwable)e);
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.CannotReadUnifiedGroups"));
        }
        microsoftUserService.setUpdateMessage(null);
        boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
        if (mockOptionsEnabled) {
            groups.addAll(this.buildMockUnifiedGroups(microsoftUserService.getId(), this.schedulerApplication.getConfiguration().getMockOptionsCount()));
        }
        return groups;
    }

    public List<Team> getUserAssociatedTeams(String upn) throws ThirdPartyRestException {
        String associatedTeamsUrl = this.microsoftUserService.getGraphUrl() + "/v1.0/users/" + upn + "/teamwork/associatedTeams";
        return this.queryAndPopulateTeamGroupSettings(associatedTeamsUrl);
    }

    public List<Team> getUserJoinedTeams(String upn) throws ThirdPartyRestException {
        String joinedTeamsUrl = this.microsoftUserService.getGraphUrl() + "/v1.0/users/" + upn + "/joinedTeams";
        return this.queryAndPopulateTeamGroupSettings(joinedTeamsUrl);
    }

    private List<Team> queryAndPopulateTeamGroupSettings(String url) throws ThirdPartyRestException {
        String accessToken = this.authenticateAsApplication(this.microsoftUserService);
        Response response = this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
        if (response.getStatus() >= 400) {
            String stringResponse = (String)response.readEntity(String.class);
            String errorMessage = "GET " + url + " HTTP/" + response.getStatus() + " " + stringResponse;
            throw new ThirdPartyRestException(errorMessage, response.getStatus(), stringResponse);
        }
        com.nuix.automate.utils.models.internal.graphapi.ListValueResponse teams = (com.nuix.automate.utils.models.internal.graphapi.ListValueResponse)response.readEntity((GenericType)new GenericType<com.nuix.automate.utils.models.internal.graphapi.ListValueResponse<Team>>(){});
        Map userServiceUnifiedGroups = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.UNIFIED_GROUP, this.microsoftUserService.getId());
        for (Team team : teams.getValue()) {
            MicrosoftUnifiedGroup teamGroup = (MicrosoftUnifiedGroup)userServiceUnifiedGroups.get(team.getId());
            if (teamGroup == null) continue;
            team.setMail(teamGroup.getEmail());
        }
        return teams.getValue();
    }

    public List<MicrosoftSharePointSite> getSharePointSites(MicrosoftUserService microsoftUserService, boolean getAllSites) throws IOException {
        LOGGER.info("Getting SharePoint Sites for: " + microsoftUserService.getName());
        ArrayList<MicrosoftSharePointSite> sites = new ArrayList<MicrosoftSharePointSite>();
        String accessToken = this.authenticateAsApplication(microsoftUserService);
        Consumer<String> pagedGetSharePointSites = getSitesUrl -> {
            while (getSitesUrl != null) {
                microsoftUserService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.SyncSites", (Object)sites.size()));
                Response response = this.client.target(getSitesUrl).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
                ListValueResponse responseObject = (ListValueResponse)response.readEntity((GenericType)new GenericType<ListValueResponse<Map<String, Object>>>(){});
                for (Map siteEntry : responseObject.getValue()) {
                    MicrosoftSharePointSite site = new MicrosoftSharePointSite(siteEntry);
                    site.setUserServiceId(microsoftUserService.getId());
                    sites.add(site);
                }
                getSitesUrl = responseObject.getNextLink();
            }
        };
        try {
            String getSitesUrl2 = microsoftUserService.getGraphUrl() + "/v1.0/sites";
            if (getAllSites) {
                getSitesUrl2 = getSitesUrl2 + "/getAllSites";
            }
            getSitesUrl2 = getSitesUrl2 + "?$top=999&$select=" + URLEncoder.encode("id,webUrl", StandardCharsets.UTF_8);
            pagedGetSharePointSites.accept(getSitesUrl2);
            for (MicrosoftSharePointSite site : new ArrayList(sites)) {
                String getSubSitesUrl = microsoftUserService.getGraphUrl() + "/v1.0/sites/" + site.getId() + "/sites";
                pagedGetSharePointSites.accept(getSubSitesUrl);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting sharePoint sites", (Throwable)e);
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.CannotReadSites"));
        }
        if (sites.isEmpty()) {
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.EmptyListOfSites"));
        }
        boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
        if (mockOptionsEnabled) {
            sites.addAll(this.buildMockSharePointSites(microsoftUserService.getId(), this.schedulerApplication.getConfiguration().getMockOptionsCount()));
        }
        microsoftUserService.setUpdateMessage(null);
        return sites;
    }

    public byte[] getMicrosoftUserImage(String username) {
        if (this.getOidcUserService().getEnabled().booleanValue()) {
            try {
                String accessToken = this.authenticateAsApplication(this.microsoftUserService);
                URL url = new URL(this.microsoftUserService.getGraphUrl() + "/v1.0/users/" + URLEncoder.encode(username, StandardCharsets.UTF_8) + "/photo/$value");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + accessToken);
                int httpResponseCode = conn.getResponseCode();
                LOGGER.info("Attempting to get image from URL " + String.valueOf(url) + ", Response code: " + httpResponseCode);
                if (httpResponseCode == 200) {
                    return IOUtils.toByteArray((InputStream)conn.getInputStream());
                }
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cannot get user image", (Throwable)e);
                }
                LOGGER.debug("Cannot get user image, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
            }
        }
        return null;
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly, boolean inactive) throws Exception {
        Object listUsersUrl;
        LOGGER.info("Getting AD users");
        ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
        MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
        String accessToken = this.authenticateAsApplication(microsoftUserService);
        if (inactive) {
            listUsersUrl = microsoftUserService.getGraphUrl() + "/v1.0/directory/deletedItems/microsoft.graph.user?$top=999";
        } else {
            listUsersUrl = microsoftUserService.getGraphUrl() + "/v1.0/users?$top=999";
            if (microsoftUserService.getIncludeGuestUsers() != Boolean.TRUE) {
                listUsersUrl = (String)listUsersUrl + "&$filter=" + URLEncoder.encode("userType eq 'Member' and mail ge ' '", StandardCharsets.UTF_8);
            }
        }
        listUsersUrl = (String)listUsersUrl + "&$select=" + URLEncoder.encode("id,userPrincipalName,mail,displayName,userType", StandardCharsets.UTF_8);
        try {
            while (listUsersUrl != null) {
                userService.setUpdateMessage(this.iu.getFormattedString("UserServiceWorker.SyncUsers", (Object)userAccounts.size()));
                Response response = this.client.target((String)listUsersUrl).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + accessToken)).get();
                ListValueResponse responseObject = (ListValueResponse)response.readEntity((GenericType)new GenericType<ListValueResponse<Map<String, Object>>>(){});
                for (Map userEntry : responseObject.getValue()) {
                    UserAccount userAccount = new UserAccount();
                    userAccount.setUserServiceId(userService.getId());
                    userAccount.setUserAccountState(UserAccountState.ACTIVE);
                    userAccount.setPlatform(UserAccountPlatform.AZURE_AD);
                    userAccount.setId((String)userEntry.get("id"));
                    userAccount.setName((String)userEntry.get("userPrincipalName"));
                    if (userEntry.get("mail") != null) {
                        userAccount.setEmail((String)userEntry.get("mail"));
                    }
                    HashMap attributes = new HashMap();
                    attributes.put("displayName", userEntry.get("displayName"));
                    attributes.put("userType", userEntry.get("userType"));
                    userAccount.setAttributes(attributes);
                    if (inactive) {
                        String flatId = userAccount.getId().replace("-", "");
                        if (userAccount.getName().startsWith(flatId)) {
                            userAccount.setName(userAccount.getName().substring(flatId.length()));
                        }
                    }
                    userAccounts.add(userAccount);
                }
                listUsersUrl = responseObject.getNextLink();
                if (!firstPageOnly) continue;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting azureAD users", (Throwable)e);
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.CannotReadUsers"));
        }
        userService.setUpdateMessage(null);
        if (!inactive && userAccounts.isEmpty()) {
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.EmptyListOfUsers"));
        }
        boolean mockOptionsEnabled = this.schedulerApplication.getConfiguration().getMockOptionsEnabled();
        if (mockOptionsEnabled) {
            userAccounts.addAll(this.buildMockUserAccounts(userService.getId(), UserAccountPlatform.AZURE_AD, this.schedulerApplication.getConfiguration().getMockOptionsCount(), this.schedulerApplication.getConfiguration().getMockOptionsChangingValues()));
        }
        return userAccounts;
    }

    public List<MicrosoftSharePointSite> buildMockSharePointSites(String userServiceId, int count) {
        ArrayList<MicrosoftSharePointSite> mockSharePointSites = new ArrayList<MicrosoftSharePointSite>();
        for (int i = 0; i < count; ++i) {
            MicrosoftSharePointSite sharePointSite = new MicrosoftSharePointSite();
            sharePointSite.setUserServiceId(userServiceId);
            String webUrl = "https://mock_site.example.com/sites/" + i + "/";
            if (this.schedulerApplication.getConfiguration().getMockOptionsChangingValues()) {
                webUrl = webUrl + this.random.nextInt(5);
            }
            sharePointSite.setId(UidUtils.fromString((String)webUrl));
            sharePointSite.setWebUrl(webUrl);
            mockSharePointSites.add(sharePointSite);
        }
        return mockSharePointSites;
    }

    private List<MicrosoftUnifiedGroup> buildMockUnifiedGroups(String userServiceId, int count) {
        ArrayList<MicrosoftUnifiedGroup> mockUnifiedGroups = new ArrayList<MicrosoftUnifiedGroup>();
        for (int i = 0; i < count; ++i) {
            MicrosoftUnifiedGroup unifiedGroup = new MicrosoftUnifiedGroup();
            unifiedGroup.setUserServiceId(userServiceId);
            String email = "mock.group." + i + "@example.com";
            if (this.schedulerApplication.getConfiguration().getMockOptionsChangingValues()) {
                email = email + this.random.nextInt(5);
            }
            unifiedGroup.setId(UidUtils.fromString((String)email));
            unifiedGroup.setEmail(email);
            mockUnifiedGroups.add(unifiedGroup);
        }
        return mockUnifiedGroups;
    }

    public Map<String, Object> getRefreshTokenResponse(String refreshToken) throws IOException {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IOException(e);
        }
        Form form = new Form();
        form.param("refresh_token", refreshToken);
        form.param("grant_type", "refresh_token");
        return this.getTokenResponse(form);
    }

    public Map<String, Object> getAuthCodeTokenResponse(String code, String codeVerifier, String redirectUrl) throws IOException {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IOException(e);
        }
        Form form = new Form();
        form.param("redirect_uri", redirectUrl);
        form.param("grant_type", "authorization_code");
        form.param("scope", "Directory.AccessAsUser.All offline_access");
        form.param("code", code);
        form.param("code_verifier", codeVerifier);
        return this.getTokenResponse(form);
    }

    private Map<String, Object> getTokenResponse(Form form) throws IOException {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IOException(e);
        }
        Client client = DropwizardRestClientFactory.getClient((String)("MicrosoftOidcUtil-" + DateTime.now().getMillis()), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
        String tokenEndpoint = (String)this.getWellKnownConfiguration().get("token_endpoint");
        form.param("client_id", this.microsoftUserService.getClientId());
        form.param("client_secret", this.microsoftUserService.getClientSecret());
        try (Response response = client.target(tokenEndpoint).request(new String[]{"application/json"}).post(Entity.form((Form)form));){
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new IllegalStateException("Post Token Endpoint with Code HTTP/" + response.getStatus() + " " + error);
            }
            Map map = (Map)response.readEntity((GenericType)new GenericType<Map<String, Object>>(){});
            return map;
        }
    }

    public Map<String, Object> getTokenResponseV1(String redirectUrl, String code) throws IOException {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"grant_type", (Object)"authorization_code");
        formData.add((Object)"redirect_uri", (Object)redirectUrl);
        formData.add((Object)"code", (Object)code);
        String tokenEndpoint = (String)this.getWellKnownConfiguration().get("token_endpoint");
        try (Response response = this.prepareClientRequestV1(tokenEndpoint).post(Entity.form((MultivaluedMap)formData));){
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new IllegalStateException("Post Token Endpoint with Code HTTP/" + response.getStatus() + " " + error);
            }
            Map map = (Map)response.readEntity(Map.class);
            return map;
        }
    }

    public Map<String, Object> getRefreshTokenResponseV1(String refreshToken) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"refresh_token", (Object)refreshToken);
        formData.add((Object)"grant_type", (Object)"refresh_token");
        String tokenEndpoint = (String)this.getWellKnownConfiguration().get("token_endpoint");
        try (Response response = this.prepareClientRequestV1(tokenEndpoint).post(Entity.form((MultivaluedMap)formData));){
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new IllegalStateException("Post Refresh Token Endpoint with Code HTTP/" + response.getStatus() + " " + error);
            }
            Map map = (Map)response.readEntity(Map.class);
            return map;
        }
    }

    private Invocation.Builder prepareClientRequestV1(String url) {
        try {
            this.checkEnabled();
        }
        catch (JwkException e) {
            throw new IllegalStateException(e);
        }
        String auth = this.microsoftUserService.getClientId() + ":" + this.microsoftUserService.getClientSecret();
        String basicToken = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
        return this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicToken));
    }

    @Override
    public void revokeToken(String token) {
    }

    public DecodedJWT verifyTokenV1(Map<String, Object> jsonResponse, OidcPartialUser partialUser) throws Exception {
        this.checkEnabled();
        String idToken = (String)jsonResponse.get("id_token");
        DecodedJWT jwt = JWT.decode((String)idToken);
        Jwk jwk = this.getJwkProvider().get(jwt.getKeyId());
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        algorithm.verify(jwt);
        if (jwt.getExpiresAt().before(new Date())) {
            throw new JwkException("Token expired");
        }
        String tokenNonce = jwt.getClaim("nonce").asString();
        if (!partialUser.getOidcNonce().equals(tokenNonce)) {
            throw new JwkException("Invalid token nonce " + tokenNonce);
        }
        return jwt;
    }

    public OAuthBearerUser getUserFromToken(String token) throws JwkException, JWTVerificationException {
        this.checkEnabled();
        DecodedJWT jwt = JWT.decode((String)token);
        try {
            Jwk jwk = this.getJwkProvider().get(jwt.getKeyId());
            Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
            algorithm.verify(jwt);
            if (jwt.getExpiresAt().before(new Date())) {
                throw new JwkException("Token expired");
            }
            String userName = jwt.getClaim("upn").asString();
            OAuthBearerUser user = new OAuthBearerUser(userName);
            return user;
        }
        catch (JwkException | JWTVerificationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JwkException("Cannot get user from token", (Throwable)e);
        }
    }

    @Override
    public BearerUser trackAuthenticationCode(String redirectUrl, String code, OidcPartialUser oidcPartialUser) throws Exception {
        Map<String, Object> tokenResponse;
        this.checkEnabled();
        String codeVerifier = this.stateToCodeVerifier.remove(oidcPartialUser.getOidcState());
        if (this.microsoftUserService.getoAuthVersion() == MicrosoftOAuthVersion.V1) {
            tokenResponse = this.getTokenResponseV1(redirectUrl, code);
            DecodedJWT jwt = this.verifyTokenV1(tokenResponse, oidcPartialUser);
            if (oidcPartialUser.getLoginMode() == OidcLoginMode.E_DISCOVERY_DOWNLOADER) {
                HashMap<String, String> userInfo = new HashMap<String, String>();
                for (String claim : new String[]{"upn", "name", "unique_name", "oid", "tid", "nonce", "sub"}) {
                    userInfo.put(claim, jwt.getClaim(claim).asString());
                }
                OidcMicrosoftBearerUser bearerUser = new OidcMicrosoftBearerUser(userInfo, this, tokenResponse);
                bearerUser.setSessionId(oidcPartialUser.getSessionId());
                return bearerUser;
            }
        } else {
            tokenResponse = this.getAuthCodeTokenResponse(code, codeVerifier, redirectUrl);
        }
        String accessToken = (String)tokenResponse.get("access_token");
        User user = this.getMicrosoftUser(accessToken);
        try {
            Set<Group> groups = this.getUserGroups(accessToken);
            OidcMicrosoftBearerUser bearerUser = new OidcMicrosoftBearerUser(user, groups, this, tokenResponse);
            bearerUser.setSessionId(oidcPartialUser.getSessionId());
            return bearerUser;
        }
        catch (Exception e) {
            LOGGER.error("Cannot get user groups", (Throwable)e);
            throw new IOException(this.iu.getString("OidcMicrosoftUtil.CannotReadGroups"));
        }
    }

    @Override
    public void processOidcOAuthResponse(HttpServletRequest request, UriInfo uriInfo, String access_token, String state, String code, String session_state, String error, String error_description) {
        block6: {
            try {
                this.checkEnabled();
                OidcPartialUser partialUser = (OidcPartialUser)this.stateToPartialUser.get(state);
                if (error == null) {
                    try {
                        BearerUser bearerUser = this.trackAuthenticationCode(ResourceUtils.getBaseUri((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/users/oidcResponse", code, partialUser);
                        if (bearerUser != null) {
                            partialUser.setBearerUser(bearerUser);
                            partialUser.setOidcState(null);
                            partialUser.setOidcNonce(null);
                            this.stateToError.remove(state);
                            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), bearerUser.getSessionId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), bearerUser.getName(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                            LOGGER.info("User " + bearerUser.getName() + ", session " + bearerUser.getSessionId() + ", logged in");
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("OIDC", "Microsoft365", bearerUser.getName(), bearerUser.getSessionId()), bearerUser.getName());
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        LOGGER.error("Cannot authenticate user against Azure AD", (Throwable)e);
                        this.stateToError.put(state, e);
                        String affectedId = partialUser.getSessionId();
                        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), affectedId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("OIDC", "Microsoft365", "N/A", affectedId, e.getLocalizedMessage()), "N/A");
                    }
                    break block6;
                }
                AuthenticationException e = new AuthenticationException(error + "\n" + error_description);
                this.stateToError.put(state, e);
            }
            catch (JwkException ex) {
                AuthenticationException e = new AuthenticationException((Throwable)ex);
                this.stateToError.put(state, e);
            }
        }
    }

    @Override
    public String getOAuthAuthorizeUrl(String redirectUrl, String state, String sessionId, OidcLoginMode loginMode) throws NoSuchAlgorithmException {
        String extraScope = null;
        if (loginMode == OidcLoginMode.E_DISCOVERY_MANAGER) {
            extraScope = "eDiscovery.ReadWrite.All";
        }
        OidcPartialUser oidcPartialUser = new OidcPartialUser(sessionId, loginMode);
        oidcPartialUser.setOidcState(state);
        this.stateToPartialUser.put(state, oidcPartialUser);
        if (this.microsoftUserService.getoAuthVersion() == MicrosoftOAuthVersion.V1) {
            String graphUrl;
            String nonce = SecurityUtils.getSecureRandomSecret();
            oidcPartialUser.setOidcNonce(nonce);
            String resource = graphUrl = this.microsoftUserService.getGraphUrl();
            Object scope = "openid " + graphUrl + "/user.read offline_access";
            if (extraScope != null) {
                scope = (String)scope + " " + extraScope;
            }
            if (loginMode == OidcLoginMode.E_DISCOVERY_DOWNLOADER) {
                resource = "b26e684c-5068-4120-a679-64a5d2c909d9";
                scope = "openid eDiscovery.Download.Read offline_access";
            }
            return String.valueOf(this.getWellKnownConfiguration().get("authorization_endpoint")) + "?client_id=" + URLEncoder.encode(this.microsoftUserService.getClientId(), StandardCharsets.UTF_8) + "&response_type=code&response_mode=form_post&redirect_uri=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8) + "&scope=" + URLEncoder.encode((String)scope, StandardCharsets.UTF_8) + "&state=" + URLEncoder.encode(state, StandardCharsets.UTF_8) + "&nonce=" + URLEncoder.encode(nonce, StandardCharsets.UTF_8) + "&resource=" + URLEncoder.encode(resource, StandardCharsets.UTF_8);
        }
        if (this.microsoftUserService.getoAuthVersion() == MicrosoftOAuthVersion.V2) {
            String codeVerifier = SecurityUtils.getRandomAlphaNumericString((int)43);
            String codeChallenge = Base64.getUrlEncoder().withoutPadding().encodeToString(SecurityUtils.computeSha256((String)codeVerifier));
            this.stateToCodeVerifier.put(state, codeVerifier);
            String graphUrl = this.microsoftUserService.getGraphUrl();
            Object scope = "openid " + graphUrl + "/user.read offline_access";
            if (extraScope != null) {
                scope = (String)scope + " " + extraScope;
            }
            if (loginMode == OidcLoginMode.E_DISCOVERY_DOWNLOADER) {
                scope = "openid b26e684c-5068-4120-a679-64a5d2c909d9/.default offline_access";
            }
            return String.valueOf(this.getWellKnownConfiguration().get("authorization_endpoint")) + "?client_id=" + URLEncoder.encode(this.microsoftUserService.getClientId(), StandardCharsets.UTF_8) + "&response_type=code&response_mode=form_post&redirect_uri=" + URLEncoder.encode(redirectUrl, StandardCharsets.UTF_8) + "&scope=" + URLEncoder.encode((String)scope, StandardCharsets.UTF_8) + "&state=" + URLEncoder.encode(state, StandardCharsets.UTF_8) + "&code_challenge=" + codeChallenge + "&code_challenge_method=S256";
        }
        throw new IllegalArgumentException("Microsoft OAuth version " + String.valueOf(this.microsoftUserService.getoAuthVersion()) + " not supported");
    }

    @Override
    public boolean valid() {
        return true;
    }

    @Override
    public void update(UserService userService) {
        super.update(userService);
        this.microsoftUserService = (MicrosoftUserService)userService;
    }

    private static class ListValueResponse<T> {
        private List<T> value;
        @JsonProperty(value="@odata.nextLink")
        private String nextLink;

        private ListValueResponse() {
        }

        public List<T> getValue() {
            if (this.value == null) {
                return new ArrayList();
            }
            return this.value;
        }

        public void setValue(List<T> value) {
            this.value = value;
        }

        public String getNextLink() {
            return this.nextLink;
        }

        public void setNextLink(String nextLink) {
            this.nextLink = nextLink;
        }
    }
}

