/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.microsoft;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.security.oidc.microsoft.Group;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.User;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class OidcMicrosoftBearerUser
extends BearerUser
implements UserServiceUser {
    private User user;
    private Set<Group> groups;
    private Map<String, Object> tokenResponse;
    private Long expiresOn;
    private final MicrosoftOidcUserServiceClient oidcUserServiceClient;

    public OidcMicrosoftBearerUser(User user, Set<Group> groups, MicrosoftOidcUserServiceClient oidcUserServiceClient, Map<String, Object> tokenResponse) {
        super(new Identifier(IdentifierType.AZURE_USERNAME, user.getUserPrincipalName()));
        this.oidcUserServiceClient = oidcUserServiceClient;
        this.groups = groups;
        this.setUser(user);
        this.setTokenResponse(tokenResponse);
    }

    public OidcMicrosoftBearerUser(Map<String, String> jwtClaimInfo, MicrosoftOidcUserServiceClient oidcUserServiceClient, Map<String, Object> tokenResponse) {
        super(new Identifier(IdentifierType.AZURE_USERNAME, jwtClaimInfo.get("upn")));
        this.oidcUserServiceClient = oidcUserServiceClient;
        this.setTokenResponse(tokenResponse);
    }

    public void invalidate() {
    }

    public boolean refresh() {
        return this.oidcUserServiceClient.refresh(this);
    }

    @JsonIgnore
    public MicrosoftOidcUserServiceClient getClient() {
        return this.oidcUserServiceClient;
    }

    public String getUserServiceId() {
        return this.oidcUserServiceClient.getOidcUserService().getId();
    }

    public Set<Identifier> getIdentifiers() {
        if (!this.oidcUserServiceClient.getOidcUserService().getEnabled().booleanValue()) {
            return new HashSet<Identifier>();
        }
        HashSet<Identifier> identifiers = new HashSet<Identifier>(super.getIdentifiers());
        identifiers.add(new Identifier(IdentifierType.AZURE_USERNAME, this.user.getUserPrincipalName().toLowerCase()));
        for (Group group : this.groups) {
            identifiers.add(new Identifier(IdentifierType.AZURE_GROUP_ID, group.getId().toLowerCase()));
        }
        return identifiers;
    }

    public String getAccessToken() {
        return (String)this.tokenResponse.get("access_token");
    }

    public String getRefreshToken() {
        return (String)this.tokenResponse.get("refresh_token");
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.setId(user.getId());
        this.user = user;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public Map<String, Object> getTokenResponse() {
        return this.tokenResponse;
    }

    public void setTokenResponse(Map<String, Object> tokenResponse) {
        Integer expiresIn;
        this.tokenResponse = tokenResponse;
        try {
            expiresIn = (Integer)tokenResponse.get("expires_in");
        }
        catch (ClassCastException e) {
            expiresIn = Integer.parseInt((String)tokenResponse.get("expires_in"));
        }
        this.expiresOn = expiresIn != null ? Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + (long)(expiresIn * 1000)) : null;
    }

    public Long getExpiresInMillis() {
        if (this.expiresOn != null) {
            return this.expiresOn - DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        }
        return null;
    }
}

