/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.relativity;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.security.relativity.RelativityImpersonatedUser;
import com.nuix.automate.scheduler.security.relativity.RelativityObject;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.Set;

public class RelativityImpersonatedBearerUser
extends BearerUser {
    private RelativityImpersonatedUser relativityImpersonatedUser;

    public RelativityImpersonatedBearerUser(RelativityImpersonatedUser relativityImpersonatedUser) {
        super(new Identifier(IdentifierType.RELATIVITY_USER_EMAIL, relativityImpersonatedUser.getUserEmail()));
        this.relativityImpersonatedUser = relativityImpersonatedUser;
        this.setId(relativityImpersonatedUser.getUserEmail());
    }

    public void invalidate() {
    }

    public boolean refresh() {
        return true;
    }

    public Set<Identifier> getIdentifiers() {
        HashSet<Identifier> identifiers = new HashSet<Identifier>(super.getIdentifiers());
        identifiers.add(new Identifier(IdentifierType.RELATIVITY_USER_EMAIL, this.relativityImpersonatedUser.getUserEmail()));
        identifiers.add(new Identifier(IdentifierType.RELATIVITY_USER_ARTIFACT_ID, this.relativityImpersonatedUser.getUserId()));
        if (this.relativityImpersonatedUser.getUserGroups() != null) {
            for (RelativityObject relativityGroup : this.relativityImpersonatedUser.getUserGroups()) {
                identifiers.add(new Identifier(IdentifierType.RELATIVITY_GROUP_NAME, relativityGroup.getName()));
                identifiers.add(new Identifier(IdentifierType.RELATIVITY_GROUP_ID, relativityGroup.getId()));
            }
        }
        return identifiers;
    }
}

