/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.relativity;

import com.auth0.jwk.JwkException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.nuix.automate.scheduler.security.relativity.RelativityImpersonatedBearerUser;
import com.nuix.automate.scheduler.security.relativity.RelativityImpersonatedUser;
import com.nuix.automate.scheduler.security.relativity.RelativityObject;
import com.nuix.automate.utils.models.internal.user.RelativityUserImpersonationService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;

public class RelativityImpersonationUtils {
    private static final String USER_EMAIL_CLAIM = "email";
    private static final String USER_ARTIFACT_ID_CLAIM = "artifactId";

    public static RelativityImpersonatedBearerUser getUserFromToken(RelativityUserImpersonationService relativityUserImpersonationService, String token) throws JwkException, JWTVerificationException {
        DecodedJWT jwt = JWT.decode((String)token);
        Algorithm algorithm = Algorithm.HMAC256((byte[])relativityUserImpersonationService.getSecret().getBytes(StandardCharsets.UTF_8));
        algorithm.verify(jwt);
        if (jwt.getExpiresAt() == null) {
            throw new JwkException("Token is missing expiration date");
        }
        if (jwt.getExpiresAt().before(new Date())) {
            throw new JwkException("Token expired");
        }
        try {
            RelativityImpersonatedUser relativityImpersonatedUser = new RelativityImpersonatedUser();
            relativityImpersonatedUser.setUserEmail(jwt.getClaim(USER_EMAIL_CLAIM).asString());
            relativityImpersonatedUser.setUserId("" + jwt.getClaim(USER_ARTIFACT_ID_CLAIM).asInt());
            ArrayList<RelativityObject> relativityGroups = new ArrayList<RelativityObject>();
            relativityImpersonatedUser.setGroups(relativityGroups);
            RelativityImpersonatedBearerUser user = new RelativityImpersonatedBearerUser(relativityImpersonatedUser);
            return user;
        }
        catch (Exception e) {
            throw new JwkException("Cannot decode Relativity User", (Throwable)e);
        }
    }
}

