/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.utils.StringUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverService;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceDefinition;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceType;
import com.nuix.automate.workflow.core.utils.discover.DiscoverRestClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DiscoverServiceSession
extends ThirdPartyServiceSession<DiscoverService, DiscoverUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DiscoverServiceSession.class);
    private DiscoverRestClient discoverRestClient;

    public DiscoverServiceSession(String userId, DiscoverService discoverService, DiscoverUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, discoverService, userCredential, schedulerApplication);
    }

    public DiscoverServiceSession(DiscoverServiceSession client) {
        super(client);
        this.discoverRestClient = null;
    }

    public DiscoverRestClient getClient() {
        return this.discoverRestClient;
    }

    @Override
    public List<ThirdPartyServiceDefinition> getServicesDefinition(String bearerToken) {
        String apiUrl;
        ThirdPartyServiceDefinition discoverServiceDefinition = new ThirdPartyServiceDefinition(ThirdPartyServiceType.NUIX_DISCOVER, ((DiscoverService)this.service).getName());
        discoverServiceDefinition.setConfigured(true);
        if (this.discoverRestClient == null) {
            try {
                this.initialize();
            }
            catch (IOException e) {
                LOGGER.error("Cannot initialize client", (Throwable)e);
            }
        }
        if (this.discoverRestClient != null && (apiUrl = this.discoverRestClient.getApiUrl()) != null) {
            discoverServiceDefinition.setUrl(StringUtils.caseInsensitiveReplace(apiUrl, "/ringtail-svc-portal/api/query", ""));
        }
        discoverServiceDefinition.setConnected(this.getConnected());
        return List.of(discoverServiceDefinition);
    }

    @Override
    public String getLogKey() {
        return "logApiDiscover";
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        if (this.discoverRestClient == null) {
            throw new IOException("Cannot initialize service");
        }
        this.discoverRestClient.getMeId();
        return null;
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.discoverRestClient = new DiscoverRestClient((DiscoverService)this.service, (DiscoverUserCredential)this.userCredential, this.getClientName(), logChannel, whitelistedCertFingerprints);
    }

    @Override
    protected void closeSession() {
        if (this.discoverRestClient != null) {
            this.discoverRestClient.close();
        }
    }

    @Override
    public DiscoverServiceSession clone() {
        return new DiscoverServiceSession(this);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        licenseInfo.assertModuleLicensed(ModuleType.DISCOVER_ADVANCED);
    }
}

