/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.ecc.responses.cases.Case;
import com.nuix.automate.utils.ecc.responses.cases.Cases;
import com.nuix.automate.utils.ecc.responses.computers.Computer;
import com.nuix.automate.utils.ecc.responses.computers.Computers;
import com.nuix.automate.utils.ecc.responses.configurations.Configuration;
import com.nuix.automate.utils.ecc.responses.configurations.Configurations;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.EccService;
import com.nuix.automate.utils.models.api.thirdparty.EccUserCredential;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class EccServiceSession
extends ThirdPartyServiceSession<EccService, EccUserCredential> {
    private final ObjectMapper objectMapper;

    public EccServiceSession(String userId, EccService eccService, EccUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, eccService, userCredential, schedulerApplication);
        this.objectMapper = new ObjectMapperProvider().getContext(null);
    }

    public EccServiceSession(EccServiceSession session) {
        super(session);
        this.objectMapper = session.objectMapper;
    }

    @Override
    public String getLogKey() {
        return "logApiEcc";
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        Entity requestBody = apiProxyRequest.getBody() != null ? Entity.json((Object)apiProxyRequest.getBody()) : Entity.json(new HashMap());
        if (apiProxyRequest.getProxyResponse()) {
            return this.callApiResponse(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, apiProxyRequest.getApiVersion(), true);
        }
        return this.callApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, new GenericType<Object>(){}, apiProxyRequest.getApiVersion());
    }

    public List<Computer> getComputers() throws IOException {
        HashMap<String, Integer> filter = new HashMap<String, Integer>();
        filter.put("limit", 1000);
        ArrayList<Computer> computers = new ArrayList<Computer>();
        String endpoint = "/api/ecc/v2/computers";
        while (true) {
            String next;
            Computers computersObj;
            if ((computersObj = this.callApi(endpoint, "POST", Entity.json(filter), new GenericType<Computers>(){}, null)).getComputers() != null) {
                computers.addAll(computersObj.getComputers());
            }
            if ((next = computersObj.getNext()) == null) break;
            endpoint = next;
        }
        return computers.size() == 0 ? null : computers;
    }

    public List<Configuration> getConfigurations() throws IOException {
        String endpoint = "/api/ecc/v2/configurations";
        Configurations configurations = this.callGetApi(endpoint, new GenericType<Configurations>(){});
        if (configurations == null || configurations.getConfigurations() == null) {
            return null;
        }
        return configurations.getConfigurations().size() == 0 ? null : configurations.getConfigurations();
    }

    public List<Case> getCases() throws IOException {
        String endpoint = "/api/ecc/v2/cases";
        Cases cases = this.callGetApi(endpoint, new GenericType<Cases>(){});
        if (cases == null || cases.getCases() == null) {
            return null;
        }
        return cases.getCases().size() == 0 ? null : cases.getCases();
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        return "Cases: " + this.getCases().size();
    }

    private <ResponseType> ResponseType callGetApi(String url, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, "GET", null, entityType);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, method, body, entityType, null);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType, String apiVersion) throws IOException {
        try (Response response = this.callApiResponse(url, method, body, apiVersion, false);){
            ResponseType ResponseType = this.readResponseEntity(this.objectMapper, response, entityType);
            return ResponseType;
        }
    }

    private <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, String apiVersion, boolean proxyRequest) throws IOException {
        Object fullUrl = httpsPattern.matcher(url).find() ? url : ((EccService)this.service).getUrl() + url;
        return this.callApiResponse((String)fullUrl, method, body, proxyRequest);
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    protected synchronized Invocation.Builder prepareRequest(String url) throws IOException {
        this.validateRequest();
        String basicAuthCredentials = Base64.getEncoder().encodeToString((((EccUserCredential)this.userCredential).getUsername() + ":" + ((EccUserCredential)this.userCredential).getPassword()).getBytes(StandardCharsets.UTF_8));
        return this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicAuthCredentials));
    }

    @Override
    public EccServiceSession clone() {
        return new EccServiceSession(this);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.ECC_COLLECTIONS, false);
    }
}

