/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.NlpService;
import com.nuix.automate.utils.models.api.thirdparty.NlpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceDefinition;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceType;
import com.nuix.automate.workflow.core.utils.nlp.NlpRestClient;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NlpServiceSession
extends ThirdPartyServiceSession<NlpService, NlpUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NlpServiceSession.class);
    private NlpRestClient nlpRestClient;

    public NlpServiceSession(String userId, NlpService nlpService, NlpUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, nlpService, userCredential, schedulerApplication);
    }

    public NlpServiceSession(NlpServiceSession client) {
        super(client);
        this.nlpRestClient = null;
    }

    public NlpRestClient getClient() {
        return this.nlpRestClient;
    }

    @Override
    public String getLogKey() {
        return "logApiNlp";
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        this.nlpRestClient.retrieveAccessToken();
        return null;
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.nlpRestClient = new NlpRestClient(this.getClientName(), (NlpService)this.service, (NlpUserCredential)this.userCredential, logChannel, whitelistedCertFingerprints);
    }

    @Override
    protected void closeSession() {
        if (this.nlpRestClient != null) {
            this.nlpRestClient.close();
        }
    }

    @Override
    public NlpServiceSession clone() {
        return new NlpServiceSession(this);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.NLP, false);
    }

    @Override
    public List<ThirdPartyServiceDefinition> getServicesDefinition(String bearerToken) {
        String url;
        ThirdPartyServiceDefinition nlpServiceDefinition = new ThirdPartyServiceDefinition(ThirdPartyServiceType.NUIX_NLP, ((NlpService)this.service).getName());
        nlpServiceDefinition.setConfigured(true);
        if (this.nlpRestClient == null) {
            try {
                this.initialize();
            }
            catch (IOException e) {
                LOGGER.error("Cannot initialize client", (Throwable)e);
            }
        }
        if (this.nlpRestClient != null && (url = this.nlpRestClient.getUrl()) != null && !url.isEmpty()) {
            nlpServiceDefinition.setUrl(url);
        }
        nlpServiceDefinition.setConnected(this.getConnected());
        return List.of(nlpServiceDefinition);
    }
}

