/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.UserCredential;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import java.io.IOException;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class OidcThirdPartyServiceSession<T1 extends ThirdPartyService, T2 extends ThirdPartyUserCredential>
extends ThirdPartyServiceSession<T1, T2> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OidcThirdPartyServiceSession.class);
    protected OidcUserService userService;

    public OidcThirdPartyServiceSession(String userId, T1 service, T2 userCredential, SchedulerApplication schedulerApplication) {
        super(userId, service, userCredential, schedulerApplication);
        if (service.usingOidcAuthenticationMethod()) {
            UserService userService = schedulerApplication.getUserServiceResource().getUserService(service.getAuthenticationServiceId());
            if (userService instanceof OidcUserService) {
                this.userService = (OidcUserService)userService;
            } else {
                this.userService = null;
                this.logger.addError(iu.getString("ThirdPartySession.Error.InvalidConfiguration"));
            }
        }
    }

    public OidcThirdPartyServiceSession(OidcThirdPartyServiceSession<T1, T2> thirdPartySession) {
        super(thirdPartySession);
        this.userService = thirdPartySession.userService;
    }

    public ThirdPartyUserCredential createOidcClientCredential() {
        return null;
    }

    @Override
    public boolean refreshToken() throws IOException {
        this.refreshToken((UserCredential)this.userCredential);
        this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential(this.userCredential);
        this.logger.addLog(iu.getFormattedString(this.getTranslationKey("Log.RefreshedAccessToken"), new Object[0]));
        return true;
    }

    protected synchronized void refreshToken(UserCredential userCredential) throws IOException {
        if (userCredential.getRefreshToken() == null) {
            String errorMessage = iu.getFormattedString(this.getTranslationKey("Error.CannotRefreshMissingRefreshToken"), new Object[0]);
            throw new IOException(errorMessage);
        }
        OidcUserServiceClient oidcUserServiceClient = (OidcUserServiceClient)this.schedulerApplication.getUserServiceResource().getUserServiceClient(this.service.getAuthenticationServiceId());
        Map<String, Object> refreshedTokenResponse = oidcUserServiceClient.refreshToken(userCredential.getRefreshToken());
        LOGGER.info("Refreshed token for userCredential signed in as: " + userCredential.getUsername());
        userCredential.setOidcTokenResponse(refreshedTokenResponse);
        userCredential.setTokenLastRefreshDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICE, this.service.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES);
    }
}

