/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftOidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.ImportedObjectsParseResult;
import com.nuix.automate.utils.models.api.thirdparty.PurviewDownloadUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.PurviewService;
import com.nuix.automate.utils.models.api.thirdparty.PurviewUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.thirdparty.UserCredential;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.userservice.MicrosoftSharePointSite;
import com.nuix.automate.utils.models.api.userservice.MicrosoftUnifiedGroup;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.graphapi.Group;
import com.nuix.automate.utils.models.internal.graphapi.ListValueResponse;
import com.nuix.automate.utils.models.internal.graphapi.MicrosoftGraphObject;
import com.nuix.automate.utils.models.internal.graphapi.Site;
import com.nuix.automate.utils.models.internal.graphapi.Team;
import com.nuix.automate.utils.models.internal.graphapi.User;
import com.nuix.automate.utils.models.internal.purview.Custodian;
import com.nuix.automate.utils.models.internal.purview.DataSource;
import com.nuix.automate.utils.models.internal.purview.DataSourceType;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryApiRequest;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryCase;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryListValueResponse;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSet;
import com.nuix.automate.utils.models.internal.purview.EDiscoveryReviewSetQuery;
import com.nuix.automate.utils.models.internal.purview.EDiscoverySearch;
import com.nuix.automate.utils.models.internal.purview.NonCustodialDataSource;
import com.nuix.automate.utils.models.internal.purview.PurviewServiceObjectType;
import com.nuix.automate.utils.models.internal.purview.operations.CaseOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.ReviewSetExportOperation;
import com.nuix.automate.utils.models.internal.purview.operations.SearchExportOperation;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.purview.PurviewUtils;
import com.nuix.automate.workflow.core.execution.options.purview.CustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.execution.options.purview.DataLocationType;
import com.nuix.automate.workflow.core.execution.options.purview.NonCustodialDataSourceSubmission;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class PurviewServiceSession
extends OidcThirdPartyServiceSession<PurviewService, PurviewUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PurviewServiceSession.class);
    private final MicrosoftUserService userService;
    private final ObjectMapper objectMapper;
    private final Map<String, String> userEmailToUpnCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> userUpnToEmailCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> groupEmailToIdCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> caseInsensitiveUserEmail = new ConcurrentHashMap<String, String>();

    public PurviewServiceSession(String userId, PurviewService purviewService, PurviewUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, purviewService, userCredential, schedulerApplication);
        this.version = schedulerApplication.getConfiguration().getPurviewGraphApiVersion();
        this.reattemptEnabled = true;
        this.objectMapper = new ObjectMapperProvider().getContext(null);
        UserService userService = schedulerApplication.getUserServiceResource().getUserService(purviewService.getAuthenticationServiceId());
        if (userService instanceof MicrosoftUserService) {
            this.userService = (MicrosoftUserService)userService;
        } else {
            this.userService = null;
            this.logger.addError(iu.getString("ThirdPartySession.Error.InvalidConfiguration"));
        }
    }

    public PurviewServiceSession(PurviewServiceSession session) {
        super(session);
        this.userService = session.userService;
        this.version = session.version;
        this.reattemptEnabled = session.reattemptEnabled;
        this.objectMapper = session.objectMapper;
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        if (apiProxyRequest.getEndpoint().equals("/tenant")) {
            return this.userService.getTenant();
        }
        if (apiProxyRequest.getEndpoint().equals("/purviewDownloadToken")) {
            return this.getPurviewDownloadToken();
        }
        if (apiProxyRequest.getEndpoint().contains("?email=")) {
            String[] pathSplit = apiProxyRequest.getEndpoint().split("\\?email=");
            String email = URLDecoder.decode(pathSplit[1], StandardCharsets.UTF_8);
            switch (pathSplit[0]) {
                case "/upn": {
                    return this.getUserUpnFromEmail(email);
                }
                case "/userSharePoint": {
                    return this.getUserPersonalSharePointSite(email);
                }
                case "/groupSharePoint": {
                    return this.getGroupSharePointSite(email);
                }
                case "/userAssociatedTeams": {
                    return this.getUserAssociatedTeams(email);
                }
                case "/userJoinedTeams": {
                    return this.getUserJoinedTeams(email);
                }
            }
        } else {
            if (apiProxyRequest.getEndpoint().startsWith("email?upn=")) {
                String[] pathSplit = apiProxyRequest.getEndpoint().split("\\?upn=");
                String upn = URLDecoder.decode(pathSplit[1], StandardCharsets.UTF_8);
                return this.getUserEmailFromUpn(upn);
            }
            if (apiProxyRequest.getEndpoint().equals("/normalizeUserEmails")) {
                return this.normalizeUserEmails((Collection)apiProxyRequest.getBody());
            }
        }
        Entity requestBody = apiProxyRequest.getBody() != null ? Entity.json((Object)apiProxyRequest.getBody()) : Entity.json(new HashMap());
        if (apiProxyRequest.getProxyResponse()) {
            return this.callApiResponse(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), apiProxyRequest.getExpectedStatus(), requestBody, apiProxyRequest.getApiVersion(), true);
        }
        Object result = apiProxyRequest.getPageRequests() ? this.callGenericPagedGetApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getApiVersion(), true) : this.callApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), apiProxyRequest.getExpectedStatus(), requestBody, new GenericType<Object>(){}, apiProxyRequest.getApiVersion());
        if (apiProxyRequest.getEndpoint().endsWith("/custodians") || apiProxyRequest.getEndpoint().endsWith("/userSources")) {
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                if (resultMap.containsKey("value")) {
                    this.patchPurviewUserEmail((List)resultMap.get("value"));
                } else if (resultMap.containsKey("email")) {
                    this.patchPurviewUserEmail(Collections.singletonList(resultMap));
                }
            } else if (result instanceof List) {
                this.patchPurviewUserEmail((List)result);
            }
        }
        return result;
    }

    @Override
    public Object getObjects(String serviceObjectType, Map<String, Object> parameters) throws IOException {
        PurviewServiceObjectType objectType = PurviewServiceObjectType.valueOf((String)serviceObjectType);
        EDiscoveryApiRequest apiRequest = (EDiscoveryApiRequest)this.objectMapper.convertValue(parameters, EDiscoveryApiRequest.class);
        switch (objectType) {
            case CASES: {
                return this.getCases(false);
            }
            case SEARCHES: {
                return this.getSearches(apiRequest.getCaseId(), false);
            }
            case REVIEW_SETS: {
                return this.getCaseReviewSets(apiRequest.getCaseId(), false);
            }
            case REVIEW_SET_QUERIES: {
                return this.getReviewSetQueries(apiRequest.getCaseId(), apiRequest.getReviewSetId(), false);
            }
            case EXPORT_JOBS: {
                return this.getExportOperations(apiRequest.getCaseId());
            }
            case CUSTODIANS: {
                return this.getCaseCustodians(apiRequest.getCaseId(), false);
            }
            case CUSTODIAN_DATA_SOURCES: {
                return this.getCaseCustodianDataSources(apiRequest.getCaseId(), apiRequest.getCustodianId(), false);
            }
            case NON_CUSTODIAL_DATA_SOURCES: {
                return this.getCaseNonCustodialDataSources(apiRequest.getCaseId(), false);
            }
            case ALL_CUSTODIAL_DATA_SOURCES: {
                HashMap<String, List<DataSource>> custodianDataSources = new HashMap<String, List<DataSource>>();
                for (Custodian custodian : this.getCaseCustodians(apiRequest.getCaseId(), false)) {
                    List<DataSource> dataSources = this.getCaseCustodianDataSources(apiRequest.getCaseId(), custodian.getId(), false);
                    custodianDataSources.put(custodian.getId(), dataSources);
                }
                return custodianDataSources;
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + String.valueOf(objectType));
    }

    @Override
    public ImportedObjectsParseResult<?> parseImportedObjects(String serviceObjectType, List<String[]> objectRows) {
        PurviewServiceObjectType objectType = PurviewServiceObjectType.valueOf((String)serviceObjectType);
        Set userEmails = this.schedulerApplication.getUserServiceResource().getUsers(this.userService.getId()).stream().map(UserAccount::getEmail).collect(Collectors.toSet());
        Set sharePointUrls = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.SHARE_POINT_SITE, this.userService.getId()).values().stream().map(obj -> ((MicrosoftSharePointSite)obj).getWebUrl()).collect(Collectors.toSet());
        Set unifiedGroupEmails = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.UNIFIED_GROUP, this.userService.getId()).values().stream().map(obj -> ((MicrosoftUnifiedGroup)obj).getEmail()).collect(Collectors.toSet());
        switch (objectType) {
            case CUSTODIAN_DATA_SOURCES: {
                ImportedObjectsParseResult custodialDataSourcesParseResult = new ImportedObjectsParseResult();
                for (int i = 1; i < objectRows.size(); ++i) {
                    try {
                        boolean invalid;
                        Object[] row = objectRows.get(i);
                        CustodialDataSourceSubmission dataSourceSubmission = CustodialDataSourceSubmission.build((Object[])row);
                        boolean bl = invalid = !userEmails.contains(dataSourceSubmission.getCustodianEmail());
                        if (!invalid && dataSourceSubmission.getType() != null) {
                            switch (dataSourceSubmission.getType()) {
                                case USER: {
                                    invalid = !userEmails.contains(dataSourceSubmission.getValue());
                                    break;
                                }
                                case UNIFIED_GROUP: {
                                    invalid = !unifiedGroupEmails.contains(dataSourceSubmission.getValue());
                                    break;
                                }
                                case SITE: {
                                    boolean bl2 = invalid = !sharePointUrls.contains(dataSourceSubmission.getValue());
                                }
                            }
                        }
                        if (!invalid) {
                            custodialDataSourcesParseResult.add((Object)dataSourceSubmission);
                            continue;
                        }
                        custodialDataSourcesParseResult.incrementInvalidCount();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error parsing custodial data source row " + i, (Throwable)e);
                        custodialDataSourcesParseResult.incrementInvalidCount();
                    }
                }
                return custodialDataSourcesParseResult;
            }
            case NON_CUSTODIAL_DATA_SOURCES: {
                ImportedObjectsParseResult nonCustodialDataSourcesParseResult = new ImportedObjectsParseResult();
                for (int i = 1; i < objectRows.size(); ++i) {
                    try {
                        Object[] row = objectRows.get(i);
                        String value = (String)row[1];
                        DataLocationType type = NonCustodialDataSourceSubmission.normalizeType((String)((String)row[0]));
                        NonCustodialDataSourceSubmission dataSourceSubmission = new NonCustodialDataSourceSubmission(type, value);
                        boolean invalid = true;
                        if (dataSourceSubmission.getType() != null) {
                            switch (dataSourceSubmission.getType()) {
                                case EXCHANGE_LOCATION: {
                                    invalid = !userEmails.contains(dataSourceSubmission.getValue()) && !unifiedGroupEmails.contains(dataSourceSubmission.getValue());
                                    break;
                                }
                                case SHAREPOINT_SITE: {
                                    boolean bl = invalid = !sharePointUrls.contains(dataSourceSubmission.getValue());
                                }
                            }
                        }
                        if (!invalid) {
                            nonCustodialDataSourcesParseResult.add((Object)dataSourceSubmission);
                            continue;
                        }
                        nonCustodialDataSourcesParseResult.incrementInvalidCount();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error parsing non-custodial data source row " + i, (Throwable)e);
                        nonCustodialDataSourcesParseResult.incrementInvalidCount();
                    }
                }
                return nonCustodialDataSourcesParseResult;
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + String.valueOf(objectType));
    }

    private String getPurviewDownloadToken() throws IOException {
        this.validateRequest();
        if (!this.getUsePurviewDownload()) {
            throw new IllegalStateException(iu.getFormattedString("PurviewServiceSession.Error.PurviewDownloadDisabled", new Object[0]));
        }
        PurviewDownloadUserCredential downloadUserCredential = ((PurviewUserCredential)this.userCredential).getDownloadUserCredential();
        if (downloadUserCredential == null || !downloadUserCredential.getSignedIn()) {
            throw new IllegalStateException(iu.getFormattedString("PurviewServiceSession.Error.DownloadUserNotSignedIn", new Object[0]));
        }
        if (downloadUserCredential.getToken() == null || downloadUserCredential.getExpired()) {
            this.refreshDownloadUserToken();
        }
        return downloadUserCredential.getToken();
    }

    private String getUserPersonalSharePointSite(String email) throws IOException {
        String upn = this.getUserUpnFromEmail(email);
        if (upn != null) {
            String getUserUrl = "/users/" + upn + "?$select=" + URLEncoder.encode("id,mySite", StandardCharsets.UTF_8);
            Map<String, Object> userEntry = this.callGetApi(getUserUrl, new GenericType<Map<String, Object>>(){});
            return (String)userEntry.get("mySite");
        }
        return null;
    }

    private String getGroupSharePointSite(String email) throws IOException {
        String groupId = this.getGroupIdFromEmail(email);
        if (groupId != null) {
            return this.getGroupSharePointSiteFromId(groupId).getWebUrl();
        }
        return null;
    }

    private MicrosoftSharePointSite getGroupSharePointSiteFromId(String id) throws IOException {
        String getGroupSiteUrl = "/groups/" + id + "/sites/root?&$select=" + URLEncoder.encode("id,webUrl", StandardCharsets.UTF_8);
        return this.callGetApi(getGroupSiteUrl, new GenericType<MicrosoftSharePointSite>(){});
    }

    private List<Team> getUserAssociatedTeams(String email) throws ThirdPartyRestException {
        String upn = this.getUserUpnFromEmail(email);
        if (upn != null) {
            MicrosoftOidcUserServiceClient microsoftUserServiceClient = (MicrosoftOidcUserServiceClient)this.schedulerApplication.getUserServiceResource().getUserServiceClient(this.userService.getId());
            return microsoftUserServiceClient.getUserAssociatedTeams(upn);
        }
        return null;
    }

    private List<Team> getUserJoinedTeams(String email) throws ThirdPartyRestException {
        String upn = this.getUserUpnFromEmail(email);
        if (upn != null) {
            MicrosoftOidcUserServiceClient microsoftUserServiceClient = (MicrosoftOidcUserServiceClient)this.schedulerApplication.getUserServiceResource().getUserServiceClient(this.userService.getId());
            return microsoftUserServiceClient.getUserJoinedTeams(upn);
        }
        return null;
    }

    private void patchPurviewUserEmail(List<Map<String, Object>> purviewUsers) {
        for (Map<String, Object> user : purviewUsers) {
            String upn;
            String email = this.getUserEmailFromUpn((String)user.get("email"));
            if (email != null) {
                user.put("email", email);
            }
            if ((upn = this.getUserUpnFromEmail((String)user.get("email"))) == null) continue;
            user.put("upn", upn);
        }
    }

    private String getUserUpnFromEmail(String email) {
        if (this.userEmailToUpnCache.isEmpty()) {
            this.populateCachedUserMap(this.userEmailToUpnCache, UserAccount::getEmail, UserAccount::getName);
        }
        return this.userEmailToUpnCache.get(email);
    }

    private String getUserEmailFromUpn(String upn) {
        if (this.userUpnToEmailCache.isEmpty()) {
            this.populateCachedUserMap(this.userUpnToEmailCache, UserAccount::getName, UserAccount::getEmail);
        }
        return this.userUpnToEmailCache.get(upn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGroupIdFromEmail(String email) {
        if (this.groupEmailToIdCache.isEmpty()) {
            Map<String, String> map = this.groupEmailToIdCache;
            synchronized (map) {
                Map unifiedGroups = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.UNIFIED_GROUP, this.userService.getId());
                for (MicrosoftUnifiedGroup unifiedGroup : unifiedGroups.values()) {
                    if (unifiedGroup.getEmail() == null || unifiedGroup.getId() == null) continue;
                    this.groupEmailToIdCache.put(unifiedGroup.getEmail(), unifiedGroup.getId());
                }
                this.schedulerApplication.getScheduledExecutorService().schedule(this.groupEmailToIdCache::clear, 60L, TimeUnit.SECONDS);
            }
        }
        return this.groupEmailToIdCache.get(email);
    }

    private Map<String, String> normalizeUserEmails(Collection<String> userEmails) {
        HashMap<String, String> normalizedUserEmails = new HashMap<String, String>();
        if (this.caseInsensitiveUserEmail.isEmpty()) {
            this.populateCachedUserMap(this.caseInsensitiveUserEmail, userAccount -> userAccount.getEmail() != null ? userAccount.getEmail().toLowerCase().trim() : null, UserAccount::getEmail);
        }
        Iterator<String> iterator = userEmails.iterator();
        while (iterator.hasNext()) {
            String userEmail;
            String email = userEmail = iterator.next();
            if (userEmail.startsWith(".")) {
                email = userEmail.substring(1);
            }
            if (!this.caseInsensitiveUserEmail.containsKey(email = email.toLowerCase().trim())) continue;
            Object normalizedUserEmail = this.caseInsensitiveUserEmail.get(email);
            if (userEmail.startsWith(".")) {
                normalizedUserEmail = "." + (String)normalizedUserEmail;
            }
            normalizedUserEmails.put(userEmail, (String)normalizedUserEmail);
        }
        return normalizedUserEmails;
    }

    private synchronized void populateCachedUserMap(Map<String, String> cachedMap, Function<UserAccount, String> keyGetter, Function<UserAccount, String> valueGetter) {
        for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getUsers().values()) {
            if (!this.userService.getId().equals(userAccount.getUserServiceId())) continue;
            String key = keyGetter.apply(userAccount);
            String value = valueGetter.apply(userAccount);
            if (key == null || value == null) continue;
            cachedMap.put(key, value);
        }
        this.schedulerApplication.getScheduledExecutorService().schedule(cachedMap::clear, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        return "Cases: " + this.getCases(true).size();
    }

    @Override
    public boolean refreshToken() throws IOException {
        this.refreshToken((UserCredential)this.userCredential);
        this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential(this.userCredential);
        this.logger.addLog(iu.getFormattedString(this.getTranslationKey("Log.RefreshedAccessToken"), new Object[0]));
        this.refreshDownloadUserToken();
        return true;
    }

    public void refreshDownloadUserToken() throws IOException {
        PurviewDownloadUserCredential downloadUserCredential = ((PurviewUserCredential)this.userCredential).getDownloadUserCredential();
        if (downloadUserCredential != null && this.getUsePurviewDownload()) {
            this.refreshToken((UserCredential)downloadUserCredential);
            this.schedulerApplication.getSchedulerConfigurationDao().updateThirdPartyUserCredential(this.userCredential);
            this.logger.addLog(iu.getFormattedString(this.getTranslationKey("Log.RefreshedDownloadAccessToken"), new Object[0]));
        }
    }

    public boolean getUsePurviewDownload() {
        return Boolean.TRUE.equals(((PurviewService)this.service).getUsePurviewDownload());
    }

    @Override
    public void calculateStatus(boolean reset) {
        super.calculateStatus(reset);
        if (this.getUsePurviewDownload() && (((PurviewUserCredential)this.userCredential).getDownloadUserCredential() == null || !((PurviewUserCredential)this.userCredential).getDownloadUserCredential().getSignedIn())) {
            this.logger.addInfo(iu.getString("PurviewServiceSession.Error.DownloadUserNotSignedIn"));
        }
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public PurviewServiceSession clone() {
        return new PurviewServiceSession(this);
    }

    @Override
    public String getLogKey() {
        return "logApiPurview";
    }

    public List<NonCustodialDataSource> getCaseNonCustodialDataSources(String caseId, boolean bypassCache) throws IOException {
        String nonCustodialDataSourcesKey = "nonCustodialDataSources:" + caseId;
        List<NonCustodialDataSource> nonCustodialDataSources = null;
        if (!bypassCache) {
            nonCustodialDataSources = (List<NonCustodialDataSource>)this.cachedObjects.get(nonCustodialDataSourcesKey);
        }
        if (nonCustodialDataSources == null) {
            String getNonCustodialDataSourcesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/noncustodialDataSources?$expand=dataSource";
            nonCustodialDataSources = this.callPagedGetApi(getNonCustodialDataSourcesUrl, new GenericType<ListValueResponse<NonCustodialDataSource>>(){}, true);
            this.cachedObjects.put(nonCustodialDataSourcesKey, nonCustodialDataSources);
        }
        return nonCustodialDataSources;
    }

    public List<DataSource> getCaseCustodianDataSources(String caseId, String custodianId, boolean bypassCache) throws IOException {
        String custodianDataSourcesKey = "custodianDataSources:" + caseId + ":" + custodianId;
        ArrayList<DataSource> custodianDataSources = null;
        if (!bypassCache) {
            custodianDataSources = (ArrayList<DataSource>)this.cachedObjects.get(custodianDataSourcesKey);
        }
        if (custodianDataSources == null) {
            custodianDataSources = new ArrayList<DataSource>();
            String getCustodianUserSourcesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/userSources";
            List<DataSource> userSources = this.callPagedGetApi(getCustodianUserSourcesUrl, new GenericType<ListValueResponse<DataSource>>(){}, true);
            for (DataSource userSource : userSources) {
                userSource.setSourceType(DataSourceType.USER);
            }
            custodianDataSources.addAll(userSources);
            String getCustodianUnifiedGroupSourcesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/unifiedGroupSources";
            List<DataSource> unifiedGroupSources = this.callPagedGetApi(getCustodianUnifiedGroupSourcesUrl, new GenericType<ListValueResponse<DataSource>>(){}, true);
            for (DataSource unifiedGroupSource : unifiedGroupSources) {
                unifiedGroupSource.setSourceType(DataSourceType.UNIFIED_GROUP);
            }
            custodianDataSources.addAll(unifiedGroupSources);
            String getCustodianSiteSourcesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/custodians/" + custodianId + "/siteSources";
            List<DataSource> siteSources = this.callPagedGetApi(getCustodianSiteSourcesUrl, new GenericType<ListValueResponse<DataSource>>(){}, true);
            for (DataSource siteSource : siteSources) {
                siteSource.setSourceType(DataSourceType.SITE);
            }
            custodianDataSources.addAll(siteSources);
            this.cachedObjects.put(custodianDataSourcesKey, custodianDataSources);
        }
        return custodianDataSources;
    }

    public List<Custodian> getCaseCustodians(String caseId, boolean bypassCache) throws IOException {
        String custodiansKey = "custodians:" + caseId;
        List<Custodian> custodians = null;
        if (!bypassCache) {
            custodians = (List<Custodian>)this.cachedObjects.get(custodiansKey);
        }
        if (custodians == null) {
            String getCustodiansUrl = "/security/cases/eDiscoveryCases/" + caseId + "/custodians";
            custodians = this.callPagedGetApi(getCustodiansUrl, new GenericType<ListValueResponse<Custodian>>(){});
            this.cachedObjects.put(custodiansKey, custodians);
        }
        return custodians;
    }

    public List<Group> getUnifiedGroups(boolean bypassCache) throws IOException {
        String unifiedGroupsKey = "unifiedGroups";
        List<Group> unifiedGroups = null;
        if (!bypassCache) {
            unifiedGroups = (List<Group>)this.cachedObjects.get(unifiedGroupsKey);
        }
        if (unifiedGroups == null) {
            String getUnifiedGroupsUrl = "/groups?$filter=" + URLEncoder.encode("groupTypes/any(c:c eq 'Unified')", StandardCharsets.UTF_8) + "&$select=" + URLEncoder.encode("id,displayName,description,createdDateTime,mail,webUrl,resourceProvisioningOptions", StandardCharsets.UTF_8);
            unifiedGroups = this.callPagedGetApi(getUnifiedGroupsUrl, new GenericType<ListValueResponse<Group>>(){});
            this.cachedObjects.put(unifiedGroupsKey, unifiedGroups);
        }
        return unifiedGroups;
    }

    public Map<String, Site> getSitesForUnifiedGroups(boolean bypassCache) throws IOException {
        String sitesForUnifiedGroupsKey = "sitesForUnifiedGroups";
        HashMap<String, Site> siteForUnifiedGroup = null;
        if (!bypassCache) {
            siteForUnifiedGroup = (HashMap<String, Site>)this.cachedObjects.get(sitesForUnifiedGroupsKey);
        }
        if (siteForUnifiedGroup == null) {
            List<Group> unifiedGroups = this.getUnifiedGroups(false);
            siteForUnifiedGroup = new HashMap<String, Site>();
            for (Group group : unifiedGroups) {
                String getUnifiedGroupSite = "/groups/" + group.getId() + "/sites/root?&$select=" + URLEncoder.encode("id,displayName,description,createdDateTime,webUrl,root", StandardCharsets.UTF_8);
                Site groupSite = (Site)this.callGetApi(getUnifiedGroupSite, new GenericType(Site.class));
                siteForUnifiedGroup.put(group.getId(), groupSite);
            }
            this.cachedObjects.put(sitesForUnifiedGroupsKey, siteForUnifiedGroup);
        }
        return siteForUnifiedGroup;
    }

    public Site getSiteForUnifiedGroup(String groupId) throws IOException {
        String getUnifiedGroupSite = "/groups/" + groupId + "/sites/root?&$select=" + URLEncoder.encode("id,displayName,description,createdDateTime,webUrl,root", StandardCharsets.UTF_8);
        return (Site)this.callGetApi(getUnifiedGroupSite, new GenericType(Site.class));
    }

    public List<Site> getSharePointSites(boolean bypassCache) throws IOException {
        String sitesKey = "sites";
        List<Site> sites = null;
        if (!bypassCache) {
            sites = (List<Site>)this.cachedObjects.get(sitesKey);
        }
        if (sites == null) {
            String getSitesUrl = this.userService.getGraphUrl() + "/v1.0/sites?search=" + URLEncoder.encode("*", StandardCharsets.UTF_8) + "&$select=" + URLEncoder.encode("id,webUrl", StandardCharsets.UTF_8);
            sites = this.callPagedGetApi(getSitesUrl, new GenericType<ListValueResponse<Site>>(){});
            this.cachedObjects.put(sitesKey, sites);
        }
        return sites;
    }

    public List<User> getUsers(boolean bypassCache) throws IOException {
        String usersKey = "users";
        List<User> users = null;
        if (!bypassCache) {
            users = (List<User>)this.cachedObjects.get(usersKey);
        }
        if (users == null) {
            Object getUsersUrl = "/users?";
            if (this.userService.getIncludeGuestUsers() != Boolean.TRUE) {
                getUsersUrl = (String)getUsersUrl + "&$filter=" + URLEncoder.encode("userType eq 'Member' and mail ge ' '", StandardCharsets.UTF_8);
            }
            getUsersUrl = (String)getUsersUrl + "&$select=" + URLEncoder.encode("id,userPrincipalName,mail,displayName,userType", StandardCharsets.UTF_8);
            users = this.callPagedGetApi((String)getUsersUrl, new GenericType<ListValueResponse<User>>(){});
            this.cachedObjects.put(usersKey, users);
        }
        return users;
    }

    public List<ExportOperation> getExportOperations(String caseId) throws IOException {
        String operationsKey = "exportOperations:" + caseId;
        ArrayList<ExportOperation> operations = (ArrayList<ExportOperation>)this.cachedObjects.get(operationsKey);
        if (operations == null) {
            String getOperationsUrl = "/security/cases/eDiscoveryCases/" + caseId + "/operations";
            List<CaseOperation> caseOperations = this.callPagedGetApi(getOperationsUrl, new GenericType<EDiscoveryListValueResponse<CaseOperation>>(){});
            operations = new ArrayList<ExportOperation>();
            block4: for (CaseOperation caseOperation : caseOperations) {
                Class<ReviewSetExportOperation> exportOperationClazz;
                if (caseOperation.getAction() == null) continue;
                switch (caseOperation.getAction()) {
                    case CONTENT_EXPORT: {
                        exportOperationClazz = ReviewSetExportOperation.class;
                        break;
                    }
                    case EXPORT_RESULT: {
                        exportOperationClazz = SearchExportOperation.class;
                        break;
                    }
                    default: {
                        continue block4;
                    }
                }
                operations.add((ExportOperation)this.getCaseOperation(caseId, caseOperation.getId(), exportOperationClazz));
            }
            this.cachedObjects.put(operationsKey, operations);
        }
        return operations;
    }

    public <T extends CaseOperation> T getCaseOperation(String caseId, String operationId, Class<T> operationClass) throws IOException {
        String getOperationUrl = "/security/cases/eDiscoveryCases/" + caseId + "/operations/" + operationId;
        return (T)((CaseOperation)this.callGetApi(getOperationUrl, new GenericType(operationClass)));
    }

    public List<EDiscoveryReviewSetQuery> getReviewSetQueries(String caseId, String reviewSetId, boolean bypassCache) throws IOException {
        String queriesKey = "reviewSetQueries:" + caseId + ":" + reviewSetId;
        List<EDiscoveryReviewSetQuery> queries = null;
        if (!bypassCache) {
            queries = (List<EDiscoveryReviewSetQuery>)this.cachedObjects.get(queriesKey);
        }
        if (queries == null) {
            String getQueriesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets/" + reviewSetId + "/queries";
            queries = this.callPagedGetApi(getQueriesUrl, new GenericType<EDiscoveryListValueResponse<EDiscoveryReviewSetQuery>>(){});
            this.cachedObjects.put(queriesKey, queries);
        }
        return queries;
    }

    public List<EDiscoveryReviewSet> getCaseReviewSets(String caseId, boolean bypassCache) throws IOException {
        String reviewSetsKey = "reviewSets:" + caseId;
        List<EDiscoveryReviewSet> reviewSets = null;
        if (!bypassCache) {
            reviewSets = (List<EDiscoveryReviewSet>)this.cachedObjects.get(reviewSetsKey);
        }
        if (reviewSets == null) {
            String getReviewSetsUrl = "/security/cases/eDiscoveryCases/" + caseId + "/reviewSets";
            reviewSets = this.callPagedGetApi(getReviewSetsUrl, new GenericType<EDiscoveryListValueResponse<EDiscoveryReviewSet>>(){});
            this.cachedObjects.put(reviewSetsKey, reviewSets);
        }
        return reviewSets;
    }

    public List<EDiscoverySearch> getSearches(String caseId, boolean bypassCache) throws IOException {
        String casesKey = "searches";
        List<EDiscoverySearch> searches = null;
        if (!bypassCache) {
            searches = (List<EDiscoverySearch>)this.cachedObjects.get(casesKey);
        }
        if (searches == null) {
            String getSearchesUrl = "/security/cases/eDiscoveryCases/" + caseId + "/searches";
            searches = this.callPagedGetApi(getSearchesUrl, new GenericType<EDiscoveryListValueResponse<EDiscoverySearch>>(){});
            this.cachedObjects.put(casesKey, searches);
        }
        return searches;
    }

    public List<EDiscoveryCase> getCases(boolean bypassCache) throws IOException {
        String casesKey = "cases";
        List<EDiscoveryCase> cases = null;
        if (!bypassCache) {
            cases = (List<EDiscoveryCase>)this.cachedObjects.get(casesKey);
        }
        if (cases == null) {
            String getCasesUrl = "/security/cases/eDiscoveryCases?$filter=" + URLEncoder.encode("status eq 'active'", StandardCharsets.UTF_8);
            cases = this.callPagedGetApi(getCasesUrl, new GenericType<EDiscoveryListValueResponse<EDiscoveryCase>>(){});
            this.cachedObjects.put(casesKey, cases);
        }
        return cases;
    }

    private <T extends MicrosoftGraphObject> List<T> callPagedGetApi(String url, GenericType<? extends ListValueResponse<T>> genericType) throws IOException {
        return this.callPagedGetApi(url, genericType, false);
    }

    private <T extends MicrosoftGraphObject> List<T> callPagedGetApi(String url, GenericType<? extends ListValueResponse<T>> genericType, boolean overwriteODataId) throws IOException {
        ArrayList result = new ArrayList();
        Object pagedUrl = url;
        if (!url.contains("?")) {
            pagedUrl = (String)pagedUrl + "?";
        }
        pagedUrl = (String)pagedUrl + "&$top=999";
        while (pagedUrl != null) {
            ListValueResponse<T> response = this.callGetApi((String)pagedUrl, genericType);
            result.addAll(response.getValue());
            if (overwriteODataId) {
                for (MicrosoftGraphObject obj : response.getValue()) {
                    obj.setODataId(PurviewUtils.cleanODataContextForSearch((String)response.getODataContext(), (String)obj.getId()));
                }
            }
            pagedUrl = response.getNextLink();
        }
        return result;
    }

    private List<Map<String, Object>> callGenericPagedGetApi(String url, String apiVersion, boolean overwriteODataId) throws IOException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Object pagedUrl = url;
        if (!url.contains("?")) {
            pagedUrl = (String)pagedUrl + "?";
        }
        pagedUrl = (String)pagedUrl + "&$top=999";
        while (pagedUrl != null) {
            Map<String, Object> response = this.callApi(url, "GET", Response.Status.OK.getStatusCode(), null, new GenericType<Map<String, Object>>(){}, apiVersion);
            List values = (List)response.get("value");
            if (values != null) {
                result.addAll(values);
                if (overwriteODataId) {
                    for (Map obj : values) {
                        obj.put("@odata.id", PurviewUtils.cleanODataContextForSearch((String)((String)response.get("@odata.context")), (String)((String)obj.get("id"))));
                    }
                }
            }
            pagedUrl = (String)response.get("@odata.nextLink");
        }
        return result;
    }

    private <ResponseType> ResponseType callGetApi(String url, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, "GET", Response.Status.OK.getStatusCode(), null, entityType);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, int expectedStatus, Entity<RequestType> body, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, method, expectedStatus, body, entityType, null);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, int expectedStatus, Entity<RequestType> body, GenericType<ResponseType> entityType, String apiVersion) throws IOException {
        try (Response response = this.callApiResponse(url, method, expectedStatus, body, apiVersion, false);){
            ResponseType ResponseType = this.readResponseEntity(this.objectMapper, response, entityType);
            return ResponseType;
        }
    }

    private <RequestType> Response callApiResponse(String url, String method, int expectedStatus, Entity<RequestType> body, String apiVersion, boolean proxyRequest) throws IOException {
        Object fullUrl;
        if (httpsPattern.matcher(url).find()) {
            fullUrl = url;
        } else {
            if (apiVersion == null) {
                apiVersion = this.version;
            }
            fullUrl = this.userService.getGraphUrl() + "/" + apiVersion + url;
        }
        return this.callApiResponse((String)fullUrl, method, body, expectedStatus, proxyRequest);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.PURVIEW_COLLECTIONS, false);
    }
}

