/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.licence.ThirdPartyProduct;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.ThirdPartyLicense;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.models.api.thirdparty.RelativityService;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.workflow.core.utils.relativity.RelativityClient;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class RelativityServiceSession
extends ThirdPartyServiceSession<RelativityService, RelativityUserCredential> {
    private RelativityClient relativityClient;

    public RelativityServiceSession(String userId, RelativityService relativityService, RelativityUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, relativityService, userCredential, schedulerApplication);
    }

    public RelativityServiceSession(RelativityServiceSession client) {
        super(client);
        this.relativityClient = null;
    }

    public RelativityClient getClient() {
        return this.relativityClient;
    }

    @Override
    public String getLogKey() {
        return "logApiRelativity";
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        return "Version: " + this.relativityClient.getVersion();
    }

    @Override
    public boolean refreshToken() {
        return false;
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.relativityClient = RelativityClient.getInstance((RelativityService)((RelativityService)this.service), (RelativityUserCredential)((RelativityUserCredential)this.userCredential), (String)this.getClientName(), (LogChannel)logChannel, whitelistedCertFingerprints);
    }

    @Override
    protected void closeSession() {
        if (this.relativityClient != null) {
            this.relativityClient.close();
        }
    }

    @Override
    public RelativityServiceSession clone() {
        return new RelativityServiceSession(this);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        try {
            if (this.relativityClient != null && this.relativityClient.getInstanceId() != null) {
                this.assertInstanceLicensed(this.relativityClient.getInstanceId());
            }
        }
        catch (IOException e) {
            throw new LicenseException((Throwable)e);
        }
    }

    private void assertInstanceLicensed(String relativityInstanceId) throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        if (licenseInfo.getThirdPartyLicenses() != null) {
            for (ThirdPartyLicense thirdPartyLicense : licenseInfo.getThirdPartyLicenses()) {
                if (!thirdPartyLicense.getThirdPartyProductType().equals((Object)ThirdPartyProduct.RELATIVITY_REVIEW)) continue;
                if (thirdPartyLicense.getId().equals("*")) {
                    return;
                }
                if (!thirdPartyLicense.getId().toLowerCase().contains(relativityInstanceId.toLowerCase())) continue;
                return;
            }
        }
        throw new LicenseException(iu.getFormattedString("ThirdPartySession.Error.ServiceNotLicensed", new Object[]{"Relativity", relativityInstanceId}));
    }
}

