/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.ImportedObjectsParseResult;
import com.nuix.automate.utils.models.api.thirdparty.VaultService;
import com.nuix.automate.utils.models.api.thirdparty.VaultUserCredential;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.userservice.GoogleChatSpace;
import com.nuix.automate.utils.models.api.userservice.GoogleDrive;
import com.nuix.automate.utils.models.api.userservice.GoogleGroup;
import com.nuix.automate.utils.models.api.userservice.GoogleOrgUnit;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.googleapi.ChatSpace;
import com.nuix.automate.utils.models.internal.googleapi.Drive;
import com.nuix.automate.utils.models.internal.googleapi.Group;
import com.nuix.automate.utils.models.internal.googleapi.GroupMember;
import com.nuix.automate.utils.models.internal.googleapi.GroupMemberType;
import com.nuix.automate.utils.models.internal.googleapi.OrgUnit;
import com.nuix.automate.utils.models.internal.googleapi.PagedResponse;
import com.nuix.automate.utils.models.internal.googleapi.User;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.vault.CorpusType;
import com.nuix.automate.utils.models.internal.vault.MatterState;
import com.nuix.automate.utils.models.internal.vault.VaultExport;
import com.nuix.automate.utils.models.internal.vault.VaultHold;
import com.nuix.automate.utils.models.internal.vault.VaultLocation;
import com.nuix.automate.utils.models.internal.vault.VaultMatter;
import com.nuix.automate.utils.models.internal.vault.VaultSavedQuery;
import com.nuix.automate.utils.models.internal.vault.VaultServiceObjectType;
import com.nuix.automate.utils.models.internal.vault.export.ExportStatus;
import com.nuix.automate.utils.models.internal.vault.hold.HeldLocation;
import com.nuix.automate.utils.models.internal.vault.query.SearchMethod;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class VaultServiceSession
extends OidcThirdPartyServiceSession<VaultService, VaultUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VaultServiceSession.class);
    private static final String VAULT_API_URL = "https://vault.googleapis.com";
    private static final String ADMIN_DIRECTORY_API_URL = "https://admin.googleapis.com/admin/directory/v1";
    private static final String CHAT_API_URL = "https://chat.googleapis.com/v1";
    private static final String DRIVE_API_URL = "https://www.googleapis.com/drive/v3";
    private final ObjectMapper objectMapper;
    private final Map<String, String> userEmailToIdCache = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> orgPathToUserIds = new ConcurrentHashMap<String, Set<String>>();

    public VaultServiceSession(String userId, VaultService vaultService, VaultUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, vaultService, userCredential, schedulerApplication);
        this.version = "v1";
        this.reattemptEnabled = true;
        this.maxAttempts = schedulerApplication.getConfiguration().getVaultServiceApiRequestMaxAttempts();
        this.initialDelayBetweenAttempts = 30;
        this.objectMapper = new ObjectMapperProvider().getContext(null);
    }

    public VaultServiceSession(VaultServiceSession session) {
        super(session);
        this.version = session.version;
        this.reattemptEnabled = session.reattemptEnabled;
        this.maxAttempts = session.maxAttempts;
        this.initialDelayBetweenAttempts = session.initialDelayBetweenAttempts;
        this.objectMapper = session.objectMapper;
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        switch (apiProxyRequest.getEndpoint()) {
            case "/domain": {
                return this.getUserDomain();
            }
            case "/allUserIds": {
                return this.getAllUserIds();
            }
            case "/userIdsFromEmails": {
                return this.getUserIdsFromEmails(new HashSet<String>((Collection)apiProxyRequest.getBody()));
            }
            case "/userIdsFromGroups": {
                return this.getUserIdsFromGroupEmails(new HashSet<String>((Collection)apiProxyRequest.getBody()));
            }
            case "/userIdsFromOrgUnits": {
                return this.getUserIdsFromOrgUnitIds(new HashSet<String>((Collection)apiProxyRequest.getBody()));
            }
            case "/cloudDownloadToken": {
                this.validateRequest();
                return ((VaultUserCredential)this.userCredential).getToken();
            }
        }
        Entity requestBody = apiProxyRequest.getBody() != null ? Entity.json((Object)apiProxyRequest.getBody()) : Entity.json(new HashMap());
        if (apiProxyRequest.getProxyResponse()) {
            return this.callApiResponse(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, apiProxyRequest.getApiVersion(), true);
        }
        if (apiProxyRequest.getPageRequests() && apiProxyRequest.getPagedValueKey() != null && !apiProxyRequest.getPagedValueKey().trim().isEmpty()) {
            return this.callGenericPagedGetApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getPagedValueKey());
        }
        return this.callApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, new GenericType<Object>(){}, apiProxyRequest.getApiVersion());
    }

    @Override
    public Object getObjects(String serviceObjectType, Map<String, Object> parameters) throws IOException {
        VaultServiceObjectType objectType = VaultServiceObjectType.valueOf((String)serviceObjectType);
        String matterId = (String)parameters.get("matterId");
        switch (objectType) {
            case MATTERS: {
                MatterState matterState = MatterState.valueOf((String)((String)parameters.get("matterState")));
                return this.getMatters(false, matterState);
            }
            case SAVED_QUERIES: {
                return this.getSavedQueries(matterId);
            }
            case EXPORTS: {
                return this.getExports(matterId).stream().filter(export -> export != null && (export.getStatus() == ExportStatus.IN_PROGRESS || export.getStatus() == ExportStatus.COMPLETED)).collect(Collectors.toList());
            }
            case ALL_HELD_LOCATIONS: {
                HashMap<String, HeldLocation.Item> heldLocations = new HashMap<String, HeldLocation.Item>();
                Map orgUnits = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_ORG_UNIT, this.userService.getId());
                for (VaultHold hold : this.getHolds(matterId)) {
                    for (HeldLocation location : hold.getHeldLocations()) {
                        GoogleOrgUnit orgUnit;
                        HeldLocation.Item item = null;
                        if (location.getType() == SearchMethod.ORG_UNIT && (orgUnit = (GoogleOrgUnit)orgUnits.get(location.getId())) != null) {
                            item = location.getItem(orgUnit);
                        }
                        if (item == null) {
                            item = location.getItem();
                        }
                        heldLocations.put(location.getId(), item);
                    }
                }
                return heldLocations.values();
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + String.valueOf(objectType));
    }

    @Override
    public ImportedObjectsParseResult<?> parseImportedObjects(String serviceObjectType, List<String[]> objectRows) {
        VaultServiceObjectType objectType = VaultServiceObjectType.valueOf((String)serviceObjectType);
        HashSet<String> userEmails = new HashSet<String>();
        for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getUsers(this.userService.getId())) {
            userEmails.add(userAccount.getEmail());
        }
        Map googleGroups = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_GROUP, this.userService.getId());
        HashMap<String, String> groupIdentifierToEmail = new HashMap<String, String>();
        for (GoogleGroup group : googleGroups.values()) {
            groupIdentifierToEmail.put(group.getId(), group.getEmail());
            groupIdentifierToEmail.put(group.getEmail(), group.getEmail());
        }
        Map orgUnits = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_ORG_UNIT, this.userService.getId());
        HashMap<String, String> orgUnitIdentifierToId = new HashMap<String, String>();
        for (GoogleOrgUnit orgUnit : orgUnits.values()) {
            orgUnitIdentifierToId.put(orgUnit.getId(), orgUnit.getId());
            orgUnitIdentifierToId.put(orgUnit.getName(), orgUnit.getId());
            orgUnitIdentifierToId.put(orgUnit.getPath(), orgUnit.getId());
        }
        Map sharedDrives = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_SHARED_DRIVE, this.userService.getId());
        HashMap<String, String> sharedDriveToId = new HashMap<String, String>();
        for (GoogleDrive sharedDrive : sharedDrives.values()) {
            sharedDriveToId.put(sharedDrive.getId(), sharedDrive.getId());
            sharedDriveToId.put(sharedDrive.getName(), sharedDrive.getId());
        }
        Map chatSpaces = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_CHAT_SPACE, this.userService.getId());
        HashMap<String, String> chatSpaceToId = new HashMap<String, String>();
        for (GoogleChatSpace chatSpace : chatSpaces.values()) {
            chatSpaceToId.put(chatSpace.getId(), chatSpace.getId());
            chatSpaceToId.put(chatSpace.getName(), chatSpace.getId());
            chatSpaceToId.put(chatSpace.getDisplayName(), chatSpace.getId());
        }
        switch (objectType) {
            case ALL_HELD_LOCATIONS: {
                ImportedObjectsParseResult locationsParseResult = new ImportedObjectsParseResult();
                for (int i = 1; i < objectRows.size(); ++i) {
                    try {
                        Object[] row = objectRows.get(i);
                        VaultLocation location = VaultLocation.build((Object[])row);
                        boolean invalid = false;
                        switch (location.getSearchMethod()) {
                            case ENTIRE_ORG: {
                                location.setValue(null);
                                break;
                            }
                            case ACCOUNT: {
                                if (location.getCorpusType() == CorpusType.GROUPS) {
                                    String groupEmail = (String)groupIdentifierToEmail.get(location.getValue());
                                    if (groupEmail != null) {
                                        location.setValue(groupEmail);
                                        break;
                                    }
                                    invalid = true;
                                    break;
                                }
                                invalid = !userEmails.contains(location.getValue());
                                break;
                            }
                            case ORG_UNIT: {
                                String orgUnitId = (String)orgUnitIdentifierToId.get(location.getValue());
                                if (orgUnitId != null) {
                                    location.setValue(orgUnitId);
                                    break;
                                }
                                invalid = true;
                                break;
                            }
                            case SITES_URL: {
                                break;
                            }
                            case SHARED_DRIVE: {
                                String sharedDriveId = (String)sharedDriveToId.get(location.getValue());
                                if (sharedDriveId != null) {
                                    location.setValue(sharedDriveId);
                                    break;
                                }
                                invalid = true;
                                break;
                            }
                            case ROOM: {
                                String chatSpaceId = (String)chatSpaceToId.get(location.getValue());
                                if (chatSpaceId != null) {
                                    location.setValue(chatSpaceId);
                                    break;
                                }
                                invalid = true;
                            }
                        }
                        if (!invalid) {
                            locationsParseResult.add((Object)location);
                            continue;
                        }
                        locationsParseResult.incrementInvalidCount();
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error parsing Vault location row " + i, (Throwable)e);
                        locationsParseResult.incrementInvalidCount();
                    }
                }
                return locationsParseResult;
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + String.valueOf(objectType));
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.GOOGLE_COLLECTIONS, false);
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        return "Matters: " + this.getMatters(true, MatterState.OPEN).size();
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public VaultServiceSession clone() {
        return new VaultServiceSession(this);
    }

    private Set<String> getAllUserIds() {
        this.populateUserEmailToIdCache();
        return new HashSet<String>(this.userEmailToIdCache.values());
    }

    private Set<String> getUserIdsFromEmails(Set<String> userEmails) {
        HashSet<String> userIds = new HashSet<String>();
        this.populateUserEmailToIdCache();
        for (String userEmail : userEmails) {
            userIds.add(this.userEmailToIdCache.get(userEmail));
        }
        return userIds;
    }

    private Set<String> getUserIdsFromGroupEmails(Set<String> groupEmails) throws IOException {
        HashSet<String> userIds = new HashSet<String>();
        this.populateUserEmailToIdCache();
        for (String groupEmail : groupEmails) {
            userIds.addAll(this.getUserIdsFromGroup(groupEmail));
        }
        return userIds;
    }

    private Set<String> getUserIdsFromGroup(String groupEmail) throws IOException {
        HashSet<String> userIds = new HashSet<String>();
        for (GroupMember member : this.getGroupMembers(groupEmail)) {
            if (member.getType() == GroupMemberType.GROUP) {
                userIds.addAll(this.getUserIdsFromGroup(member.getEmail()));
                continue;
            }
            userIds.add(this.userEmailToIdCache.get(member.getEmail()));
        }
        return userIds;
    }

    private Set<String> getUserIdsFromOrgUnitIds(Set<String> orgUnitIds) {
        HashSet<String> userIds = new HashSet<String>();
        this.populateOrgPathToUserIds();
        Map orgUnits = this.schedulerApplication.getUserServiceResource().getUserServiceObjects(UserServiceObjectType.GOOGLE_ORG_UNIT, this.userService.getId());
        for (GoogleOrgUnit orgUnit : orgUnits.values()) {
            if (!orgUnitIds.contains(orgUnit.getId()) || this.orgPathToUserIds.get(orgUnit.getPath()) == null) continue;
            userIds.addAll((Collection<String>)this.orgPathToUserIds.get(orgUnit.getPath()));
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateUserEmailToIdCache() {
        if (this.userEmailToIdCache.isEmpty()) {
            Map<String, String> map = this.userEmailToIdCache;
            synchronized (map) {
                for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getUsers().values()) {
                    if (userAccount.getUserAccountState() != UserAccountState.ACTIVE || !this.userService.getId().equals(userAccount.getUserServiceId()) || userAccount.getId() == null || userAccount.getEmail() == null) continue;
                    this.userEmailToIdCache.put(userAccount.getEmail(), userAccount.getId());
                }
                this.schedulerApplication.getScheduledExecutorService().schedule(this.userEmailToIdCache::clear, 60L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateOrgPathToUserIds() {
        if (this.orgPathToUserIds.isEmpty()) {
            Map<String, Set<String>> map = this.orgPathToUserIds;
            synchronized (map) {
                for (UserAccount userAccount : this.schedulerApplication.getUserServiceResource().getUsers().values()) {
                    String orgUnitPath;
                    if (userAccount.getUserAccountState() != UserAccountState.ACTIVE || !this.userService.getId().equals(userAccount.getUserServiceId()) || userAccount.getId() == null || userAccount.getAttributes() == null || (orgUnitPath = (String)userAccount.getAttributes().get("orgUnitPath")) == null) continue;
                    Set userIds = this.orgPathToUserIds.computeIfAbsent(orgUnitPath, k -> new HashSet());
                    userIds.add(userAccount.getId());
                }
                this.schedulerApplication.getScheduledExecutorService().schedule(this.orgPathToUserIds::clear, 60L, TimeUnit.SECONDS);
            }
        }
    }

    public List<GroupMember> getGroupMembers(String groupEmail) throws IOException {
        String groupUsersKey = "groupMembers:" + groupEmail;
        List members = (List)this.cachedObjects.get(groupUsersKey);
        if (members == null) {
            String endpoint = "https://admin.googleapis.com/admin/directory/v1/groups/" + groupEmail + "/members";
            members = this.callPagedGetApi(endpoint, new GenericType<GroupMember.PagedGroupMemberResponse>(){});
            this.cachedObjects.put(groupUsersKey, members);
        }
        return members;
    }

    public List<User> getUsers(boolean bypassCache) throws IOException {
        String usersKey = "users";
        List users = null;
        if (!bypassCache) {
            users = (List)this.cachedObjects.get(usersKey);
        }
        if (users == null) {
            String endpoint = "https://admin.googleapis.com/admin/directory/v1/users?customer=" + URLEncoder.encode("my_customer", StandardCharsets.UTF_8);
            users = this.callPagedGetApi(endpoint, new GenericType<User.PagedUserResponse>(){});
            this.cachedObjects.put(usersKey, users);
        }
        return users;
    }

    public List<Group> getGroups(boolean bypassCache) throws IOException {
        String groupsKey = "groups";
        List groups = null;
        if (!bypassCache) {
            groups = (List)this.cachedObjects.get(groupsKey);
        }
        if (groups == null) {
            String endpoint = "https://admin.googleapis.com/admin/directory/v1/groups?customer=" + URLEncoder.encode("my_customer", StandardCharsets.UTF_8);
            groups = this.callPagedGetApi(endpoint, new GenericType<Group.PagedGroupResponse>(){});
            this.cachedObjects.put(groupsKey, groups);
        }
        return groups;
    }

    public List<OrgUnit> getOrgUnits(boolean bypassCache) throws IOException {
        String orgUnitsKey = "orgUnits";
        List orgUnits = null;
        if (!bypassCache) {
            orgUnits = (List)this.cachedObjects.get(orgUnitsKey);
        }
        if (orgUnits == null) {
            String endpoint = "https://admin.googleapis.com/admin/directory/v1/customer/my_customer/orgunits?type=" + URLEncoder.encode("ALL_INCLUDING_PARENT", StandardCharsets.UTF_8);
            orgUnits = this.callPagedGetApi(endpoint, new GenericType<OrgUnit.PagedOrgUnitResponse>(){});
            this.cachedObjects.put(orgUnitsKey, orgUnits);
        }
        return orgUnits;
    }

    public List<ChatSpace> getChatSpaces(boolean bypassCache) throws IOException {
        String chatSpacesKey = "chatSpaces";
        List chatSpaces = null;
        if (!bypassCache) {
            chatSpaces = (List)this.cachedObjects.get(chatSpacesKey);
        }
        if (chatSpaces == null) {
            String endpoint = "https://chat.googleapis.com/v1/spaces?filter=" + URLEncoder.encode("spaceType=\"SPACE\"", StandardCharsets.UTF_8);
            chatSpaces = this.callPagedGetApi(endpoint, new GenericType<ChatSpace.PagedChatSpaceResponse>(){});
            this.cachedObjects.put(chatSpacesKey, chatSpaces);
        }
        return chatSpaces;
    }

    public List<Drive> getSharedDrives(boolean bypassCache) throws IOException {
        String drivesKey = "sharedDrives";
        List drives = null;
        if (!bypassCache) {
            drives = (List)this.cachedObjects.get(drivesKey);
        }
        if (drives == null) {
            String endpoint = "https://www.googleapis.com/drive/v3/drives";
            drives = this.callPagedGetApi(endpoint, new GenericType<Drive.PagedDriveResponse>(){});
            this.cachedObjects.put(drivesKey, drives);
        }
        return drives;
    }

    public List<VaultMatter> getMatters(boolean bypassCache, MatterState state) throws IOException {
        String mattersKey = "matters" + String.valueOf(state);
        List matters = null;
        if (!bypassCache) {
            matters = (List)this.cachedObjects.get(mattersKey);
        }
        if (matters == null) {
            Object getMattersUrl = "/matters";
            if (state != null) {
                getMattersUrl = (String)getMattersUrl + "?&state=" + URLEncoder.encode(state.name(), StandardCharsets.UTF_8);
            }
            matters = this.callPagedGetApi((String)getMattersUrl, new GenericType<VaultMatter.PagedVaultMatterResponse>(){});
            this.cachedObjects.put(mattersKey, matters);
        }
        return matters;
    }

    public List<VaultSavedQuery> getSavedQueries(String matterId) throws IOException {
        String savedQueriesKey = "savedQueries" + matterId;
        List savedQueries = (List)this.cachedObjects.get(savedQueriesKey);
        if (savedQueries == null) {
            String savedQueriesUrl = "/matters/" + matterId + "/savedQueries";
            savedQueries = this.callPagedGetApi(savedQueriesUrl, new GenericType<VaultSavedQuery.PagedVaultSavedQueryResponse>(){});
            this.cachedObjects.put(savedQueriesKey, savedQueries);
        }
        return savedQueries;
    }

    public List<VaultExport> getExports(String matterId) throws IOException {
        String exportsKey = "exports" + matterId;
        List exports = (List)this.cachedObjects.get(exportsKey);
        if (exports == null) {
            String exportsUrl = "/matters/" + matterId + "/exports";
            exports = this.callPagedGetApi(exportsUrl, new GenericType<VaultExport.PagedVaultExportResponse>(){});
            this.cachedObjects.put(exportsKey, exports);
        }
        return exports;
    }

    public List<VaultHold> getHolds(String matterId) throws IOException {
        String holdsKey = "holds" + matterId;
        List holds = (List)this.cachedObjects.get(holdsKey);
        if (holds == null) {
            String holdsUrl = "/matters/" + matterId + "/holds";
            holds = this.callPagedGetApi(holdsUrl, new GenericType<VaultHold.PagedVaultHoldResponse>(){});
            this.cachedObjects.put(holdsKey, holds);
        }
        return holds;
    }

    private <T> List<T> callPagedGetApi(String url, GenericType<? extends PagedResponse<T>> genericType) throws IOException {
        PagedResponse<T> pagedResponse;
        ArrayList result = new ArrayList();
        if (!((String)url).contains("?")) {
            url = (String)url + "?";
        }
        url = (String)url + "&pageSize=100";
        String pageToken = null;
        do {
            List value;
            Object pagedUrl = url;
            if (pageToken != null) {
                pagedUrl = (String)pagedUrl + "&pageToken=" + URLEncoder.encode(pageToken, StandardCharsets.UTF_8);
            }
            if ((value = (pagedResponse = this.callGetApi((String)pagedUrl, genericType)).getValue()) == null) continue;
            result.addAll(value);
        } while ((pageToken = pagedResponse.getNextPageToken()) != null && !pageToken.isBlank());
        return result;
    }

    private List<Map<String, Object>> callGenericPagedGetApi(String url, String pagedValueKey) throws IOException {
        Map<String, Object> pagedResponse;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (!((String)url).contains("?")) {
            url = (String)url + "?";
        }
        url = (String)url + "&pageSize=100";
        String pageToken = null;
        do {
            List values;
            Object pagedUrl = url;
            if (pageToken != null) {
                pagedUrl = (String)pagedUrl + "&pageToken=" + URLEncoder.encode(pageToken, StandardCharsets.UTF_8);
            }
            if ((values = (List)(pagedResponse = this.callGetApi((String)pagedUrl, new GenericType<Map<String, Object>>(){})).get(pagedValueKey)) == null) continue;
            result.addAll(values);
        } while ((pageToken = (String)pagedResponse.get("nextPageToken")) != null && !pageToken.isBlank());
        return result;
    }

    private <ResponseType> ResponseType callGetApi(String url, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, "GET", null, entityType);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, method, body, entityType, null);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType, String apiVersion) throws IOException {
        try (Response response = this.callApiResponse(url, method, body, apiVersion, false);){
            ResponseType ResponseType = this.readResponseEntity(this.objectMapper, response, entityType);
            return ResponseType;
        }
    }

    private <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, String apiVersion, boolean proxyRequest) throws IOException {
        Object fullUrl;
        if (httpsPattern.matcher(url).find()) {
            fullUrl = url;
        } else {
            if (apiVersion == null) {
                apiVersion = this.version;
            }
            fullUrl = "https://vault.googleapis.com/" + apiVersion + url;
        }
        return this.callApiResponse((String)fullUrl, method, body, proxyRequest);
    }

    @Override
    protected boolean reattemptResponse(Response response, String responseString) {
        if (response.getStatus() == 429) {
            String errorMessage = this.parseErrorResponse(response, responseString);
            String requestHigherQuotaLink = this.parseRequestHigherQuotaLinkText(responseString);
            this.logger.addWarning(iu.getFormattedString("VaultServiceSession.Log.ReachedUsageLimit", new Object[]{errorMessage, requestHigherQuotaLink}));
            ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICE, ((VaultUserCredential)this.userCredential).getThirdPartyServiceId());
            ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES);
            return true;
        }
        return super.reattemptResponse(response, responseString);
    }

    private String parseRequestHigherQuotaLinkText(String errorResponseString) {
        try {
            Object errorDetails;
            Map endServiceResponseMap = (Map)SerializationUtils.fromJson((String)errorResponseString, Map.class);
            Object endServiceResponseError = endServiceResponseMap.get("error");
            if (endServiceResponseError instanceof Map && (errorDetails = ((Map)endServiceResponseError).get("details")) instanceof List) {
                for (Object entry : (List)errorDetails) {
                    Map entryMap;
                    String entryType;
                    if (!(entry instanceof Map) || (entryType = (String)(entryMap = (Map)entry).get("@type")) == null || !entryType.toLowerCase().contains("help")) continue;
                    return VaultServiceSession.getRequestHigherQuotaLinkText(entryMap.get("links"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse " + ((VaultService)this.service).getPrintableServiceType() + " request higher quota link", (Throwable)e);
        }
        return null;
    }

    private static String getRequestHigherQuotaLinkText(Object links) {
        if (links instanceof List) {
            for (Object linkDetails : (List)links) {
                Map linkDetailsMap;
                String description;
                if (!(linkDetails instanceof Map) || (description = (String)(linkDetailsMap = (Map)linkDetails).get("description")) != null && !description.toLowerCase().contains("quota")) continue;
                String requestHigherQuotaLink = (String)linkDetailsMap.get("url");
                if (description != null) {
                    if (description.endsWith(".")) {
                        return description.substring(0, description.length() - 1) + ", " + requestHigherQuotaLink;
                    }
                    return description + ", " + requestHigherQuotaLink;
                }
                return requestHigherQuotaLink;
            }
        }
        return null;
    }

    private String getUserDomain() {
        if (this.getSignedIn()) {
            String domainName = ((VaultUserCredential)this.userCredential).getUsername();
            if (domainName.contains("@")) {
                domainName = domainName.split("@")[1];
            }
            return domainName;
        }
        return null;
    }
}

