/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneService;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneUserCredential;
import com.nuix.automate.utils.models.internal.job.JobFilePayload;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.veritone.EngineDetail;
import com.nuix.automate.utils.models.internal.veritone.EngineState;
import com.nuix.automate.utils.models.internal.veritone.OrganizationDetail;
import com.nuix.automate.utils.models.internal.veritone.VeritoneEngine;
import com.nuix.automate.utils.models.internal.veritone.response.BaseVeritoneResponse;
import com.nuix.automate.workflow.core.utils.general.ObjectMapperProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class VeritoneServiceSession
extends ThirdPartyServiceSession<VeritoneService, VeritoneUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(VeritoneServiceSession.class);
    private final ObjectMapper objectMapper;

    public VeritoneServiceSession(String userId, VeritoneService service, VeritoneUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, service, userCredential, schedulerApplication);
        this.version = "v1";
        this.reattemptEnabled = true;
        this.initialDelayBetweenAttempts = 30;
        this.objectMapper = new ObjectMapperProvider().getContext(null);
    }

    public VeritoneServiceSession(VeritoneServiceSession session) {
        super(session);
        this.version = session.version;
        this.reattemptEnabled = session.reattemptEnabled;
        this.initialDelayBetweenAttempts = session.initialDelayBetweenAttempts;
        this.objectMapper = session.objectMapper;
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.VERITONE, false);
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        List<OrganizationDetail> organizations = this.getOrganizations();
        HashMap<String, EngineDetail> veritoneEngines = new HashMap<String, EngineDetail>();
        for (EngineDetail engine : this.getEngines()) {
            if (engine.getEngineID() == null) continue;
            veritoneEngines.put(engine.getEngineID(), engine);
        }
        ArrayList<VeritoneEngine> definedEngines = new ArrayList<VeritoneEngine>();
        if (((VeritoneService)this.service).getOwEngine() != null) {
            definedEngines.add(((VeritoneService)this.service).getOwEngine());
        }
        if (((VeritoneService)this.service).getTranslationEngines() != null) {
            definedEngines.addAll(((VeritoneService)this.service).getTranslationEngines());
        }
        if (((VeritoneService)this.service).getTranscriptionEngines() != null) {
            definedEngines.addAll(((VeritoneService)this.service).getTranscriptionEngines());
        }
        for (VeritoneEngine veritoneEngine : definedEngines) {
            veritoneEngine.reset();
            EngineDetail correspondingEngine = (EngineDetail)veritoneEngines.get(veritoneEngine.getId());
            String warningMessage = null;
            if (correspondingEngine == null) {
                warningMessage = iu.getFormattedString("VeritoneServiceSession.Warning.CouldNotFindEngine", (Object)veritoneEngine.getId());
            } else if (correspondingEngine.getEngineState() != EngineState.ACTIVE) {
                warningMessage = iu.getFormattedString("VeritoneServiceSession.Warning.EngineNotActive", (Object)veritoneEngine.getId());
            } else {
                veritoneEngine.setName(correspondingEngine.getEngineName());
            }
            if (warningMessage == null) continue;
            veritoneEngine.getStatus().setWarningMessage(warningMessage);
        }
        return "Organizations: " + organizations.size();
    }

    @Override
    public void calculateStatus(boolean reset) {
        super.calculateStatus(reset);
        if (this.getSignedIn()) {
            ArrayList<VeritoneEngine> veritoneEngines = new ArrayList<VeritoneEngine>();
            ArrayList<String> engineWarnings = new ArrayList<String>();
            if (((VeritoneService)this.service).getOwEngine() == null) {
                engineWarnings.add(iu.getString("VeritoneServiceSession.Warning.OwEngineNotDefined"));
            } else if (((VeritoneService)this.service).getOwEngine().getStatus().getCode() == State.WARNING) {
                engineWarnings.add(((VeritoneService)this.service).getOwEngine().getStatus().getMessage());
                veritoneEngines.add(((VeritoneService)this.service).getOwEngine());
            }
            if (((VeritoneService)this.service).getTranslationEngines() == null || ((VeritoneService)this.service).getTranslationEngines().isEmpty()) {
                engineWarnings.add(iu.getString("VeritoneServiceSession.Warning.TranslationEnginesNotDefined"));
            } else {
                veritoneEngines.addAll(((VeritoneService)this.service).getTranslationEngines());
            }
            if (((VeritoneService)this.service).getTranscriptionEngines() == null || ((VeritoneService)this.service).getTranscriptionEngines().isEmpty()) {
                engineWarnings.add(iu.getString("VeritoneServiceSession.Warning.TranscriptionEnginesNotDefined"));
            } else {
                veritoneEngines.addAll(((VeritoneService)this.service).getTranscriptionEngines());
            }
            HashSet<String> engineKeys = new HashSet<String>();
            HashSet<String> seenEngineIds = new HashSet<String>();
            HashSet<String> duplicateEngineIds = new HashSet<String>();
            for (VeritoneEngine veritoneEngine : veritoneEngines) {
                String engineKey = veritoneEngine.getKey();
                if (!engineKeys.add(engineKey)) {
                    engineWarnings.add(iu.getFormattedString("VeritoneServiceSession.Warning.DetectedDuplicateEngineMapping", new Object[]{engineKey, veritoneEngine.getId()}));
                }
                if (seenEngineIds.add(veritoneEngine.getId())) continue;
                duplicateEngineIds.add(veritoneEngine.getId());
            }
            if (!duplicateEngineIds.isEmpty()) {
                engineWarnings.add(iu.getFormattedString("VeritoneServiceSession.Warning.DetectedDuplicateEngineIds", (Object)String.join((CharSequence)", ", duplicateEngineIds)));
            }
            if (!engineWarnings.isEmpty()) {
                this.logger.addWarning(String.join((CharSequence)"\n", engineWarnings));
            }
        }
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    protected boolean reattemptResponse(Response response, String responseString) {
        return false;
    }

    @Override
    public VeritoneServiceSession clone() {
        return new VeritoneServiceSession(this);
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws Exception {
        if (apiProxyRequest.getEndpoint().equals("/fileDownloadEndpoint")) {
            return this.schedulerApplication.getJobResource().getFileDownloadEndpoint((JobFilePayload)this.objectMapper.convertValue(apiProxyRequest.getBody(), JobFilePayload.class));
        }
        Entity requestBody = apiProxyRequest.getBody() != null ? Entity.json((Object)apiProxyRequest.getBody()) : Entity.json(new HashMap());
        if (apiProxyRequest.getProxyResponse()) {
            return this.callApiResponse(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, apiProxyRequest.getApiVersion(), true);
        }
        return this.callApi(apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, new GenericType<Object>(){}, apiProxyRequest.getApiVersion());
    }

    public List<EngineDetail> getEngines() throws IOException {
        String endpoint = "/admin/engines";
        BaseVeritoneResponse.BaseVeritoneListResponse<EngineDetail> response = this.callGetApi(endpoint, new GenericType<BaseVeritoneResponse.BaseVeritoneListResponse<EngineDetail>>(){});
        return (List)response.getResult();
    }

    public List<OrganizationDetail> getOrganizations() throws IOException {
        String endpoint = "/admin/organizations";
        BaseVeritoneResponse.BaseVeritoneListResponse<OrganizationDetail> response = this.callGetApi(endpoint, new GenericType<BaseVeritoneResponse.BaseVeritoneListResponse<OrganizationDetail>>(){});
        return (List)response.getResult();
    }

    private <ResponseType> ResponseType callGetApi(String url, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, "GET", null, entityType);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType) throws IOException {
        return this.callApi(url, method, body, entityType, null);
    }

    private <RequestType, ResponseType> ResponseType callApi(String url, String method, Entity<RequestType> body, GenericType<ResponseType> entityType, String apiVersion) throws IOException {
        try (Response response = this.callApiResponse(url, method, body, apiVersion, false);){
            ResponseType ResponseType = this.readResponseEntity(this.objectMapper, response, entityType);
            return ResponseType;
        }
    }

    private <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, String apiVersion, boolean proxyRequest) throws IOException {
        Object fullUrl;
        if (httpsPattern.matcher(url).find()) {
            fullUrl = url;
        } else {
            if (apiVersion == null) {
                apiVersion = this.version;
            }
            fullUrl = ((VeritoneService)this.service).getUrl() + "/edge/" + apiVersion + url;
        }
        return this.callApiResponse((String)fullUrl, method, body, proxyRequest);
    }
}

