/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.ums;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.basic.BasicAuthUser;
import com.nuix.automate.scheduler.security.internal.Credential;
import com.nuix.automate.scheduler.security.internal.InternalBearerUser;
import com.nuix.automate.scheduler.security.ldap.LdapBearerUser;
import com.nuix.automate.scheduler.security.ldap.LdapClient;
import com.nuix.automate.scheduler.security.ums.PasswordBasicAuthUser;
import com.nuix.automate.scheduler.security.ums.UmsUtil;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.basic.BasicCredentials;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class PasswordBasicAuthenticator
implements Authenticator<BasicCredentials, BasicAuthUser> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PasswordBasicAuthenticator.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public PasswordBasicAuthenticator(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
    }

    public Optional<BasicAuthUser> authenticate(BasicCredentials basicCredentials) throws AuthenticationException {
        return this.authenticate(basicCredentials, null);
    }

    public Optional<BasicAuthUser> authenticate(BasicCredentials basicCredentials, String requestUrl) throws AuthenticationException {
        LOGGER.info("Authenticating user " + basicCredentials.getUsername() + " using Basic auth");
        PasswordAuthenticationSubmission passwordAuthenticationSubmission = new PasswordAuthenticationSubmission();
        try {
            if (BuiltInPrincipalIdentifiers.valueOf((String)basicCredentials.getUsername()) != null) {
                throw new AuthenticationException(this.iu.getString("UmsBasicAuthenticator.InvalidUsername"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (BuiltInPrincipalIdentifiers.fromString((String)basicCredentials.getUsername()) != null) {
            throw new AuthenticationException(this.iu.getString("UmsBasicAuthenticator.InvalidUsername"));
        }
        passwordAuthenticationSubmission.setUsername(basicCredentials.getUsername());
        passwordAuthenticationSubmission.setPassword(basicCredentials.getPassword());
        BasicAuthUser basicAuthUser = null;
        String username = basicCredentials.getUsername();
        int indexOfSeparator = username.lastIndexOf("#");
        if (indexOfSeparator > 0) {
            passwordAuthenticationSubmission.setUsername(username.substring(0, indexOfSeparator));
            passwordAuthenticationSubmission.setScope(username.substring(indexOfSeparator + 1));
        } else {
            ArrayList<String> scopes = new ArrayList<String>();
            Map<String, String> authMethods = this.schedulerApplication.getAuthMethodsResource().getAuthMethods();
            for (String authScope : authMethods.keySet()) {
                String type = authMethods.get(authScope);
                if (!type.equals(AuthMethodType.USERNAME_PASSWORD.toString())) continue;
                scopes.add(authScope);
            }
            if (scopes.size() == 1) {
                passwordAuthenticationSubmission.setScope((String)scopes.get(0));
            } else {
                LOGGER.error("Attempting to log in with username " + passwordAuthenticationSubmission.getUsername() + " with no scope, but there are several  username/password services available: " + String.join((CharSequence)", ", scopes) + ". Specify the scope to authenticate to, for example: " + passwordAuthenticationSubmission.getUsername() + "#" + (String)scopes.get(0));
                throw new AuthenticationException(this.iu.getString("UmsBasicAuthenticator.InvalidUsername"));
            }
        }
        LOGGER.info("Authenticating user " + passwordAuthenticationSubmission.getUsername() + " using " + passwordAuthenticationSubmission.getScope());
        if (basicAuthUser == null && (basicAuthUser = this.authenticateInternal(passwordAuthenticationSubmission)) != null) {
            LOGGER.info("Authenticated user " + basicCredentials.getUsername() + " using Internal");
        }
        if (basicAuthUser == null && (basicAuthUser = this.authenticateWithUms(passwordAuthenticationSubmission, requestUrl)) != null) {
            LOGGER.info("Authenticated user " + basicCredentials.getUsername() + " using UMS");
        }
        if (basicAuthUser == null && (basicAuthUser = this.authenticateWithLdap(passwordAuthenticationSubmission, requestUrl)) != null) {
            LOGGER.info("Authenticated user " + basicCredentials.getUsername() + " using LDAP");
        }
        if (basicAuthUser != null) {
            return Optional.of(basicAuthUser);
        }
        return Optional.empty();
    }

    private BasicAuthUser authenticateWithUms(PasswordAuthenticationSubmission passwordAuthenticationSubmission, String requestUrl) {
        try {
            UmsUtil client = this.schedulerApplication.getUserServiceResource().getUmsClientForScope(passwordAuthenticationSubmission.getScope(), requestUrl);
            if (client != null) {
                BearerUser bearerUser = client.authenticateUser(passwordAuthenticationSubmission);
                PasswordBasicAuthUser basicAuthUser = new PasswordBasicAuthUser(bearerUser);
                bearerUser.invalidate();
                return basicAuthUser;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private BasicAuthUser authenticateInternal(PasswordAuthenticationSubmission passwordAuthenticationSubmission) {
        if (this.schedulerConfiguration.getInternalCredentials() != null && this.schedulerConfiguration.getInternalCredentials().getDisplayName().equals(passwordAuthenticationSubmission.getScope())) {
            for (Credential credential : this.schedulerConfiguration.getInternalCredentials().getCredentials()) {
                if (!credential.getUsername().equalsIgnoreCase(passwordAuthenticationSubmission.getUsername()) || !credential.checkPassword(passwordAuthenticationSubmission.getPassword())) continue;
                InternalBearerUser bearerUser = new InternalBearerUser(credential.getUsername(), credential.getId());
                PasswordBasicAuthUser basicAuthUser = new PasswordBasicAuthUser(bearerUser);
                return basicAuthUser;
            }
        }
        return null;
    }

    private BasicAuthUser authenticateWithLdap(PasswordAuthenticationSubmission passwordAuthenticationSubmission, String requestUrl) {
        try {
            LdapClient client = this.schedulerApplication.getUserServiceResource().getLdapClientForScope(passwordAuthenticationSubmission.getScope(), requestUrl);
            if (client != null) {
                LdapBearerUser bearerUser = client.authenticateUser(passwordAuthenticationSubmission);
                PasswordBasicAuthUser basicAuthUser = new PasswordBasicAuthUser(bearerUser);
                bearerUser.invalidate();
                return basicAuthUser;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

