/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.ums;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.security.ums.UmsGroup;
import com.nuix.automate.scheduler.security.ums.UmsPrivilege;
import com.nuix.automate.scheduler.security.ums.UmsRole;
import com.nuix.automate.scheduler.security.ums.UmsUser;
import com.nuix.automate.scheduler.security.ums.UmsUtil;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.Set;

public class UmsBearerUser
extends BearerUser
implements UserServiceUser {
    private UmsUser umsUser;
    private final UmsUtil nuixUmsUtils;
    private final UmsUserService umsUserService;

    public UmsBearerUser(UmsUser umsUser, UmsUtil nuixUmsUtils, UmsUserService umsUserService) {
        super(new Identifier(IdentifierType.UMS_USERNAME, umsUser.getName()));
        this.setId(umsUser.getName());
        this.umsUser = umsUser;
        this.nuixUmsUtils = nuixUmsUtils;
        this.umsUserService = umsUserService;
    }

    public Set<Identifier> getIdentifiers() {
        if (!this.umsUserService.getEnabled().booleanValue()) {
            return new HashSet<Identifier>();
        }
        HashSet<Identifier> identifiers = new HashSet<Identifier>(super.getIdentifiers());
        identifiers.add(new Identifier(IdentifierType.UMS_USERNAME, this.umsUser.getName()));
        for (UmsRole umsRole : this.umsUser.getRoles()) {
            identifiers.add(new Identifier(IdentifierType.UMS_ROLE, umsRole.getName()));
        }
        for (UmsGroup umsGroup : this.umsUser.getGroups()) {
            identifiers.add(new Identifier(IdentifierType.UMS_GROUP, umsGroup.getName()));
            for (UmsPrivilege umsPrivilege : umsGroup.getPrivileges()) {
                identifiers.add(new Identifier(IdentifierType.UMS_PRIVILEGE, umsPrivilege.getName()));
            }
        }
        return identifiers;
    }

    public UmsUser getUmsUser() {
        return this.umsUser;
    }

    public void setUmsUser(UmsUser umsUser) {
        this.umsUser = umsUser;
        this.getIdentifiers();
    }

    public void invalidate() {
        this.nuixUmsUtils.invalidateUserSession(this.umsUser);
    }

    public boolean refresh() {
        return this.nuixUmsUtils.validateUserSession(this);
    }

    public String getUserServiceId() {
        if (this.umsUserService != null) {
            return this.umsUserService.getId();
        }
        return null;
    }
}

