/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.concatenation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestHandler;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.concatenation.ConcatenationHeadRequestHandler;
import com.nuix.automate.scheduler.tus.concatenation.ConcatenationOptionsRequestHandler;
import com.nuix.automate.scheduler.tus.concatenation.ConcatenationPostRequestHandler;
import com.nuix.automate.scheduler.tus.concatenation.validation.NoUploadLengthOnFinalValidator;
import com.nuix.automate.scheduler.tus.concatenation.validation.PartialUploadsExistValidator;
import com.nuix.automate.scheduler.tus.concatenation.validation.PatchFinalUploadValidator;
import com.nuix.automate.scheduler.tus.utils.AbstractTusExtension;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ConcatenationExtension
extends AbstractTusExtension {
    @Override
    public String getName() {
        return "concatenation";
    }

    @Override
    public Collection<HttpMethod> getMinimalSupportedHttpMethods() {
        return Arrays.asList(HttpMethod.OPTIONS, HttpMethod.POST, HttpMethod.PATCH, HttpMethod.HEAD);
    }

    @Override
    protected void initValidators(List<RequestValidator> requestValidators) {
        requestValidators.add(new PatchFinalUploadValidator());
        requestValidators.add(new NoUploadLengthOnFinalValidator());
        requestValidators.add(new PartialUploadsExistValidator());
    }

    @Override
    protected void initRequestHandlers(List<RequestHandler> requestHandlers) {
        requestHandlers.add(new ConcatenationOptionsRequestHandler());
        requestHandlers.add(new ConcatenationPostRequestHandler());
        requestHandlers.add(new ConcatenationHeadRequestHandler());
    }
}

