/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.concatenation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.UploadType;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import java.io.IOException;
import java.util.Objects;

public class ConcatenationHeadRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.HEAD.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (!UploadType.REGULAR.equals((Object)uploadInfo.getUploadType())) {
            servletResponse.setHeader("Upload-Concat", uploadInfo.getUploadConcatHeaderValue());
        }
        if (UploadType.CONCATENATED.equals((Object)uploadInfo.getUploadType())) {
            if (uploadInfo.isUploadInProgress()) {
                uploadStorageService.getUploadConcatenationService().merge(uploadInfo);
            }
            if (uploadInfo.hasLength()) {
                servletResponse.setHeader("Upload-Length", Objects.toString(uploadInfo.getLength()));
            }
            if (!uploadInfo.isUploadInProgress()) {
                servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
            }
        }
    }
}

