/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.concatenation.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadLengthNotAllowedOnConcatenationException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class NoUploadLengthOnFinalValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadConcatValue = request.getHeader("Upload-Concat");
        if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final") && StringUtils.isNotBlank((CharSequence)request.getHeader("Upload-Length"))) {
            throw new UploadLengthNotAllowedOnConcatenationException("The upload length of a concatenated upload cannot be set");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

