/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.concatenation.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.InvalidPartialUploadIdException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class PartialUploadsExistValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadConcatValue = request.getHeader("Upload-Concat");
        if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final")) {
            for (String uploadUri : Utils.parseConcatenationIDsFromHeader(uploadConcatValue)) {
                UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
                if (uploadInfo != null) continue;
                throw new InvalidPartialUploadIdException("The URI " + uploadUri + " in Upload-Concat header does not match an existing upload");
            }
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

