/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.InvalidContentTypeException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import javax.servlet.http.HttpServletRequest;

public class ContentTypeValidator
implements RequestValidator {
    static final String APPLICATION_OFFSET_OCTET_STREAM = "application/offset+octet-stream";

    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        String contentType = Utils.getHeader(request, "Content-Type");
        if (!APPLICATION_OFFSET_OCTET_STREAM.equals(contentType)) {
            throw new InvalidContentTypeException("The Content-Type header must contain value application/offset+octet-stream");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

