/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.InvalidTusResumableException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class TusResumableValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        String requestVersion = Utils.getHeader(request, "Tus-Resumable");
        if (!StringUtils.equals((CharSequence)requestVersion, (CharSequence)"1.0.0")) {
            throw new InvalidTusResumableException("This server does not support tus protocol version " + requestVersion);
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return !HttpMethod.OPTIONS.equals((Object)method) && !HttpMethod.GET.equals((Object)method);
    }
}

