/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadOffsetMismatchException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class UploadOffsetValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String expectedOffset;
        String uploadOffset = Utils.getHeader(request, "Upload-Offset");
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(request.getRequestURI(), ownerKey);
        if (uploadInfo != null && !StringUtils.equals((CharSequence)(expectedOffset = Objects.toString(uploadInfo.getOffset())), (CharSequence)uploadOffset)) {
            throw new UploadOffsetMismatchException("The Upload-Offset was " + StringUtils.trimToNull((String)uploadOffset) + " but expected " + expectedOffset);
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

