/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.creation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class CreationPostRequestHandler
extends AbstractRequestHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CreationPostRequestHandler.class);
    private final Pattern datasetIdPattern = Pattern.compile("dataset/([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})/");

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, UploadLocationNotFoundException {
        String uploadURI;
        UploadInfo info = this.buildUploadInfo((HttpServletRequest)servletRequest);
        info = uploadStorageService.create(info, ownerKey);
        String url = uploadURI + (StringUtils.endsWith((CharSequence)(uploadURI = ResourceUtils.getProxiedAbsoluteUri((String)servletRequest.getRequestURI(), (HttpServletRequest)servletRequest)), (CharSequence)"/") ? "" : "/") + String.valueOf(info.getId());
        servletResponse.setHeader("Location", url);
        servletResponse.setStatus(201);
        LOGGER.info("Created upload with ID " + String.valueOf(info.getId()) + " at " + info.getCreationTimestamp() + " for ip address " + info.getClientIpAddresses() + " with location " + url);
    }

    private UploadInfo buildUploadInfo(HttpServletRequest servletRequest) {
        String uploadLocation;
        String metadata;
        UploadInfo info = new UploadInfo(servletRequest);
        Long length = Utils.getLongHeader(servletRequest, "Upload-Length");
        if (length != null) {
            info.setLength(length);
        }
        if (StringUtils.isNotBlank((CharSequence)(metadata = Utils.getHeader(servletRequest, "Upload-Metadata")))) {
            info.setEncodedMetadata(metadata);
        }
        if (StringUtils.isNotBlank((CharSequence)(uploadLocation = Utils.getHeader(servletRequest, "Upload-Location")))) {
            info.setUploadLocation(uploadLocation);
        }
        HashMap<String, MessageDigest> digests = new HashMap<String, MessageDigest>();
        String hashAlgorithms = Utils.getHeader(servletRequest, "Hash-Algorithm");
        if (StringUtils.isNotBlank((CharSequence)hashAlgorithms) && !hashAlgorithms.toLowerCase().contains("none")) {
            for (String algorithm : hashAlgorithms.split(",")) {
                String normalizedAlgorithmName = algorithm.replace("[", "").replace("]", "").trim();
                normalizedAlgorithmName = normalizedAlgorithmName.replace("SHA", "SHA-").replace("--", "-");
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(normalizedAlgorithmName);
                    digests.put(normalizedAlgorithmName.replace("-", ""), messageDigest);
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.error("Algorithm " + normalizedAlgorithmName + " not supported", (Throwable)e);
                }
            }
        }
        info.setDigests(digests);
        String uploadUri = servletRequest.getRequestURI();
        Matcher matcher = this.datasetIdPattern.matcher(uploadUri);
        if (matcher.find()) {
            String datasetId = matcher.group(1);
            info.setLocationIdentifier(datasetId);
        }
        return info;
    }
}

