/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.models;

import com.nuix.automate.scheduler.tus.TusFileUploadService;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.utils.models.internal.dataset.UploadInfoState;

public class UploadInfoModel {
    private String id;
    private String datasetId;
    private String matterId;
    private String clientId;
    private String dataRepositoryId;
    private String ownerKey;
    private String name;
    private String relativePath;
    private UploadInfoState state;
    private long createdDate;
    private Long expiryDate;
    private String clientIpAddresses;
    private String serverIpAddress;
    private String serverName;
    private String serverRole;
    private long offset;
    private long length;
    private long uploadDuration;
    private long lastTransferred;
    private long transferInterval;
    private int interruptedCount;

    public UploadInfoModel() {
    }

    public UploadInfoModel(UploadInfo uploadInfo, TusFileUploadService tusFileUploadService) {
        this(uploadInfo, tusFileUploadService, false);
    }

    public UploadInfoModel(UploadInfo uploadInfo, TusFileUploadService tusFileUploadService, boolean maskSensitiveValues) {
        this.ownerKey = uploadInfo.getOwnerKey();
        this.id = uploadInfo.getId().getUrlSafeValue();
        this.datasetId = uploadInfo.getLocationIdentifier();
        if (!maskSensitiveValues) {
            this.name = uploadInfo.getFileName();
            this.relativePath = uploadInfo.getRelativePath();
        }
        this.uploadDuration = uploadInfo.getUploadDuration();
        this.createdDate = uploadInfo.getCreationTimestamp();
        this.expiryDate = uploadInfo.getExpirationTimestamp();
        this.clientIpAddresses = uploadInfo.getClientIpAddresses();
        this.serverIpAddress = uploadInfo.getServerIpAddress();
        this.serverName = uploadInfo.getServerName();
        this.serverRole = uploadInfo.getServerRole();
        this.lastTransferred = uploadInfo.getLastTransferred();
        this.transferInterval = uploadInfo.getTransferInterval();
        this.interruptedCount = uploadInfo.getInterruptedCount();
        this.offset = uploadInfo.getOffset();
        if (tusFileUploadService.isLocked(uploadInfo)) {
            this.state = UploadInfoState.ACTIVE;
        } else {
            this.state = uploadInfo.getState();
            if (this.state == null) {
                this.state = UploadInfoState.IDLE;
            }
        }
        this.length = uploadInfo.getLength();
    }

    public String getId() {
        return this.id;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public String getOwnerKey() {
        return this.ownerKey;
    }

    public String getName() {
        return this.name;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public UploadInfoState getState() {
        return this.state;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public Long getExpiryDate() {
        return this.expiryDate;
    }

    public String getClientIpAddresses() {
        return this.clientIpAddresses;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public long getUploadDuration() {
        return this.uploadDuration;
    }

    public long getLastTransferred() {
        return this.lastTransferred;
    }

    public long getTransferInterval() {
        return this.transferInterval;
    }

    public int getInterruptedCount() {
        return this.interruptedCount;
    }
}

