/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class UploadId
implements Serializable {
    private static final String UPLOAD_ID_CHARSET = "UTF-8";
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UploadId.class);
    private String urlSafeValue;

    public UploadId(Serializable inputObject) {
        String inputValue;
        String string = inputValue = inputObject == null ? null : inputObject.toString();
        assert (inputValue != null);
        Validate.notBlank((CharSequence)inputValue, (String)"The upload ID value cannot be blank", (Object[])new Object[0]);
        try {
            this.urlSafeValue = inputValue.equals(URLDecoder.decode(inputValue, UPLOAD_ID_CHARSET)) ? URLEncoder.encode(inputValue, UPLOAD_ID_CHARSET) : inputValue;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Unable to URL encode upload ID value", (Throwable)e);
            this.urlSafeValue = inputValue;
        }
    }

    public UploadId(String inputValue) {
        try {
            this.urlSafeValue = inputValue.equals(URLDecoder.decode(inputValue, UPLOAD_ID_CHARSET)) ? URLEncoder.encode(inputValue, UPLOAD_ID_CHARSET) : inputValue;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Unable to URL encode upload ID value", (Throwable)e);
            this.urlSafeValue = inputValue;
        }
    }

    public String getUrlSafeValue() {
        return this.urlSafeValue;
    }

    public String toString() {
        return this.urlSafeValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadId)) {
            return false;
        }
        UploadId uploadId = (UploadId)o;
        return Objects.equals(this.urlSafeValue, uploadId.urlSafeValue);
    }

    public int hashCode() {
        return Objects.hash(this.urlSafeValue);
    }
}

