/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload;

import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadLocationNotFoundException;
import com.nuix.automate.scheduler.tus.exception.UploadNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.concatenation.UploadConcatenationService;
import com.nuix.automate.scheduler.tus.utils.InputStreamContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public interface UploadStorageService {
    public UploadInfo getUploadInfo(String var1, String var2);

    public UploadInfo getUploadInfo(UploadId var1);

    public String getUploadURI();

    public UploadInfo append(UploadInfo var1, InputStreamContainer var2) throws IOException, TusException;

    public void setMaxUploadSize(Long var1);

    public long getMaxUploadSize();

    public UploadInfo create(UploadInfo var1, String var2) throws IOException, UploadLocationNotFoundException;

    public void update(UploadInfo var1) throws IOException, UploadNotFoundException;

    public InputStream getUploadedBytes(String var1, String var2) throws IOException, UploadNotFoundException, UploadLocationNotFoundException;

    public InputStream getUploadedBytes(UploadId var1) throws IOException, UploadNotFoundException, UploadLocationNotFoundException;

    public void copyUploadTo(UploadInfo var1, OutputStream var2) throws UploadNotFoundException, IOException, UploadLocationNotFoundException;

    public void cleanupExpiredUploads(UploadLockingService var1) throws IOException;

    public void removeLastNumberOfBytes(UploadInfo var1, long var2) throws UploadNotFoundException, IOException, UploadLocationNotFoundException;

    public void terminateUpload(UploadInfo var1) throws UploadNotFoundException, IOException;

    public Long getUploadExpirationPeriod();

    public void setUploadExpirationPeriod(Long var1);

    public void setUploadConcatenationService(UploadConcatenationService var1);

    public UploadConcatenationService getUploadConcatenationService();

    public void setIdFactory(UploadIdFactory var1);

    public void finalizeUpload(UploadInfo var1, Map<String, String> var2) throws UploadLocationNotFoundException, IOException;
}

