/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.disk;

import com.nuix.automate.scheduler.tus.TusFileUploadService;
import com.nuix.automate.scheduler.tus.exception.StoragePathNotAvailableException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.Validate;

public class AbstractDiskBasedService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TusFileUploadService.class);
    private final Path storagePath;

    public AbstractDiskBasedService(String path) {
        Validate.notBlank((CharSequence)path, (String)"The storage path cannot be blank", (Object[])new Object[0]);
        this.storagePath = Paths.get(path, new String[0]);
    }

    protected Path getStoragePath() {
        return this.storagePath;
    }

    protected Path getPathInStorageDirectory(UploadId id) throws FileTraversalException {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            this.init();
        }
        if (id == null) {
            return null;
        }
        return FileUtils.safeResolve((Path)this.storagePath, (String)id.toString());
    }

    private synchronized void init() {
        if (!Files.exists(this.storagePath, new LinkOption[0])) {
            try {
                Files.createDirectories(this.storagePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                String message = "Unable to create the directory specified by the storage path " + String.valueOf(this.storagePath);
                LOGGER.error(message, (Throwable)e);
                throw new StoragePathNotAvailableException(message, e);
            }
        }
    }
}

