/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.disk;

import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadAlreadyLockedException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.disk.AbstractDiskBasedService;
import com.nuix.automate.scheduler.tus.upload.disk.FileBasedLock;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DiskLockingService
extends AbstractDiskBasedService
implements UploadLockingService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DiskLockingService.class);
    private static final String LOCK_SUB_DIRECTORY = "locks";
    private UploadIdFactory idFactory;

    public DiskLockingService(String storagePath) {
        super(storagePath + File.separator + LOCK_SUB_DIRECTORY);
    }

    public DiskLockingService(UploadIdFactory idFactory, String storagePath) {
        this(storagePath);
        Validate.notNull((Object)idFactory, (String)"The IdFactory cannot be null", (Object[])new Object[0]);
        this.idFactory = idFactory;
    }

    @Override
    public UploadLock lockUploadByUri(String requestURI) throws TusException, IOException {
        UploadId id = this.idFactory.readUploadId(requestURI);
        FileBasedLock lock = null;
        Path lockPath = this.getLockPath(id);
        if (lockPath != null) {
            lock = new FileBasedLock(requestURI, lockPath);
        }
        return lock;
    }

    @Override
    public UploadLock lockUploadById(UploadId id) throws IOException, UploadAlreadyLockedException {
        FileBasedLock lock = null;
        Path lockPath = this.getLockPath(id);
        if (lockPath != null) {
            lock = new FileBasedLock(null, lockPath);
        }
        return lock;
    }

    @Override
    public void cleanupStaleLocks() throws IOException {
        try (DirectoryStream<Path> locksStream = Files.newDirectoryStream(this.getStoragePath());){
            for (Path path : locksStream) {
                UploadId id;
                FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                if (lastModifiedTime.toMillis() >= DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - 10000L || this.isLocked(id = new UploadId(path.getFileName().toString()))) continue;
                FileUtils.deleteRecursively((Path)path);
            }
        }
        catch (NoSuchFileException e) {
            LOGGER.info("No lock found");
        }
    }

    @Override
    public boolean isLocked(UploadId id) {
        boolean locked = false;
        Path lockPath = null;
        try {
            lockPath = this.getLockPath(id);
        }
        catch (FileTraversalException e) {
            LOGGER.error("Cannot get lock path", (Throwable)e);
        }
        if (lockPath != null) {
            try (FileBasedLock lock = new FileBasedLock(id.toString(), lockPath);){
                lock.release();
            }
            catch (UploadAlreadyLockedException | IOException e) {
                locked = true;
            }
        }
        return locked;
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        Validate.notNull((Object)idFactory, (String)"The IdFactory cannot be null", (Object[])new Object[0]);
        this.idFactory = idFactory;
    }

    private Path getLockPath(UploadId id) throws FileTraversalException {
        return this.getPathInStorageDirectory(id);
    }
}

