/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.disk;

import com.nuix.automate.scheduler.tus.exception.UploadAlreadyLockedException;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.commons.lang3.Validate;

public class FileBasedLock
implements UploadLock {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(FileBasedLock.class);
    private final String uploadUri;
    private FileChannel fileChannel = null;
    protected Path lockPath;

    public FileBasedLock(String uploadUri, Path lockPath) throws UploadAlreadyLockedException, IOException {
        Validate.notNull((Object)lockPath, (String)"The path to the lock cannot be null", (Object[])new Object[0]);
        this.uploadUri = uploadUri;
        this.lockPath = lockPath;
        this.tryToObtainFileLock();
    }

    private void tryToObtainFileLock() throws UploadAlreadyLockedException, IOException {
        String message = "The upload " + this.getUploadUri() + " is already locked";
        try {
            this.fileChannel = this.createFileChannel();
            FileLock fileLock = Utils.lockFileExclusively(this.fileChannel);
            if (fileLock == null) {
                this.fileChannel.close();
                throw new UploadAlreadyLockedException(message);
            }
        }
        catch (OverlappingFileLockException e) {
            if (this.fileChannel != null) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new UploadAlreadyLockedException(message);
        }
        catch (IOException e) {
            throw new IOException("Unable to create or open file required to implement file-based locking", e);
        }
    }

    @Override
    public String getUploadUri() {
        return this.uploadUri;
    }

    @Override
    public void release() {
        try {
            this.fileChannel.close();
            FileUtils.deleteRecursively((Path)this.lockPath);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to release file lock for URI " + this.getUploadUri(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.release();
    }

    protected FileChannel createFileChannel() throws IOException {
        return FileChannel.open(this.lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }
}

