/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.scheduler;

import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadAlreadyLockedException;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerLock
implements UploadLock {
    private final Lock lock = new ReentrantLock();
    private final String uploadUri;
    private final long createdMillis;

    public SchedulerLock(String uploadUri) {
        this.uploadUri = uploadUri;
        this.createdMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public void tryToObtainLock() throws TusException {
        try {
            if (!this.lock.tryLock(5L, TimeUnit.SECONDS)) {
                throw new UploadAlreadyLockedException("The upload " + this.getUploadUri() + " is already locked");
            }
        }
        catch (InterruptedException e) {
            throw new TusException(423, "Interrupted while waiting for lock: " + this.uploadUri, e);
        }
    }

    public long getCreatedMillis() {
        return this.createdMillis;
    }

    public boolean isLocked() {
        if (this.lock.tryLock()) {
            this.lock.unlock();
            return false;
        }
        return true;
    }

    @Override
    public String getUploadUri() {
        return this.uploadUri;
    }

    @Override
    public void release() {
        this.lock.unlock();
    }

    @Override
    public void close() {
        this.release();
    }
}

