/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.upload.scheduler;

import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerLock;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SchedulerLockingService
implements UploadLockingService {
    private final Map<String, SchedulerLock> idLocks = new ConcurrentHashMap<String, SchedulerLock>();
    private UploadIdFactory idFactory;

    public void terminateLock(UploadId id) {
        if (id != null) {
            this.idLocks.remove(id.toString());
        }
    }

    @Override
    public UploadLock lockUploadByUri(String requestURI) throws TusException, IOException {
        UploadId id = this.idFactory.readUploadId(requestURI);
        if (id != null) {
            SchedulerLock lock = this.idLocks.computeIfAbsent(id.toString(), key -> new SchedulerLock(requestURI));
            lock.tryToObtainLock();
            return lock;
        }
        return null;
    }

    @Override
    public UploadLock lockUploadById(UploadId id) throws TusException, IOException {
        if (id != null) {
            SchedulerLock lock = this.idLocks.computeIfAbsent(id.toString(), key -> new SchedulerLock(null));
            lock.tryToObtainLock();
            return lock;
        }
        return null;
    }

    @Override
    public void cleanupStaleLocks() throws IOException {
        this.idLocks.values().removeIf(lock -> {
            if (!lock.isLocked()) {
                return DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - lock.getCreatedMillis() > 10000L;
            }
            return false;
        });
    }

    @Override
    public boolean isLocked(UploadId id) {
        SchedulerLock lock = this.idLocks.get(id.toString());
        if (lock != null) {
            return lock.isLocked();
        }
        return false;
    }

    @Override
    public void setIdFactory(UploadIdFactory idFactory) {
        this.idFactory = idFactory;
    }
}

