/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.utils;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestHandler;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.TusExtension;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractTusExtension
implements TusExtension {
    private final List<RequestValidator> requestValidators = new LinkedList<RequestValidator>();
    private final List<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();

    public AbstractTusExtension() {
        this.initValidators(this.requestValidators);
        this.initRequestHandlers(this.requestHandlers);
    }

    protected abstract void initValidators(List<RequestValidator> var1);

    protected abstract void initRequestHandlers(List<RequestHandler> var1);

    @Override
    public void validate(HttpMethod method, HttpServletRequest servletRequest, UploadStorageService uploadStorageService, String ownerKey) throws TusException, IOException {
        for (RequestValidator requestValidator : this.requestValidators) {
            if (!requestValidator.supports(method)) continue;
            requestValidator.validate(method, servletRequest, uploadStorageService, ownerKey);
        }
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        for (RequestHandler requestHandler : this.requestHandlers) {
            if (!requestHandler.supports(method)) continue;
            requestHandler.process(method, servletRequest, servletResponse, uploadStorageService, ownerKey);
        }
    }

    @Override
    public void handleError(HttpMethod method, TusServletRequest request, TusServletResponse response, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        for (RequestHandler requestHandler : this.requestHandlers) {
            if (!requestHandler.supports(method) || !requestHandler.isErrorHandler()) continue;
            requestHandler.process(method, request, response, uploadStorageService, ownerKey);
        }
    }
}

